/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModelBase;

public class PDEManager {
    public static IFragmentModel[] findFragmentsFor(IPluginModelBase model) {
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        BundleDescription desc = PDEManager.getBundleDescription(model);
        if (desc != null) {
            BundleDescription[] fragments;
            BundleDescription[] bundleDescriptionArray = fragments = desc.getFragments();
            int n = fragments.length;
            int n2 = 0;
            while (n2 < n) {
                BundleDescription fragment = bundleDescriptionArray[n2];
                IPluginModelBase candidate = PluginRegistry.findModel(fragment);
                if (candidate instanceof IFragmentModel) {
                    result.add(candidate);
                }
                ++n2;
            }
        }
        return result.toArray(new IFragmentModel[result.size()]);
    }

    public static IPluginModel findHostFor(IFragmentModel fragment) {
        IPluginModelBase host;
        HostSpecification spec;
        BundleDescription desc = PDEManager.getBundleDescription(fragment);
        if (desc != null && (spec = desc.getHost()) != null && (host = PluginRegistry.findModel(spec.getName())) instanceof IPluginModel) {
            return (IPluginModel)host;
        }
        return null;
    }

    private static BundleDescription getBundleDescription(IPluginModelBase model) {
        IProject project;
        IPluginModelBase coreModel;
        BundleDescription desc = model.getBundleDescription();
        if (desc == null && model.getUnderlyingResource() != null && (coreModel = PluginRegistry.findModel(project = model.getUnderlyingResource().getProject())) != null) {
            desc = coreModel.getBundleDescription();
        }
        return desc;
    }

    public static URL[] getNLLookupLocations(IPluginModelBase model) {
        IPluginModel host;
        ArrayList<URL> urls = new ArrayList<URL>();
        PDEManager.addNLLocation(model, urls);
        if (model instanceof IPluginModel) {
            IFragmentModel[] fragments;
            IFragmentModel[] iFragmentModelArray = fragments = PDEManager.findFragmentsFor(model);
            int n = fragments.length;
            int n2 = 0;
            while (n2 < n) {
                IFragmentModel fragment = iFragmentModelArray[n2];
                PDEManager.addNLLocation(fragment, urls);
                ++n2;
            }
        } else if (model instanceof IFragmentModel && (host = PDEManager.findHostFor((IFragmentModel)model)) != null) {
            PDEManager.addNLLocation(host, urls);
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static void addNLLocation(IPluginModelBase model, ArrayList<URL> urls) {
        if (model.getInstallLocation() != null) {
            try {
                URI encodedURI = URIUtil.toURI((String)model.getInstallLocation(), (boolean)true);
                urls.add(encodedURI.toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        }
    }

    public static String getBundleLocalization(IPluginModelBase model) {
        if (model instanceof IBundlePluginModelBase && model.getUnderlyingResource() != null) {
            return ((IBundlePluginModelBase)model).getBundleLocalization();
        }
        if (model instanceof ExternalPluginModelBase) {
            return ((ExternalPluginModelBase)model).getLocalization();
        }
        return "OSGI-INF/l10n/bundle";
    }
}

