/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal.bundleresources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.webresources.AbstractResource;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.buf.UriUtil;
import org.eclipse.gemini.web.tomcat.internal.bundleresources.BundleWebResourceAttributes;
import org.eclipse.gemini.web.tomcat.internal.support.BundleFileResolver;
import org.eclipse.gemini.web.tomcat.internal.support.BundleFileResolverFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

final class BundleWebResource
extends AbstractResource {
    private static final String WEB_INF_DOT = "WEB-INF.";
    private static final String META_INF_DOT = "META-INF.";
    private static final String META_INF = "META-INF";
    private static final String OSGI_INF_DOT = "OSGI-INF.";
    private static final String OSGI_OPT_DOT = "OSGI-OPT.";
    private static final String PATH_SEPARATOR = "/";
    private static final String DOT = ".";
    private final WebResourceRoot root;
    private final String path;
    private final Bundle bundle;
    private final List<Bundle> fragments;
    private final BundleFileResolver bundleFileResolver = BundleFileResolverFactory.createBundleFileResolver();
    private final boolean checkEntryPath;
    private String bundleLocationCanonicalPath;
    private boolean isBundleLocationDirectory;
    private URL url;
    private BundleWebResourceAttributes attributes;

    BundleWebResource(Bundle bundle, WebResourceRoot root) {
        super(root, "");
        this.root = root;
        this.path = "";
        this.bundle = bundle;
        this.fragments = this.getFragments(bundle);
        this.checkEntryPath = this.checkEntryPath();
        File bundleLocation = this.bundleFileResolver.resolve(bundle);
        if (bundleLocation != null) {
            try {
                this.bundleLocationCanonicalPath = bundleLocation.getCanonicalPath();
            }
            catch (IOException iOException) {}
            if (bundleLocation.isDirectory()) {
                this.isBundleLocationDirectory = true;
            }
        }
    }

    private BundleWebResource(Bundle bundle, WebResourceRoot root, List<Bundle> fragments, String path, boolean checkEntryPath, String bundleLocationCanonicalPath, boolean isBundleLocationDirectory) {
        super(root, path);
        this.root = root;
        this.path = path;
        this.bundle = bundle;
        this.fragments = fragments;
        this.checkEntryPath = checkEntryPath;
        this.bundleLocationCanonicalPath = bundleLocationCanonicalPath;
        this.isBundleLocationDirectory = isBundleLocationDirectory;
    }

    private Bundle getBundle() {
        return this.bundle;
    }

    List<BundleWebResource> list() {
        ArrayList<BundleWebResource> entries = new ArrayList<BundleWebResource>();
        Set<String> paths = this.getEntryPathsFromBundle();
        if (paths != null) {
            for (String subPath : paths) {
                entries.add(this.createBundleEntry(subPath));
            }
        }
        return entries;
    }

    private BundleWebResource createBundleEntry(String path) {
        return new BundleWebResource(this.bundle, this.root, this.fragments, path, this.checkEntryPath, this.bundleLocationCanonicalPath, this.isBundleLocationDirectory);
    }

    private Set<String> getEntryPathsFromBundle() {
        Set<String> paths = this.getEntryPathsFromBundle(this.bundle);
        int i = 0;
        while (i < this.fragments.size()) {
            paths.addAll(this.getEntryPathsFromBundle(this.fragments.get(i)));
            ++i;
        }
        if (paths.isEmpty()) {
            return null;
        }
        return paths;
    }

    private Set<String> getEntryPathsFromBundle(Bundle bundle) {
        Enumeration ep = bundle.getEntryPaths(this.path);
        HashSet<String> paths = new HashSet<String>();
        if (ep != null) {
            while (ep.hasMoreElements()) {
                paths.add((String)ep.nextElement());
            }
        }
        return paths;
    }

    Map.Entry<BundleWebResource, URL> getEntry(String subPath) {
        String finalPath = String.valueOf(this.path) + subPath;
        URL entryURL = this.getEntryFromBundle(finalPath);
        if (entryURL != null) {
            HashMap<BundleWebResource, URL> result = new HashMap<BundleWebResource, URL>();
            result.put(this.createBundleEntry(finalPath), entryURL);
            return result.entrySet().iterator().next();
        }
        return null;
    }

    private URL getEntryFromBundle(String path) {
        String searchFile;
        String searchPath;
        if (this.checkEntryPath && (this.checkNotAttemptingToAccess(path, META_INF_DOT) || this.checkNotAttemptingToAccess(path, WEB_INF_DOT) || this.checkNotAttemptingToAccess(path, OSGI_INF_DOT) || this.checkNotAttemptingToAccess(path, OSGI_OPT_DOT))) {
            return null;
        }
        if (path.endsWith(PATH_SEPARATOR) || path.length() == 0) {
            URL url = this.bundle.getEntry(path);
            if (url == null) {
                int i = 0;
                while (i < this.fragments.size()) {
                    Bundle b = this.fragments.get(i);
                    url = b.getEntry(path);
                    if (url != null) break;
                    ++i;
                }
            }
            return url;
        }
        int lastSlashIndex = path.lastIndexOf(PATH_SEPARATOR);
        if (lastSlashIndex == -1) {
            searchPath = PATH_SEPARATOR;
            searchFile = path;
        } else {
            searchPath = path.substring(0, lastSlashIndex);
            searchFile = path.substring(lastSlashIndex + 1);
        }
        if (searchFile.equals(DOT)) {
            return this.bundle.getEntry(path.substring(0, path.length() - 1));
        }
        Enumeration entries = this.bundle.findEntries(searchPath, searchFile, false);
        if (entries != null && entries.hasMoreElements()) {
            return (URL)entries.nextElement();
        }
        return null;
    }

    private boolean checkNotAttemptingToAccess(String path, String prefix) {
        return path.startsWith(String.valueOf(prefix) + PATH_SEPARATOR) || path.startsWith(PATH_SEPARATOR + prefix + PATH_SEPARATOR) || path.startsWith("./" + prefix + PATH_SEPARATOR);
    }

    public String getName() {
        int index;
        String name = this.path;
        if (name.endsWith(PATH_SEPARATOR)) {
            name = name.substring(0, this.path.length() - 1);
        }
        if ((index = name.lastIndexOf(PATH_SEPARATOR)) > -1) {
            name = name.substring(index + 1);
        }
        if (name.length() != 0) {
            return name;
        }
        return PATH_SEPARATOR;
    }

    public URL getURL() {
        if (this.url == null) {
            this.url = this.getEntryFromBundle(this.path);
            String urlStr = this.url.toString();
            if (urlStr.endsWith(".jar")) {
                try {
                    this.url = UriUtil.buildJarUrl((String)urlStr);
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        return this.url;
    }

    public String toString() {
        return String.format("BundleWebResource [bundle=%s,path=%s]", this.bundle, this.path);
    }

    private List<Bundle> getFragments(Bundle bundle) {
        ArrayList<Bundle> fragments = new ArrayList<Bundle>();
        BundleRevision bundleRevision = (BundleRevision)bundle.adapt(BundleRevision.class);
        if (bundleRevision != null) {
            BundleWiring bundleWiring = bundleRevision.getWiring();
            List bundleWires = bundleWiring.getProvidedWires("osgi.wiring.host");
            int i = 0;
            while (bundleWires != null && i < bundleWires.size()) {
                fragments.add(((BundleWire)bundleWires.get(i)).getRequirerWiring().getRevision().getBundle());
                ++i;
            }
        }
        return fragments;
    }

    private boolean checkEntryPath() {
        try {
            return Paths.get(META_INF, new String[0]).toRealPath(new LinkOption[0]).equals(Paths.get(META_INF_DOT, new String[0]).toRealPath(new LinkOption[0]));
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public boolean canRead() {
        return true;
    }

    public boolean delete() {
        return false;
    }

    public boolean exists() {
        return true;
    }

    public String getCanonicalPath() {
        if (this.isBundleLocationDirectory()) {
            boolean checkInBundleLocation = this.path != null && this.path.indexOf("..") >= 0;
            String bundleLocationCanonicalPath = this.getBundleLocationCanonicalPath();
            Path entry = Paths.get(bundleLocationCanonicalPath, this.path);
            if (checkInBundleLocation) {
                try {
                    if (!entry.toRealPath(new LinkOption[0]).startsWith(bundleLocationCanonicalPath)) {
                        return null;
                    }
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            return entry.toAbsolutePath().toString();
        }
        return null;
    }

    private String getBundleLocationCanonicalPath() {
        return this.bundleLocationCanonicalPath;
    }

    private boolean isBundleLocationDirectory() {
        return this.isBundleLocationDirectory;
    }

    public Certificate[] getCertificates() {
        return null;
    }

    public URL getCodeBase() {
        return this.getURL();
    }

    public byte[] getContent() {
        long len = this.getContentLength();
        if (len > Integer.MAX_VALUE) {
            throw new ArrayIndexOutOfBoundsException("Unable to return [" + this.getWebappPath() + "] as a byte array since the resource is [" + Long.valueOf(len) + "] bytes in size which is larger than the maximum size of a byte array.");
        }
        int size = (int)len;
        byte[] result = new byte[size];
        int pos = 0;
        try {
            Throwable throwable = null;
            Object var7_7 = null;
            try (InputStream is = this.getURL().openStream();){
                while (pos < size) {
                    int n = is.read(result, pos, size - pos);
                    if (n < 0) {
                        break;
                    }
                    pos += n;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    public long getContentLength() {
        return this.getAttributes().getContentLength(null);
    }

    public long getCreation() {
        return this.getAttributes().getCreation(null);
    }

    public long getLastModified() {
        return this.getAttributes().getLastModified(null);
    }

    public Manifest getManifest() {
        return null;
    }

    public boolean isDirectory() {
        URL url = this.getURL();
        return url.getFile().endsWith(PATH_SEPARATOR) && !"jar".equals(url.getProtocol());
    }

    public boolean isFile() {
        return !this.isDirectory();
    }

    public boolean isVirtual() {
        return false;
    }

    protected InputStream doGetInputStream() {
        try {
            URL url = this.getURL();
            if ("jar".equals(url.getProtocol()) || url.getPath().endsWith(".jar")) {
                JarURLConnection jarConn = (JarURLConnection)url.openConnection();
                URL jarURL = jarConn.getJarFileURL();
                URLConnection conn = jarURL.openConnection();
                conn.setUseCaches(false);
                return conn.getInputStream();
            }
            return url.openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected Log getLog() {
        return null;
    }

    Map.Entry<BundleWebResource, URL> getNamedEntry(String name) {
        this.checkCanLookup(name);
        return this.getEntry(name);
    }

    long resolveBundleWebResourceSize() {
        return this.bundleFileResolver.resolveBundleEntrySize(this.bundle, this.path);
    }

    private void checkCanLookup(String name) {
        if (this.getBundle().getState() == 1) {
            throw new IllegalArgumentException("Resource not found [" + name + "].");
        }
        this.checkNotAttemptingToLookupFromProtectedLocation(name);
    }

    private void checkNotAttemptingToLookupFromProtectedLocation(String name) {
        this.checkNotAttemptingToLookupFrom(name, "/OSGI-INF/");
        this.checkNotAttemptingToLookupFrom(name, "/OSGI-OPT/");
    }

    private void checkNotAttemptingToLookupFrom(String name, String prefix) {
        if (name.startsWith(prefix)) {
            throw new IllegalArgumentException("Resource cannot be obtained from [" + prefix + "].");
        }
    }

    private BundleWebResourceAttributes getAttributes() {
        if (this.attributes == null) {
            this.attributes = new BundleWebResourceAttributes(this);
        }
        return this.attributes;
    }
}

