/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.extender;

import org.eclipse.gemini.web.core.WebApplication;
import org.eclipse.gemini.web.core.WebApplicationStartFailedException;
import org.eclipse.gemini.web.core.WebContainer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WebContainerBundleCustomizer
implements BundleTrackerCustomizer<Object> {
    private static final Logger logger = LoggerFactory.getLogger(WebContainerBundleCustomizer.class);
    private final WebContainer container;
    private final Bundle extenderBundle;

    public WebContainerBundleCustomizer(WebContainer container, Bundle extenderBundle) {
        this.container = container;
        this.extenderBundle = extenderBundle;
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        WebApplication handle;
        block4: {
            handle = null;
            if (this.container.isWebBundle(bundle)) {
                try {
                    WebApplication webApplication;
                    handle = webApplication = this.container.createWebApplication(bundle, this.extenderBundle);
                    webApplication.start();
                }
                catch (BundleException e) {
                    logger.error("Exception occurred during web application startup.", (Throwable)e);
                }
                catch (WebApplicationStartFailedException _) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug("", (Throwable)_);
                }
            }
        }
        return handle;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        if (this.container.isWebBundle(bundle)) {
            ((WebApplication)object).stop();
        }
    }
}

