/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal.bundleresources;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.webresources.AbstractArchiveResourceSet;
import org.apache.catalina.webresources.JarResourceSet;
import org.eclipse.gemini.web.tomcat.internal.bundleresources.BundleJarResource;

final class BundleJarResourceSet
extends JarResourceSet {
    BundleJarResourceSet(WebResourceRoot root, String webAppMount, String base, String internalPath) throws IllegalArgumentException {
        super(root, webAppMount, base, internalPath);
    }

    protected WebResource createArchiveResource(JarEntry jarEntry, String webAppPath, Manifest manifest) {
        return new BundleJarResource((AbstractArchiveResourceSet)this, webAppPath, this.getBaseUrlString(), jarEntry);
    }

    protected void initInternal() throws LifecycleException {
        URLConnection conn = null;
        URL baseUrl = null;
        try {
            baseUrl = new URL(this.getBase());
            conn = baseUrl.openConnection();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        try {
            Throwable e = null;
            Object var4_7 = null;
            try (JarInputStream jarIs = new JarInputStream(conn.getInputStream());){
                this.setManifest(jarIs.getManifest());
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe);
        }
        this.setBaseUrl(baseUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashMap<String, JarEntry> getArchiveEntries(boolean single) {
        Object object = this.archiveLock;
        synchronized (object) {
            if (this.archiveEntries == null && !single) {
                URLConnection conn = null;
                URL baseUrl = null;
                try {
                    baseUrl = new URL(this.getBase());
                    conn = baseUrl.openConnection();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
                this.archiveEntries = new HashMap();
                try {
                    Throwable e = null;
                    Object var6_9 = null;
                    try (JarInputStream jarIs = new JarInputStream(conn.getInputStream());){
                        JarEntry entry = jarIs.getNextJarEntry();
                        while (entry != null) {
                            this.archiveEntries.put(entry.getName(), entry);
                            entry = jarIs.getNextJarEntry();
                        }
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        throw e;
                    }
                }
                catch (IOException ioe) {
                    this.archiveEntries = null;
                    throw new IllegalStateException(ioe);
                }
            }
            return this.archiveEntries;
        }
    }

    protected JarEntry getArchiveEntry(String pathInArchive) {
        URLConnection conn = null;
        URL baseUrl = null;
        try {
            baseUrl = new URL(this.getBase());
            conn = baseUrl.openConnection();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        JarEntry entry = null;
        try {
            Throwable throwable = null;
            Object var6_9 = null;
            try (JarInputStream jarIs = new JarInputStream(conn.getInputStream());){
                entry = jarIs.getNextJarEntry();
                while (entry != null && !entry.getName().equals(pathInArchive)) {
                    entry = jarIs.getNextJarEntry();
                }
                return entry;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    protected boolean isMultiRelease() {
        return false;
    }
}

