/*
 * Decompiled with CFR 0.152.
 */
package javax.persistence.spi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolver;

public class PersistenceProviderResolverHolder {
    private static PersistenceProviderResolver singleton = new DefaultPersistenceProviderResolver();

    public static PersistenceProviderResolver getPersistenceProviderResolver() {
        return singleton;
    }

    public static void setPersistenceProviderResolver(PersistenceProviderResolver persistenceProviderResolver) {
        singleton = persistenceProviderResolver == null ? new DefaultPersistenceProviderResolver() : persistenceProviderResolver;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultPersistenceProviderResolver
    implements PersistenceProviderResolver {
        private volatile WeakHashMap<ClassLoader, List<PersistenceProvider>> providers = new WeakHashMap();
        private static final String LOGGER_SUBSYSTEM = "javax.persistence.spi";
        private Logger logger;
        private static final String SERVICE_PROVIDER_FILE = "META-INF/services/javax.persistence.spi.PersistenceProvider";
        private static final Pattern nonCommentPattern = Pattern.compile("^([^#]+)");

        private DefaultPersistenceProviderResolver() {
        }

        @Override
        public List<PersistenceProvider> getPersistenceProviders() {
            ClassLoader classLoader = DefaultPersistenceProviderResolver.getContextClassLoader();
            List<PersistenceProvider> list = this.providers.get(classLoader);
            if (list == null) {
                Collection<ProviderName> collection = this.getProviderNames(classLoader);
                list = new ArrayList<PersistenceProvider>();
                for (ProviderName providerName : collection) {
                    try {
                        PersistenceProvider persistenceProvider = (PersistenceProvider)classLoader.loadClass(providerName.getName()).newInstance();
                        list.add(persistenceProvider);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this.log(Level.FINEST, classNotFoundException + ": " + providerName);
                    }
                    catch (InstantiationException instantiationException) {
                        this.log(Level.FINEST, instantiationException + ": " + providerName);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        this.log(Level.FINEST, illegalAccessException + ": " + providerName);
                    }
                    catch (ClassCastException classCastException) {
                        this.log(Level.FINEST, classCastException + ": " + providerName);
                    }
                }
                if (list.isEmpty() && !collection.isEmpty()) {
                    this.log(Level.WARNING, "No valid providers found using:");
                    for (ProviderName providerName : collection) {
                        this.log(Level.WARNING, providerName.toString());
                    }
                }
                this.providers.put(classLoader, list);
            }
            return list;
        }

        private static ClassLoader getContextClassLoader() {
            if (System.getSecurityManager() == null) {
                return Thread.currentThread().getContextClassLoader();
            }
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }

        private void log(Level level, String string) {
            if (this.logger == null) {
                this.logger = Logger.getLogger(LOGGER_SUBSYSTEM);
            }
            this.logger.log(level, "javax.persistence.spi::" + string);
        }

        private Collection<ProviderName> getProviderNames(ClassLoader classLoader) {
            Enumeration<URL> enumeration = null;
            try {
                enumeration = classLoader.getResources(SERVICE_PROVIDER_FILE);
            }
            catch (IOException iOException) {
                throw new PersistenceException("IOException caught: " + classLoader + ".getResources(" + SERVICE_PROVIDER_FILE + ")", iOException);
            }
            ArrayList<ProviderName> arrayList = new ArrayList<ProviderName>();
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                this.addProviderNames(uRL, arrayList);
            }
            return arrayList;
        }

        private void addProviderNames(URL uRL, Collection<ProviderName> collection) {
            InputStream inputStream = null;
            try {
                String string;
                inputStream = uRL.openStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((string = bufferedReader.readLine()) != null) {
                    Matcher matcher = nonCommentPattern.matcher(string = string.trim());
                    if (!matcher.find()) continue;
                    collection.add(new ProviderName(matcher.group().trim(), uRL));
                }
            }
            catch (IOException iOException) {
                throw new PersistenceException("IOException caught reading: " + uRL, iOException);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        @Override
        public void clearCachedProviders() {
            this.providers.clear();
        }

        private class ProviderName {
            private String name;
            private URL source;

            public ProviderName(String string, URL uRL) {
                this.name = string;
                this.source = uRL;
            }

            public String getName() {
                return this.name;
            }

            public URL getSource() {
                return this.source;
            }

            public String toString() {
                return this.getName() + " - " + this.getSource();
            }
        }
    }
}

