/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.parser.manifest.internal;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.virgo.util.parser.manifest.ManifestProblem;
import org.eclipse.virgo.util.parser.manifest.ManifestProblemKind;
import org.eclipse.virgo.util.parser.manifest.internal.ManifestToken;
import org.eclipse.virgo.util.parser.manifest.internal.SimpleTokenStream;
import org.eclipse.virgo.util.parser.manifest.internal.SourceContext;
import org.eclipse.virgo.util.parser.manifest.internal.Token;
import org.eclipse.virgo.util.parser.manifest.internal.TokenStream;

public class RecoveringManifestLexer {
    private static final char[] BLANK_TOKEN_VALUE = "".toCharArray();
    private static final char SPACE = ' ';
    private static final char COLON = ':';
    public static final int MAX_TOKEN_LENGTH = 65535;
    private SimpleTokenStream tokenStream;
    private SourceContext context;
    private char[] data;
    private int dataLength;
    private int dataPos;
    private List<Integer> linebreaks = new ArrayList<Integer>();
    private ParsingState parsingState = null;
    private char[] token;
    private int tokenPos = 0;
    private int startPosition;
    private int possibleTokenEnd;
    private ManifestToken lastEmittedNameToken = null;
    private List<Token> newlineTokens = new ArrayList<Token>();
    private static byte[] fastCharLookup = new byte[256];
    private static final byte letterChar = 1;
    private static final byte digitChar = 2;
    private static final byte underscoreHyphenChar = 4;
    private static final byte newlineChar = 16;
    private static final byte alphanumMask = 3;
    private static final byte nameMask = 7;

    static {
        int i = 0;
        while (i < 256) {
            RecoveringManifestLexer.fastCharLookup[i] = 0;
            ++i;
        }
        i = 97;
        while (i <= 122) {
            int n = i++;
            fastCharLookup[n] = (byte)(fastCharLookup[n] | 1);
        }
        i = 65;
        while (i <= 90) {
            int n = i++;
            fastCharLookup[n] = (byte)(fastCharLookup[n] | 1);
        }
        i = 48;
        while (i <= 57) {
            int n = i++;
            fastCharLookup[n] = (byte)(fastCharLookup[n] | 2);
        }
        fastCharLookup[45] = (byte)(fastCharLookup[45] | 4);
        fastCharLookup[95] = (byte)(fastCharLookup[95] | 4);
        fastCharLookup[13] = (byte)(fastCharLookup[13] | 0x10);
        fastCharLookup[10] = (byte)(fastCharLookup[10] | 0x10);
    }

    private RecoveringManifestLexer() {
    }

    public static TokenStream tokenize(String manifestString) {
        manifestString = String.valueOf(manifestString) + "\n\n";
        RecoveringManifestLexer lexer = new RecoveringManifestLexer();
        lexer.initialize();
        lexer.process(manifestString);
        return lexer.tokenStream;
    }

    public static TokenStream tokenize(Reader reader) throws IOException {
        StringBuilder manifestString = new StringBuilder();
        char[] data = new char[8192];
        int dataRead = reader.read(data);
        while (dataRead != -1) {
            manifestString.append(data, 0, dataRead);
            dataRead = reader.read(data);
        }
        manifestString.append("\n\n");
        RecoveringManifestLexer lexer = new RecoveringManifestLexer();
        lexer.initialize();
        lexer.process(manifestString.toString());
        return lexer.tokenStream;
    }

    private void initialize() {
        this.parsingState = ParsingState.Default;
        this.tokenStream = new SimpleTokenStream();
        this.dataPos = 0;
        this.linebreaks.clear();
        this.linebreaks.add(0);
    }

    private void process(String str) {
        this.data = str.toCharArray();
        this.context = new SourceContext(str);
        this.tokenStream.setSourceContext(this.context);
        this.dataLength = this.data.length;
        this.token = new char[this.dataLength];
        while (this.dataPos < this.dataLength) {
            char ch = this.data[this.dataPos];
            if (this.parsingState == ParsingState.Default) {
                if (RecoveringManifestLexer.isAlphanumeric(ch)) {
                    this.parsingState = ParsingState.ParsingName;
                    this.startNewToken();
                    ++this.dataPos;
                    continue;
                }
                if (RecoveringManifestLexer.isNewline(ch)) {
                    this.processNewlines(true);
                    continue;
                }
                if (ch == ' ') {
                    this.recordProblem(ManifestProblemKind.NAME_MUST_START_WITH_ALPHANUMERIC, this.dataPos, this.dataPos, " ");
                    ++this.dataPos;
                    continue;
                }
                this.recordProblem(ManifestProblemKind.ILLEGAL_NAME_CHAR, this.dataPos, this.dataPos + 1, Character.toString(ch));
                ++this.dataPos;
                continue;
            }
            if (this.parsingState == ParsingState.ParsingName) {
                while (RecoveringManifestLexer.isNameChar(ch) && this.tokenPos < 65535) {
                    this.token[this.tokenPos++] = ch;
                    ch = this.data[++this.dataPos];
                }
                if (this.tokenPos >= 65535) {
                    this.recordProblem(ManifestProblemKind.NAME_TOO_LONG, this.startPosition, this.dataPos, new String[0]);
                    while (RecoveringManifestLexer.isNameChar(ch)) {
                        ch = this.data[++this.dataPos];
                    }
                }
                if (ch == ':') {
                    this.emitNameToken();
                    this.emitColonToken(this.dataPos, this.dataPos + 1);
                    this.parsingState = ParsingState.ParsingValueHeaderChar;
                    ++this.dataPos;
                    continue;
                }
                if (ch == ' ') {
                    this.emitNameToken();
                    this.emitPhantomColonToken(this.dataPos);
                    this.recordProblem(ManifestProblemKind.NAME_ENDED_WITH_SPACE_RATHER_THAN_COLON, this.dataPos, this.dataPos, new String[0]);
                    this.parsingState = ParsingState.ParsingValueHeaderChar;
                    continue;
                }
                if (RecoveringManifestLexer.isNewline(ch)) {
                    this.emitNameToken();
                    int endOfNamePosition = this.dataPos;
                    this.emitPhantomColonToken(endOfNamePosition);
                    this.recordProblem(ManifestProblemKind.NAME_ENDED_PREMATURELY_WITH_NEWLINE, this.lastEmittedNameToken.getStartOffset(), this.lastEmittedNameToken.getEndOffset(), new String[0]);
                    boolean blanklines = this.processNewlines(false);
                    if (blanklines) {
                        this.recordProblem(ManifestProblemKind.MISSING_VALUE, this.lastEmittedNameToken.getStartOffset(), this.lastEmittedNameToken.getEndOffset(), RecoveringManifestLexer.substring(this.data, this.lastEmittedNameToken.getStartOffset(), this.lastEmittedNameToken.getEndOffset()));
                        this.emitPhantomValueToken(endOfNamePosition);
                        this.emitAccumulatedNewlineTokens();
                        this.parsingState = ParsingState.Default;
                        continue;
                    }
                    if (this.dataPos < this.dataLength && this.data[this.dataPos] == ' ') {
                        this.parsingState = ParsingState.ParsingValueHeaderChar;
                        this.newlineTokens.clear();
                        continue;
                    }
                    this.recordProblem(ManifestProblemKind.MISSING_VALUE, this.lastEmittedNameToken.getStartOffset(), this.lastEmittedNameToken.getEndOffset(), this.lastEmittedNameToken.value());
                    this.emitPhantomValueToken(endOfNamePosition);
                    this.emitAccumulatedNewlineTokens();
                    this.parsingState = ParsingState.Default;
                    continue;
                }
                this.recordProblem(ManifestProblemKind.ILLEGAL_NAME_CHAR, this.dataPos, this.dataPos, Character.toString(ch));
                ++this.dataPos;
                continue;
            }
            if (this.parsingState == ParsingState.ParsingValueHeaderChar) {
                if (ch == ' ') {
                    this.startPosition = this.dataPos + 1;
                    this.tokenPos = 0;
                    this.parsingState = ParsingState.ParsingValue;
                    ++this.dataPos;
                    continue;
                }
                if (RecoveringManifestLexer.isNewline(ch)) {
                    boolean blankline = this.processNewlines(false);
                    if (blankline) {
                        this.recordProblem(ManifestProblemKind.VALUE_MUST_IMMEDIATELY_FOLLOW_NAME, this.lastEmittedNameToken.getStartOffset(), this.lastEmittedNameToken.getEndOffset(), new String[0]);
                        this.emitPhantomValueToken(this.newlineTokens.get(0).getStartOffset());
                        this.emitAccumulatedNewlineTokens();
                        this.parsingState = ParsingState.Default;
                        continue;
                    }
                    this.newlineTokens.clear();
                    continue;
                }
                this.recordProblem(ManifestProblemKind.VALUE_MUST_START_WITH_SPACE, this.dataPos, this.dataPos, new String[0]);
                this.startPosition = this.dataPos;
                this.tokenPos = 0;
                this.parsingState = ParsingState.ParsingValue;
                continue;
            }
            if (this.parsingState == ParsingState.ParsingValue) {
                while (!RecoveringManifestLexer.isNewline(ch)) {
                    this.token[this.tokenPos++] = ch;
                    ch = this.data[++this.dataPos];
                }
                if (this.tokenPos >= 65535) {
                    this.recordProblem(ManifestProblemKind.VALUE_TOO_LONG, this.startPosition, this.dataPos, new String[0]);
                }
                this.possibleTokenEnd = this.dataPos;
                boolean blanklines = this.processNewlines(false);
                if (blanklines) {
                    if (this.dataPos < this.dataLength && this.data[this.dataPos] == ' ') {
                        this.recordProblem(ManifestProblemKind.UNEXPECTED_NEWLINE_DURING_VALUE_PARSING, this.possibleTokenEnd, this.dataPos, new String[0]);
                        this.parsingState = ParsingState.ParsingNameOrContinuation;
                        continue;
                    }
                    this.emitValueToken(this.startPosition, this.possibleTokenEnd);
                    this.emitAccumulatedNewlineTokens();
                    this.parsingState = ParsingState.Default;
                    continue;
                }
                this.parsingState = ParsingState.ParsingNameOrContinuation;
                continue;
            }
            assert (this.parsingState == ParsingState.ParsingNameOrContinuation);
            if (ch == ' ') {
                this.newlineTokens.clear();
                this.parsingState = ParsingState.ParsingValue;
                ++this.dataPos;
                continue;
            }
            if (RecoveringManifestLexer.isAlphanumeric(ch)) {
                this.emitValueToken(this.startPosition, this.possibleTokenEnd);
                this.emitAccumulatedNewlineTokens();
                this.startPosition = this.dataPos++;
                this.tokenPos = 0;
                this.token[this.tokenPos++] = ch;
                this.parsingState = ParsingState.ParsingName;
                continue;
            }
            assert (!RecoveringManifestLexer.isNewline(ch));
            this.recordProblem(ManifestProblemKind.MISSING_SPACE_FOR_CONTINUATION, this.dataPos, this.dataPos + 1, new String[0]);
            this.newlineTokens.clear();
            this.token[this.tokenPos++] = ch;
            this.parsingState = ParsingState.ParsingValue;
            ++this.dataPos;
        }
        assert (this.parsingState == ParsingState.Default);
        this.tokenStream.getSourceContext().setLinebreaks(this.linebreaks);
        this.tokenStream.lexComplete();
    }

    private int correctMaxPosition(int pos) {
        return pos;
    }

    private void emitNameToken() {
        this.lastEmittedNameToken = ManifestToken.makeName(RecoveringManifestLexer.subarray(this.token, 0, this.correctMaxPosition(this.tokenPos)), this.startPosition, this.dataPos);
        this.tokenStream.addToken(this.lastEmittedNameToken);
    }

    private void emitColonToken(int spos, int epos) {
        this.tokenStream.addToken(ManifestToken.makeColon(spos, epos));
    }

    private void emitPhantomColonToken(int pos) {
        this.tokenStream.addToken(ManifestToken.makeColon(pos, pos));
    }

    private void emitValueToken(int spos, int epos) {
        this.tokenStream.addToken(ManifestToken.makeValue(RecoveringManifestLexer.subarray(this.token, 0, this.correctMaxPosition(this.tokenPos)), spos, epos));
    }

    private void emitPhantomValueToken(int pos) {
        this.tokenStream.addToken(ManifestToken.makeValue(BLANK_TOKEN_VALUE, pos, pos));
    }

    private void emitAccumulatedNewlineTokens() {
        for (Token newlineToken : this.newlineTokens) {
            this.tokenStream.addToken(newlineToken);
        }
        this.newlineTokens.clear();
    }

    private void startNewToken() {
        this.startPosition = this.dataPos;
        this.tokenPos = 0;
        this.token[this.tokenPos++] = this.data[this.dataPos];
    }

    private void recordProblem(ManifestProblemKind problemKind, int start, int end, String ... inserts) {
        this.tokenStream.recordProblem(new ManifestProblem(problemKind, this.context, start, end, inserts));
    }

    public static final char[] subarray(char[] array, int start, int end) {
        char[] result = new char[end - start];
        System.arraycopy(array, start, result, 0, end - start);
        return result;
    }

    public static final String substring(char[] array, int start, int end) {
        return new String(array, start, end - start);
    }

    private static boolean isAlphanumeric(char ch) {
        if (ch > '\u0100') {
            return false;
        }
        return (fastCharLookup[ch] & 3) != 0;
    }

    private static boolean isNameChar(char ch) {
        if (ch > '\u00ff') {
            return false;
        }
        return (fastCharLookup[ch] & 7) != 0;
    }

    private static boolean isNewline(char ch) {
        if (ch > '\u00ff') {
            return false;
        }
        return (fastCharLookup[ch] & 0x10) != 0;
    }

    private boolean processNewlines(boolean emitToTokenStreamImmediately) {
        assert (this.newlineTokens.size() == 0);
        char ch = this.data[this.dataPos];
        assert (RecoveringManifestLexer.isNewline(ch));
        this.newlineTokens.clear();
        int newlines = 0;
        do {
            ++newlines;
            int toskip = 1;
            if (ch == '\r' && this.dataPos + 1 < this.dataLength && this.data[this.dataPos + 1] == '\n') {
                ++toskip;
            }
            Token newlineToken = ManifestToken.makeNewline(this.dataPos, this.dataPos + toskip);
            if (emitToTokenStreamImmediately) {
                this.tokenStream.addToken(newlineToken);
            } else {
                this.newlineTokens.add(newlineToken);
            }
            this.linebreaks.add(this.dataPos + toskip);
            this.dataPos += toskip;
        } while (this.dataPos < this.dataLength && RecoveringManifestLexer.isNewline(ch = this.data[this.dataPos]));
        return newlines > 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ParsingState {
        Default,
        ParsingName,
        ParsingValue,
        ParsingValueHeaderChar,
        ParsingNameOrContinuation;

    }
}

