/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.apache.naming.NamingEntry;
import org.apache.naming.resources.FileDirContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualDirContext
extends FileDirContext {
    private Map<String, File> virtualMappings;
    private Map<String, File> tagfileMappings;
    private String virtualClasspath;

    public void setVirtualClasspath(String path) {
        this.virtualClasspath = path;
    }

    @Override
    public void allocate() {
        super.allocate();
        this.virtualMappings = new Hashtable<String, File>();
        this.tagfileMappings = new Hashtable<String, File>();
        StringTokenizer tkn = new StringTokenizer(this.virtualClasspath, ";");
        while (tkn.hasMoreTokens()) {
            File file = new File(tkn.nextToken(), "META-INF");
            if (!file.exists() || !file.isDirectory()) continue;
            this.scanForTlds(file);
        }
    }

    @Override
    public void release() {
        super.release();
        this.virtualMappings = null;
    }

    @Override
    public Attributes getAttributes(String name) throws NamingException {
        if (name.startsWith("/WEB-INF/") && name.endsWith(".tld")) {
            String tldName = name.substring(name.lastIndexOf("/") + 1);
            if (this.virtualMappings.containsKey(tldName)) {
                return new FileDirContext.FileResourceAttributes(this.virtualMappings.get(tldName));
            }
        } else if (name.startsWith("/META-INF/tags") && name.endsWith(".tag") || name.endsWith(".tagx")) {
            if (this.tagfileMappings.containsKey(name)) {
                return new FileDirContext.FileResourceAttributes(this.tagfileMappings.get(name));
            }
            StringTokenizer tkn = new StringTokenizer(this.virtualClasspath, ";");
            while (tkn.hasMoreTokens()) {
                File file = new File(tkn.nextToken(), name);
                if (!file.exists()) continue;
                this.tagfileMappings.put(name, file);
                return new FileDirContext.FileResourceAttributes(file);
            }
        }
        return super.getAttributes(name);
    }

    @Override
    protected ArrayList list(File file) {
        ArrayList entries = super.list(file);
        if ("WEB-INF".equals(file.getName())) {
            entries.addAll(this.getVirtualNamingEntries());
        }
        return entries;
    }

    @Override
    protected Object doLookup(String name) throws NamingException {
        File tagFile;
        if (name.startsWith("/WEB-INF/") && name.endsWith(".tld")) {
            String tldName = name.substring(name.lastIndexOf("/") + 1);
            if (this.virtualMappings.containsKey(tldName)) {
                return new FileDirContext.FileResource(this.virtualMappings.get(tldName));
            }
        } else if ((name.startsWith("/META-INF/tags") && name.endsWith(".tag") || name.endsWith(".tagx")) && (tagFile = this.tagfileMappings.get(name)) != null) {
            return new FileDirContext.FileResource(tagFile);
        }
        return super.lookup(name);
    }

    private void scanForTlds(File dir) {
        File[] files = dir.listFiles();
        for (int j = 0; j < files.length; ++j) {
            File file = files[j];
            if (file.isDirectory()) {
                this.scanForTlds(file);
                continue;
            }
            if (!file.getName().endsWith(".tld")) continue;
            String virtualTldName = "~" + System.currentTimeMillis() + "~" + file.getName();
            this.virtualMappings.put(virtualTldName, file);
        }
    }

    private List<NamingEntry> getVirtualNamingEntries() {
        ArrayList<NamingEntry> virtual = new ArrayList<NamingEntry>();
        for (String name : this.virtualMappings.keySet()) {
            File file = this.virtualMappings.get(name);
            NamingEntry entry = new NamingEntry(name, new FileDirContext.FileResource(file), 0);
            virtual.add(entry);
        }
        return virtual;
    }
}

