/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.osgi.manifest.parse.standard;

import org.eclipse.virgo.util.osgi.manifest.parse.standard.BasicHeaderToken;
import org.eclipse.virgo.util.osgi.manifest.parse.standard.HeaderProblem;
import org.eclipse.virgo.util.osgi.manifest.parse.standard.HeaderProblemKind;
import org.eclipse.virgo.util.osgi.manifest.parse.standard.HeaderTokenKind;
import org.eclipse.virgo.util.osgi.manifest.parse.standard.HeaderTokenStream;

public class StandardHeaderLexer {
    private HeaderTokenStream tokenStream;
    private int tokenStart;
    private boolean tokenStartedWithLetter;
    char[] data;
    private int state;
    private int datapos;
    private int datalen;
    private BasicHeaderToken extensionStart = null;
    private BasicHeaderToken lastEmittedToken = null;
    private boolean foundSpace = false;
    private boolean allowsPathToken = false;
    private static final int UNKNOWN = 0;
    private static final int DIGITS = 1;
    private static final int ALPHABETIC = 2;
    private static final int ALPHANUMERIC = 3;
    private static final int TOKEN = 4;
    private static final int IDENTIFIER = 5;
    private static final int QUOTEDSTRING = 6;
    private static final int PATHELEMENT = 7;
    private static final HeaderTokenKind[] stateToTokenMap;
    private static final boolean[] tokenExtension;
    private static final byte[] lookup;
    private static final byte IS_DIGIT = 1;
    private static final byte IS_ALPHA = 2;
    private static final byte IS_UNDERLINE_OR_MINUS = 4;
    private static final byte IS_ALPHANUM = 3;
    private static final byte IS_TOKEN = 7;

    static {
        HeaderTokenKind[] headerTokenKindArray = new HeaderTokenKind[8];
        headerTokenKindArray[1] = HeaderTokenKind.NUMBER;
        headerTokenKindArray[2] = HeaderTokenKind.ALPHAS;
        headerTokenKindArray[3] = HeaderTokenKind.ALPHANUMERIC;
        headerTokenKindArray[4] = HeaderTokenKind.TOKEN;
        headerTokenKindArray[5] = HeaderTokenKind.IDENTIFIER;
        headerTokenKindArray[6] = HeaderTokenKind.QUOTEDSTRING;
        headerTokenKindArray[7] = HeaderTokenKind.PATHELEMENT;
        stateToTokenMap = headerTokenKindArray;
        boolean[] blArray = new boolean[8];
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[7] = true;
        tokenExtension = blArray;
        lookup = new byte[256];
        int ch = 48;
        while (ch <= 57) {
            int n = ch++;
            lookup[n] = (byte)(lookup[n] | 1);
        }
        ch = 97;
        while (ch <= 122) {
            int n = ch++;
            lookup[n] = (byte)(lookup[n] | 2);
        }
        ch = 65;
        while (ch <= 90) {
            int n = ch++;
            lookup[n] = (byte)(lookup[n] | 2);
        }
        lookup[95] = (byte)(lookup[95] | 4);
        lookup[45] = (byte)(lookup[45] | 4);
    }

    public StandardHeaderLexer() {
    }

    public StandardHeaderLexer(boolean allowsPathToken) {
        this.allowsPathToken = allowsPathToken;
    }

    public HeaderTokenStream getTokenStream() {
        return this.tokenStream;
    }

    private void initializeLexer(String header) {
        int stringlen = header.length();
        this.data = new char[stringlen + 1];
        header.getChars(0, stringlen, this.data, 0);
        this.data[stringlen] = '\u0000';
        this.tokenStream = new HeaderTokenStream(header);
        this.datapos = 0;
        this.tokenStart = -1;
        this.datalen = this.data.length;
    }

    public void process(String header) {
        this.initializeLexer(header);
        this.state = 0;
        while (this.datapos < this.datalen) {
            char ch = this.data[this.datapos];
            if (this.isDigit(ch)) {
                this.processDigit();
                continue;
            }
            if (this.isAlphabetic(ch)) {
                this.processAlphabetic();
                continue;
            }
            if (this.isUnderlineMinus(ch)) {
                this.processUnderlineMinus();
                continue;
            }
            if (ch == '\"') {
                this.processQuote();
                continue;
            }
            if (ch == '/') {
                this.processSlash();
                continue;
            }
            if (ch == '\u0000') {
                this.processNul();
                continue;
            }
            if (ch == ':') {
                this.processColon();
                continue;
            }
            if (ch == ';') {
                this.emitToken(this.datapos);
                this.emitToken2(HeaderTokenKind.SEMICOLON, this.datapos++);
                continue;
            }
            if (ch == '=') {
                this.emitToken(this.datapos);
                this.lastEmittedToken.tagAsAttributeName();
                this.emitToken2(HeaderTokenKind.EQUALS, this.datapos++);
                continue;
            }
            if (ch == ',') {
                this.emitToken(this.datapos);
                this.emitToken2(HeaderTokenKind.COMMA, this.datapos++);
                continue;
            }
            if (ch == '.') {
                this.processDot();
                continue;
            }
            if (ch == '*') {
                this.processStar();
                continue;
            }
            if (Character.isJavaIdentifierStart((int)ch)) {
                this.processJavaIdentifierStart();
                continue;
            }
            if (Character.isJavaIdentifierPart((int)ch)) {
                this.processJavaIdentifierPart();
                continue;
            }
            this.processUnexpected();
        }
        if (this.state != 0) {
            this.emitToken(this.datapos);
        }
        this.tokenStream.lexComplete();
    }

    private void processSpace() {
        if (this.state != 0) {
            this.emitToken(this.datapos);
        }
        if (this.lastEmittedToken != null) {
            this.lastEmittedToken.tagAsFollowedBySpace();
        }
        char ch = this.data[this.datapos];
        this.recordProblem(HeaderProblemKind.UNEXPECTED_SPACE_WARNING, this.datapos, this.datapos, Character.toString(ch), Integer.toString(ch));
        this.foundSpace = true;
        ++this.datapos;
    }

    private void processDot() {
        if (this.lastEmittedToken != null && this.lastEmittedToken.getKind() == HeaderTokenKind.SEMICOLON) {
            if (this.state == 0) {
                this.processDotOrigin();
            } else if (this.state == 1 || this.state == 2 || this.state == 3 || this.state == 4) {
                this.state = 4;
                do {
                    if (this.data[this.datapos + 1] == '*' && this.data[this.datapos] == '.') {
                        ++this.datapos;
                    }
                    ++this.datapos;
                } while (this.isToken(this.data[this.datapos]));
            } else {
                assert (this.state == 6);
                this.emitToken(this.datapos);
                this.state = 0;
            }
        } else {
            this.processDotOrigin();
        }
    }

    private void processDotOrigin() {
        boolean isDotStar;
        this.emitToken(this.datapos);
        boolean bl = isDotStar = this.data[this.datapos + 1] == '*';
        if (isDotStar) {
            this.emitDotStar(this.datapos);
            this.datapos += 2;
        } else {
            this.emitToken(HeaderTokenKind.DOT, this.datapos);
            ++this.datapos;
        }
    }

    private void processSlash() {
        if (!this.allowsPathToken) {
            char ch = this.data[this.datapos];
            this.recordProblem(HeaderProblemKind.UNEXPECTED_CHARACTER, this.datapos, this.datapos, Character.toString(ch), Integer.toString(ch));
            ++this.datapos;
        } else {
            this.emitToken(this.datapos);
            this.emitToken(HeaderTokenKind.SLASH, this.datapos);
            ++this.datapos;
        }
    }

    private void processStar() {
        this.emitToken(this.datapos);
        this.emitToken(HeaderTokenKind.STAR, this.datapos);
        ++this.datapos;
    }

    private void processUnexpected() {
        if (this.data[this.datapos] == ' ') {
            this.processSpace();
        } else if (this.allowsPathToken) {
            this.state = 7;
            while (!this.pathEnd(this.data[this.datapos])) {
                ++this.datapos;
            }
            this.emitToken(this.datapos);
            char ch = this.data[this.datapos];
            if (this.pathEnd(ch) && ch != '\u0000') {
                this.recordProblem(HeaderProblemKind.UNEXPECTED_CHARACTER, this.datapos, this.datapos, Character.toString(ch), Integer.toString(ch));
                ++this.datapos;
            }
        } else {
            this.emitToken(this.datapos);
            char ch = this.data[this.datapos];
            this.recordProblem(HeaderProblemKind.UNEXPECTED_CHARACTER, this.datapos, this.datapos, Character.toString(ch), Integer.toString(ch));
            ++this.datapos;
        }
    }

    private boolean pathEnd(char ch) {
        return ch == '\u0000' || ch == '/' || ch == '\"' || ch == '\n' || ch == '\r' || ch == '\\' || ch == ' ';
    }

    private void processNul() {
        if (this.tokenStart != -1) {
            this.emitToken(this.datapos);
            if (this.extensionStart != null && this.lastEmittedToken != this.extensionStart) {
                this.extensionStart.setExtendedOffset(this.lastEmittedToken.getEndOffset());
            }
        }
        this.datapos = this.datalen;
    }

    private void processDigit() {
        if (this.state == 0) {
            this.state = 1;
            this.tokenStart = this.datapos++;
            while (this.isDigit(this.data[this.datapos])) {
                ++this.datapos;
            }
        } else if (this.state == 2 || this.state == 3) {
            this.state = 3;
            do {
                ++this.datapos;
            } while (this.isAlphanumeric(this.data[this.datapos]));
        } else {
            assert (this.state == 6);
            this.emitToken(this.datapos);
            this.state = 0;
        }
    }

    private void processAlphabetic() {
        if (this.state == 0) {
            this.tokenStart = this.datapos;
            this.state = 2;
            this.tokenStartedWithLetter = true;
            while (this.isAlphabetic(this.data[++this.datapos])) {
            }
        } else if (this.state == 1 || this.state == 3) {
            this.state = 3;
            while (this.isAlphanumeric(this.data[++this.datapos])) {
            }
        } else {
            assert (this.state == 6);
            this.emitToken(this.datapos);
            this.state = 0;
        }
    }

    private void processUnderlineMinus() {
        if (this.state == 0 || this.state == 1 || this.state == 2 || this.state == 3) {
            if (this.state == 0) {
                this.tokenStart = this.datapos;
            }
            this.state = 4;
            do {
                ++this.datapos;
            } while (this.isToken(this.data[this.datapos]));
        } else {
            assert (this.state == 6);
            this.emitToken(this.datapos);
            this.state = 0;
        }
    }

    private void processQuote() {
        if (this.state != 0) {
            this.emitToken(this.datapos);
            this.state = 0;
        }
        this.tokenStart = this.datapos;
        this.state = 6;
        boolean run = true;
        boolean escape = false;
        while (run) {
            char ch;
            if ((ch = this.data[++this.datapos]) == '\\') {
                escape = true;
                continue;
            }
            if (!escape) {
                if (ch == '\"') {
                    run = false;
                }
                if (ch == '\r' || ch == '\n') {
                    this.recordProblem(HeaderProblemKind.UNEXPECTED_CHARACTER, this.datapos, this.datapos, Character.toString(ch), Integer.toString(ch));
                }
            }
            if (ch == '\u0000') {
                this.recordProblem(HeaderProblemKind.NON_TERMINATING_QUOTED_STRING, this.tokenStart, this.datapos, new String[0]);
                run = false;
            }
            escape = false;
        }
        ++this.datapos;
    }

    private void processJavaIdentifierPart() {
        if (this.state == 2 || this.state == 3 && this.tokenStartedWithLetter || this.state == 4 && (this.data[this.tokenStart] == '_' || this.isAlphabetic(this.data[this.tokenStart]))) {
            this.state = 5;
            char ch = '\u0000';
            while ((ch = this.data[++this.datapos]) != '\u0000' && Character.isJavaIdentifierPart(ch)) {
            }
        } else {
            if (this.state != 0) {
                this.emitToken(this.datapos);
            }
            char ch = this.data[this.datapos];
            this.recordProblem(HeaderProblemKind.UNEXPECTED_CHARACTER, this.datapos, this.datapos, Character.toString(ch), Integer.toString(ch));
            ++this.datapos;
        }
    }

    private void processColon() {
        boolean isColonEquals;
        if (this.state != 0) {
            this.emitToken(this.datapos);
        }
        boolean bl = isColonEquals = this.data[this.datapos + 1] == '=';
        if (isColonEquals) {
            this.lastEmittedToken.tagAsDirectiveName();
            this.emitColonEquals(this.datapos);
            this.datapos += 2;
        } else {
            this.recordProblem(HeaderProblemKind.UNEXPECTED_CHARACTER, this.datapos, this.datapos, ":", Integer.toString(58));
            ++this.datapos;
        }
    }

    private void processJavaIdentifierStart() {
        if (this.state == 6) {
            this.emitToken(this.datapos);
            this.state = 0;
        }
        if (this.state == 0) {
            this.tokenStart = this.datapos;
        }
        this.state = 5;
        char ch = '\u0000';
        do {
            ++this.datapos;
        } while ((ch = this.data[this.datapos]) != '\u0000' && Character.isJavaIdentifierPart(ch));
    }

    private boolean isDigit(int ch) {
        if (ch > 255) {
            return false;
        }
        return (lookup[ch] & 1) != 0;
    }

    private boolean isAlphabetic(int ch) {
        if (ch > 255) {
            return false;
        }
        return (lookup[ch] & 2) != 0;
    }

    private boolean isAlphanumeric(int ch) {
        if (ch > 255) {
            return false;
        }
        return (lookup[ch] & 3) != 0;
    }

    private boolean isUnderlineMinus(int ch) {
        if (ch > 255) {
            return false;
        }
        return (lookup[ch] & 4) != 0;
    }

    private boolean isToken(int ch) {
        if (ch > 255) {
            return false;
        }
        if (this.state == 4 && (ch == 46 || ch == 42) && this.lastEmittedToken != null && this.lastEmittedToken.getKind() == HeaderTokenKind.SEMICOLON && this.extensionStart != null) {
            return true;
        }
        return (lookup[ch] & 7) != 0;
    }

    private void emitToken(HeaderTokenKind kind, int pos) {
        this.pushExtensionToken(BasicHeaderToken.makeToken(this.data, kind, pos, pos + 1));
    }

    private void emitToken2(HeaderTokenKind kind, int pos) {
        this.pushToken(BasicHeaderToken.makeToken(this.data, kind, pos, pos + 1));
    }

    private void emitDotStar(int pos) {
        this.pushToken(BasicHeaderToken.makeToken(this.data, HeaderTokenKind.DOTSTAR, pos, pos + 2));
    }

    private void emitColonEquals(int pos) {
        this.pushToken(BasicHeaderToken.makeToken(this.data, HeaderTokenKind.COLONEQUALS, pos, pos + 2));
    }

    private void emitToken(int tokenEnd) {
        HeaderTokenKind kind = stateToTokenMap[this.state];
        if (kind == null) {
            return;
        }
        if (kind == HeaderTokenKind.QUOTEDSTRING) {
            ++this.tokenStart;
            --tokenEnd;
        }
        BasicHeaderToken newToken = BasicHeaderToken.makeToken(this.data, kind, this.tokenStart, tokenEnd);
        if (this.tokenStartedWithLetter) {
            newToken.tagAsStartedWithLetter();
        }
        if (tokenExtension[this.state]) {
            this.pushExtensionToken(newToken);
        } else {
            this.pushToken(newToken);
        }
        this.state = 0;
        this.tokenStartedWithLetter = false;
        this.tokenStart = -1;
    }

    private void pushExtensionToken(BasicHeaderToken token) {
        if (this.extensionStart == null) {
            this.extensionStart = token;
        } else if (this.foundSpace) {
            this.extensionStart.tagAsSpaced();
        }
        this.foundSpace = false;
        this.lastEmittedToken = token;
        this.tokenStream.addToken(token);
    }

    private void pushToken(BasicHeaderToken token) {
        if (this.extensionStart != null) {
            if (this.lastEmittedToken != this.extensionStart) {
                this.extensionStart.setExtendedOffset(this.lastEmittedToken.getEndOffset());
            }
            this.extensionStart = null;
        }
        this.foundSpace = false;
        this.lastEmittedToken = token;
        this.tokenStream.addToken(token);
    }

    private void recordProblem(HeaderProblemKind parseProblem, int startOffset, int endOffset, String ... inserts) {
        this.tokenStream.recordProblem(new HeaderProblem(parseProblem, startOffset, endOffset, inserts));
    }
}

