/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.internal.template;

import org.eclipse.gemini.web.internal.template.ServiceCallback;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceTemplate<S> {
    private final ServiceTracker<Object, Object> tracker;

    public ServiceTemplate(BundleContext context, Class<S> clazz) {
        this.tracker = new ServiceTracker(context, clazz.getName(), (ServiceTrackerCustomizer)new ServiceTemplateCustomizer(context));
    }

    public void start() {
        this.tracker.open();
    }

    public void stop() {
        this.tracker.close();
    }

    public <T> T executeWithService(ServiceCallback<S, T> callback) {
        Object service = this.tracker.getService();
        if (service != null) {
            return callback.doWithService(service);
        }
        return null;
    }

    private static final class ServiceTemplateCustomizer
    implements ServiceTrackerCustomizer<Object, Object> {
        private final BundleContext context;

        public ServiceTemplateCustomizer(BundleContext context) {
            this.context = context;
        }

        public Object addingService(ServiceReference<Object> reference) {
            return this.context.getService(reference);
        }

        public void modifiedService(ServiceReference<Object> reference, Object service) {
        }

        public void removedService(ServiceReference<Object> reference, Object service) {
            this.context.ungetService(reference);
        }
    }
}

