/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.naming;

class OSGiURLParser {
    private static final String OSGI_SERVICE_PREFIX = "osgi:service/";
    private static final String OSGI_SERVICE_LIST_PREFIX = "osgi:servicelist/";
    private final String m_osgiURL;
    private String m_serviceInterface = null;
    private String m_filter = null;
    private boolean m_parsingCompleted = false;
    private boolean m_isServiceList = false;

    public OSGiURLParser(String osgiURL) {
        this.m_osgiURL = osgiURL;
    }

    public void parse() {
        if (this.m_osgiURL.startsWith(OSGI_SERVICE_PREFIX)) {
            this.parseURLData(OSGI_SERVICE_PREFIX);
        } else if (this.m_osgiURL.startsWith(OSGI_SERVICE_LIST_PREFIX)) {
            this.parseURLData(OSGI_SERVICE_LIST_PREFIX);
            this.m_isServiceList = true;
        } else {
            throw new IllegalStateException("URL '" + this.m_osgiURL + "'" + "did not conform to the OSGi URL Syntax");
        }
    }

    public String getServiceInterface() {
        this.checkParserState();
        return this.m_serviceInterface;
    }

    public String getFilter() {
        this.checkParserState();
        return this.m_filter;
    }

    public boolean hasFilter() {
        this.checkParserState();
        return this.getFilter() != null;
    }

    public boolean isServiceListURL() {
        this.checkParserState();
        return this.m_isServiceList;
    }

    private void checkParserState() {
        if (!this.m_parsingCompleted) {
            throw new IllegalStateException("OSGi URL has not been parsed");
        }
    }

    private void parseURLData(String prefix) {
        String urlData = this.m_osgiURL.substring(prefix.length());
        if ('/' == urlData.charAt(0)) {
            throw new IllegalStateException("URL did not conform to the OSGi URL Syntax - No Service Interface specified");
        }
        int indexOfSlash = urlData.indexOf("/(");
        if (indexOfSlash != -1) {
            this.m_serviceInterface = urlData.substring(0, indexOfSlash);
            this.m_filter = urlData.substring(indexOfSlash + 1);
        } else {
            this.m_serviceInterface = urlData;
        }
        if (this.m_serviceInterface.length() == 0) {
            throw new IllegalStateException("URL did not conform to the OSGi URL Syntax - No Service Interface specified");
        }
        this.m_parsingCompleted = true;
    }
}

