/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.jpa.provider;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.gemini.jpa.provider.BundleArchive;
import org.eclipse.persistence.internal.jpa.deployment.ArchiveFactoryImpl;
import org.eclipse.persistence.internal.jpa.deployment.JarInputStreamURLArchive;
import org.eclipse.persistence.jpa.Archive;

public class OSGiArchiveFactoryImpl
extends ArchiveFactoryImpl {
    public Archive createArchive(URL rootUrl, String descriptorLocation, Map properties) throws URISyntaxException, IOException {
        this.logger.entering("ArchiveFactoryImpl", "createArchive", new Object[]{rootUrl, descriptorLocation});
        String protocol = rootUrl.getProtocol();
        this.logger.logp(Level.FINER, "ArchiveFactoryImpl", "createArchive", "protocol = {0}", protocol);
        if (properties != null && properties.get("org.eclipse.gemini.jpa.bundle") != null) {
            if (this.isJarInputStream(rootUrl)) {
                return new JarInputStreamURLArchive(rootUrl, descriptorLocation);
            }
            return new BundleArchive(rootUrl, properties, descriptorLocation, this.logger);
        }
        return super.createArchive(rootUrl, descriptorLocation, properties);
    }
}

