/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.gemini.jpa.GeminiProperties;
import org.eclipse.gemini.jpa.GeminiUtil;
import org.eclipse.gemini.jpa.PUnitInfo;
import org.eclipse.gemini.jpa.PersistenceDescriptorInfo;
import org.eclipse.gemini.jpa.PersistenceUnitBundleUtil;
import org.eclipse.gemini.jpa.provider.OSGiJpaProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.packageadmin.PackageAdmin;

public class PersistenceBundleExtender
implements SynchronousBundleListener {
    OSGiJpaProvider osgiJpaProvider;
    PersistenceUnitBundleUtil bundleUtil;
    Map<Bundle, List<PUnitInfo>> unitsByBundle = Collections.synchronizedMap(new HashMap());
    Set<Long> lazyBundles = new HashSet<Long>();
    Set<Long> refreshingBundles = new HashSet<Long>();

    public PersistenceBundleExtender() {
    }

    public PersistenceBundleExtender(OSGiJpaProvider provider) {
        this.osgiJpaProvider = provider;
        this.bundleUtil = new PersistenceUnitBundleUtil();
    }

    public void startListening() {
        GeminiUtil.debug("GeminiExtender listening");
        this.osgiJpaProvider.getBundleContext().addBundleListener((BundleListener)this);
    }

    public void stopListening() {
        GeminiUtil.debug("GeminiExtender no longer listening");
        this.osgiJpaProvider.getBundleContext().removeBundleListener((BundleListener)this);
    }

    public void lookForExistingBundles() {
        Bundle[] installedBundles = this.osgiJpaProvider.getBundleContext().getBundles();
        GeminiUtil.debug("GeminiExtender looking at existing bundles: ", (Object)installedBundles);
        Bundle[] bundleArray = installedBundles;
        int n = installedBundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (this.isPersistenceUnitBundle(b)) {
                if (GeminiProperties.refreshPersistenceBundles()) {
                    if (b.getState() == 32) {
                        this.refreshBundle(b);
                    }
                } else if (b.getState() != 1) {
                    this.tryAssigningPersistenceUnitsInBundle(b);
                    if (b.getState() == 8 || b.getState() == 32) {
                        this.registerPersistenceUnitsInBundle(b);
                    }
                }
            }
            ++n2;
        }
    }

    public Map<Bundle, List<PUnitInfo>> clearAllPUnitInfos() {
        Map<Bundle, List<PUnitInfo>> pUnitInfos = this.unitsByBundle;
        this.unitsByBundle = null;
        this.lazyBundles = null;
        this.refreshingBundles = null;
        return pUnitInfos;
    }

    public void tryAssigningPersistenceUnitsInBundle(Bundle b) {
        GeminiUtil.debug("GeminiExtender tryAssigningPersistenceUnitsInBundle: ", (Object)b);
        if (this.isAssigned(b)) {
            GeminiUtil.warning("Attempted to assign a bundle that was already assigned: ", b.toString());
            return;
        }
        List<PersistenceDescriptorInfo> descriptorInfos = this.bundleUtil.persistenceDescriptorInfos(b);
        Set<PUnitInfo> pUnitInfos = this.bundleUtil.persistenceUnitInfoFromXmlFiles(descriptorInfos);
        for (PUnitInfo info : pUnitInfos) {
            if (info.getProvider() != null && !this.osgiJpaProvider.getProviderClassName().equals(info.getProvider())) continue;
            info.setBundle(b);
            info.setAssignedProvider(this.osgiJpaProvider);
            this.addToBundleUnits(this.unitsByBundle, b, info);
        }
        List<PUnitInfo> unitsFound = this.unitsByBundle.get(b);
        if (unitsFound != null && unitsFound.size() != 0) {
            this.osgiJpaProvider.assignPersistenceUnitsInBundle(b, (Collection<PUnitInfo>)this.unitsByBundle.get(b));
        }
    }

    public void unassignPersistenceUnitsInBundle(Bundle b) {
        GeminiUtil.debug("GeminiExtender unassignPersistenceUnitsInBundle: ", (Object)b);
        List<PUnitInfo> infos = this.unitsByBundle.get(b);
        this.unitsByBundle.remove(b);
        this.removeFromLazyBundles(b);
        this.osgiJpaProvider.unassignPersistenceUnitsInBundle(b, infos);
        for (PUnitInfo info : infos) {
            info.setAssignedProvider(null);
            info.setBundle(null);
        }
    }

    public void registerPersistenceUnitsInBundle(Bundle b) {
        GeminiUtil.debug("GeminiExtender registerPersistenceUnitsInBundle: ", (Object)b);
        if (!this.isAssigned(b)) {
            GeminiUtil.warning("Register called on bundle " + b.getSymbolicName(), " but bundle was not assigned");
            return;
        }
        if (this.areCompatibleBundles(b, this.osgiJpaProvider.getBundle())) {
            GeminiUtil.debug("GeminiExtender provider compatible with bundle: ", (Object)b);
            this.osgiJpaProvider.registerPersistenceUnits((Collection<PUnitInfo>)this.unitsByBundle.get(b));
        } else {
            GeminiUtil.warning("Cannot support bundle " + b.getSymbolicName() + " because it is not JPA-compatible with the assigned provider " + this.osgiJpaProvider.getProviderClassName() + ". This is because the " + "persistence unit bundle has resolved to a different javax.persistence " + "than the provider. \nTo fix this, uninstall one of the javax.persistence " + "bundles so that both the persistence unit bundle and the provider resolve " + "to the same javax.persistence package.");
            this.unassignPersistenceUnitsInBundle(b);
        }
    }

    public void unregisterPersistenceUnitsInBundle(Bundle b) {
        GeminiUtil.debug("GeminiExtender unregisterPersistenceUnitsInBundle: ", (Object)b);
        if (!this.isAssigned(b)) {
            GeminiUtil.warning("Unregister called on bundle " + b.getSymbolicName(), " but bundle was not assigned");
            return;
        }
        this.osgiJpaProvider.unregisterPersistenceUnits((Collection<PUnitInfo>)this.unitsByBundle.get(b));
    }

    public void refreshBundle(Bundle b) {
        this.addToRefreshingBundles(b);
        PackageAdmin admin = GeminiUtil.getPackageAdmin(this.osgiJpaProvider.getBundleContext());
        GeminiUtil.debug("GeminiExtender refreshing packages of bundle ", (Object)b);
        admin.refreshPackages(new Bundle[]{b});
    }

    public void bundleChanged(BundleEvent event) {
        Bundle b = event.getBundle();
        GeminiUtil.debug("Extender - bundle event, ", (Object)event);
        if (!this.isPersistenceUnitBundle(b)) {
            return;
        }
        int eventType = event.getType();
        if (eventType == 1) {
            this.tryAssigningPersistenceUnitsInBundle(b);
        } else if (eventType == 512) {
            if (this.isAssigned(b)) {
                this.lazyBundles.add(b.getBundleId());
                this.registerPersistenceUnitsInBundle(b);
            }
        } else if (eventType == 128) {
            if (this.isAssigned(b) && !this.isLazy(b)) {
                this.registerPersistenceUnitsInBundle(b);
            }
        } else if (eventType == 2) {
            if (!this.isAssigned(b)) {
                this.refreshBundle(b);
            }
        } else if (eventType == 256) {
            if (this.isAssigned(b)) {
                if (this.isLazy(b)) {
                    this.removeFromLazyBundles(b);
                }
                this.unregisterPersistenceUnitsInBundle(b);
            }
        } else if (eventType == 16) {
            if (this.isAssigned(b)) {
                this.unassignPersistenceUnitsInBundle(b);
            }
        } else if (eventType == 8) {
            if (this.isAssigned(b)) {
                this.unassignPersistenceUnitsInBundle(b);
            }
            this.tryAssigningPersistenceUnitsInBundle(b);
        } else if (eventType == 64 && this.isRefreshing(b)) {
            this.tryAssigningPersistenceUnitsInBundle(b);
            this.removeFromRefreshingBundles(b);
        }
    }

    protected boolean isAssigned(Bundle b) {
        return this.unitsByBundle.containsKey(b);
    }

    protected boolean isLazy(Bundle b) {
        return this.lazyBundles.contains(b.getBundleId());
    }

    protected boolean addToLazyBundles(Bundle b) {
        return this.lazyBundles.add(b.getBundleId());
    }

    protected boolean removeFromLazyBundles(Bundle b) {
        return this.lazyBundles.remove(b.getBundleId());
    }

    protected boolean isRefreshing(Bundle b) {
        return this.refreshingBundles.contains(b.getBundleId());
    }

    protected void addToRefreshingBundles(Bundle b) {
        this.refreshingBundles.add(b.getBundleId());
    }

    protected void removeFromRefreshingBundles(Bundle b) {
        this.refreshingBundles.remove(b.getBundleId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToBundleUnits(Map<Bundle, List<PUnitInfo>> map, Bundle b, PUnitInfo info) {
        Map<Bundle, List<PUnitInfo>> map2 = map;
        synchronized (map2) {
            List<PUnitInfo> infos;
            if (!map.containsKey(b)) {
                map.put(b, new ArrayList());
            }
            if (!(infos = map.get(b)).contains(info)) {
                infos.add(info);
            }
        }
    }

    public boolean isPersistenceUnitBundle(Bundle b) {
        return b.getHeaders().get("Meta-Persistence") != null;
    }

    public boolean isLazyActivatedBundle(Bundle b) {
        String policy = (String)b.getHeaders().get("Bundle-ActivationPolicy");
        return policy != null && policy.equals("lazy");
    }

    public boolean areCompatibleBundles(Bundle pUnitBundle, Bundle providerBundle) {
        try {
            GeminiUtil.debug("GeminiExtender checking bundle compatibility of: ", (Object)pUnitBundle);
            Class pUnitClass = pUnitBundle.loadClass("javax.persistence.Entity");
            Class providerClass = providerBundle.loadClass("javax.persistence.Entity");
            return pUnitClass.getClassLoader() == providerClass.getClassLoader();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return true;
        }
    }

    public void stop(BundleContext context) throws Exception {
    }

    public void start(BundleContext context) throws Exception {
    }
}

