/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.jpa;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import org.eclipse.gemini.jpa.AnchorClassUtil;
import org.eclipse.gemini.jpa.DSFOfflineTracker;
import org.eclipse.gemini.jpa.DSFOnlineTracker;
import org.eclipse.gemini.jpa.GeminiUtil;
import org.eclipse.gemini.jpa.PUnitInfo;
import org.eclipse.gemini.jpa.classloader.BundleProxyClassLoader;
import org.eclipse.gemini.jpa.classloader.CompositeClassLoader;
import org.eclipse.gemini.jpa.provider.OSGiJpaProvider;
import org.eclipse.gemini.jpa.proxy.EMFBuilderServiceProxyHandler;
import org.eclipse.gemini.jpa.proxy.EMFServiceProxyHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.jdbc.DataSourceFactory;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class GeminiServicesUtil {
    OSGiJpaProvider osgiJpaProvider;
    String providerClassName;
    AnchorClassUtil anchorUtil;
    ServiceRegistration providerService;

    public GeminiServicesUtil(OSGiJpaProvider provider, AnchorClassUtil anchorUtil) {
        this.osgiJpaProvider = provider;
        this.providerClassName = provider.getProviderClassName();
        this.anchorUtil = anchorUtil;
    }

    public void registerProviderService() {
        GeminiUtil.debug("GeminiServicesUtil registering provider service for ", (Object)this.providerClassName);
        String[] serviceNames = new String[]{PersistenceProvider.class.getName()};
        PersistenceProvider persistenceProvider = this.osgiJpaProvider.getProviderInstance();
        String version = GeminiUtil.bundleVersion(this.osgiJpaProvider.getBundle());
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.jpa.provider.version", version);
        ((Dictionary)props).put("javax.persistence.provider", this.providerClassName);
        this.providerService = this.osgiJpaProvider.getBundleContext().registerService(serviceNames, (Object)persistenceProvider, props);
        GeminiUtil.debug("GeminiServicesUtil successfully registered provider service for ", (Object)this.providerClassName);
    }

    public void unregisterProviderService() {
        GeminiUtil.debug("GeminiServicesUtil un-registering provider service for ", (Object)this.providerClassName);
        this.providerService.unregister();
        this.providerService = null;
        GeminiUtil.debug("GeminiServicesUtil successfully un-registered provider service for ", (Object)this.providerClassName);
    }

    public void registerEMFServices(PUnitInfo pUnitInfo) {
        GeminiUtil.debug("GeminiServicesUtil registerEMFServices for ", (Object)pUnitInfo.getUnitName());
        Map<String, Class<?>> anchorClasses = this.anchorUtil.loadAnchorClasses(pUnitInfo);
        Dictionary<String, String> props = this.buildServiceProperties(pUnitInfo);
        this.tryToRegisterEMFService(pUnitInfo, anchorClasses, props);
        this.registerEMFBuilderService(pUnitInfo, anchorClasses, props);
    }

    public void unregisterEMFServices(PUnitInfo pUnitInfo) {
        this.unregisterEMFService(pUnitInfo);
        this.unregisterEMFBuilderService(pUnitInfo);
    }

    public void unregisterEMFService(PUnitInfo pUnitInfo) {
        EntityManagerFactory emf;
        GeminiUtil.debug("GeminiServicesUtil un-registerEMFService for ", (Object)pUnitInfo.getUnitName());
        this.stopTrackingDataSourceFactory(pUnitInfo);
        ServiceRegistration emfService = pUnitInfo.getEmfService();
        if (emfService != null) {
            GeminiUtil.debug("GeminiServicesUtil un-registering EMF service for ", (Object)pUnitInfo.getUnitName());
            try {
                emfService.unregister();
            }
            catch (Exception e) {
                GeminiUtil.warning("Error unregistering EMF service: ", e);
            }
            GeminiUtil.debug("GeminiServicesUtil un-registered EMF service for ", (Object)pUnitInfo.getUnitName());
            pUnitInfo.setEmfService(null);
        }
        if ((emf = pUnitInfo.getEmf()) != null && !pUnitInfo.isEmfSetByBuilderService()) {
            if (emf.isOpen()) {
                emf.close();
            }
            pUnitInfo.getEmfHandler().syncUnsetEMF();
            GeminiUtil.debug("GeminiServicesUtil EMF service removed EMF: ", (Object)emf);
        }
        pUnitInfo.setEmfHandler(null);
    }

    public void unregisterEMFBuilderService(PUnitInfo pUnitInfo) {
        EntityManagerFactory emf;
        GeminiUtil.debug("GeminiServicesUtil un-registerEMFBuilderService for ", (Object)pUnitInfo.getUnitName());
        ServiceRegistration emfBuilderService = pUnitInfo.getEmfBuilderService();
        if (emfBuilderService != null) {
            GeminiUtil.debug("GeminiServicesUtil un-registering EMFBuilder service for ", (Object)pUnitInfo.getUnitName());
            try {
                emfBuilderService.unregister();
            }
            catch (Exception e) {
                GeminiUtil.warning("Error un-registering EMFBuilder service: ", e);
            }
            GeminiUtil.debug("GeminiServicesUtil un-registered EMFBuilder service for ", (Object)pUnitInfo.getUnitName());
            pUnitInfo.setEmfBuilderService(null);
        }
        if ((emf = pUnitInfo.getEmf()) != null) {
            if (emf.isOpen()) {
                emf.close();
            }
            pUnitInfo.getEmfBuilderHandler().syncUnsetEMF();
            GeminiUtil.debug("GeminiServicesUtil EMFBuilder service removed emf: ", (Object)emf);
        }
        pUnitInfo.setEmfBuilderHandler(null);
    }

    ClassLoader extractPUnitLoader(PUnitInfo pUnitInfo, Map<String, Class<?>> anchorClasses) {
        ClassLoader pUnitLoader = null;
        if (!anchorClasses.isEmpty()) {
            pUnitLoader = anchorClasses.values().iterator().next().getClassLoader();
        } else if (!pUnitInfo.getClasses().isEmpty()) {
            try {
                pUnitLoader = pUnitInfo.getBundle().loadClass((String)pUnitInfo.getClasses().toArray()[0]).getClassLoader();
            }
            catch (ClassNotFoundException cnfEx) {
                GeminiUtil.fatalError("Could not load domain class in p-unit", cnfEx);
            }
        } else {
            pUnitLoader = new BundleProxyClassLoader(pUnitInfo.getBundle());
        }
        GeminiUtil.debug("GeminiServicesUtil pUnit loader ", (Object)pUnitLoader);
        return pUnitLoader;
    }

    ClassLoader proxyLoader(PUnitInfo pUnitInfo, Map<String, Class<?>> anchorClasses, Class<?> jpaClass) {
        ClassLoader cl = null;
        if (pUnitInfo.getClasses().isEmpty()) {
            cl = jpaClass.getClassLoader();
        } else if (!anchorClasses.isEmpty()) {
            cl = anchorClasses.values().iterator().next().getClassLoader();
        } else {
            try {
                ClassLoader pUnitLoader = pUnitInfo.getBundle().loadClass((String)pUnitInfo.getClasses().toArray()[0]).getClassLoader();
                ClassLoader jpaClassLoader = jpaClass.getClassLoader();
                cl = pUnitLoader == jpaClassLoader ? jpaClassLoader : new CompositeClassLoader(pUnitLoader, jpaClassLoader);
            }
            catch (ClassNotFoundException cnfEx) {
                GeminiUtil.fatalError("Could not load domain class in p-unit", cnfEx);
            }
        }
        GeminiUtil.debugClassLoader("GeminiServicesUtil proxy loader ", cl);
        return cl;
    }

    Object createEMFProxy(PUnitInfo pUnitInfo, ClassLoader loader, Class<?>[] clsArray) {
        EMFServiceProxyHandler emfProxyHandler = new EMFServiceProxyHandler(pUnitInfo);
        Object result = null;
        try {
            result = Proxy.newProxyInstance(loader, clsArray, (InvocationHandler)emfProxyHandler);
            GeminiUtil.debug("GeminiServicesUtil created EMF proxy ");
        }
        catch (Exception e) {
            GeminiUtil.fatalError("GeminiServicesUtil - Failed to create proxy for EMF service: ", e);
        }
        pUnitInfo.setEmfHandler(emfProxyHandler);
        return result;
    }

    Object createEMFBuilderProxy(PUnitInfo pUnitInfo, ClassLoader loader, Class<?>[] clsArray) {
        EMFBuilderServiceProxyHandler emfBuilderProxyHandler = new EMFBuilderServiceProxyHandler(pUnitInfo, pUnitInfo.getEmfHandler());
        Object result = null;
        try {
            result = Proxy.newProxyInstance(loader, clsArray, (InvocationHandler)emfBuilderProxyHandler);
            GeminiUtil.debug("GeminiServicesUtil created EMFBuilder proxy ");
        }
        catch (Exception e) {
            GeminiUtil.fatalError("GeminiServicesUtil - Failed to create proxy for EMFBuilder service: ", e);
        }
        pUnitInfo.setEmfBuilderHandler(emfBuilderProxyHandler);
        return result;
    }

    Dictionary<String, String> buildServiceProperties(PUnitInfo pUnitInfo) {
        Bundle pUnitBundle = pUnitInfo.getBundle();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.unit.name", pUnitInfo.getUnitName());
        ((Dictionary)props).put("osgi.unit.version", GeminiUtil.bundleVersion(pUnitInfo.getBundle()));
        ((Dictionary)props).put("osgi.unit.provider", this.providerClassName);
        String bundleId = String.valueOf(pUnitBundle.getSymbolicName()) + "_" + GeminiUtil.bundleVersion(pUnitBundle);
        ((Dictionary)props).put("osgi.managed.bundles", bundleId);
        GeminiUtil.debug("GeminiServicesUtil JPA services props: ", props);
        return props;
    }

    void tryToRegisterEMFService(PUnitInfo pUnitInfo, Map<String, Class<?>> anchorClasses, Dictionary<String, String> props) {
        GeminiUtil.debug("GeminiServicesUtil tryToregister EMF service for ", (Object)pUnitInfo.getUnitName());
        ArrayList proxiedClasses = new ArrayList();
        Class<?> emfClass = GeminiUtil.loadClassFromBundle("javax.persistence.EntityManagerFactory", this.osgiJpaProvider.getBundle());
        proxiedClasses.addAll(anchorClasses.values());
        proxiedClasses.add(emfClass);
        Class[] classArray = proxiedClasses.toArray(new Class[0]);
        GeminiUtil.debug("GeminiServicesUtil EMF proxy class array: ", (Object)classArray);
        ClassLoader loader = this.proxyLoader(pUnitInfo, anchorClasses, emfClass);
        Object emfServiceProxy = this.createEMFProxy(pUnitInfo, loader, classArray);
        String driverClassName = pUnitInfo.getDriverClassName();
        if (driverClassName == null) {
            GeminiUtil.debug("GeminiServicesUtil No driver class specified so no factory service created");
        } else {
            if (!this.trackDataSourceFactory(pUnitInfo)) {
                GeminiUtil.debug("DataSourceFactory service for " + driverClassName + " not found.");
                try {
                    pUnitInfo.getBundle().loadClass(driverClassName);
                    GeminiUtil.debug("JDBC driver " + driverClassName + " found locally.");
                    this.stopTrackingDataSourceFactory(pUnitInfo);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    GeminiUtil.debug("JDBC driver " + driverClassName + " was not found locally.");
                    GeminiUtil.warning("DataSourceFactory service for " + driverClassName + " was not found. EMF service not registered.");
                    return;
                }
            }
            String[] classNameArray = new String[classArray.length];
            int i = 0;
            while (i < classArray.length) {
                classNameArray[i] = classArray[i].getName();
                ++i;
            }
            ServiceRegistration emfService = null;
            try {
                emfService = pUnitInfo.getBundle().getBundleContext().registerService(classNameArray, emfServiceProxy, props);
                GeminiUtil.debug("GeminiServicesUtil EMF service: ", (Object)emfService);
            }
            catch (Exception e) {
                GeminiUtil.fatalError("GeminiServicesUtil could not register EMF service for " + pUnitInfo.getUnitName(), e);
            }
            pUnitInfo.setEmfService(emfService);
        }
    }

    void registerEMFBuilderService(PUnitInfo pUnitInfo, Map<String, Class<?>> anchorClasses, Dictionary<String, String> props) {
        GeminiUtil.debug("GeminiServicesUtil register EMFBuilder service for ", (Object)pUnitInfo.getUnitName());
        ArrayList proxiedClasses = new ArrayList();
        Class<?> emfBuilderClass = GeminiUtil.loadClassFromBundle("org.osgi.service.jpa.EntityManagerFactoryBuilder", this.osgiJpaProvider.getBundle());
        proxiedClasses.addAll(anchorClasses.values());
        proxiedClasses.add(emfBuilderClass);
        GeminiUtil.debug("GeminiServicesUtil EMFBuilder proxied classes: ", proxiedClasses);
        Class[] classArray = proxiedClasses.toArray(new Class[0]);
        ClassLoader loader = this.proxyLoader(pUnitInfo, anchorClasses, emfBuilderClass);
        Object emfBuilderServiceProxy = this.createEMFBuilderProxy(pUnitInfo, loader, classArray);
        String[] classNameArray = new String[classArray.length];
        int i = 0;
        while (i < classArray.length) {
            classNameArray[i] = classArray[i].getName();
            ++i;
        }
        ServiceRegistration emfBuilderService = null;
        try {
            emfBuilderService = this.osgiJpaProvider.getBundleContext().registerService(classNameArray, emfBuilderServiceProxy, props);
            GeminiUtil.debug("GeminiServicesUtil EMFBuilder service: ", (Object)emfBuilderService);
        }
        catch (Exception e) {
            GeminiUtil.fatalError("GeminiServicesUtil could not register EMFBuilder service for " + pUnitInfo.getUnitName(), e);
        }
        pUnitInfo.setEmfBuilderService(emfBuilderService);
    }

    public boolean trackDataSourceFactory(PUnitInfo pUnitInfo) {
        GeminiUtil.debug("GeminiServicesUtil trackDataSourceFactory for p-unit ", (Object)pUnitInfo.getUnitName());
        ServiceReference[] dsfRefs = null;
        ServiceTracker tracker = null;
        String filter = "(osgi.jdbc.driver.class=" + pUnitInfo.getDriverClassName() + ")";
        try {
            dsfRefs = pUnitInfo.getBundle().getBundleContext().getServiceReferences(DataSourceFactory.class.getName(), filter);
            if (dsfRefs != null) {
                GeminiUtil.debug("GeminiServicesUtil starting tracker on existing DSF for ", (Object)pUnitInfo.getUnitName());
                tracker = new ServiceTracker(this.osgiJpaProvider.getBundleContext(), dsfRefs[0], (ServiceTrackerCustomizer)new DSFOfflineTracker(pUnitInfo, this));
                pUnitInfo.setDsfService(dsfRefs[0]);
            } else {
                GeminiUtil.debug("GeminiServicesUtil starting tracker to wait for DSF for ", (Object)pUnitInfo.getUnitName());
                tracker = new ServiceTracker(this.osgiJpaProvider.getBundleContext(), this.osgiJpaProvider.getBundleContext().createFilter(filter), (ServiceTrackerCustomizer)new DSFOnlineTracker(pUnitInfo, this));
            }
        }
        catch (InvalidSyntaxException isEx) {
            GeminiUtil.fatalError("Bad filter syntax (likely because of missing driver class name)", isEx);
        }
        catch (Exception ex) {
            GeminiUtil.fatalError("Unexpected failure to creating DSF service tracker", ex);
        }
        pUnitInfo.setTracker(tracker);
        tracker.open();
        return dsfRefs != null;
    }

    public void stopTrackingDataSourceFactory(PUnitInfo pUnitInfo) {
        GeminiUtil.debug("GeminiServicesUtil stopTrackingDataSourceFactory", " for p-unit ", pUnitInfo.getUnitName());
        if (pUnitInfo.getTracker() != null) {
            GeminiUtil.debug("GeminiServicesUtil stopping tracker for p-unit ", (Object)pUnitInfo.getUnitName());
            pUnitInfo.getTracker().close();
            pUnitInfo.setTracker(null);
        }
    }

    public void dataSourceFactoryOnline(PUnitInfo pUnitInfo, ServiceReference ref) {
        GeminiUtil.debug("dataSourceFactoryOnline, ref=", ref, " for p-unit ", pUnitInfo.getUnitName());
        if (pUnitInfo.getEmf() != null) {
            GeminiUtil.warning("DSF " + ref + " came online when EMF for p-unit " + pUnitInfo.getUnitName() + " already existed - ignoring DSF");
        } else if (pUnitInfo.getDsfService() != null) {
            GeminiUtil.warning("DSF service already exists for p-unit " + pUnitInfo.getUnitName() + " - ignoring new DSF service");
        } else {
            GeminiUtil.debug("dataSourceFactoryOnline, unregistering and reregistering EMF services for p-unit ", (Object)pUnitInfo.getUnitName());
            this.unregisterEMFServices(pUnitInfo);
            this.registerEMFServices(pUnitInfo);
        }
    }

    public void dataSourceFactoryOffline(PUnitInfo pUnitInfo, ServiceReference removedRef) {
        ServiceReference dsServiceRef = pUnitInfo.getDsfService();
        GeminiUtil.debug("dataSourceFactoryOffline, p-unit=", pUnitInfo.getUnitName(), "removedRef=", removedRef, "storedRef=", dsServiceRef);
        if (dsServiceRef == null) {
            GeminiUtil.warning("DataSourceFactory " + removedRef + " went offline but no record of it was stored in p-unit " + pUnitInfo.getUnitName());
        } else if (dsServiceRef.compareTo((Object)removedRef) != 0) {
            GeminiUtil.warning("DataSourceFactory " + removedRef + " went offline but a different DSF was stored in p-unit " + pUnitInfo.getUnitName());
        }
        GeminiUtil.debug("dataSourceFactoryOffline - unregistering EMF service ", "for p-unit ", pUnitInfo.getUnitName());
        pUnitInfo.setDsfService(null);
        this.unregisterEMFService(pUnitInfo);
    }
}

