/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p5edges;

import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.Util;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.properties.PortType;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrthogonalRoutingGenerator {
    private static final double CONFL_THRESH_FACTOR = 0.2;
    private static final int STRAIGHT_TOLERANCE = 256;
    private static final int CONFLICT_PENALTY = 16;
    private IRoutingDirectionStrategy routingStrategy;
    private double edgeSpacing;
    private double conflictThreshold;
    private String debugPrefix;

    public OrthogonalRoutingGenerator(IRoutingDirectionStrategy routingStrategy, double edgeSpacing, String debugPrefix) {
        this.routingStrategy = routingStrategy;
        this.edgeSpacing = edgeSpacing;
        this.conflictThreshold = 0.2 * edgeSpacing;
        this.debugPrefix = debugPrefix;
    }

    public int routeEdges(LGraph layeredGraph, Iterable<LNode> sourceLayerNodes, int sourceLayerIndex, Iterable<LNode> targetLayerNodes, double startPos) {
        HashMap<LPort, HyperNode> portToHyperNodeMap = new HashMap<LPort, HyperNode>();
        LinkedList<HyperNode> hyperNodes = new LinkedList<HyperNode>();
        this.createHyperNodes(sourceLayerNodes, this.routingStrategy.getSourcePortSide(), hyperNodes, portToHyperNodeMap);
        this.createHyperNodes(targetLayerNodes, this.routingStrategy.getTargetPortSide(), hyperNodes, portToHyperNodeMap);
        ListIterator iter1 = hyperNodes.listIterator();
        while (iter1.hasNext()) {
            HyperNode hyperNode1 = (HyperNode)iter1.next();
            ListIterator iter2 = hyperNodes.listIterator(iter1.nextIndex());
            while (iter2.hasNext()) {
                HyperNode hyperNode2 = (HyperNode)iter2.next();
                OrthogonalRoutingGenerator.createDependency(hyperNode1, hyperNode2, this.conflictThreshold);
            }
        }
        if (this.debugPrefix != null) {
            this.writeDebugGraph(layeredGraph, sourceLayerNodes == null ? 0 : sourceLayerIndex + 1, hyperNodes, "full");
        }
        OrthogonalRoutingGenerator.breakCycles(hyperNodes);
        if (this.debugPrefix != null) {
            this.writeDebugGraph(layeredGraph, sourceLayerNodes == null ? 0 : sourceLayerIndex + 1, hyperNodes, "acyclic");
        }
        OrthogonalRoutingGenerator.topologicalNumbering(hyperNodes);
        int rankCount = -1;
        for (HyperNode node : hyperNodes) {
            if (node.start == node.end) continue;
            rankCount = Math.max(rankCount, node.rank);
            this.routingStrategy.calculateBendPoints(node, startPos, this.edgeSpacing);
        }
        return rankCount + 1;
    }

    private void createHyperNodes(Iterable<LNode> nodes, PortSide portSide, List<HyperNode> hyperNodes, Map<LPort, HyperNode> portToHyperNodeMap) {
        if (nodes != null) {
            for (LNode node : nodes) {
                for (LPort port : node.getPorts(PortType.OUTPUT, portSide)) {
                    HyperNode hyperNode = portToHyperNodeMap.get(port);
                    if (hyperNode != null) continue;
                    hyperNode = new HyperNode();
                    hyperNodes.add(hyperNode);
                    hyperNode.addPortPosis(port, portToHyperNodeMap);
                }
            }
        }
    }

    private static void createDependency(HyperNode hn1, HyperNode hn2, double minDiff) {
        int crossings2;
        int depValue2;
        if (hn1.start == hn1.end || hn2.start == hn2.end) {
            return;
        }
        int conflicts1 = OrthogonalRoutingGenerator.countConflicts(hn1.targetPosis, hn2.sourcePosis, minDiff);
        int conflicts2 = OrthogonalRoutingGenerator.countConflicts(hn2.targetPosis, hn1.sourcePosis, minDiff);
        int crossings1 = OrthogonalRoutingGenerator.countCrossings(hn1.targetPosis, hn2.start, hn2.end) + OrthogonalRoutingGenerator.countCrossings(hn2.sourcePosis, hn1.start, hn1.end);
        int depValue1 = 16 * conflicts1 + crossings1;
        if (depValue1 < (depValue2 = 16 * conflicts2 + (crossings2 = OrthogonalRoutingGenerator.countCrossings(hn2.targetPosis, hn1.start, hn1.end) + OrthogonalRoutingGenerator.countCrossings(hn1.sourcePosis, hn2.start, hn2.end)))) {
            new Dependency(hn1, hn2, depValue2 - depValue1);
        } else if (depValue1 > depValue2) {
            new Dependency(hn2, hn1, depValue1 - depValue2);
        } else if (depValue1 > 0 && depValue2 > 0) {
            new Dependency(hn1, hn2, 0);
            new Dependency(hn2, hn1, 0);
        }
    }

    private static int countConflicts(List<Double> posis1, List<Double> posis2, double minDiff) {
        int conflicts = 0;
        if (!posis1.isEmpty() && !posis2.isEmpty()) {
            Iterator<Double> iter1 = posis1.iterator();
            Iterator<Double> iter2 = posis2.iterator();
            double pos1 = iter1.next();
            double pos2 = iter2.next();
            boolean hasMore = true;
            do {
                if (pos1 > pos2 - minDiff && pos1 < pos2 + minDiff) {
                    ++conflicts;
                }
                if (pos1 <= pos2 && iter1.hasNext()) {
                    pos1 = iter1.next();
                    continue;
                }
                if (pos2 <= pos1 && iter2.hasNext()) {
                    pos2 = iter2.next();
                    continue;
                }
                hasMore = false;
            } while (hasMore);
        }
        return conflicts;
    }

    private static int countCrossings(List<Double> posis, double start, double end) {
        int crossings = 0;
        for (double pos : posis) {
            if (pos > end) break;
            if (!(pos >= start)) continue;
            ++crossings;
        }
        return crossings;
    }

    /*
     * Unable to fully structure code
     */
    private static void breakCycles(List<HyperNode> nodes) {
        sources = new LinkedList<HyperNode>();
        sinks = new LinkedList<HyperNode>();
        nextMark = -1;
        for (HyperNode node : nodes) {
            HyperNode.access$10(node, nextMark--);
            inweight = 0;
            outweight = 0;
            for (Dependency dependency : HyperNode.access$3(node)) {
                outweight += Dependency.access$1(dependency);
            }
            for (Dependency dependency : HyperNode.access$4(node)) {
                inweight += Dependency.access$1(dependency);
            }
            HyperNode.access$11(node, inweight);
            HyperNode.access$12(node, outweight);
            if (outweight == 0) {
                sinks.add(node);
                continue;
            }
            if (inweight != 0) continue;
            sources.add(node);
        }
        unprocessed = new TreeSet<HyperNode>(nodes);
        markBase = nodes.size();
        nextRight = markBase - 1;
        nextLeft = markBase + 1;
        ** GOTO lbl56
        {
            sink = (HyperNode)sinks.removeFirst();
            unprocessed.remove(sink);
            HyperNode.access$10(sink, nextRight--);
            OrthogonalRoutingGenerator.updateNeighbors(sink, sources, sinks);
            do {
                if (!sinks.isEmpty()) continue block3;
                while (!sources.isEmpty()) {
                    source = (HyperNode)sources.removeFirst();
                    unprocessed.remove(source);
                    HyperNode.access$10(source, nextLeft++);
                    OrthogonalRoutingGenerator.updateNeighbors(source, sources, sinks);
                }
                maxOutflow = -2147483648;
                maxNode = null;
                for (HyperNode node : unprocessed) {
                    outflow = HyperNode.access$13(node) - HyperNode.access$14(node);
                    if (outflow <= maxOutflow) continue;
                    maxOutflow = outflow;
                    maxNode = node;
                }
                if (maxNode == null) continue;
                unprocessed.remove(maxNode);
                HyperNode.access$10(maxNode, nextLeft++);
                OrthogonalRoutingGenerator.updateNeighbors(maxNode, sources, sinks);
lbl56:
                // 3 sources

            } while (!unprocessed.isEmpty());
        }
        shiftBase = nodes.size() + 1;
        for (HyperNode node : nodes) {
            if (HyperNode.access$15(node) >= markBase) continue;
            v0 = node;
            HyperNode.access$10(v0, HyperNode.access$15(v0) + shiftBase);
        }
        for (HyperNode source : nodes) {
            depIter = HyperNode.access$3(source).listIterator();
            while (depIter.hasNext()) {
                dependency = (Dependency)depIter.next();
                target = Dependency.access$2(dependency);
                if (HyperNode.access$15(source) <= HyperNode.access$15(target)) continue;
                depIter.remove();
                HyperNode.access$4(target).remove(dependency);
                if (Dependency.access$1(dependency) <= 0) continue;
                Dependency.access$3(dependency, target);
                HyperNode.access$3(target).add(dependency);
                Dependency.access$4(dependency, source);
                HyperNode.access$4(source).add(dependency);
            }
        }
    }

    private static void updateNeighbors(HyperNode node, LinkedList<HyperNode> sources, LinkedList<HyperNode> sinks) {
        for (Dependency dep : node.outgoing) {
            if (dep.target.mark >= 0 || dep.weight <= 0) continue;
            HyperNode hyperNode = dep.target;
            hyperNode.inweight = hyperNode.inweight - dep.weight;
            if (dep.target.inweight > 0 || dep.target.outweight <= 0) continue;
            sources.add(dep.target);
        }
        for (Dependency dep : node.incoming) {
            if (dep.source.mark >= 0 || dep.weight <= 0) continue;
            HyperNode hyperNode = dep.source;
            hyperNode.outweight = hyperNode.outweight - dep.weight;
            if (dep.source.outweight > 0 || dep.source.inweight <= 0) continue;
            sinks.add(dep.source);
        }
    }

    private static void topologicalNumbering(List<HyperNode> nodes) {
        HyperNode node3;
        LinkedList<HyperNode> sources = new LinkedList<HyperNode>();
        LinkedList<HyperNode> rightwardTargets = new LinkedList<HyperNode>();
        for (HyperNode node2 : nodes) {
            node2.inweight = node2.incoming.size();
            node2.outweight = node2.outgoing.size();
            if (node2.inweight == 0) {
                sources.add(node2);
            }
            if (node2.outweight != 0 || node2.sourcePosis.size() != 0) continue;
            rightwardTargets.add(node2);
        }
        int maxRank = -1;
        while (!sources.isEmpty()) {
            node3 = (HyperNode)sources.remove(0);
            for (Object dep : node3.outgoing) {
                HyperNode target = ((Dependency)dep).target;
                target.rank = Math.max(target.rank, node3.rank + 1);
                maxRank = Math.max(maxRank, target.rank);
                HyperNode hyperNode = target;
                hyperNode.inweight = hyperNode.inweight - 1;
                if (target.inweight != 0) continue;
                sources.add(target);
            }
        }
        if (maxRank > -1) {
            for (HyperNode node3 : rightwardTargets) {
                node3.rank = maxRank;
            }
            while (!rightwardTargets.isEmpty()) {
                node3 = (HyperNode)rightwardTargets.remove(0);
                for (Object dep : node3.incoming) {
                    HyperNode source = ((Dependency)dep).source;
                    if (source.sourcePosis.size() > 0) continue;
                    source.rank = Math.min(source.rank, node3.rank - 1);
                    HyperNode hyperNode = source;
                    hyperNode.outweight = hyperNode.outweight - 1;
                    if (source.outweight != 0) continue;
                    rightwardTargets.add(source);
                }
            }
        }
    }

    private static void insertSorted(List<Double> list, double value) {
        ListIterator<Double> listIter = list.listIterator();
        while (listIter.hasNext()) {
            double next = listIter.next().floatValue();
            if (next == value) {
                return;
            }
            if (!(next > value)) continue;
            listIter.previous();
            break;
        }
        listIter.add(value);
    }

    private void writeDebugGraph(LGraph layeredGraph, int layerIndex, List<HyperNode> hypernodes, String label) {
        try {
            Writer writer = this.createWriter(layeredGraph, layerIndex, label);
            writer.write("digraph {\n");
            for (HyperNode hypernode : hypernodes) {
                writer.write("  " + hypernode.hashCode() + "[label=\"" + hypernode.toString() + "\"]\n");
            }
            for (HyperNode hypernode : hypernodes) {
                for (Dependency dependency : hypernode.outgoing) {
                    writer.write("  " + hypernode.hashCode() + "->" + dependency.target.hashCode() + "[label=\"" + dependency.weight + "\"]\n");
                }
            }
            writer.write("}\n");
            writer.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Writer createWriter(LGraph layeredGraph, int layerIndex, String label) throws IOException {
        String path = Util.getDebugOutputPath();
        new File(path).mkdirs();
        String debugFileName = String.valueOf(Util.getDebugOutputFileBaseName(layeredGraph)) + this.debugPrefix + "-l" + layerIndex + "-" + label;
        return new FileWriter(new File(String.valueOf(path) + File.separator + debugFileName + ".dot"));
    }

    private static final class Dependency {
        private HyperNode source;
        private HyperNode target;
        private int weight;

        private Dependency(HyperNode thesource, HyperNode thetarget, int theweight) {
            this.target = thetarget;
            this.source = thesource;
            this.weight = theweight;
            this.source.outgoing.add(this);
            this.target.incoming.add(this);
        }

        public String toString() {
            return this.source + "->" + this.target;
        }

        static /* synthetic */ void access$3(Dependency dependency, HyperNode hyperNode) {
            dependency.source = hyperNode;
        }

        static /* synthetic */ void access$4(Dependency dependency, HyperNode hyperNode) {
            dependency.target = hyperNode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HyperNode
    implements Comparable<HyperNode> {
        private List<LPort> ports = new LinkedList<LPort>();
        private int mark;
        private int rank;
        private double start = Double.NaN;
        private double end = Double.NaN;
        private List<Double> sourcePosis = new LinkedList<Double>();
        private List<Double> targetPosis = new LinkedList<Double>();
        private List<Dependency> outgoing = new LinkedList<Dependency>();
        private int outweight;
        private List<Dependency> incoming = new LinkedList<Dependency>();
        private int inweight;

        private HyperNode() {
        }

        void addPortPosis(LPort port, Map<LPort, HyperNode> hyperNodeMap) {
            hyperNodeMap.put(port, this);
            this.ports.add(port);
            double pos = OrthogonalRoutingGenerator.this.routingStrategy.getPortPositionOnHyperNode(port);
            this.start = Double.isNaN(this.start) ? pos : Math.min(this.start, pos);
            this.end = Double.isNaN(this.end) ? pos : Math.max(this.end, pos);
            if (port.getSide() == OrthogonalRoutingGenerator.this.routingStrategy.getSourcePortSide()) {
                OrthogonalRoutingGenerator.insertSorted(this.sourcePosis, pos);
            } else {
                OrthogonalRoutingGenerator.insertSorted(this.targetPosis, pos);
            }
            for (LPort otherPort : port.getConnectedPorts()) {
                if (hyperNodeMap.containsKey(otherPort)) continue;
                this.addPortPosis(otherPort, hyperNodeMap);
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("{");
            Iterator<LPort> portIter = this.ports.iterator();
            while (portIter.hasNext()) {
                LPort port = portIter.next();
                String name = port.getNode().getName();
                if (name == null) {
                    name = "n" + port.getNode().getIndex();
                }
                builder.append(name);
                if (!portIter.hasNext()) continue;
                builder.append(',');
            }
            builder.append('}');
            return builder.toString();
        }

        @Override
        public int compareTo(HyperNode other) {
            return this.mark - other.mark;
        }

        public boolean equals(Object object) {
            if (object instanceof HyperNode) {
                HyperNode other = (HyperNode)object;
                return this.mark == other.mark;
            }
            return false;
        }

        public int hashCode() {
            return this.mark;
        }

        static /* synthetic */ void access$10(HyperNode hyperNode, int n) {
            hyperNode.mark = n;
        }
    }

    public static interface IRoutingDirectionStrategy {
        public double getPortPositionOnHyperNode(LPort var1);

        public PortSide getSourcePortSide();

        public PortSide getTargetPortSide();

        public void calculateBendPoints(HyperNode var1, double var2, double var4);
    }

    public static class NorthToSouthRoutingStrategy
    implements IRoutingDirectionStrategy {
        public double getPortPositionOnHyperNode(LPort port) {
            return port.getNode().getPosition().x + port.getPosition().x + port.getAnchor().x;
        }

        public PortSide getSourcePortSide() {
            return PortSide.SOUTH;
        }

        public PortSide getTargetPortSide() {
            return PortSide.NORTH;
        }

        public void calculateBendPoints(HyperNode hyperNode, double startPos, double edgeSpacing) {
            double y = startPos + (double)hyperNode.rank * edgeSpacing;
            for (LPort port : hyperNode.ports) {
                double sourcex = port.getNode().getPosition().x + port.getPosition().x + port.getAnchor().x;
                for (LEdge edge : port.getOutgoingEdges()) {
                    LPort target = edge.getTarget();
                    double targetx = target.getNode().getPosition().x + target.getPosition().x + target.getAnchor().x;
                    if (!(Math.abs(sourcex - targetx) > edgeSpacing / 256.0)) continue;
                    KVector point1 = new KVector(sourcex, y);
                    edge.getBendPoints().add((Object)point1);
                    KVector point2 = new KVector(targetx, y);
                    edge.getBendPoints().add((Object)point2);
                }
            }
        }
    }

    public static class SouthToNorthRoutingStrategy
    implements IRoutingDirectionStrategy {
        public double getPortPositionOnHyperNode(LPort port) {
            return port.getNode().getPosition().x + port.getPosition().x + port.getAnchor().x;
        }

        public PortSide getSourcePortSide() {
            return PortSide.NORTH;
        }

        public PortSide getTargetPortSide() {
            return PortSide.SOUTH;
        }

        public void calculateBendPoints(HyperNode hyperNode, double startPos, double edgeSpacing) {
            double y = startPos - (double)hyperNode.rank * edgeSpacing;
            for (LPort port : hyperNode.ports) {
                double sourcex = port.getNode().getPosition().x + port.getPosition().x + port.getAnchor().x;
                for (LEdge edge : port.getOutgoingEdges()) {
                    LPort target = edge.getTarget();
                    double targetx = target.getNode().getPosition().x + target.getPosition().x + target.getAnchor().x;
                    if (!(Math.abs(sourcex - targetx) > edgeSpacing / 256.0)) continue;
                    KVector point1 = new KVector(sourcex, y);
                    edge.getBendPoints().add((Object)point1);
                    KVector point2 = new KVector(targetx, y);
                    edge.getBendPoints().add((Object)point2);
                }
            }
        }
    }

    public static class WestToEastRoutingStrategy
    implements IRoutingDirectionStrategy {
        public double getPortPositionOnHyperNode(LPort port) {
            return port.getNode().getPosition().y + port.getPosition().y + port.getAnchor().y;
        }

        public PortSide getSourcePortSide() {
            return PortSide.EAST;
        }

        public PortSide getTargetPortSide() {
            return PortSide.WEST;
        }

        public void calculateBendPoints(HyperNode hyperNode, double startPos, double edgeSpacing) {
            double x = startPos + (double)hyperNode.rank * edgeSpacing;
            for (LPort port : hyperNode.ports) {
                double sourcey = port.getNode().getPosition().y + port.getPosition().y + port.getAnchor().y;
                for (LEdge edge : port.getOutgoingEdges()) {
                    LPort target = edge.getTarget();
                    double targety = target.getNode().getPosition().y + target.getPosition().y + target.getAnchor().y;
                    if (!(Math.abs(sourcey - targety) > edgeSpacing / 256.0)) continue;
                    KVector point1 = new KVector(x, sourcey);
                    edge.getBendPoints().add((Object)point1);
                    KVector point2 = new KVector(x, targety);
                    edge.getBendPoints().add((Object)point2);
                }
            }
        }
    }
}

