/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p3order;

import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.p3order.IPortDistributor;
import de.cau.cs.kieler.klay.layered.p3order.NodeGroup;
import de.cau.cs.kieler.klay.layered.properties.PortType;
import java.util.Collections;
import java.util.Comparator;

public class NodeRelativePortDistributor
implements IPortDistributor {
    private float[] portBarycenter;
    private float[] portRanks;
    private static final float INCR_ONE = 0.3f;
    private static final float INCR_TWO = 0.5f;
    private static final float INCR_THREE = 0.7f;
    private static final float INCR_FOUR = 0.9f;

    public NodeRelativePortDistributor(float[] portRanks) {
        this.portRanks = portRanks;
        this.portBarycenter = new float[portRanks.length];
    }

    public void calculatePortRanks(LNode[] layer, PortType portType) {
        int nodeIx = 0;
        while (nodeIx < layer.length) {
            this.calculatePortRanks(layer[nodeIx], nodeIx, portType);
            ++nodeIx;
        }
    }

    public void calculatePortRanks(NodeGroup[] layer, PortType portType) {
        int nodeIx = 0;
        while (nodeIx < layer.length) {
            NodeGroup nodeGroup = layer[nodeIx];
            if (nodeGroup.getNodes().length == 1) {
                this.calculatePortRanks(nodeGroup.getNode(), nodeIx, portType);
            }
            ++nodeIx;
        }
    }

    private void calculatePortRanks(LNode node, int nodeIx, PortType type) {
        block11: {
            block10: {
                if (!((PortConstraints)node.getProperty(LayoutOptions.PORT_CONSTRAINTS)).isOrderFixed()) break block10;
                switch (type) {
                    case INPUT: {
                        int inputCount = 0;
                        int northInputCount = 0;
                        for (LPort port : node.getPorts()) {
                            if (port.getIncomingEdges().isEmpty()) continue;
                            ++inputCount;
                            if (port.getSide() != PortSide.NORTH) continue;
                            ++northInputCount;
                        }
                        float incr = 1.0f / (float)(inputCount + 1);
                        float northPos = (float)nodeIx + (float)(northInputCount + 1) * incr;
                        float restPos = (float)(nodeIx + 1) - incr;
                        for (LPort port : node.getPorts(PortType.INPUT)) {
                            if (port.getSide() == PortSide.NORTH) {
                                this.portRanks[port.id] = northPos;
                                northPos -= incr;
                                continue;
                            }
                            this.portRanks[port.id] = restPos;
                            restPos -= incr;
                        }
                        break block11;
                    }
                    case OUTPUT: {
                        int outputCount = 0;
                        for (LPort port : node.getPorts()) {
                            if (port.getOutgoingEdges().isEmpty()) continue;
                            ++outputCount;
                        }
                        float outincr = 1.0f / (float)(outputCount + 1);
                        float pos = (float)nodeIx + outincr;
                        for (LPort port : node.getPorts(PortType.OUTPUT)) {
                            this.portRanks[port.id] = pos;
                            pos += outincr;
                        }
                    }
                }
                break block11;
            }
            for (LPort port : node.getPorts(type)) {
                this.portRanks[port.id] = (float)nodeIx + NodeRelativePortDistributor.getPortIncr(type, port.getSide());
            }
        }
    }

    private static float getPortIncr(PortType type, PortSide side) {
        switch (type) {
            case INPUT: {
                switch (side) {
                    case NORTH: {
                        return 0.3f;
                    }
                    case WEST: {
                        return 0.5f;
                    }
                    case SOUTH: {
                        return 0.7f;
                    }
                    case EAST: {
                        return 0.9f;
                    }
                }
                break;
            }
            case OUTPUT: {
                switch (side) {
                    case NORTH: {
                        return 0.3f;
                    }
                    case EAST: {
                        return 0.5f;
                    }
                    case SOUTH: {
                        return 0.7f;
                    }
                    case WEST: {
                        return 0.9f;
                    }
                }
            }
        }
        return 0.0f;
    }

    public void distributePorts(LNode[][] layeredGraph) {
        int l = 0;
        while (l < layeredGraph.length) {
            if (l + 1 < layeredGraph.length) {
                this.calculatePortRanks(layeredGraph[l + 1], PortType.INPUT);
            }
            LNode[] layer = layeredGraph[l];
            int i = 0;
            while (i < layer.length) {
                this.distributePorts(layer[i], i);
                ++i;
            }
            ++l;
        }
    }

    public void distributePorts(NodeGroup[][] layeredGraph) {
        int l = 0;
        while (l < layeredGraph.length) {
            if (l + 1 < layeredGraph.length) {
                this.calculatePortRanks(layeredGraph[l + 1], PortType.INPUT);
            }
            NodeGroup[] layer = layeredGraph[l];
            int i = 0;
            while (i < layer.length) {
                this.distributePorts(layer[i].getNode(), i);
                ++i;
            }
            ++l;
        }
    }

    private void distributePorts(LNode node, int nodeIndex) {
        if (!((PortConstraints)node.getProperty(LayoutOptions.PORT_CONSTRAINTS)).isOrderFixed()) {
            if (node.getPorts().size() > 1) {
                for (LPort port : node.getPorts()) {
                    float sum = 0.0f;
                    for (LPort connectedPort : port.getConnectedPorts()) {
                        sum += this.portRanks[connectedPort.id];
                    }
                    this.portBarycenter[port.id] = port.getDegree() == 0 ? -1.0f : sum / (float)port.getDegree();
                }
                NodeRelativePortDistributor.sortPorts(node, this.portBarycenter);
            }
            node.setProperty(LayoutOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_ORDER);
        } else {
            NodeRelativePortDistributor.sortPortsByPosition(node);
        }
        this.calculatePortRanks(node, nodeIndex, PortType.OUTPUT);
    }

    private static void sortPorts(LNode node, final float[] position) {
        Collections.sort(node.getPorts(), new Comparator<LPort>(){

            @Override
            public int compare(LPort port1, LPort port2) {
                PortType type2;
                PortSide side1 = port1.getSide();
                PortType type1 = port1.getNetFlow() >= 0 ? PortType.INPUT : PortType.OUTPUT;
                PortSide side2 = port2.getSide();
                PortType portType = type2 = port2.getNetFlow() >= 0 ? PortType.INPUT : PortType.OUTPUT;
                if (side1 != side2) {
                    return side1.ordinal() - side2.ordinal();
                }
                if (type1 != type2) {
                    if (side1 == PortSide.NORTH) {
                        return type1.ordinal() - type2.ordinal();
                    }
                    return type2.ordinal() - type1.ordinal();
                }
                float pos1 = position[port1.id];
                float pos2 = position[port2.id];
                if (type1 == PortType.INPUT) {
                    return Float.compare(pos2, pos1);
                }
                return Float.compare(pos1, pos2);
            }
        });
    }

    private static void sortPortsByPosition(LNode node) {
        Collections.sort(node.getPorts(), new Comparator<LPort>(){

            @Override
            public int compare(LPort port1, LPort port2) {
                PortSide port1Side = port1.getSide();
                PortSide port2Side = port2.getSide();
                int result = 0;
                switch (port1Side) {
                    case NORTH: {
                        if (port2Side == PortSide.NORTH) {
                            result = Double.compare(port1.getPosition().x, port2.getPosition().x);
                            break;
                        }
                        result = -1;
                        break;
                    }
                    case EAST: {
                        if (port2Side == PortSide.NORTH) {
                            result = 1;
                            break;
                        }
                        if (port2Side == PortSide.EAST) {
                            result = Double.compare(port1.getPosition().y, port2.getPosition().y);
                            break;
                        }
                        result = -1;
                        break;
                    }
                    case SOUTH: {
                        if (port2Side == PortSide.NORTH || port2Side == PortSide.EAST) {
                            result = 1;
                            break;
                        }
                        if (port2Side == PortSide.SOUTH) {
                            result = Double.compare(port2.getPosition().x, port1.getPosition().x);
                            break;
                        }
                        result = -1;
                        break;
                    }
                    case WEST: {
                        result = port2Side == PortSide.NORTH || port2Side == PortSide.EAST || port2Side == PortSide.SOUTH ? 1 : (port2Side == PortSide.WEST ? Double.compare(port2.getPosition().y, port1.getPosition().y) : -1);
                    }
                }
                return result;
            }
        });
    }
}

