/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.force.graph;

import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.core.properties.MapPropertyHolder;
import de.cau.cs.kieler.klay.force.graph.FBendpoint;
import de.cau.cs.kieler.klay.force.graph.FLabel;
import de.cau.cs.kieler.klay.force.graph.FNode;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FEdge
extends MapPropertyHolder {
    private static final long serialVersionUID = 4387555754824186467L;
    private List<FBendpoint> bendpoints = new LinkedList<FBendpoint>();
    private List<FLabel> labels = new LinkedList<FLabel>();
    private FNode source;
    private FNode target;

    public String toString() {
        if (this.source != null && this.target != null) {
            return String.valueOf(this.source.toString()) + "->" + this.target.toString();
        }
        return "e_" + ((Object)((Object)this)).hashCode();
    }

    public FNode getSource() {
        return this.source;
    }

    public FNode getTarget() {
        return this.target;
    }

    public List<FBendpoint> getBendpoints() {
        return this.bendpoints;
    }

    public List<FLabel> getLabels() {
        return this.labels;
    }

    public KVector getSourcePoint() {
        KVector v = this.target.getPosition().differenceCreate(this.source.getPosition());
        FEdge.clipVector(v, this.source.getSize().x, this.source.getSize().y);
        return v.add(this.source.getPosition());
    }

    public KVector getTargetPoint() {
        KVector v = this.source.getPosition().differenceCreate(this.target.getPosition());
        FEdge.clipVector(v, this.target.getSize().x, this.target.getSize().y);
        return v.add(this.target.getPosition());
    }

    private static void clipVector(KVector v, double width, double height) {
        double wh = width / 2.0;
        double hh = height / 2.0;
        double absx = Math.abs(v.x);
        double absy = Math.abs(v.y);
        double xscale = 1.0;
        double yscale = 1.0;
        if (absx > wh) {
            xscale = wh / absx;
        }
        if (absy > hh) {
            yscale = hh / absy;
        }
        v.scale(Math.min(xscale, yscale));
    }

    public final void setSource(FNode theSource) {
        this.source = theSource;
    }

    public final void setTarget(FNode theTarget) {
        this.target = theTarget;
    }

    public KVectorChain toVectorChain() {
        KVectorChain vectorChain = new KVectorChain();
        vectorChain.add((Object)this.getSourcePoint());
        for (FBendpoint bendPoint : this.bendpoints) {
            vectorChain.add((Object)bendPoint.getPosition());
        }
        vectorChain.add((Object)this.getTargetPoint());
        return vectorChain;
    }

    public void distributeBendpoints() {
        int count = this.bendpoints.size();
        if (count > 0) {
            KVector sourcePos = this.source.getPosition();
            KVector targetPos = this.target.getPosition();
            KVector incr = targetPos.differenceCreate(sourcePos).scale(1.0 / (double)(count + 1));
            KVector pos = sourcePos.clone();
            for (FBendpoint bendPoint : this.bendpoints) {
                bendPoint.getPosition().x = pos.x;
                bendPoint.getPosition().y = pos.y;
                pos.add(incr);
            }
        }
    }
}

