/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.force;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.IPropertyHolder;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KInsets;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import de.cau.cs.kieler.klay.force.IGraphImporter;
import de.cau.cs.kieler.klay.force.graph.FEdge;
import de.cau.cs.kieler.klay.force.graph.FGraph;
import de.cau.cs.kieler.klay.force.graph.FLabel;
import de.cau.cs.kieler.klay.force.graph.FNode;
import de.cau.cs.kieler.klay.force.properties.Properties;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KGraphImporter
implements IGraphImporter<KNode> {
    @Override
    public FGraph importGraph(KNode kgraph) {
        FGraph fgraph = new FGraph();
        fgraph.setProperty(Properties.ORIGIN, kgraph);
        KShapeLayout sourceShapeLayout = (KShapeLayout)kgraph.getData(KShapeLayout.class);
        fgraph.copyProperties((IPropertyHolder)sourceShapeLayout);
        fgraph.checkProperties(new IProperty[]{Properties.SPACING, Properties.ASPECT_RATIO, Properties.TEMPERATURE, Properties.ITERATIONS, Properties.REPULSION});
        HashMap<KNode, FNode> elemMap = new HashMap<KNode, FNode>();
        this.transformNodes(kgraph, fgraph, elemMap);
        this.transformEdges(kgraph, fgraph, elemMap);
        return fgraph;
    }

    private void transformNodes(KNode parentNode, FGraph fgraph, Map<KNode, FNode> elemMap) {
        int index = 0;
        for (KNode knode : parentNode.getChildren()) {
            KShapeLayout nodeLayout = (KShapeLayout)knode.getData(KShapeLayout.class);
            String label = "";
            if (!knode.getLabels().isEmpty()) {
                label = ((KLabel)knode.getLabels().get(0)).getText();
            }
            FNode newNode = new FNode(label);
            newNode.id = index++;
            newNode.setProperty(Properties.ORIGIN, knode);
            newNode.getPosition().x = nodeLayout.getXpos() + nodeLayout.getWidth() / 2.0f;
            newNode.getPosition().y = nodeLayout.getYpos() + nodeLayout.getHeight() / 2.0f;
            newNode.getSize().x = Math.max(nodeLayout.getWidth(), 1.0f);
            newNode.getSize().y = Math.max(nodeLayout.getHeight(), 1.0f);
            fgraph.getNodes().add(newNode);
            elemMap.put(knode, newNode);
            PortConstraints portConstraints = (PortConstraints)nodeLayout.getProperty(LayoutOptions.PORT_CONSTRAINTS);
            if (portConstraints == PortConstraints.UNDEFINED) {
                portConstraints = PortConstraints.FREE;
            }
            newNode.copyProperties((IPropertyHolder)nodeLayout);
        }
    }

    private void transformEdges(KNode parentNode, FGraph fgraph, Map<KNode, FNode> elemMap) {
        for (KNode knode : parentNode.getChildren()) {
            for (KEdge kedge : knode.getOutgoingEdges()) {
                if (kedge.getTarget().getParent() != parentNode || knode == kedge.getTarget()) continue;
                KEdgeLayout edgeLayout = (KEdgeLayout)kedge.getData(KEdgeLayout.class);
                FEdge newEdge = new FEdge();
                newEdge.setProperty(Properties.ORIGIN, kedge);
                newEdge.setSource(elemMap.get(knode));
                newEdge.setTarget(elemMap.get(kedge.getTarget()));
                fgraph.getEdges().add(newEdge);
                for (KLabel klabel : kedge.getLabels()) {
                    KShapeLayout labelLayout = (KShapeLayout)klabel.getData(KShapeLayout.class);
                    FLabel newLabel = new FLabel(newEdge, klabel.getText());
                    newLabel.getSize().x = Math.max(labelLayout.getWidth(), 1.0f);
                    newLabel.getSize().y = Math.max(labelLayout.getHeight(), 1.0f);
                    newLabel.setProperty(Properties.ORIGIN, klabel);
                    newLabel.refreshPosition();
                    fgraph.getLabels().add(newLabel);
                }
                newEdge.copyProperties((IPropertyHolder)edgeLayout);
                newEdge.checkProperties(new IProperty[]{Properties.LABEL_SPACING, Properties.EDGE_REP});
            }
        }
    }

    @Override
    public void applyLayout(FGraph fgraph) {
        KNode kgraph = (KNode)fgraph.getProperty(Properties.ORIGIN);
        KShapeLayout parentLayout = (KShapeLayout)kgraph.getData(KShapeLayout.class);
        float borderSpacing = ((Float)fgraph.getProperty(LayoutOptions.BORDER_SPACING)).floatValue();
        if (borderSpacing < 0.0f) {
            borderSpacing = ((Float)Properties.SPACING.getDefault()).floatValue();
        }
        fgraph.setProperty(LayoutOptions.BORDER_SPACING, Float.valueOf(borderSpacing));
        double minXPos = 2.147483647E9;
        double minYPos = 2.147483647E9;
        double maxXPos = -2.147483648E9;
        double maxYPos = -2.147483648E9;
        for (FNode node : fgraph.getNodes()) {
            KVector pos = node.getPosition();
            KVector size = node.getSize();
            minXPos = Math.min(minXPos, pos.x - size.x / 2.0);
            minYPos = Math.min(minYPos, pos.y - size.y / 2.0);
            maxXPos = Math.max(maxXPos, pos.x + size.x / 2.0);
            maxYPos = Math.max(maxYPos, pos.y + size.y / 2.0);
        }
        KVector offset = new KVector((double)borderSpacing - minXPos, (double)borderSpacing - minYPos);
        for (FNode fnode : fgraph.getNodes()) {
            Object object = fnode.getProperty(Properties.ORIGIN);
            if (!(object instanceof KNode)) continue;
            KNode knode = (KNode)object;
            KShapeLayout nodeLayout = (KShapeLayout)knode.getData(KShapeLayout.class);
            KVector nodePos = fnode.getPosition().add(offset);
            nodeLayout.setXpos((float)nodePos.x - nodeLayout.getWidth() / 2.0f);
            nodeLayout.setYpos((float)nodePos.y - nodeLayout.getHeight() / 2.0f);
        }
        for (FEdge fedge : fgraph.getEdges()) {
            KEdge kedge = (KEdge)fedge.getProperty(Properties.ORIGIN);
            KEdgeLayout edgeLayout = (KEdgeLayout)kedge.getData(KEdgeLayout.class);
            edgeLayout.getBendPoints().clear();
            edgeLayout.getSourcePoint().applyVector(fedge.getSourcePoint());
            edgeLayout.getTargetPoint().applyVector(fedge.getTargetPoint());
        }
        for (FLabel flabel : fgraph.getLabels()) {
            KLabel klabel = (KLabel)flabel.getProperty(Properties.ORIGIN);
            KShapeLayout klabelLayout = (KShapeLayout)klabel.getData(KShapeLayout.class);
            KVector labelPos = flabel.getPosition().add(offset);
            klabelLayout.applyVector(labelPos);
        }
        KInsets insets = parentLayout.getInsets();
        float width = (float)(maxXPos - minXPos) + 2.0f * borderSpacing + insets.getLeft() + insets.getRight();
        float height = (float)(maxYPos - minYPos) + 2.0f * borderSpacing + insets.getTop() + insets.getBottom();
        KimlUtil.resizeNode((KNode)kgraph, (float)width, (float)height, (boolean)false);
    }
}

