/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.AbstractLayoutProvider;
import de.cau.cs.kieler.kiml.IGraphLayoutEngine;
import de.cau.cs.kieler.kiml.LayoutAlgorithmData;
import de.cau.cs.kieler.kiml.config.DefaultLayoutConfig;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.GraphFeature;
import de.cau.cs.kieler.kiml.options.LayoutOptions;

public class RecursiveGraphLayoutEngine
implements IGraphLayoutEngine {
    public void layout(KNode layoutGraph, IKielerProgressMonitor progressMonitor) {
        int nodeCount = this.countNodes(layoutGraph, true);
        progressMonitor.begin("Recursive Graph Layout", (float)nodeCount);
        this.layoutRecursively(layoutGraph, progressMonitor);
        progressMonitor.done();
    }

    private void layoutRecursively(KNode layoutNode, IKielerProgressMonitor progressMonitor) {
        if (!layoutNode.getChildren().isEmpty() && !((Boolean)((KShapeLayout)layoutNode.getData(KShapeLayout.class)).getProperty(LayoutOptions.NO_LAYOUT)).booleanValue()) {
            int nodeCount;
            LayoutAlgorithmData algorithmData = this.getAlgorithm(layoutNode);
            AbstractLayoutProvider layoutProvider = (AbstractLayoutProvider)algorithmData.getProviderPool().fetch();
            if (((Boolean)((KShapeLayout)layoutNode.getData(KShapeLayout.class)).getProperty(LayoutOptions.LAYOUT_HIERARCHY)).booleanValue() && (algorithmData.getFeatureSupport(GraphFeature.COMPOUND) > -536870912 || algorithmData.getFeatureSupport(GraphFeature.CLUSTERS) > -536870912)) {
                nodeCount = this.countNodes(layoutNode, false);
            } else {
                nodeCount = layoutNode.getChildren().size();
                for (KNode child : layoutNode.getChildren()) {
                    this.layoutRecursively(child, progressMonitor);
                    if (!progressMonitor.isCanceled()) continue;
                    return;
                }
            }
            layoutProvider.doLayout(layoutNode, progressMonitor.subTask((float)nodeCount));
            algorithmData.getProviderPool().release((Object)layoutProvider);
        }
    }

    private LayoutAlgorithmData getAlgorithm(KNode layoutNode) {
        String diagramType;
        KShapeLayout nodeLayout = (KShapeLayout)layoutNode.getData(KShapeLayout.class);
        String layoutHint = (String)nodeLayout.getProperty(LayoutOptions.ALGORITHM);
        LayoutAlgorithmData algorithmData = DefaultLayoutConfig.getLayouterData(layoutHint, diagramType = (String)nodeLayout.getProperty(LayoutOptions.DIAGRAM_TYPE));
        if (algorithmData == null) {
            throw new IllegalStateException("No registered layout algorithm is available.");
        }
        return algorithmData;
    }

    private int countNodes(KNode layoutNode, boolean countAncestors) {
        int count = layoutNode.getChildren().size();
        for (KNode childNode : layoutNode.getChildren()) {
            if (childNode.getChildren().isEmpty()) continue;
            count += this.countNodes(childNode, false);
        }
        if (countAncestors) {
            KNode parent = layoutNode.getParent();
            while (parent != null) {
                count += parent.getChildren().size();
                parent = parent.getParent();
            }
        }
        return count;
    }

    public boolean isActive() {
        return true;
    }
}

