/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.ui.views;

import de.cau.cs.kieler.kiml.LayoutAlgorithmData;
import de.cau.cs.kieler.kiml.LayoutDataService;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.ui.KimlUiPlugin;
import de.cau.cs.kieler.kiml.ui.Messages;
import de.cau.cs.kieler.kiml.ui.diagram.IDiagramLayoutManager;
import de.cau.cs.kieler.kiml.ui.service.EclipseLayoutInfoService;
import de.cau.cs.kieler.kiml.ui.util.KimlUiUtil;
import de.cau.cs.kieler.kiml.ui.views.LayoutViewPart;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.properties.IPropertySheetEntry;

public class SelectionInfoAction
extends Action {
    private static ImageDescriptor icon = KimlUiPlugin.getImageDescriptor("icons/menu16/info.gif");
    private static final int DEFAULT_WIDTH = 580;
    private static final int DEFAULT_HEIGHT = 600;
    private LayoutViewPart layoutView;

    public SelectionInfoAction(LayoutViewPart thelayoutView, String text) {
        super(text, icon);
        this.layoutView = thelayoutView;
    }

    public void run() {
        SelectionInfoDialog dialog = new SelectionInfoDialog(this.layoutView.getViewSite().getShell(), this.createInfo());
        dialog.open();
    }

    private String createInfo() {
        List<IPropertySheetEntry> selectedOptions;
        LayoutAlgorithmData[] layouterData;
        Object diagramPart;
        LayoutDataService layoutServices = LayoutDataService.getInstance();
        StringBuilder builder = new StringBuilder();
        IWorkbenchPart workbenchPart = this.layoutView.getCurrentWorkbenchPart();
        if (workbenchPart != null) {
            builder.append("<b>Workbench part class</b><ul><li>" + workbenchPart.getClass().getName() + "</li></ul>");
        }
        if ((diagramPart = this.layoutView.getCurrentDiagramPart()) != null) {
            builder.append("<b>Diagram part class</b><ul><li>" + diagramPart.getClass().getName() + "</li></ul>");
            IDiagramLayoutManager<?> manager = EclipseLayoutInfoService.getInstance().getManager(null, diagramPart);
            EObject model = (EObject)manager.getAdapter(diagramPart, EObject.class);
            if (model != null) {
                builder.append("<b>Domain model class</b><ul><li>" + model.eClass().getInstanceTypeName() + "</li></ul>");
            }
        }
        if ((layouterData = this.layoutView.getCurrentLayouterData()) != null && layouterData.length > 0) {
            builder.append("<b>Involved layout providers</b><ul>");
            LayoutAlgorithmData[] layoutAlgorithmDataArray = layouterData;
            int n = layouterData.length;
            int n2 = 0;
            while (n2 < n) {
                LayoutAlgorithmData data = layoutAlgorithmDataArray[n2];
                if (data != null) {
                    builder.append("<li>" + data.getName());
                    String category = layoutServices.getCategoryName(data.getCategory());
                    if (category != null) {
                        builder.append(" (" + category + ")");
                    }
                    builder.append(" - " + data.getId() + "</li>");
                }
                ++n2;
            }
            builder.append("</ul>");
        }
        if (!(selectedOptions = this.layoutView.getSelection()).isEmpty()) {
            builder.append("<b>Selected options</b><ul>");
            for (IPropertySheetEntry entry : selectedOptions) {
                LayoutOptionData<?> optionData = KimlUiUtil.getOptionData(layouterData, entry.getDisplayName());
                if (optionData == null) continue;
                builder.append("<li>" + optionData.getName() + " (" + optionData.getType().literal() + ") - " + optionData.getId() + "</li>");
            }
            builder.append("</ul>");
        }
        if (builder.length() == 0) {
            builder.append("No information available.");
        }
        return builder.toString();
    }

    private static class SelectionInfoDialog
    extends Dialog {
        private String htmlText;

        protected SelectionInfoDialog(Shell parentShell, String text) {
            super(parentShell);
            this.htmlText = text;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(Messages.getString("kiml.ui.38"));
        }

        protected Point getInitialSize() {
            return new Point(580, 600);
        }

        protected boolean isResizable() {
            return true;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            try {
                Browser browser = new Browser(composite, 2048);
                GridData gridData = new GridData(1808);
                browser.setLayoutData((Object)gridData);
                browser.setText(this.htmlText);
            }
            catch (SWTError exception) {
                Status status = new Status(4, "de.cau.cs.kieler.kiml.ui", "Could not instantiate Browser.", (Throwable)exception);
                StatusManager.getManager().handle((IStatus)status);
            }
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        }
    }
}

