/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service.grana.analyses;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KPoint;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.service.grana.AnalysisOptions;
import de.cau.cs.kieler.kiml.service.grana.IAnalysis;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeEdgeOverlapsAnalysis
implements IAnalysis {
    public static final String ID = "de.cau.cs.kieler.kiml.grana.nodeEdgeOverlaps";
    private static final int LEFT = 1;
    private static final int RIGHT = 2;
    private static final int BOTTOM = 4;
    private static final int TOP = 8;

    private static boolean hasIntersection(KPoint p1, KPoint p2, float x1, float y1, float x2, float y2) {
        float s = (y2 - y1) * (p2.getX() - p1.getX()) - (x2 - x1) * (p2.getY() - p1.getY());
        if (s == 0.0f) {
            return false;
        }
        float a1 = (x2 - x1) * (p1.getY() - y1) - (y2 - y1) * (p1.getX() - x1);
        float a2 = (p2.getX() - p1.getX()) * (p1.getY() - y1) - (p2.getY() - p1.getY()) * (p1.getX() - x1);
        float t1 = a1 / s;
        float t2 = a2 / s;
        return 0.0f < t1 && t1 < 1.0f && 0.0f < t2 && t2 < 1.0f;
    }

    private static int computeOutCode(KPoint point, KNode node) {
        KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
        int code = 0;
        if (point.getY() > nodeLayout.getYpos() + nodeLayout.getHeight()) {
            code |= 8;
        } else if (point.getY() < nodeLayout.getYpos()) {
            code |= 4;
        }
        if (point.getX() > nodeLayout.getXpos() + nodeLayout.getWidth()) {
            code |= 2;
        } else if (point.getX() < nodeLayout.getXpos()) {
            code |= 1;
        }
        return code;
    }

    private static int computeOppositeOutCode(int outcode) {
        int oppOutcode = 0;
        if ((outcode & 1) > 0) {
            oppOutcode |= 2;
        } else if ((outcode & 2) > 0) {
            oppOutcode |= 1;
        }
        if ((outcode & 8) > 0) {
            oppOutcode |= 4;
        } else if ((outcode & 4) > 0) {
            oppOutcode |= 8;
        }
        return oppOutcode;
    }

    private static boolean hasIntersection(KPoint p1, KPoint p2, KNode node) {
        KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
        int p1OutCode = NodeEdgeOverlapsAnalysis.computeOutCode(p1, node);
        int p2OutCode = NodeEdgeOverlapsAnalysis.computeOutCode(p2, node);
        if (p1OutCode == 0 || p2OutCode == 0) {
            return true;
        }
        if ((p1OutCode & p2OutCode) > 0) {
            return false;
        }
        if (p1OutCode == NodeEdgeOverlapsAnalysis.computeOppositeOutCode(p2OutCode)) {
            return true;
        }
        int outcode = p1OutCode != 8 && p1OutCode > 4 ? p2OutCode : p1OutCode;
        float xpos = nodeLayout.getXpos();
        float ypos = nodeLayout.getYpos();
        float width = nodeLayout.getWidth();
        float height = nodeLayout.getHeight();
        if ((outcode & 1) > 0) {
            return NodeEdgeOverlapsAnalysis.hasIntersection(p1, p2, xpos, ypos, xpos, ypos + height);
        }
        if ((outcode & 2) > 0) {
            return NodeEdgeOverlapsAnalysis.hasIntersection(p1, p2, xpos + width, ypos, xpos + width, ypos + height);
        }
        if ((outcode & 8) > 0) {
            return NodeEdgeOverlapsAnalysis.hasIntersection(p1, p2, xpos, ypos, xpos + width, ypos);
        }
        return NodeEdgeOverlapsAnalysis.hasIntersection(p1, p2, xpos, ypos + height, xpos + width, ypos + height);
    }

    private int computeNumberOfOverlaps(KNode node1, KNode node2) {
        if (node1 == node2) {
            return 0;
        }
        int overlaps = 0;
        block0: for (KEdge edge : node1.getOutgoingEdges()) {
            KPoint p22;
            if (edge.getTarget() == node2) continue;
            KEdgeLayout edgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class);
            KPoint p1 = edgeLayout.getSourcePoint();
            for (KPoint p22 : edgeLayout.getBendPoints()) {
                if (NodeEdgeOverlapsAnalysis.hasIntersection(p1, p22, node2)) {
                    ++overlaps;
                    continue block0;
                }
                p1 = p22;
            }
            p22 = edgeLayout.getTargetPoint();
            if (!NodeEdgeOverlapsAnalysis.hasIntersection(p1, p22, node2)) continue;
            ++overlaps;
        }
        return overlaps;
    }

    @Override
    public Object doAnalysis(KNode parentNode, Map<String, Object> results, IKielerProgressMonitor progressMonitor) {
        progressMonitor.begin("Node Crossings analysis", 1.0f);
        boolean hierarchy = (Boolean)((KShapeLayout)parentNode.getData(KShapeLayout.class)).getProperty(AnalysisOptions.ANALYZE_HIERARCHY);
        int overlaps = 0;
        LinkedList<KNode> nodeQueue = new LinkedList<KNode>();
        nodeQueue.add(parentNode);
        while (nodeQueue.size() > 0) {
            KNode node = (KNode)nodeQueue.remove(0);
            for (KNode node1 : node.getChildren()) {
                for (KNode node2 : node.getChildren()) {
                    overlaps += this.computeNumberOfOverlaps(node1, node2);
                }
            }
            if (!hierarchy) continue;
            nodeQueue.addAll((Collection<KNode>)node.getChildren());
        }
        progressMonitor.done();
        return overlaps;
    }
}

