/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service.grana.analyses;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.service.grana.IAnalysis;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundEdgeAnalysis
implements IAnalysis {
    public static final String ID = "de.cau.cs.kieler.kiml.grana.compoundEdge";

    @Override
    public Object doAnalysis(KNode parentNode, Map<String, Object> results, IKielerProgressMonitor progressMonitor) {
        progressMonitor.begin("Compound edge analysis", 1.0f);
        int edgeCount = 0;
        int maxLevels = 0;
        int compoundEdges = 0;
        LinkedList nodeQueue = new LinkedList();
        nodeQueue.addAll(parentNode.getChildren());
        while (!nodeQueue.isEmpty()) {
            KNode node = (KNode)nodeQueue.remove(0);
            for (KEdge edge : node.getOutgoingEdges()) {
                int crossedLevels = this.crossedLevels(edge.getSource(), edge.getTarget());
                if (crossedLevels > 0) {
                    ++edgeCount;
                }
                if (crossedLevels > maxLevels) {
                    maxLevels = crossedLevels;
                }
                if (edge.getSource().getChildren().isEmpty() && edge.getTarget().getChildren().isEmpty()) continue;
                ++compoundEdges;
            }
            nodeQueue.addAll(node.getChildren());
        }
        progressMonitor.done();
        return new Object[]{edgeCount, maxLevels, compoundEdges};
    }

    private int crossedLevels(KNode node1, KNode node2) {
        LinkedList<KNode> parentList1 = new LinkedList<KNode>();
        KNode parent1 = node1.getParent();
        while (parent1 != null) {
            parentList1.add(parent1);
            parent1 = parent1.getParent();
        }
        parentList1.add(null);
        KNode parent2 = node2.getParent();
        int levels1 = parentList1.indexOf(parent2);
        int levels2 = 0;
        while (levels1 < 0) {
            parent2 = parent2.getParent();
            levels1 = parentList1.indexOf(parent2);
            ++levels2;
        }
        return levels1 + levels2;
    }
}

