/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.gmf;

import com.google.common.collect.BiMap;
import de.cau.cs.kieler.core.WrappedException;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KGraphFactory;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KLabeledGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.Property;
import de.cau.cs.kieler.core.util.Maybe;
import de.cau.cs.kieler.kiml.LayoutContext;
import de.cau.cs.kieler.kiml.config.ILayoutConfig;
import de.cau.cs.kieler.kiml.config.VolatileLayoutConfig;
import de.cau.cs.kieler.kiml.gmf.ApplyLayoutRequest;
import de.cau.cs.kieler.kiml.gmf.GefDiagramLayoutManager;
import de.cau.cs.kieler.kiml.gmf.GmfLayoutConfig;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KInsets;
import de.cau.cs.kieler.kiml.klayoutdata.KLayoutDataFactory;
import de.cau.cs.kieler.kiml.klayoutdata.KPoint;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.impl.KEdgeLayoutImpl;
import de.cau.cs.kieler.kiml.klayoutdata.impl.KShapeLayoutImpl;
import de.cau.cs.kieler.kiml.options.EdgeLabelPlacement;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.ui.diagram.LayoutMapping;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.TopGraphicEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GmfDiagramLayoutManager
extends GefDiagramLayoutManager<IGraphicalEditPart> {
    public static final IProperty<List<ConnectionEditPart>> CONNECTIONS = new Property("gmf.connections");
    public static final IProperty<DiagramEditor> DIAGRAM_EDITOR = new Property("gmf.diagramEditor");
    public static final IProperty<DiagramEditPart> DIAGRAM_EDIT_PART = new Property("gmf.diagramEditPart");
    public static final IProperty<Command> LAYOUT_COMMAND = new Property("gmf.applyLayoutCommand");
    public static final IProperty<CommandStack> COMMAND_STACK = new Property("gmf.applyLayoutCommandStack");
    public static final IProperty<VolatileLayoutConfig> STATIC_CONFIG = new Property("gmf.staticLayoutConfig");
    private GmfLayoutConfig layoutConfig = new GmfLayoutConfig();

    public static Insets calcInsets(IFigure parent, IFigure child) {
        Insets result = new Insets(0);
        IFigure currentChild = child;
        IFigure currentParent = child.getParent();
        Point coordsToAdd = null;
        boolean isRelative = false;
        while (currentChild != parent && currentParent != null) {
            if (currentParent.isCoordinateSystem()) {
                isRelative = true;
                result.add(currentParent.getInsets());
                if (coordsToAdd != null) {
                    result.left += coordsToAdd.x;
                    result.top += coordsToAdd.y;
                }
                coordsToAdd = currentParent.getBounds().getLocation();
            } else if (currentParent == parent && coordsToAdd != null) {
                Point parentCoords = parent.getBounds().getLocation();
                result.left += coordsToAdd.x - parentCoords.x;
                result.top += coordsToAdd.y - parentCoords.y;
            }
            currentChild = currentParent;
            currentParent = currentChild.getParent();
        }
        if (!isRelative) {
            Rectangle parentBounds = parent.getBounds();
            currentParent = child.getParent();
            Rectangle containerBounds = currentParent.getBounds();
            result.left = containerBounds.x - parentBounds.x;
            result.top = containerBounds.y - parentBounds.y;
        }
        result.right = result.left;
        result.bottom = result.left;
        return result;
    }

    public static Rectangle getAbsoluteBounds(IFigure figure) {
        Rectangle bounds = new Rectangle(figure.getBounds()){
            static final long serialVersionUID = 1L;

            public void performScale(double factor) {
            }
        };
        figure.translateToAbsolute((Translatable)bounds);
        return bounds;
    }

    public static Point getAbsolutePoint(Connection connection, int index) {
        Point point = new Point(connection.getPoints().getPoint(index)){
            static final long serialVersionUID = 1L;

            public void performScale(double factor) {
            }
        };
        connection.translateToAbsolute((Translatable)point);
        return point;
    }

    public static DiagramEditPart getDiagramEditPart(EditPart editPart) {
        EditPart ep = editPart;
        while (ep != null && !(ep instanceof DiagramEditPart) && !(ep instanceof RootEditPart)) {
            ep = ep.getParent();
        }
        if (ep instanceof RootEditPart) {
            RootEditPart root = (RootEditPart)ep;
            ep = null;
            for (Object child : root.getChildren()) {
                if (!(child instanceof DiagramEditPart)) continue;
                ep = (EditPart)child;
            }
        }
        return (DiagramEditPart)ep;
    }

    public boolean supports(Object object) {
        return object instanceof DiagramEditor || object instanceof IGraphicalEditPart;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getAdapter(Object object, Class adapterType) {
        try {
            if (adapterType.isAssignableFrom(GmfLayoutConfig.class)) {
                return this.layoutConfig;
            }
            if (adapterType.isAssignableFrom(IGraphicalEditPart.class)) {
                if (object instanceof CompartmentEditPart) {
                    return ((CompartmentEditPart)object).getParent();
                }
                if (object instanceof IGraphicalEditPart) {
                    return object;
                }
                if (object instanceof DiagramEditor) {
                    return ((DiagramEditor)object).getDiagramEditPart();
                }
                if (object instanceof DiagramRootEditPart) {
                    return ((DiagramRootEditPart)object).getContents();
                }
            } else if (adapterType.isAssignableFrom(EObject.class)) {
                if (object instanceof IGraphicalEditPart) {
                    IGraphicalEditPart editPart = (IGraphicalEditPart)object;
                    EObject element = editPart.getNotationView().getElement();
                    if (editPart.getParent() == null) return element;
                    Object model = editPart.getParent().getModel();
                    if (!(model instanceof View)) return element;
                    EObject parentElement = ((View)model).getElement();
                    if (element != parentElement) return element;
                    return null;
                }
                if (object instanceof View) {
                    return ((View)object).getElement();
                }
            } else if (adapterType.isAssignableFrom(TransactionalEditingDomain.class)) {
                if (object instanceof DiagramEditor) {
                    return ((DiagramEditor)object).getEditingDomain();
                }
                if (object instanceof IGraphicalEditPart) {
                    return ((IGraphicalEditPart)object).getEditingDomain();
                }
            }
            if (!(object instanceof IAdaptable)) return null;
            return ((IAdaptable)object).getAdapter(adapterType);
        }
        catch (RuntimeException runtimeException) {}
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{IGraphicalEditPart.class};
    }

    public LayoutMapping<IGraphicalEditPart> buildLayoutGraph(IWorkbenchPart workbenchPart, Object diagramPart) {
        TopGraphicEditPart tgEditPart;
        DiagramEditor diagramEditor = null;
        if (workbenchPart instanceof DiagramEditor) {
            diagramEditor = (DiagramEditor)workbenchPart;
        }
        IGraphicalEditPart layoutRootPart = null;
        if (diagramPart instanceof ShapeNodeEditPart || diagramPart instanceof DiagramEditPart) {
            layoutRootPart = (IGraphicalEditPart)diagramPart;
        } else if (diagramPart instanceof IGraphicalEditPart && (tgEditPart = ((IGraphicalEditPart)diagramPart).getTopGraphicEditPart()) instanceof ShapeNodeEditPart) {
            layoutRootPart = (IGraphicalEditPart)tgEditPart;
        }
        if (layoutRootPart == null && diagramEditor != null) {
            layoutRootPart = diagramEditor.getDiagramEditPart();
        }
        if (layoutRootPart == null) {
            throw new UnsupportedOperationException("Not supported by this layout manager: Workbench part " + workbenchPart + ", Edit part " + diagramPart);
        }
        LayoutMapping<IGraphicalEditPart> mapping = this.buildLayoutGraph(layoutRootPart);
        if (diagramEditor != null) {
            mapping.setProperty(DIAGRAM_EDITOR, (Object)diagramEditor);
        }
        mapping.getLayoutConfigs().add((ILayoutConfig)mapping.getProperty(STATIC_CONFIG));
        mapping.getLayoutConfigs().add(this.layoutConfig);
        return mapping;
    }

    protected LayoutMapping<IGraphicalEditPart> buildLayoutGraph(IGraphicalEditPart layoutRootPart) {
        LayoutMapping mapping = new LayoutMapping((IAdapterFactory)this);
        mapping.setProperty(CONNECTIONS, new LinkedList());
        mapping.setProperty(STATIC_CONFIG, (Object)new VolatileLayoutConfig(29));
        mapping.setParentElement((Object)layoutRootPart);
        mapping.setProperty(DIAGRAM_EDIT_PART, (Object)GmfDiagramLayoutManager.getDiagramEditPart((EditPart)layoutRootPart));
        KNode topNode = KimlUtil.createInitializedNode();
        KShapeLayout shapeLayout = (KShapeLayout)topNode.getData(KShapeLayout.class);
        Rectangle rootBounds = layoutRootPart.getFigure().getBounds();
        if (layoutRootPart instanceof DiagramEditPart) {
            String labelText = ((DiagramEditPart)layoutRootPart).getDiagramView().getName();
            if (labelText.length() > 0) {
                KLabel label = KimlUtil.createInitializedLabel((KLabeledGraphElement)topNode);
                label.setText(labelText);
            }
        } else {
            shapeLayout.setPos((float)rootBounds.x, (float)rootBounds.y);
        }
        shapeLayout.setSize((float)rootBounds.width, (float)rootBounds.height);
        mapping.getGraphMap().put((Object)topNode, (Object)layoutRootPart);
        mapping.setLayoutGraph(topNode);
        this.buildLayoutGraphRecursively((LayoutMapping<IGraphicalEditPart>)mapping, layoutRootPart, topNode, layoutRootPart);
        this.processConnections((LayoutMapping<IGraphicalEditPart>)mapping);
        return mapping;
    }

    @Override
    protected void transferLayout(LayoutMapping<IGraphicalEditPart> mapping) {
        ApplyLayoutRequest applyLayoutRequest = new ApplyLayoutRequest();
        for (Map.Entry entry : mapping.getGraphMap().entrySet()) {
            if (entry.getValue() instanceof DiagramEditPart) continue;
            applyLayoutRequest.addElement((KGraphElement)entry.getKey(), (GraphicalEditPart)entry.getValue());
        }
        KShapeLayout graphLayout = (KShapeLayout)mapping.getLayoutGraph().getData(KShapeLayout.class);
        applyLayoutRequest.setUpperBound(graphLayout.getWidth(), graphLayout.getHeight());
        DiagramEditPart diagramEditPart = (DiagramEditPart)mapping.getProperty(DIAGRAM_EDIT_PART);
        if (((InternalTransactionalEditingDomain)diagramEditPart.getEditingDomain()).getChangeRecorder() != null) {
            Command applyLayoutCommand = diagramEditPart.getCommand((Request)applyLayoutRequest);
            mapping.setProperty(LAYOUT_COMMAND, (Object)applyLayoutCommand);
        }
    }

    @Override
    protected void applyLayout(LayoutMapping<IGraphicalEditPart> mapping) {
        Command applyLayoutCommand = (Command)mapping.getProperty(LAYOUT_COMMAND);
        if (applyLayoutCommand != null) {
            CommandStack commandStack = (CommandStack)mapping.getProperty(COMMAND_STACK);
            DiagramEditor diagramEditor = (DiagramEditor)mapping.getProperty(DIAGRAM_EDITOR);
            if (commandStack == null) {
                Object adapter;
                if (diagramEditor != null && (adapter = diagramEditor.getAdapter(CommandStack.class)) instanceof CommandStack) {
                    commandStack = (CommandStack)adapter;
                }
                if (commandStack == null) {
                    commandStack = ((IGraphicalEditPart)mapping.getParentElement()).getDiagramEditDomain().getDiagramCommandStack();
                }
            }
            commandStack.execute(applyLayoutCommand);
            if (diagramEditor != null || mapping.getParentElement() != null) {
                GmfDiagramLayoutManager.refreshDiagram(diagramEditor, (IGraphicalEditPart)mapping.getParentElement());
            }
        }
    }

    @Override
    protected void performUndo(LayoutMapping<IGraphicalEditPart> mapping) {
        try {
            IOperationHistory history = OperationHistoryFactory.getOperationHistory();
            history.undoOperation((IUndoableOperation)DiagramCommandStack.getICommand((Command)((Command)mapping.getProperty(LAYOUT_COMMAND))), (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            throw new WrappedException((Throwable)e);
        }
    }

    private void buildLayoutGraphRecursively(LayoutMapping<IGraphicalEditPart> mapping, IGraphicalEditPart parentEditPart, KNode parentLayoutNode, IGraphicalEditPart currentEditPart) {
        Maybe kinsets = new Maybe();
        for (Object obj : currentEditPart.getChildren()) {
            IFigure figure;
            if (obj instanceof IGraphicalEditPart && !(figure = ((IGraphicalEditPart)obj).getFigure()).isVisible()) continue;
            if (obj instanceof AbstractBorderItemEditPart) {
                this.createPort(mapping, (AbstractBorderItemEditPart)obj, parentEditPart, parentLayoutNode);
                continue;
            }
            if (obj instanceof ResizableCompartmentEditPart && ((CompartmentEditPart)obj).getChildren().size() > 0) {
                CompartmentEditPart compartment = (CompartmentEditPart)obj;
                if (GmfLayoutConfig.isNoLayout((EditPart)compartment)) continue;
                boolean compExp = true;
                IFigure compartmentFigure = compartment.getFigure();
                if (compartmentFigure instanceof ResizableCompartmentFigure) {
                    ResizableCompartmentFigure resizCompFigure = (ResizableCompartmentFigure)compartmentFigure;
                    compExp = resizCompFigure.isExpanded();
                }
                if (!compExp) continue;
                this.buildLayoutGraphRecursively(mapping, parentEditPart, parentLayoutNode, (IGraphicalEditPart)compartment);
                continue;
            }
            if (obj instanceof ShapeNodeEditPart) {
                ShapeNodeEditPart childNodeEditPart = (ShapeNodeEditPart)obj;
                if (GmfLayoutConfig.isNoLayout((EditPart)childNodeEditPart)) continue;
                this.createNode(mapping, childNodeEditPart, parentEditPart, parentLayoutNode, (Maybe<KInsets>)kinsets);
                continue;
            }
            if (!(obj instanceof IGraphicalEditPart)) continue;
            this.createNodeLabel(mapping, (IGraphicalEditPart)obj, parentEditPart, parentLayoutNode);
        }
    }

    private void createNode(LayoutMapping<IGraphicalEditPart> mapping, ShapeNodeEditPart nodeEditPart, IGraphicalEditPart parentEditPart, KNode parentKNode, Maybe<KInsets> kinsets) {
        IFigure nodeFigure = nodeEditPart.getFigure();
        KNode childLayoutNode = KimlUtil.createInitializedNode();
        Rectangle childBounds = GmfDiagramLayoutManager.getAbsoluteBounds(nodeFigure);
        Rectangle containerBounds = GmfDiagramLayoutManager.getAbsoluteBounds(nodeFigure.getParent());
        KShapeLayout nodeLayout = (KShapeLayout)childLayoutNode.getData(KShapeLayout.class);
        nodeLayout.setXpos((float)(childBounds.x - containerBounds.x));
        nodeLayout.setYpos((float)(childBounds.y - containerBounds.y));
        nodeLayout.setSize((float)childBounds.width, (float)childBounds.height);
        ((KShapeLayoutImpl)nodeLayout).resetModificationFlag();
        try {
            Dimension minSize = nodeFigure.getMinimumSize();
            VolatileLayoutConfig staticConfig = (VolatileLayoutConfig)mapping.getProperty(STATIC_CONFIG);
            staticConfig.setValue(LayoutOptions.MIN_WIDTH, (Object)childLayoutNode, LayoutContext.GRAPH_ELEM, (Object)Float.valueOf(minSize.width));
            staticConfig.setValue(LayoutOptions.MIN_HEIGHT, (Object)childLayoutNode, LayoutContext.GRAPH_ELEM, (Object)Float.valueOf(minSize.height));
        }
        catch (SWTException sWTException) {}
        if (kinsets.get() == null) {
            KInsets ki = ((KShapeLayout)parentKNode.getData(KShapeLayout.class)).getInsets();
            Insets insets = GmfDiagramLayoutManager.calcInsets(parentEditPart.getFigure(), nodeFigure);
            ki.setLeft((float)insets.left);
            ki.setTop((float)insets.top);
            ki.setRight((float)insets.right);
            ki.setBottom((float)insets.bottom);
            kinsets.set((Object)ki);
        }
        parentKNode.getChildren().add((Object)childLayoutNode);
        mapping.getGraphMap().put((Object)childLayoutNode, (Object)nodeEditPart);
        this.buildLayoutGraphRecursively(mapping, (IGraphicalEditPart)nodeEditPart, childLayoutNode, (IGraphicalEditPart)nodeEditPart);
        this.addConnections(mapping, (IGraphicalEditPart)nodeEditPart);
    }

    private void createPort(LayoutMapping<IGraphicalEditPart> mapping, AbstractBorderItemEditPart portEditPart, IGraphicalEditPart nodeEditPart, KNode knode) {
        KPort port = KimlUtil.createInitializedPort();
        port.setNode(knode);
        KShapeLayout portLayout = (KShapeLayout)port.getData(KShapeLayout.class);
        Rectangle portBounds = GmfDiagramLayoutManager.getAbsoluteBounds(portEditPart.getFigure());
        Rectangle nodeBounds = GmfDiagramLayoutManager.getAbsoluteBounds(nodeEditPart.getFigure());
        float xpos = portBounds.x - nodeBounds.x;
        float ypos = portBounds.y - nodeBounds.y;
        portLayout.setPos(xpos, ypos);
        portLayout.setSize((float)portBounds.width, (float)portBounds.height);
        ((KShapeLayoutImpl)portLayout).resetModificationFlag();
        mapping.getGraphMap().put((Object)port, (Object)portEditPart);
        this.addConnections(mapping, (IGraphicalEditPart)portEditPart);
        for (Object portChildObj : portEditPart.getChildren()) {
            if (!(portChildObj instanceof IGraphicalEditPart)) continue;
            IFigure labelFigure = ((IGraphicalEditPart)portChildObj).getFigure();
            String text = null;
            if (labelFigure instanceof WrappingLabel) {
                text = ((WrappingLabel)labelFigure).getText();
            } else if (labelFigure instanceof Label) {
                text = ((Label)labelFigure).getText();
            }
            if (text == null) continue;
            KLabel portLabel = KimlUtil.createInitializedLabel((KLabeledGraphElement)port);
            portLabel.setText(text);
            mapping.getGraphMap().put((Object)portLabel, (Object)((IGraphicalEditPart)portChildObj));
            KShapeLayout labelLayout = (KShapeLayout)portLabel.getData(KShapeLayout.class);
            Rectangle labelBounds = GmfDiagramLayoutManager.getAbsoluteBounds(labelFigure);
            labelLayout.setXpos((float)(labelBounds.x - portBounds.x));
            labelLayout.setYpos((float)(labelBounds.y - portBounds.y));
            try {
                Dimension size = labelFigure.getPreferredSize();
                labelLayout.setWidth((float)size.width);
                labelLayout.setHeight((float)size.height);
            }
            catch (SWTException sWTException) {}
            ((KShapeLayoutImpl)labelLayout).resetModificationFlag();
        }
    }

    private void createNodeLabel(LayoutMapping<IGraphicalEditPart> mapping, IGraphicalEditPart labelEditPart, IGraphicalEditPart nodeEditPart, KNode knode) {
        Label label;
        IFigure labelFigure = labelEditPart.getFigure();
        String text = null;
        Font font = null;
        if (labelFigure instanceof WrappingLabel) {
            WrappingLabel wrappingLabel = (WrappingLabel)labelFigure;
            text = wrappingLabel.getText();
            font = wrappingLabel.getFont();
        } else if (labelFigure instanceof Label) {
            label = (Label)labelFigure;
            text = label.getText();
            font = label.getFont();
        }
        if (text != null) {
            label = KimlUtil.createInitializedLabel((KLabeledGraphElement)knode);
            label.setText(text);
            mapping.getGraphMap().put((Object)label, (Object)labelEditPart);
            KShapeLayout labelLayout = (KShapeLayout)label.getData(KShapeLayout.class);
            Rectangle labelBounds = GmfDiagramLayoutManager.getAbsoluteBounds(labelFigure);
            Rectangle nodeBounds = GmfDiagramLayoutManager.getAbsoluteBounds(nodeEditPart.getFigure());
            labelLayout.setXpos((float)(labelBounds.x - nodeBounds.x));
            labelLayout.setYpos((float)(labelBounds.y - nodeBounds.y));
            try {
                Dimension size = labelFigure.getPreferredSize();
                labelLayout.setSize((float)size.width, (float)size.height);
                if (font != null && !font.isDisposed()) {
                    VolatileLayoutConfig staticConfig = (VolatileLayoutConfig)mapping.getProperty(STATIC_CONFIG);
                    staticConfig.setValue(LayoutOptions.FONT_NAME, (Object)label, LayoutContext.GRAPH_ELEM, (Object)font.getFontData()[0].getName());
                    staticConfig.setValue(LayoutOptions.FONT_SIZE, (Object)label, LayoutContext.GRAPH_ELEM, (Object)font.getFontData()[0].getHeight());
                }
            }
            catch (SWTException sWTException) {}
            ((KShapeLayoutImpl)labelLayout).resetModificationFlag();
        }
    }

    protected void addConnections(LayoutMapping<IGraphicalEditPart> mapping, IGraphicalEditPart editPart) {
        for (Object targetConn : editPart.getTargetConnections()) {
            if (!(targetConn instanceof ConnectionEditPart)) continue;
            ConnectionEditPart connectionEditPart = (ConnectionEditPart)targetConn;
            ((List)mapping.getProperty(CONNECTIONS)).add(connectionEditPart);
            this.addConnections(mapping, (IGraphicalEditPart)connectionEditPart);
        }
    }

    protected void processConnections(LayoutMapping<IGraphicalEditPart> mapping) {
        HashMap<EReference, KEdge> reference2EdgeMap = new HashMap<EReference, KEdge>();
        for (ConnectionEditPart connection : (List)mapping.getProperty(CONNECTIONS)) {
            KGraphElement targetElem;
            KGraphElement sourceElem;
            KEdge edge;
            boolean isOppositeEdge = false;
            EdgeLabelPlacement edgeLabelPlacement = EdgeLabelPlacement.UNDEFINED;
            EObject modelObject = connection.getNotationView().getElement();
            if (modelObject instanceof EReference) {
                EReference reference = (EReference)modelObject;
                edge = (KEdge)reference2EdgeMap.get(reference.getEOpposite());
                if (edge != null) {
                    edgeLabelPlacement = EdgeLabelPlacement.TAIL;
                    isOppositeEdge = true;
                } else {
                    edge = KimlUtil.createInitializedEdge();
                    reference2EdgeMap.put(reference, edge);
                }
            } else {
                edge = KimlUtil.createInitializedEdge();
            }
            BiMap graphMap = mapping.getGraphMap();
            EditPart sourceObj = connection.getSource();
            if (sourceObj instanceof ConnectionEditPart) {
                sourceElem = (KGraphElement)graphMap.inverse().get((Object)((ConnectionEditPart)sourceObj).getSource());
                if (sourceElem == null) {
                    sourceElem = (KGraphElement)graphMap.inverse().get((Object)((ConnectionEditPart)sourceObj).getTarget());
                }
            } else {
                sourceElem = (KGraphElement)graphMap.inverse().get((Object)sourceObj);
            }
            KNode sourceNode = null;
            KPort sourcePort = null;
            if (sourceElem instanceof KNode) {
                sourceNode = (KNode)sourceElem;
            } else {
                if (!(sourceElem instanceof KPort)) continue;
                sourcePort = (KPort)sourceElem;
                sourceNode = sourcePort.getNode();
            }
            EditPart targetObj = connection.getTarget();
            if (targetObj instanceof ConnectionEditPart) {
                targetElem = (KGraphElement)graphMap.inverse().get((Object)((ConnectionEditPart)targetObj).getTarget());
                if (targetElem == null) {
                    targetElem = (KGraphElement)graphMap.inverse().get((Object)((ConnectionEditPart)targetObj).getSource());
                }
            } else {
                targetElem = (KGraphElement)graphMap.inverse().get((Object)targetObj);
            }
            KNode targetNode = null;
            KPort targetPort = null;
            if (targetElem instanceof KNode) {
                targetNode = (KNode)targetElem;
            } else {
                if (!(targetElem instanceof KPort)) continue;
                targetPort = (KPort)targetElem;
                targetNode = targetPort.getNode();
            }
            KVector offset = new KVector();
            if (KimlUtil.isDescendant((KNode)targetNode, (KNode)sourceNode)) {
                KimlUtil.toAbsolute((KVector)offset, (KNode)sourceNode);
            } else {
                KimlUtil.toAbsolute((KVector)offset, (KNode)sourceNode.getParent());
            }
            if (!isOppositeEdge) {
                edge.setSource(sourceNode);
                if (sourcePort != null) {
                    edge.setSourcePort(sourcePort);
                    sourcePort.getEdges().add((Object)edge);
                }
                edge.setTarget(targetNode);
                if (targetPort != null) {
                    edge.setTargetPort(targetPort);
                    targetPort.getEdges().add((Object)edge);
                }
                graphMap.put((Object)edge, (Object)connection);
                KEdgeLayout edgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class);
                this.setEdgeLayout(edgeLayout, connection, offset);
            }
            this.processEdgeLabels(mapping, connection, edge, edgeLabelPlacement, offset);
        }
    }

    protected void setEdgeLayout(KEdgeLayout edgeLayout, ConnectionEditPart connection, KVector offset) {
        Connection figure = connection.getConnectionFigure();
        PointList pointList = figure.getPoints();
        KPoint sourcePoint = edgeLayout.getSourcePoint();
        Point firstPoint = pointList.getPoint(0);
        sourcePoint.setX((float)firstPoint.x - (float)offset.x);
        sourcePoint.setY((float)firstPoint.y - (float)offset.y);
        int i = 1;
        while (i < pointList.size() - 1) {
            Point point = pointList.getPoint(i);
            KPoint kpoint = KLayoutDataFactory.eINSTANCE.createKPoint();
            kpoint.setX((float)point.x - (float)offset.x);
            kpoint.setY((float)point.y - (float)offset.y);
            edgeLayout.getBendPoints().add((Object)kpoint);
            ++i;
        }
        KPoint targetPoint = edgeLayout.getTargetPoint();
        Point lastPoint = pointList.getPoint(pointList.size() - 1);
        targetPoint.setX((float)lastPoint.x - (float)offset.x);
        targetPoint.setY((float)lastPoint.y - (float)offset.y);
        ((KEdgeLayoutImpl)edgeLayout).resetModificationFlag();
    }

    private void processEdgeLabels(LayoutMapping<IGraphicalEditPart> mapping, ConnectionEditPart connection, KEdge edge, EdgeLabelPlacement placement, KVector offset) {
        VolatileLayoutConfig staticConfig = (VolatileLayoutConfig)mapping.getProperty(STATIC_CONFIG);
        for (Object obj : connection.getChildren()) {
            KShapeLayout labelLayout;
            Label label;
            LabelEditPart labelEditPart;
            IFigure labelFigure;
            if (!(obj instanceof LabelEditPart) || (labelFigure = (labelEditPart = (LabelEditPart)obj).getFigure()) == null || !labelFigure.isVisible()) continue;
            Rectangle labelBounds = GmfDiagramLayoutManager.getAbsoluteBounds(labelFigure);
            String labelText = null;
            Dimension iconBounds = null;
            if (labelFigure instanceof WrappingLabel) {
                WrappingLabel wrappingLabel = (WrappingLabel)labelFigure;
                labelText = wrappingLabel.getText();
                if (wrappingLabel.getIcon() != null) {
                    iconBounds = new Dimension();
                    iconBounds.width = wrappingLabel.getIcon().getBounds().width + wrappingLabel.getIconTextGap();
                    iconBounds.height = wrappingLabel.getIcon().getBounds().height;
                    labelText = "O " + labelText;
                }
            } else if (labelFigure instanceof Label) {
                label = (Label)labelFigure;
                labelText = label.getText();
                if (label.getIcon() != null) {
                    iconBounds = label.getIconBounds().getSize();
                    iconBounds.width += label.getIconTextGap();
                    labelText = "O " + labelText;
                }
            }
            if (labelText != null && labelText.length() > 0) {
                label = KimlUtil.createInitializedLabel((KLabeledGraphElement)edge);
                labelLayout = (KShapeLayout)label.getData(KShapeLayout.class);
                if (placement == EdgeLabelPlacement.UNDEFINED) {
                    switch (labelEditPart.getKeyPoint()) {
                        case 2: {
                            staticConfig.setValue(LayoutOptions.EDGE_LABEL_PLACEMENT, (Object)label, LayoutContext.GRAPH_ELEM, (Object)EdgeLabelPlacement.HEAD);
                            break;
                        }
                        case 4: {
                            staticConfig.setValue(LayoutOptions.EDGE_LABEL_PLACEMENT, (Object)label, LayoutContext.GRAPH_ELEM, (Object)EdgeLabelPlacement.CENTER);
                            break;
                        }
                        case 3: {
                            staticConfig.setValue(LayoutOptions.EDGE_LABEL_PLACEMENT, (Object)label, LayoutContext.GRAPH_ELEM, (Object)EdgeLabelPlacement.TAIL);
                        }
                    }
                } else {
                    staticConfig.setValue(LayoutOptions.EDGE_LABEL_PLACEMENT, (Object)label, LayoutContext.GRAPH_ELEM, (Object)placement);
                }
                Font font = labelFigure.getFont();
                if (font != null && !font.isDisposed()) {
                    staticConfig.setValue(LayoutOptions.FONT_NAME, (Object)label, LayoutContext.GRAPH_ELEM, (Object)font.getFontData()[0].getName());
                    staticConfig.setValue(LayoutOptions.FONT_SIZE, (Object)label, LayoutContext.GRAPH_ELEM, (Object)font.getFontData()[0].getHeight());
                }
                labelLayout.setXpos((float)labelBounds.x - (float)offset.x);
                labelLayout.setYpos((float)labelBounds.y - (float)offset.y);
                if (iconBounds != null) {
                    labelLayout.setWidth((float)(labelBounds.width + iconBounds.width));
                } else {
                    labelLayout.setWidth((float)labelBounds.width);
                }
                labelLayout.setHeight((float)labelBounds.height);
                ((KShapeLayoutImpl)labelLayout).resetModificationFlag();
                label.setText(labelText);
                mapping.getGraphMap().put((Object)label, (Object)labelEditPart);
                continue;
            }
            label = KGraphFactory.eINSTANCE.createKLabel();
            labelLayout = KLayoutDataFactory.eINSTANCE.createKShapeLayout();
            label.getData().add((Object)labelLayout);
            mapping.getGraphMap().put((Object)label, (Object)labelEditPart);
        }
    }

    private static void refreshDiagram(DiagramEditor editor, IGraphicalEditPart rootPart) {
        IGraphicalEditPart editPart = rootPart;
        if (editPart == null) {
            editPart = editor.getDiagramEditPart();
        }
        for (Object obj : editPart.getViewer().getEditPartRegistry().values()) {
            IFigure figure;
            if (!(obj instanceof ShapeNodeEditPart) || !((figure = ((ShapeNodeEditPart)obj).getFigure()) instanceof BorderedNodeFigure)) continue;
            IFigure portContainer = ((BorderedNodeFigure)figure).getBorderItemContainer();
            portContainer.invalidate();
            portContainer.validate();
        }
    }
}

