/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.core.properties;

import de.cau.cs.kieler.core.properties.IProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Property<T>
implements IProperty<T>,
Comparable<IProperty<?>> {
    public static final Comparable<?> NEGATIVE_INFINITY = new Comparable<Object>(){

        @Override
        public int compareTo(Object other) {
            return -1;
        }
    };
    public static final Comparable<?> POSITIVE_INFINITY = new Comparable<Object>(){

        @Override
        public int compareTo(Object other) {
            return 1;
        }
    };
    private String id;
    private T defaultValue;
    private Comparable<T> lowerBound = NEGATIVE_INFINITY;
    private Comparable<T> upperBound = POSITIVE_INFINITY;

    public Property(String theid) {
        this.id = theid;
    }

    public Property(String theid, T thedefaultValue) {
        this(theid);
        this.defaultValue = thedefaultValue;
    }

    public Property(String theid, T thedefaultValue, Comparable<T> thelowerBound) {
        this(theid, thedefaultValue);
        if (thelowerBound != null) {
            this.lowerBound = thelowerBound;
        }
    }

    public Property(String theid, T thedefaultValue, Comparable<T> thelowerBound, Comparable<T> theupperBound) {
        this(theid, thedefaultValue, thelowerBound);
        if (theupperBound != null) {
            this.upperBound = theupperBound;
        }
    }

    public Property(IProperty<T> other, T thedefaultValue) {
        this(other.getId(), thedefaultValue, other.getLowerBound(), other.getUpperBound());
    }

    public Property(IProperty<T> other, T thedefaultValue, Comparable<T> thelowerBound) {
        this(other.getId(), thedefaultValue, thelowerBound, other.getUpperBound());
    }

    public Property(IProperty<T> other, T thedefaultValue, Comparable<T> thelowerBound, Comparable<T> theupperBound) {
        this(other.getId(), thedefaultValue, thelowerBound, theupperBound);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IProperty) {
            return this.id.equals(((IProperty)obj).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id;
    }

    @Override
    public T getDefault() {
        return this.defaultValue;
    }

    @Override
    public Comparable<T> getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public Comparable<T> getUpperBound() {
        return this.upperBound;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int compareTo(IProperty<?> other) {
        return this.id.compareTo(other.getId());
    }
}

