/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service.grana.analyses;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.core.math.KielerMath;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.EdgeRouting;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.service.grana.AnalysisOptions;
import de.cau.cs.kieler.kiml.service.grana.IAnalysis;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperedgeCrossingsAnalysis
implements IAnalysis {
    @Override
    public Object doAnalysis(KNode parentNode, Map<String, Object> results, IKielerProgressMonitor progressMonitor) {
        progressMonitor.begin("Hyperedge crossings analysis", 1.0f);
        List<Line2D.Double> edgeSegments = this.collectEdgeSegments(parentNode);
        this.mergeEdgeSegments(edgeSegments);
        int crossings = this.countCrossings(edgeSegments.toArray(new Line2D.Double[0]));
        progressMonitor.done();
        return crossings;
    }

    private List<Line2D.Double> collectEdgeSegments(KNode parentNode) {
        LinkedList<Line2D.Double> segments = new LinkedList<Line2D.Double>();
        boolean hierarchy = (Boolean)((KShapeLayout)parentNode.getData(KShapeLayout.class)).getProperty(AnalysisOptions.ANALYZE_HIERARCHY);
        LinkedList nodeQueue = new LinkedList();
        nodeQueue.addAll(parentNode.getChildren());
        while (!nodeQueue.isEmpty()) {
            KNode node = (KNode)nodeQueue.poll();
            for (KEdge edge : node.getOutgoingEdges()) {
                if (!hierarchy && edge.getTarget().getParent() != parentNode) continue;
                KVectorChain chain = ((KEdgeLayout)edge.getData(KEdgeLayout.class)).createVectorChain();
                KNode parent = node;
                if (!KimlUtil.isDescendant((KNode)edge.getTarget(), (KNode)parent)) {
                    parent = node.getParent();
                }
                KVector referencePoint = new KVector();
                KimlUtil.toAbsolute((KVector)referencePoint, (KNode)parent);
                chain.translate(referencePoint);
                if (((KEdgeLayout)edge.getData(KEdgeLayout.class)).getProperty(LayoutOptions.EDGE_ROUTING) == EdgeRouting.SPLINES) {
                    chain = KielerMath.approximateSpline((KVectorChain)chain);
                }
                KVector p1 = (KVector)chain.getFirst();
                ListIterator pointIter = chain.listIterator(1);
                while (pointIter.hasNext()) {
                    KVector p2 = (KVector)pointIter.next();
                    Line2D.Double segment = new Line2D.Double(p1.x, p1.y, p2.x, p2.y);
                    segments.add(segment);
                    p1 = p2;
                }
            }
            if (!hierarchy) continue;
            nodeQueue.addAll(node.getChildren());
        }
        return segments;
    }

    private void mergeEdgeSegments(List<Line2D.Double> segments) {
        ListIterator<Line2D.Double> iterator1 = segments.listIterator();
        while (iterator1.hasNext()) {
            Line2D.Double line1 = iterator1.next();
            if (!iterator1.hasNext()) break;
            if (line1.x1 == line1.x2 && line1.y1 == line1.y2) continue;
            ListIterator<Line2D.Double> iterator2 = segments.listIterator(iterator1.nextIndex());
            while (iterator2.hasNext()) {
                Line2D.Double line2 = iterator2.next();
                if (line2.x1 == line2.x2 && line2.y1 == line2.y2 || !this.canBeMerged(line1, line2)) continue;
                this.mergeSegments(line1, line2);
                line2.x1 = 0.0;
                line2.y1 = 0.0;
                line2.x2 = 0.0;
                line2.y2 = 0.0;
            }
        }
        ListIterator<Line2D.Double> iterator = segments.listIterator();
        while (iterator.hasNext()) {
            Line2D.Double line = iterator.next();
            if (line.x1 != line.x2 || line.y1 != line.y2) continue;
            iterator.remove();
        }
    }

    private boolean canBeMerged(Line2D.Double line1, Line2D.Double line2) {
        if (!line1.intersectsLine(line2)) {
            return false;
        }
        return line1.ptLineDist(line2.x1, line2.y1) == line1.ptLineDist(line2.x2, line2.y2);
    }

    private void mergeSegments(Line2D.Double line1, Line2D.Double line2) {
        Point2D.Double start = new Point2D.Double(line1.x1, line1.y1);
        Point2D.Double end = new Point2D.Double(line1.x2, line1.y2);
        if (line1.x1 == line1.x2) {
            if (line1.y2 < start.y) {
                start.x = line1.x2;
                start.y = line1.y2;
            }
            if (line2.y1 < start.y) {
                start.x = line2.x1;
                start.y = line2.y1;
            }
            if (line2.y2 < start.y) {
                start.x = line2.x2;
                start.y = line2.y2;
            }
            if (line1.y2 > end.y) {
                end.x = line1.x2;
                end.y = line1.y2;
            }
            if (line2.y1 < end.y) {
                end.x = line2.x1;
                end.y = line2.y1;
            }
            if (line2.y2 < end.y) {
                end.x = line2.x2;
                end.y = line2.y2;
            }
        } else {
            if (line1.x2 < start.x) {
                start.x = line1.x2;
                start.y = line1.y2;
            }
            if (line2.x1 < start.x) {
                start.x = line2.x1;
                start.y = line2.y1;
            }
            if (line2.x2 < start.x) {
                start.x = line2.x2;
                start.y = line2.y2;
            }
            if (line1.x2 > end.x) {
                end.x = line1.x2;
                end.y = line1.y2;
            }
            if (line2.x1 < end.x) {
                end.x = line2.x1;
                end.y = line2.y1;
            }
            if (line2.x2 < end.x) {
                end.x = line2.x2;
                end.y = line2.y2;
            }
        }
        line1.x1 = start.x;
        line1.y1 = start.y;
        line1.x2 = end.x;
        line1.y2 = end.y;
    }

    private int countCrossings(Line2D.Double[] segments) {
        int crossings = 0;
        int i = 0;
        while (i < segments.length) {
            int j = i + 1;
            while (j < segments.length) {
                if (segments[i].intersectsLine(segments[j]) && segments[i].ptLineDist(segments[j].x1, segments[j].y1) != 0.0 && segments[i].ptLineDist(segments[j].x2, segments[j].y2) != 0.0 && segments[j].ptLineDist(segments[i].x1, segments[i].y1) != 0.0 && segments[j].ptLineDist(segments[i].x2, segments[i].y2) != 0.0) {
                    ++crossings;
                }
                ++j;
            }
            ++i;
        }
        return crossings;
    }
}

