/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p3order;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutPhase;
import de.cau.cs.kieler.klay.layered.IntermediateProcessingConfiguration;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.intermediate.LayoutProcessorStrategy;
import de.cau.cs.kieler.klay.layered.p3order.BarycenterHeuristic;
import de.cau.cs.kieler.klay.layered.p3order.CompoundGraphLayerCrossingMinimizer;
import de.cau.cs.kieler.klay.layered.p3order.ForsterConstraintResolver;
import de.cau.cs.kieler.klay.layered.p3order.NodeGroup;
import de.cau.cs.kieler.klay.layered.p3order.NodeRelativePortDistributor;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.PortType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerSweepCrossingMinimizer
extends AbstractAlgorithm
implements ILayoutPhase {
    private static final IntermediateProcessingConfiguration INTERMEDIATE_PROCESSING_CONFIGURATION = new IntermediateProcessingConfiguration(null, null, EnumSet.of(LayoutProcessorStrategy.LONG_EDGE_SPLITTER), EnumSet.of(LayoutProcessorStrategy.IN_LAYER_CONSTRAINT_PROCESSOR), null, EnumSet.of(LayoutProcessorStrategy.LONG_EDGE_JOINER));
    private float[] portRanks;
    private int[] portPos;
    private NodeGroup[][] bestSweep;
    private NodeGroup[][] curSweep;
    private NodeGroup[][] prevSweep;
    private int[] inLayerEdgeCount;
    private final Multimap<LNode, LNode> layoutUnits = HashMultimap.create();

    @Override
    public IntermediateProcessingConfiguration getIntermediateProcessingConfiguration(LGraph graph) {
        return INTERMEDIATE_PROCESSING_CONFIGURATION;
    }

    private void initialize(LGraph layeredGraph) {
        int layerCount = layeredGraph.getLayers().size();
        this.bestSweep = new NodeGroup[layerCount][];
        this.curSweep = new NodeGroup[layerCount][];
        this.prevSweep = new NodeGroup[layerCount][];
        this.inLayerEdgeCount = new int[layerCount];
        int nodeCount = 0;
        int portCount = 0;
        ListIterator<Layer> layerIter = layeredGraph.getLayers().listIterator();
        while (layerIter.hasNext()) {
            Layer layer = layerIter.next();
            int layerIndex = layerIter.previousIndex();
            int layerNodeCount = layer.getNodes().size();
            this.bestSweep[layerIndex] = new NodeGroup[layerNodeCount];
            this.prevSweep[layerIndex] = new NodeGroup[layerNodeCount];
            this.curSweep[layerIndex] = new NodeGroup[layerNodeCount];
            this.inLayerEdgeCount[layerIndex] = 0;
            ListIterator<LNode> nodeIter = layer.getNodes().listIterator();
            while (nodeIter.hasNext()) {
                NodeGroup nodeGroup;
                LNode node = nodeIter.next();
                this.curSweep[layerIndex][nodeIter.previousIndex()] = nodeGroup = new NodeGroup(node);
                node.id = nodeCount++;
                node.setProperty(Properties.NODE_GROUP, nodeGroup);
                LNode layoutUnit = (LNode)node.getProperty(Properties.IN_LAYER_LAYOUT_UNIT);
                if (layoutUnit != null) {
                    this.layoutUnits.put((Object)layoutUnit, (Object)node);
                }
                for (LPort port : node.getPorts()) {
                    port.id = portCount++;
                    for (LEdge edge : port.getOutgoingEdges()) {
                        if (edge.getTarget().getNode().getLayer() != layer) continue;
                        int n = layerIndex;
                        this.inLayerEdgeCount[n] = this.inLayerEdgeCount[n] + 1;
                    }
                }
            }
        }
        this.portRanks = new float[portCount];
        this.portPos = new int[portCount];
    }

    private void dispose() {
        this.portRanks = null;
        this.portPos = null;
        this.bestSweep = null;
        this.curSweep = null;
        this.prevSweep = null;
        this.inLayerEdgeCount = null;
        this.layoutUnits.clear();
    }

    @Override
    public void process(LGraph layeredGraph) {
        this.getMonitor().begin("Layer sweep crossing minimization", 1.0f);
        Random random = (Random)layeredGraph.getProperty(Properties.RANDOM);
        int layerCount = layeredGraph.getLayers().size();
        if (layerCount < 2) {
            this.getMonitor().done();
            return;
        }
        this.initialize(layeredGraph);
        int bestSweepCrossings = Integer.MAX_VALUE;
        int runCount = (Integer)layeredGraph.getProperty(Properties.THOROUGHNESS);
        NodeRelativePortDistributor portDistributor = new NodeRelativePortDistributor(this.portRanks);
        ForsterConstraintResolver constraintResolver = new ForsterConstraintResolver(this.layoutUnits);
        BarycenterHeuristic heuristic = new BarycenterHeuristic(constraintResolver, random, this.portRanks);
        CompoundGraphLayerCrossingMinimizer compoundMinimizer = new CompoundGraphLayerCrossingMinimizer(layeredGraph, heuristic);
        int run = 0;
        while (run < runCount) {
            boolean forward = random.nextBoolean();
            int fixedLayerIndex = forward ? 0 : layerCount - 1;
            NodeGroup[] fixedLayer = this.curSweep[fixedLayerIndex];
            compoundMinimizer.compoundMinimizeCrossings(fixedLayer, fixedLayerIndex, forward, false, true);
            int curSweepCrossings = Integer.MAX_VALUE;
            int prevSweepCrossings = Integer.MAX_VALUE;
            boolean firstSweep = true;
            do {
                NodeGroup[] freeLayer;
                int layerIndex;
                LayerSweepCrossingMinimizer.copySweep(this.curSweep, this.prevSweep);
                prevSweepCrossings = curSweepCrossings;
                curSweepCrossings = 0;
                if (forward) {
                    layerIndex = 1;
                    while (layerIndex < layerCount) {
                        freeLayer = this.curSweep[layerIndex];
                        portDistributor.calculatePortRanks(fixedLayer, PortType.OUTPUT);
                        compoundMinimizer.compoundMinimizeCrossings(freeLayer, layerIndex, true, !firstSweep, false);
                        curSweepCrossings += this.countCrossings(fixedLayer, freeLayer);
                        if (this.inLayerEdgeCount[layerIndex] > 0) {
                            curSweepCrossings += this.countCrossings(freeLayer);
                        }
                        fixedLayer = freeLayer;
                        ++layerIndex;
                    }
                } else {
                    layerIndex = layerCount - 2;
                    while (layerIndex >= 0) {
                        freeLayer = this.curSweep[layerIndex];
                        portDistributor.calculatePortRanks(fixedLayer, PortType.INPUT);
                        compoundMinimizer.compoundMinimizeCrossings(freeLayer, layerIndex, false, !firstSweep, false);
                        curSweepCrossings += this.countCrossings(freeLayer, fixedLayer);
                        if (this.inLayerEdgeCount[layerIndex] > 0) {
                            curSweepCrossings += this.countCrossings(freeLayer);
                        }
                        fixedLayer = freeLayer;
                        --layerIndex;
                    }
                }
                firstSweep = false;
                boolean bl = forward = !forward;
            } while (curSweepCrossings < prevSweepCrossings);
            if (curSweepCrossings < bestSweepCrossings || prevSweepCrossings < bestSweepCrossings) {
                if (curSweepCrossings < prevSweepCrossings) {
                    LayerSweepCrossingMinimizer.copySweep(this.curSweep, this.bestSweep);
                    bestSweepCrossings = curSweepCrossings;
                } else {
                    LayerSweepCrossingMinimizer.copySweep(this.prevSweep, this.bestSweep);
                    bestSweepCrossings = prevSweepCrossings;
                }
            }
            ++run;
        }
        portDistributor.distributePorts(this.bestSweep);
        ListIterator<Layer> layerIter = layeredGraph.getLayers().listIterator();
        while (layerIter.hasNext()) {
            Layer layer = layerIter.next();
            NodeGroup[] nodes = this.bestSweep[layerIter.previousIndex()];
            ListIterator<LNode> nodeIter = layer.getNodes().listIterator();
            while (nodeIter.hasNext()) {
                nodeIter.next();
                nodeIter.set(nodes[nodeIter.previousIndex()].getNode());
            }
        }
        this.dispose();
        this.getMonitor().done();
    }

    private int countCrossings(NodeGroup[] leftLayer, NodeGroup[] rightLayer) {
        int targetCount = 0;
        int edgeCount = 0;
        NodeGroup[] nodeGroupArray = rightLayer;
        int n = rightLayer.length;
        int n2 = 0;
        while (n2 < n) {
            NodeGroup nodeGroup = nodeGroupArray[n2];
            LNode node = nodeGroup.getNode();
            if (((PortConstraints)node.getProperty(LayoutOptions.PORT_CONSTRAINTS)).isOrderFixed()) {
                int northInputPorts = 0;
                block1: for (LPort port : node.getPorts()) {
                    if (port.getSide() != PortSide.NORTH) break;
                    for (LEdge lEdge : port.getIncomingEdges()) {
                        if (node.getLayer() == lEdge.getSource().getNode().getLayer()) continue;
                        ++northInputPorts;
                        continue block1;
                    }
                }
                int otherInputPorts = 0;
                Iterator<LPort> portIter = node.getPorts().listIterator(node.getPorts().size());
                while (portIter.hasPrevious()) {
                    LPort lPort = (LPort)portIter.previous();
                    int portEdges = 0;
                    for (LEdge edge : lPort.getIncomingEdges()) {
                        if (node.getLayer() == edge.getSource().getNode().getLayer()) continue;
                        ++portEdges;
                    }
                    if (portEdges <= 0) continue;
                    if (lPort.getSide() == PortSide.NORTH) {
                        this.portPos[lPort.id] = targetCount++;
                    } else {
                        this.portPos[lPort.id] = targetCount + northInputPorts + otherInputPorts;
                        ++otherInputPorts;
                    }
                    edgeCount += portEdges;
                }
                targetCount += otherInputPorts;
            } else {
                int nodeEdges = 0;
                for (LPort port : node.getPorts()) {
                    for (LEdge lEdge : port.getIncomingEdges()) {
                        if (node.getLayer() == lEdge.getSource().getNode().getLayer()) continue;
                        ++nodeEdges;
                    }
                    this.portPos[port.id] = targetCount;
                }
                if (nodeEdges > 0) {
                    ++targetCount;
                    edgeCount += nodeEdges;
                }
            }
            ++n2;
        }
        int[] southSequence = new int[edgeCount];
        int i = 0;
        NodeGroup[] nodeEdges = leftLayer;
        int node = leftLayer.length;
        int n3 = 0;
        while (n3 < node) {
            LPort target;
            NodeGroup nodeGroup = nodeEdges[n3];
            LNode node2 = nodeGroup.getNode();
            if (((PortConstraints)node2.getProperty(LayoutOptions.PORT_CONSTRAINTS)).isOrderFixed()) {
                for (LPort port : node2.getPorts()) {
                    int start = i;
                    for (LEdge edge : port.getOutgoingEdges()) {
                        target = edge.getTarget();
                        if (node2.getLayer() == target.getNode().getLayer()) continue;
                        LayerSweepCrossingMinimizer.insert(southSequence, start, i++, this.portPos[target.id]);
                    }
                }
            } else {
                int start = i;
                for (LPort lPort : node2.getPorts()) {
                    for (LEdge edge : lPort.getOutgoingEdges()) {
                        target = edge.getTarget();
                        if (node2.getLayer() == target.getNode().getLayer()) continue;
                        LayerSweepCrossingMinimizer.insert(southSequence, start, i++, this.portPos[target.id]);
                    }
                }
            }
            ++n3;
        }
        int firstIndex = 1;
        while (firstIndex < targetCount) {
            firstIndex *= 2;
        }
        int treeSize = 2 * firstIndex - 1;
        --firstIndex;
        int[] tree = new int[treeSize];
        int crossCount = 0;
        int k = 0;
        while (k < edgeCount) {
            int index;
            int n4 = index = southSequence[k] + firstIndex;
            tree[n4] = tree[n4] + 1;
            while (index > 0) {
                if (index % 2 > 0) {
                    crossCount += tree[index + 1];
                }
                int n5 = index = (index - 1) / 2;
                tree[n5] = tree[n5] + 1;
            }
            ++k;
        }
        return crossCount;
    }

    private int countCrossings(NodeGroup[] layer) {
        int crossings = 0;
        HashMap<LNode, Pair> northSouthCrossingHints = new HashMap<LNode, Pair>();
        HashMap<LNode, Integer> dummyIndices = new HashMap<LNode, Integer>();
        HashMap<LPort, Integer> easternPortNumbers = new HashMap<LPort, Integer>();
        HashMap<LPort, Integer> westernPortNumbers = new HashMap<LPort, Integer>();
        this.numberEastWestPorts(layer, easternPortNumbers, westernPortNumbers);
        LNode currentNormalNode = null;
        int northMaxCrossingHint = 0;
        int southMaxCrossingHint = 0;
        boolean northernSide = true;
        boolean layerLayoutUnitsSet = true;
        NodeGroup[] nodeGroupArray = layer;
        int n = layer.length;
        int n2 = 0;
        while (n2 < n) {
            NodeGroup nodeGroup = nodeGroupArray[n2];
            LNode node = nodeGroup.getNode();
            for (LPort port : node.getPorts()) {
                switch (port.getSide()) {
                    case EAST: {
                        crossings += this.countInLayerCrossings(port, easternPortNumbers);
                        break;
                    }
                    case WEST: {
                        crossings += this.countInLayerCrossings(port, westernPortNumbers);
                    }
                }
            }
            NodeType nodeType = (NodeType)((Object)node.getProperty(Properties.NODE_TYPE));
            if (layerLayoutUnitsSet && (nodeType == NodeType.NORMAL || nodeType == NodeType.NORTH_SOUTH_PORT)) {
                LNode newNormalNode = (LNode)node.getProperty(Properties.IN_LAYER_LAYOUT_UNIT);
                if (newNormalNode == null) {
                    layerLayoutUnitsSet = false;
                } else {
                    if (currentNormalNode != newNormalNode) {
                        if (currentNormalNode != null) {
                            northSouthCrossingHints.put(currentNormalNode, new Pair((Object)northMaxCrossingHint, (Object)southMaxCrossingHint));
                        }
                        currentNormalNode = newNormalNode;
                        northMaxCrossingHint = 0;
                        southMaxCrossingHint = 0;
                        northernSide = true;
                    }
                    if (node == currentNormalNode) {
                        northernSide = false;
                    }
                    if (northernSide) {
                        dummyIndices.put(node, northMaxCrossingHint += ((Integer)node.getProperty(Properties.CROSSING_HINT)).intValue());
                    } else {
                        dummyIndices.put(node, southMaxCrossingHint += ((Integer)node.getProperty(Properties.CROSSING_HINT)).intValue());
                    }
                }
            }
            ++n2;
        }
        if (currentNormalNode != null) {
            northSouthCrossingHints.put(currentNormalNode, new Pair((Object)northMaxCrossingHint, (Object)southMaxCrossingHint));
        }
        if (layerLayoutUnitsSet) {
            LNode lastDummyNormalNode = null;
            int lastDummyIndex = 0;
            int dummyCount = 0;
            NodeGroup[] nodeGroupArray2 = layer;
            int n3 = layer.length;
            int n4 = 0;
            while (n4 < n3) {
                NodeGroup nodeGroup = nodeGroupArray2[n4];
                LNode node = nodeGroup.getNode();
                NodeType nodeType = (NodeType)((Object)node.getProperty(Properties.NODE_TYPE));
                switch (nodeType) {
                    case NORMAL: {
                        lastDummyIndex = (Integer)dummyIndices.get(node);
                        lastDummyNormalNode = node;
                        dummyCount = (Integer)((Pair)northSouthCrossingHints.get(node)).getSecond();
                        break;
                    }
                    case NORTH_SOUTH_PORT: {
                        lastDummyIndex = (Integer)dummyIndices.get(node);
                        LNode newNormalNode = (LNode)node.getProperty(Properties.IN_LAYER_LAYOUT_UNIT);
                        if (newNormalNode == lastDummyNormalNode) break;
                        dummyCount = (Integer)((Pair)northSouthCrossingHints.get(newNormalNode)).getFirst();
                        lastDummyNormalNode = newNormalNode;
                        break;
                    }
                    default: {
                        crossings += dummyCount - lastDummyIndex;
                    }
                }
                ++n4;
            }
        }
        return crossings;
    }

    private void numberEastWestPorts(NodeGroup[] layer, Map<LPort, Integer> easternMap, Map<LPort, Integer> westernMap) {
        LNode node;
        int currentEasternNumber = 0;
        int currentWesternNumber = 0;
        int nodeIndex = 0;
        while (nodeIndex < layer.length) {
            node = layer[nodeIndex].getNode();
            if (((PortConstraints)node.getProperty(LayoutOptions.PORT_CONSTRAINTS)).isOrderFixed()) {
                for (LPort easternPort : node.getPorts(PortSide.EAST)) {
                    if (easternPort.getDegree() <= 0) continue;
                    easternMap.put(easternPort, currentEasternNumber += easternPort.getDegree());
                }
            } else {
                for (LPort easternPort : node.getPorts(PortSide.EAST)) {
                    currentEasternNumber += easternPort.getDegree();
                }
                for (LPort easternPort : node.getPorts(PortSide.EAST)) {
                    if (easternPort.getDegree() <= 0) continue;
                    easternMap.put(easternPort, currentEasternNumber);
                }
            }
            ++nodeIndex;
        }
        nodeIndex = layer.length - 1;
        while (nodeIndex >= 0) {
            node = layer[nodeIndex].getNode();
            if (((PortConstraints)node.getProperty(LayoutOptions.PORT_CONSTRAINTS)).isOrderFixed()) {
                for (LPort westernPort : node.getPorts(PortSide.WEST)) {
                    if (westernPort.getDegree() <= 0) continue;
                    westernMap.put(westernPort, currentWesternNumber += westernPort.getDegree());
                }
            } else {
                for (LPort westernPort : node.getPorts(PortSide.WEST)) {
                    currentWesternNumber += westernPort.getDegree();
                }
                for (LPort westernPort : node.getPorts(PortSide.WEST)) {
                    if (westernPort.getDegree() <= 0) continue;
                    westernMap.put(westernPort, currentWesternNumber);
                }
            }
            --nodeIndex;
        }
    }

    private int countInLayerCrossings(LPort port, Map<LPort, Integer> portIndices) {
        int maxCrossings = 0;
        Integer portIndex = portIndices.get(port);
        if (portIndex == null) {
            return 0;
        }
        Integer connectedPortIndex = null;
        for (LEdge edge : port.getConnectedEdges()) {
            connectedPortIndex = edge.getSource() == port ? portIndices.get(edge.getTarget()) : portIndices.get(edge.getSource());
            if (connectedPortIndex == null || portIndex <= connectedPortIndex) continue;
            maxCrossings = Math.max(maxCrossings, portIndex - connectedPortIndex - 1);
        }
        return maxCrossings;
    }

    private static void copySweep(NodeGroup[][] source, NodeGroup[][] dest) {
        int i = 0;
        while (i < dest.length) {
            int j = 0;
            while (j < dest[i].length) {
                dest[i][j] = source[i][j];
                ++j;
            }
            ++i;
        }
    }

    private static void insert(int[] array, int start, int end, int n) {
        int insx = LayerSweepCrossingMinimizer.binarySearch(array, start, end, n);
        if (insx < 0) {
            insx = -insx - 1;
        }
        int j = end - 1;
        while (j >= insx) {
            array[j + 1] = array[j];
            --j;
        }
        array[insx] = n;
    }

    private static int binarySearch(int[] a, int fromIndex, int toIndex, int key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }
}

