/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.launch;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ResourceListSelectionDialog;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;

public abstract class GeneratorMainTab
extends AbstractLaunchConfigurationTab {
    private List modelList;

    public void createControl(Composite parent) {
        try {
            Composite mainComposite = new Composite(parent, 0);
            this.setControl((Control)mainComposite);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 0;
            layout.marginWidth = 10;
            mainComposite.setLayout((Layout)layout);
            this.createModelsEditor(mainComposite);
            Dialog.applyDialogFont((Control)mainComposite);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createModelsEditor(Composite mainComposite) {
        this.createModelList(mainComposite);
        this.createModelButtons(mainComposite);
    }

    private void createModelButtons(Composite parent) {
        Composite buttons = new Composite(parent, 128);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.verticalAlignment = 1;
        buttons.setLayoutData((Object)gd);
        this.makeButton(buttons, new AddModel(), "Add (filtered)");
        this.makeButton(buttons, new AddModelAlt(), "Add (selection)");
        this.makeButton(buttons, new RemoveModel(), "Remove");
        this.makeButton(buttons, new MoveModelUp(), "Move Up");
        this.makeButton(buttons, new MoveModelDown(), "Move Down");
    }

    private void createModelList(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Models to generate:");
        GridData gd = new GridData(1, 1, true, false, 2, 1);
        gd.verticalIndent = 20;
        label.setLayoutData((Object)gd);
        this.modelList = new List(parent, 2052);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.modelList.setLayoutData((Object)gridData);
    }

    private GridData makeButton(Composite buttons, Listener listener, String label) {
        Button addBtn = new Button(buttons, 0x1000088);
        addBtn.setText(label);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        addBtn.setLayoutData((Object)gd);
        addBtn.addListener(13, listener);
        return gd;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.modelList.removeAll();
            ArrayList param = new ArrayList();
            param = (ArrayList)configuration.getAttribute("ModelFiles", param);
            for (String tmp : param) {
                this.addModelFile(tmp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        try {
            ArrayList<String> param = new ArrayList<String>();
            String[] tmp = this.modelList.getItems();
            int i = 0;
            while (i < tmp.length) {
                param.add(tmp[i]);
                ++i;
            }
            configuration.setAttribute("ModelFiles", param);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return "Main";
    }

    private void addModelFile(String str) {
        this.modelList.add(str);
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }

    protected abstract boolean isValidModelFile(IResource var1);

    private class AddModel
    implements Listener {
        private AddModel() {
        }

        public void handleEvent(Event event) {
            Object[] tmp;
            ModelSelectionDialog dialog = new ModelSelectionDialog(GeneratorMainTab.this.modelList.getShell());
            dialog.setTitle("Resource Selection");
            dialog.setMessage("Select Room Model:");
            if (dialog.open() == 0 && (tmp = dialog.getResult()) != null) {
                int i = 0;
                while (i < tmp.length) {
                    IResource f = (IResource)tmp[i];
                    String arg = f.getFullPath().toString();
                    String fileLoc = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", arg);
                    GeneratorMainTab.this.addModelFile(fileLoc);
                    ++i;
                }
            }
        }
    }

    private class AddModelAlt
    implements Listener {
        private AddModelAlt() {
        }

        public void handleEvent(Event event) {
            Object[] tmp;
            ResourceSelectionDialog dialog = new ResourceSelectionDialog(GeneratorMainTab.this.modelList.getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), "");
            dialog.setTitle("Resource Selection");
            dialog.setMessage("Select Room Model:");
            if (dialog.open() == 0 && (tmp = dialog.getResult()) != null) {
                int i = 0;
                while (i < tmp.length) {
                    IResource f = (IResource)tmp[i];
                    String arg = f.getFullPath().toString();
                    String fileLoc = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", arg);
                    GeneratorMainTab.this.addModelFile(fileLoc);
                    ++i;
                }
            }
        }
    }

    private class ModelSelectionDialog
    extends ResourceListSelectionDialog {
        public ModelSelectionDialog(Shell parentShell) {
            super(parentShell, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
        }

        protected boolean select(IResource resource) {
            return GeneratorMainTab.this.isValidModelFile(resource);
        }
    }

    private class MoveModelDown
    implements Listener {
        private MoveModelDown() {
        }

        public void handleEvent(Event event) {
            String[] arr = GeneratorMainTab.this.modelList.getSelection();
            int i = 0;
            while (i < arr.length) {
                int index = GeneratorMainTab.this.modelList.indexOf(arr[i]);
                if (index != GeneratorMainTab.this.modelList.getItemCount() - 1) {
                    GeneratorMainTab.this.modelList.remove(arr[i]);
                    GeneratorMainTab.this.modelList.add(arr[i], index + 1);
                    GeneratorMainTab.this.modelList.setSelection(index + 1);
                }
                ++i;
            }
            GeneratorMainTab.this.setDirty(true);
            GeneratorMainTab.this.updateLaunchConfigurationDialog();
        }
    }

    private class MoveModelUp
    implements Listener {
        private MoveModelUp() {
        }

        public void handleEvent(Event event) {
            String[] arr = GeneratorMainTab.this.modelList.getSelection();
            int i = 0;
            while (i < arr.length) {
                int index = GeneratorMainTab.this.modelList.indexOf(arr[i]);
                if (index != 0) {
                    GeneratorMainTab.this.modelList.remove(arr[i]);
                    GeneratorMainTab.this.modelList.add(arr[i], index - 1);
                    GeneratorMainTab.this.modelList.setSelection(index - 1);
                }
                ++i;
            }
            GeneratorMainTab.this.setDirty(true);
            GeneratorMainTab.this.updateLaunchConfigurationDialog();
        }
    }

    private class RemoveModel
    implements Listener {
        private RemoveModel() {
        }

        public void handleEvent(Event event) {
            String[] arr = GeneratorMainTab.this.modelList.getSelection();
            int i = 0;
            while (i < arr.length) {
                GeneratorMainTab.this.modelList.remove(arr[i]);
                ++i;
            }
            GeneratorMainTab.this.setDirty(true);
            GeneratorMainTab.this.updateLaunchConfigurationDialog();
        }
    }
}

