/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.etphys.eTPhys.ExecMode;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.etphys.eTPhys.PhysicalThread;
import org.eclipse.etrice.core.genmodel.etricegen.AbstractInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInterfaceInstance;
import org.eclipse.etrice.core.genmodel.etricegen.InterfaceItemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.OptionalActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.ServiceImplInstance;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Wire;
import org.eclipse.etrice.core.genmodel.etricegen.WiredStructureClass;
import org.eclipse.etrice.core.genmodel.etricegen.WiredSubSystemClass;
import org.eclipse.etrice.core.genmodel.fsm.IDiagnostician;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.generator.base.IDataConfiguration;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.fsm.base.Indexed;
import org.eclipse.etrice.generator.fsm.base.IntelligentSeparator;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.java.Main;
import org.eclipse.etrice.generator.java.gen.ConfigGenAddon;
import org.eclipse.etrice.generator.java.gen.JavaExtensions;
import org.eclipse.etrice.generator.java.gen.VariableServiceGen;
import org.eclipse.etrice.generator.java.setup.GeneratorOptionsHelper;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class NodeGen {
    @Inject
    @Extension
    private JavaExtensions _javaExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    private IDataConfiguration dataConfigExt;
    @Inject
    private ConfigGenAddon configGenAddon;
    @Inject
    @Extension
    private ProcedureHelpers _procedureHelpers;
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;
    @Inject
    private IGeneratorFileIO fileIO;
    @Inject
    private VariableServiceGen varService;
    @Inject
    private IDiagnostician diagnostician;

    public void doGenerate(Root root) {
        HashMap sscc2wired = new HashMap();
        Functions.Function1 function1 = w -> w instanceof WiredSubSystemClass;
        Consumer<WiredStructureClass> consumer = w -> sscc2wired.put(((WiredSubSystemClass)w).getSubSystemClass(), (WiredSubSystemClass)w);
        IterableExtensions.filter((Iterable)root.getWiredInstances(), (Functions.Function1)function1).forEach(consumer);
        Collection collection = ETMapUtil.getNodeRefs();
        for (NodeRef nr : collection) {
            List list = ETMapUtil.getSubSystemInstancePaths((NodeRef)nr);
            for (String instpath : list) {
                StructureInstance structureInstance = root.getInstance(instpath);
                SubSystemInstance ssi = (SubSystemInstance)structureInstance;
                if (ssi == null) continue;
                WiredSubSystemClass wired = (WiredSubSystemClass)sscc2wired.get(ssi.getSubSystemClass());
                String path = this._roomExtensions.getPath((RoomClass)ssi.getSubSystemClass());
                String file = this._javaExtensions.getJavaFileName(nr, ssi);
                this.checkDataPorts(ssi);
                Set usedThreads = ETMapUtil.getUsedThreads((NodeRef)nr, (SubSystemInstance)ssi);
                this.fileIO.generateFile("generating Node implementation", path + file, this.generate(root, ssi, wired, usedThreads));
                boolean bl = this.dataConfigExt.hasVariableService(ssi);
                if (!bl) continue;
                this.varService.doGenerate(root, ssi);
            }
        }
    }

    private HashSet<ActorClass> getOptionalActorClasses(Root root, StructureInstance si) {
        Functions.Function1 function1 = i -> i instanceof ActorInterfaceInstance;
        Functions.Function1 function12 = aii -> (ActorInterfaceInstance)aii;
        ArrayList aifs = Lists.newArrayList((Iterator)IteratorExtensions.map((Iterator)IteratorExtensions.filter((Iterator)si.eAllContents(), (Functions.Function1)function1), (Functions.Function1)function12));
        Functions.Function1 function13 = aii -> aii.getActorClass();
        HashSet result = Sets.newHashSet((Iterable)ListExtensions.map((List)aifs, (Functions.Function1)function13));
        for (ActorInterfaceInstance ai : aifs) {
            EList eList = ai.getOptionalInstances();
            for (OptionalActorInstance oi : eList) {
                result.addAll(this.getOptionalActorClasses(root, (StructureInstance)oi));
            }
        }
        return result;
    }

    public CharSequence generate(Root root, SubSystemInstance comp, WiredSubSystemClass wired, Collection<PhysicalThread> usedThreads) {
        String string;
        String string2;
        Object svc;
        ActorRef sub2;
        Object object;
        Iterator iterator;
        String string3;
        Iterator<ActorClass> iterator2;
        Indexed thread22;
        StringConcatenation stringConcatenation = null;
        SubSystemClass cc = comp.getSubSystemClass();
        EList models = root.getReferencedModels((RoomClass)cc);
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)comp);
        String clsname = this._javaExtensions.getJavaClassName(nr, comp);
        Functions.Function1 function1 = t -> usedThreads.contains(t);
        Iterable threads = IterableExtensions.filter((Iterable)nr.getType().getThreads(), (Functions.Function1)function1);
        HashSet<ActorClass> opt = this.getOptionalActorClasses(root, (StructureInstance)comp);
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("package ");
        String string4 = this._roomExtensions.getPackage((RoomClass)cc);
        stringConcatenation2.append(string4);
        stringConcatenation2.append(";");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("import org.eclipse.etrice.runtime.java.config.IVariableService;");
        stringConcatenation2.newLine();
        boolean bl = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (bl) {
            stringConcatenation2.append("import org.eclipse.etrice.runtime.java.debugging.DebuggingService;");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("import org.eclipse.etrice.runtime.java.messaging.IRTObject;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("import org.eclipse.etrice.runtime.java.messaging.IMessageService;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("import org.eclipse.etrice.runtime.java.messaging.MessageService;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("import org.eclipse.etrice.runtime.java.messaging.MessageServiceController;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("import org.eclipse.etrice.runtime.java.messaging.RTServices;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("import org.eclipse.etrice.runtime.java.modelbase.ActorClassBase;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("import org.eclipse.etrice.runtime.java.modelbase.DataPortBase;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("import org.eclipse.etrice.runtime.java.modelbase.OptionalActorInterfaceBase;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("import org.eclipse.etrice.runtime.java.modelbase.IOptionalActorFactory;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("import org.eclipse.etrice.runtime.java.modelbase.SubSystemClassBase;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("import org.eclipse.etrice.runtime.java.modelbase.InterfaceItemBase;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("import org.eclipse.etrice.runtime.java.modelbase.InterfaceItemBroker;");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        for (RoomModel model : models) {
            stringConcatenation2.append("import ");
            String string5 = model.getName();
            stringConcatenation2.append(string5);
            stringConcatenation2.append(".*;");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        CharSequence charSequence = this._procedureHelpers.userCode((ActorContainerClass)cc, 1, false);
        stringConcatenation2.append((Object)charSequence);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("public class ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append(" extends SubSystemClassBase {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        Object object2 = Indexed.indexed((Iterable)threads);
        Object object3 = object2.iterator();
        while (object3.hasNext()) {
            thread22 = (Indexed)object3.next();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("public static final int ");
            iterator2 = this.getThreadId((PhysicalThread)thread22.getValue());
            stringConcatenation2.append((String)((Object)iterator2), "\t");
            stringConcatenation2.append(" = ");
            int n = thread22.getIndex0();
            stringConcatenation2.append((Object)n, "\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        object2 = this._procedureHelpers.userCode((ActorContainerClass)cc, 2, false);
        stringConcatenation2.append(object2, "\t");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("public ");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("(IRTObject parent, String name) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("super(parent, name);");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("@Override");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("public void receiveEvent(InterfaceItemBase ifitem, int evt, Object data){");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("@Override");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("public void instantiateMessageServices() {");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("IMessageService msgService;");
        stringConcatenation2.newLine();
        thread22 = it -> {
            long l = it.getPrio();
            return -l;
        };
        object3 = IterableExtensions.sortBy((Iterable)threads, (Functions.Function1)thread22);
        Iterator iterator3 = object3.iterator();
        while (iterator3.hasNext()) {
            PhysicalThread thread_1 = (PhysicalThread)iterator3.next();
            if (Objects.equals(thread_1.getExecmode(), ExecMode.POLLED) || Objects.equals(thread_1.getExecmode(), ExecMode.MIXED)) {
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("msgService = new MessageService(this, MessageService.ExecMode.");
                var21_31 = thread_1.getExecmode().getName();
                stringConcatenation2.append(var21_31, "\t\t");
                stringConcatenation2.append(", ");
                long l = thread_1.getTime();
                stringConcatenation2.append((Object)l, "\t\t");
                stringConcatenation2.append("L, 0, ");
                string3 = this.getThreadId(thread_1);
                stringConcatenation2.append(string3, "\t\t");
                stringConcatenation2.append(", \"MessageService_");
                iterator = thread_1.getName();
                stringConcatenation2.append((String)((Object)iterator), "\t\t");
                stringConcatenation2.append("\" /*, thread_prio */);");
                stringConcatenation2.newLineIfNotEmpty();
            } else {
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("msgService = new MessageService(this, MessageService.ExecMode.");
                var21_31 = thread_1.getExecmode().getName();
                stringConcatenation2.append(var21_31, "\t\t");
                stringConcatenation2.append(", 0, ");
                String string6 = this.getThreadId(thread_1);
                stringConcatenation2.append(string6, "\t\t");
                stringConcatenation2.append(", \"MessageService_");
                object = thread_1.getName();
                stringConcatenation2.append((String)object, "\t\t");
                stringConcatenation2.append("\" /*, thread_prio */);");
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("RTServices.getInstance().getMsgSvcCtrl().addMsgSvc(msgService);");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("@Override");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("public void instantiateActors() {");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("// thread mappings");
        stringConcatenation2.newLine();
        thread22 = comp.getAllContainedInstances();
        for (ActorInstance ai : thread22) {
            boolean bl2;
            stringConcatenation2.append("\t\t");
            ETMapUtil.MappedThread mapped = ETMapUtil.getMappedThread((AbstractInstance)ai);
            stringConcatenation2.newLineIfNotEmpty();
            boolean bl3 = bl2 = !mapped.isImplicit() && !mapped.isAsParent();
            if (!bl2) continue;
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("addPathToThread(\"");
            String string7 = ai.getPath();
            stringConcatenation2.append(string7, "\t\t");
            stringConcatenation2.append("\", ");
            object = this.getThreadId(mapped.getThread());
            stringConcatenation2.append((String)object, "\t\t");
            stringConcatenation2.append(");");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("// sub actors");
        stringConcatenation2.newLine();
        thread22 = cc.getActorRefs();
        for (ActorRef sub2 : thread22) {
            boolean bl4;
            int mapped = sub2.getMultiplicity();
            boolean bl5 = bl4 = mapped > 1;
            if (bl4) {
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("for (int i=0; i<");
                int n = sub2.getMultiplicity();
                stringConcatenation2.append((Object)n, "\t\t");
                stringConcatenation2.append("; ++i) {");
                stringConcatenation2.newLineIfNotEmpty();
                boolean bl6 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
                if (bl6) {
                    stringConcatenation2.append("\t\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("DebuggingService.getInstance().addMessageActorCreate(this, \"");
                    string3 = sub2.getName();
                    stringConcatenation2.append(string3, "\t\t\t");
                    stringConcatenation2.append((Object)Character.valueOf(':'), "\t\t\t");
                    stringConcatenation2.append("\"+i);");
                    stringConcatenation2.newLineIfNotEmpty();
                }
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("new ");
                object = sub2.getType().getName();
                stringConcatenation2.append((String)object, "\t\t\t");
                stringConcatenation2.append("(this, \"");
                string3 = sub2.getName();
                stringConcatenation2.append(string3, "\t\t\t");
                stringConcatenation2.append((Object)Character.valueOf(':'), "\t\t\t");
                stringConcatenation2.append("\"+i);");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
                continue;
            }
            boolean bl7 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
            if (bl7) {
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("DebuggingService.getInstance().addMessageActorCreate(this, \"");
                object = sub2.getName();
                stringConcatenation2.append((String)object, "\t\t");
                stringConcatenation2.append("\");");
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("new ");
            String string8 = sub2.getType().getName();
            stringConcatenation2.append(string8, "\t\t");
            stringConcatenation2.append("(this, \"");
            object = sub2.getName();
            stringConcatenation2.append((String)object, "\t\t");
            stringConcatenation2.append("\");");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("// create service brokers in optional actor interfaces");
        stringConcatenation2.newLine();
        thread22 = inst -> inst instanceof ActorInterfaceInstance;
        sub2 = inst -> (ActorInterfaceInstance)inst;
        iterator2 = IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)this._roomExtensions.getAllSubInstances((StructureInstance)comp), (Functions.Function1)thread22), (Functions.Function1)sub2);
        Iterator iterator4 = iterator2.iterator();
        while (iterator4.hasNext()) {
            ActorInterfaceInstance aii = (ActorInterfaceInstance)iterator4.next();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("{");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("OptionalActorInterfaceBase oai = (OptionalActorInterfaceBase) getObject(\"");
            String string9 = aii.getPath();
            stringConcatenation2.append(string9, "\t\t\t");
            stringConcatenation2.append("\");");
            stringConcatenation2.newLineIfNotEmpty();
            object = aii.getProvidedServices();
            iterator = object.iterator();
            while (iterator.hasNext()) {
                svc = (ServiceImplInstance)iterator.next();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("new InterfaceItemBroker(oai, \"");
                string2 = this._roomExtensions.getFullyQualifiedName((RoomClass)svc.getProtocol());
                stringConcatenation2.append(string2, "\t\t\t");
                stringConcatenation2.append("\", 0);");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("InterfaceItemBase.connect(this, \"");
                string = svc.getPath();
                stringConcatenation2.append(string, "\t\t\t");
                stringConcatenation2.append("\", \"");
                String string10 = aii.getPath();
                String string11 = string10 + String.valueOf(Character.valueOf('/'));
                String string12 = this._roomExtensions.getFullyQualifiedName((RoomClass)svc.getProtocol());
                String string13 = string11 + string12;
                stringConcatenation2.append(string13, "\t\t\t");
                stringConcatenation2.append("\");");
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("// wiring");
        stringConcatenation2.newLine();
        thread22 = wired.getWires();
        for (Wire wire : thread22) {
            stringConcatenation2.append("\t\t");
            String aii = null;
            boolean bl8 = wire.isDataDriven();
            aii = bl8 ? "DataPortBase" : "InterfaceItemBase";
            stringConcatenation2.append(aii, "\t\t");
            stringConcatenation2.append(".connect(this, \"");
            String string14 = IterableExtensions.join((Iterable)wire.getPath1(), (CharSequence)"/");
            stringConcatenation2.append(string14, "\t\t");
            stringConcatenation2.append("\", \"");
            object = IterableExtensions.join((Iterable)wire.getPath2(), (CharSequence)"/");
            stringConcatenation2.append((String)object, "\t\t");
            stringConcatenation2.append("\");");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("// apply instance attribute configurations");
        stringConcatenation2.newLine();
        thread22 = comp.getAllContainedInstances();
        for (ActorInstance ai_1 : thread22) {
            boolean bl9;
            stringConcatenation2.append("\t\t");
            CharSequence cfg = this.configGenAddon.genActorInstanceConfig(ai_1, "inst");
            stringConcatenation2.newLineIfNotEmpty();
            int n = cfg.length();
            boolean bl10 = bl9 = n > 0;
            if (!bl9) continue;
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("{");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            object = ai_1.getActorClass().getName();
            stringConcatenation2.append((String)object, "\t\t\t");
            stringConcatenation2.append(" inst = (");
            svc = ai_1.getActorClass().getName();
            stringConcatenation2.append((String)svc, "\t\t\t");
            stringConcatenation2.append(") getObject(\"");
            iterator = ai_1.getPath();
            stringConcatenation2.append((String)((Object)iterator), "\t\t\t");
            stringConcatenation2.append("\");");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("if (inst!=null) {");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append((Object)cfg, "\t\t\t\t");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("@Override");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("public void init(){");
        stringConcatenation2.newLine();
        boolean thread22 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (thread22) {
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("DebuggingService.getInstance().addVisibleComment(\"begin sub system initialization\");");
            stringConcatenation2.newLine();
        }
        if (thread22 = this.dataConfigExt.hasVariableService(comp)) {
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("variableService = new ");
            stringConcatenation2.append(clsname, "\t\t");
            stringConcatenation2.append("VariableService(this);");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("super.init();");
        stringConcatenation2.newLine();
        thread22 = this.dataConfigExt.hasVariableService(comp);
        if (thread22) {
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("variableService.init();");
            stringConcatenation2.newLine();
        }
        if (thread22 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings())) {
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("DebuggingService.getInstance().addVisibleComment(\"done sub system initialization\");");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("@Override");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("public void stop(){");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("super.stop();");
        stringConcatenation2.newLine();
        thread22 = this.dataConfigExt.hasVariableService(comp);
        if (thread22) {
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("variableService.stop();");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        thread22 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (thread22) {
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("@Override");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("public boolean hasGeneratedMSCInstrumentation() {");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("return true;");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("@Override");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("public void destroy() {");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("DebuggingService.getInstance().addVisibleComment(\"begin sub system destruction\");");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("super.destroy();");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("DebuggingService.getInstance().addVisibleComment(\"done sub system destruction\");");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("public IOptionalActorFactory getFactory(String optionalActorClass, String actorClass) {");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        IntelligentSeparator else1 = new IntelligentSeparator("else ");
        stringConcatenation2.newLineIfNotEmpty();
        for (ActorClass oa : opt) {
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append((Object)else1, "\t\t");
            stringConcatenation2.append("if (optionalActorClass.equals(\"");
            String string15 = oa.getName();
            stringConcatenation2.append(string15, "\t\t");
            stringConcatenation2.append("\")) {");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            IntelligentSeparator else2 = new IntelligentSeparator("else ");
            stringConcatenation2.newLineIfNotEmpty();
            Functions.Function1 function12 = s -> {
                boolean bl = s.isAbstract();
                return !bl;
            };
            object = IterableExtensions.filter((Iterable)this._roomExtensions.union((Iterable)root.getSubClasses(oa), (Object)oa), (Functions.Function1)function12);
            iterator = object.iterator();
            while (iterator.hasNext()) {
                ActorClass subcls = (ActorClass)iterator.next();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append((Object)else2, "\t\t\t");
                stringConcatenation2.append("if (\"");
                string2 = subcls.getName();
                stringConcatenation2.append(string2, "\t\t\t");
                stringConcatenation2.append("\".equals(actorClass)) {");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("return new ");
                string = this._javaExtensions.getJavaFactoryName(subcls);
                stringConcatenation2.append(string, "\t\t\t\t");
                stringConcatenation2.append("();");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
            }
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("return null;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("};");
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private String getThreadId(PhysicalThread thread) {
        String string = thread.getName().toUpperCase();
        return "THREAD_" + string;
    }

    private void checkDataPorts(SubSystemInstance comp) {
        HashSet<CallSite> found = new HashSet<CallSite>();
        EList eList = comp.getAllContainedInstances();
        for (ActorInstance ai : eList) {
            int thread = ai.getThreadId();
            EList eList2 = ai.getOrderedIfItemInstances();
            for (InterfaceItemInstance pi : eList2) {
                CommunicationType communicationType = pi.getProtocol().getCommType();
                boolean bl = Objects.equals(communicationType, CommunicationType.DATA_DRIVEN);
                if (!bl) continue;
                EList eList3 = pi.getPeers();
                for (InterfaceItemInstance peer : eList3) {
                    boolean bl2;
                    EObject eObject = peer.eContainer();
                    ActorInstance peer_ai = (ActorInstance)eObject;
                    int peer_thread = peer_ai.getThreadId();
                    if (thread == peer_thread) continue;
                    String path = pi.getPath();
                    String ppath = peer.getPath();
                    String string = null;
                    int n = path.compareTo(ppath);
                    boolean bl3 = n < 0;
                    string = bl3 ? path + " and " + ppath : ppath + " and " + path;
                    String pair = string;
                    boolean bl4 = found.contains(pair);
                    boolean bl5 = bl2 = !bl4;
                    if (!bl2) continue;
                    found.add((CallSite)((Object)pair));
                    this.diagnostician.error(pair + ": data ports placed on different threads (not supported yet)", (EObject)pi.getInterfaceItem(), pi.getInterfaceItem().eContainingFeature());
                }
            }
        }
    }
}

