/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.genmodel.fsm;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.ChoicepointTerminal;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.NonInitialTransition;
import org.eclipse.etrice.core.fsm.fSM.RefinedState;
import org.eclipse.etrice.core.fsm.fSM.RefinedTransition;
import org.eclipse.etrice.core.fsm.fSM.SimpleState;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.fSM.StateGraphItem;
import org.eclipse.etrice.core.fsm.fSM.StateGraphNode;
import org.eclipse.etrice.core.fsm.fSM.StateTerminal;
import org.eclipse.etrice.core.fsm.fSM.SubStateTrPointTerminal;
import org.eclipse.etrice.core.fsm.fSM.TrPointTerminal;
import org.eclipse.etrice.core.fsm.fSM.Transition;
import org.eclipse.etrice.core.fsm.naming.FSMNameProvider;
import org.eclipse.etrice.core.fsm.util.FSMHelpers;
import org.eclipse.etrice.core.genmodel.fsm.FsmGenExtensions;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.FsmGenFactory;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Graph;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphContainer;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Link;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Node;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class BasicFsmGenBuilder {
    @Extension
    protected FSMHelpers fsmHelpers;
    protected FSMNameProvider fsmNameProvider = new FSMNameProvider();
    protected final FsmGenFactory factory = FsmGenFactory.eINSTANCE;
    private int inheritanceLevel = 0;
    private final HashMap<ArrayList<?>, GraphContainer> _createCache_createContainer = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Graph> _createCache_createGraph = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Link> _createCache_createLink = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Node> _createCache_createNode = CollectionLiterals.newHashMap();

    public BasicFsmGenBuilder(FSMHelpers fsmHelpers) {
        this.fsmHelpers = fsmHelpers;
    }

    public GraphContainer createTransformedModel(ModelComponent mc) {
        return this.createContainer(mc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GraphContainer createContainer(ModelComponent mc) {
        GraphContainer graphContainer;
        ArrayList arrayList = CollectionLiterals.newArrayList((Object[])new ModelComponent[]{mc});
        HashMap<ArrayList<?>, GraphContainer> hashMap = this._createCache_createContainer;
        synchronized (hashMap) {
            GraphContainer graphContainer2;
            if (this._createCache_createContainer.containsKey(arrayList)) {
                return this._createCache_createContainer.get(arrayList);
            }
            graphContainer = graphContainer2 = this.factory.createGraphContainer();
            this._createCache_createContainer.put(arrayList, graphContainer);
        }
        this._init_createContainer(graphContainer, mc);
        return graphContainer;
    }

    private void _init_createContainer(GraphContainer it, ModelComponent mc) {
        boolean bl;
        it.setComponent(mc);
        it.setGraph(this.createStateMachine(mc));
        Graph graph = it.getGraph();
        boolean bl2 = bl = graph != null;
        if (bl) {
            EList<State> eList = it.getOrderedStates();
            Functions.Function1 function1 = it_1 -> it_1.getStateGraphNode();
            Iterable<State> iterable = FsmGenExtensions.getLeafStatesLast(IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)IteratorExtensions.map(FsmGenExtensions.getAllStateNodes(it.getGraph()), (Functions.Function1)function1), State.class)));
            Iterables.addAll(eList, iterable);
            EList<String> eList2 = it.getOrderedStateNames();
            Functions.Function1 function12 = it_1 -> this.fsmNameProvider.getFullPath((StateGraphItem)it_1);
            List list = ListExtensions.map(it.getOrderedStates(), (Functions.Function1)function12);
            Iterables.addAll(eList2, (Iterable)list);
        }
    }

    private Graph createStateMachine(ModelComponent mc) {
        Graph graph = null;
        StateGraph superFSM = this.fsmHelpers.getSuperStateMachine(mc);
        Graph graph2 = null;
        if (superFSM != null) {
            Graph graph3 = null;
            Graph baseGraph = this.createStateMachine(this.fsmHelpers.getModelComponent((EObject)superFSM));
            ++this.inheritanceLevel;
            graph2 = graph3 = this.mergeGraph(baseGraph, this.fsmHelpers.getActualStateMachine(mc));
        } else {
            boolean bl;
            Graph graph4 = null;
            StateGraph stateGraph = this.fsmHelpers.getActualStateMachine(mc);
            boolean bl2 = bl = stateGraph != null;
            if (bl) {
                StateGraph stateGraph2 = this.fsmHelpers.getActualStateMachine(mc);
                Graph graph5 = null;
                if (stateGraph2 != null) {
                    graph5 = this.createGraph(stateGraph2);
                }
                graph4 = graph5;
            }
            graph2 = graph4;
        }
        graph = graph2;
        return graph;
    }

    private Graph mergeGraph(Graph graph, StateGraph sg) {
        Consumer<Node> consumer = it -> it.setInherited(true);
        graph.getNodes().forEach(consumer);
        Consumer<Link> consumer2 = it -> it.setInherited(true);
        graph.getLinks().forEach(consumer2);
        this.createContents(graph, sg);
        graph.setStateGraph(sg);
        return graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Graph createGraph(StateGraph sg) {
        Graph graph;
        ArrayList arrayList = CollectionLiterals.newArrayList((Object[])new StateGraph[]{sg});
        HashMap<ArrayList<?>, Graph> hashMap = this._createCache_createGraph;
        synchronized (hashMap) {
            Graph graph2;
            if (this._createCache_createGraph.containsKey(arrayList)) {
                return this._createCache_createGraph.get(arrayList);
            }
            graph = graph2 = this.factory.createGraph();
            this._createCache_createGraph.put(arrayList, graph);
        }
        this._init_createGraph(graph, sg);
        return graph;
    }

    private void _init_createGraph(Graph it, StateGraph sg) {
        it.setStateGraph(sg);
        this.createContents(it, sg);
    }

    private void createContents(Graph graph, StateGraph sg) {
        Functions.Function1 function1 = it -> this.createNode((EObject)it);
        graph.getNodes().addAll((Collection)ListExtensions.map((List)sg.getChPoints(), (Functions.Function1)function1));
        Functions.Function1 function12 = it -> this.createNode((EObject)it);
        graph.getNodes().addAll((Collection)ListExtensions.map((List)sg.getTrPoints(), (Functions.Function1)function12));
        Functions.Function1 function13 = it -> this.createNode((EObject)it);
        Iterables.addAll(graph.getNodes(), (Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)sg.getStates(), SimpleState.class), (Functions.Function1)function13));
        Functions.Function1 function14 = it -> this.createLink((Transition)it);
        graph.getLinks().addAll((Collection)ListExtensions.map((List)sg.getTransitions(), (Functions.Function1)function14));
        Consumer<RefinedState> consumer = it -> this.handleRefinedState((RefinedState)it);
        Iterables.filter((Iterable)sg.getStates(), RefinedState.class).forEach(consumer);
        Consumer<RefinedTransition> consumer2 = it -> this.handleRefinedTransition((RefinedTransition)it);
        sg.getRefinedTransitions().forEach(consumer2);
    }

    private void handleRefinedState(RefinedState s) {
        boolean bl;
        Node refinedNode = this.createNode((EObject)this.fsmHelpers.getFinalTarget(s));
        StateGraph stateGraph = s.getSubgraph();
        boolean bl2 = bl = stateGraph != null;
        if (bl) {
            boolean bl3;
            Graph graph = refinedNode.getSubgraph();
            boolean bl4 = bl3 = graph != null;
            if (bl3) {
                this.mergeGraph(refinedNode.getSubgraph(), s.getSubgraph());
            } else {
                refinedNode.setSubgraph(this.createGraph(s.getSubgraph()));
            }
        }
        Node target = refinedNode;
        target.setStateGraphNode((StateGraphNode)s);
    }

    private boolean handleRefinedTransition(RefinedTransition t) {
        EList<RefinedTransition> eList = this.createLink(t.getTarget()).getRefinements();
        return eList.add((Object)t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Link createLink(Transition tr) {
        Link link;
        ArrayList arrayList = CollectionLiterals.newArrayList((Object[])new Transition[]{tr});
        HashMap<ArrayList<?>, Link> hashMap = this._createCache_createLink;
        synchronized (hashMap) {
            Link link2;
            if (this._createCache_createLink.containsKey(arrayList)) {
                return this._createCache_createLink.get(arrayList);
            }
            link = link2 = this.factory.createLink();
            this._createCache_createLink.put(arrayList, link);
        }
        this._init_createLink(link, tr);
        return link;
    }

    private void _init_createLink(Link it, Transition tr) {
        it.setTransition(tr);
        Node node = null;
        if (tr instanceof NonInitialTransition) {
            node = this.createNode((EObject)((NonInitialTransition)tr).getFrom());
        }
        it.setSource(node);
        it.setTarget(this.createNode((EObject)tr.getTo()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node _createNode(StateGraphNode s) {
        Node node;
        ArrayList arrayList = CollectionLiterals.newArrayList((Object[])new StateGraphNode[]{s});
        HashMap<ArrayList<?>, Node> hashMap = this._createCache_createNode;
        synchronized (hashMap) {
            Node node2;
            if (this._createCache_createNode.containsKey(arrayList)) {
                return this._createCache_createNode.get(arrayList);
            }
            node = node2 = this.factory.createNode();
            this._createCache_createNode.put(arrayList, node);
        }
        this._init_createNode(node, s);
        return node;
    }

    private void _init_createNode(Node it, StateGraphNode s) {
        it.setStateGraphNode(s);
        it.setInheritanceLevel(this.inheritanceLevel);
        Graph graph = null;
        if (s instanceof State) {
            StateGraph stateGraph = ((State)s).getSubgraph();
            Graph graph2 = null;
            if (stateGraph != null) {
                graph2 = this.createGraph(stateGraph);
            }
            graph = graph2;
        }
        it.setSubgraph(graph);
    }

    private Node _createNode(ChoicepointTerminal tt) {
        return this.createNode((EObject)tt.getCp());
    }

    private Node _createNode(TrPointTerminal tt) {
        return this.createNode((EObject)tt.getTrPoint());
    }

    private Node _createNode(StateTerminal tt) {
        return this.createNode((EObject)tt.getState());
    }

    private Node _createNode(SubStateTrPointTerminal tt) {
        return this.createNode((EObject)tt.getTrPoint());
    }

    private Node createNode(EObject tt) {
        if (tt instanceof ChoicepointTerminal) {
            return this._createNode((ChoicepointTerminal)tt);
        }
        if (tt instanceof StateGraphNode) {
            return this._createNode((StateGraphNode)tt);
        }
        if (tt instanceof StateTerminal) {
            return this._createNode((StateTerminal)tt);
        }
        if (tt instanceof SubStateTrPointTerminal) {
            return this._createNode((SubStateTrPointTerminal)tt);
        }
        if (tt instanceof TrPointTerminal) {
            return this._createNode((TrPointTerminal)tt);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(tt).toString());
    }
}

