/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.config.util;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.etrice.core.config.ActorClassConfig;
import org.eclipse.etrice.core.config.ActorInstanceConfig;
import org.eclipse.etrice.core.config.AttrClassConfig;
import org.eclipse.etrice.core.config.AttrInstanceConfig;
import org.eclipse.etrice.core.config.ConfigModel;
import org.eclipse.etrice.core.config.ProtocolClassConfig;
import org.eclipse.etrice.core.config.SubSystemConfig;
import org.eclipse.etrice.core.config.util.ConfigUtil;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.generator.base.logging.ILogger;

@Singleton
public class DataConfigurationHelper {
    @Inject
    private ConfigUtil ConfigUtil;
    public Map<String, AttrClassConfig> actorClassAttrMap = new HashMap<String, AttrClassConfig>();
    public Map<String, AttrClassConfig> protocolClassAttrMap = new HashMap<String, AttrClassConfig>();
    public Map<String, AttrInstanceConfig> actorInstanceAttrMap = new HashMap<String, AttrInstanceConfig>();
    public Map<String, SubSystemConfig> subSystemConfigMap = new HashMap<String, SubSystemConfig>();
    public Map<String, List<AttrInstanceConfig>> dynActorInstanceAttrMap = new HashMap<String, List<AttrInstanceConfig>>();
    public Map<ActorClass, List<AttrInstanceConfig>> dynActorClassAttrMap = new HashMap<ActorClass, List<AttrInstanceConfig>>();

    public boolean setConfigModels(ResourceSet rs, ILogger logger) {
        this.actorClassAttrMap.clear();
        this.protocolClassAttrMap.clear();
        this.actorInstanceAttrMap.clear();
        this.subSystemConfigMap.clear();
        this.dynActorInstanceAttrMap.clear();
        this.dynActorClassAttrMap.clear();
        boolean error = false;
        ArrayList<ConfigModel> configs = new ArrayList<ConfigModel>();
        for (Resource res : rs.getResources()) {
            for (EObject object : res.getContents()) {
                if (!(object instanceof ConfigModel)) continue;
                configs.add((ConfigModel)object);
            }
        }
        if (!configs.isEmpty()) {
            logger.logInfo("-- loading configurations");
        }
        HashSet<ActorClass> actorClasses = new HashSet<ActorClass>();
        HashSet<ProtocolClass> protocolClasses = new HashSet<ProtocolClass>();
        HashSet<String> actorInstances = new HashSet<String>();
        for (ConfigModel config : configs) {
            String path;
            for (ActorClassConfig classConfig : config.getActorClassConfigs()) {
                if (actorClasses.contains(classConfig.getActor())) {
                    logger.logError("Multiple configurations for actor class " + classConfig.getActor().getName() + " found");
                    error = true;
                    continue;
                }
                actorClasses.add(classConfig.getActor());
                this.collectConfigs(classConfig, this.actorClassAttrMap);
            }
            for (ProtocolClassConfig protocolConfig : config.getProtocolClassConfigs()) {
                if (protocolClasses.contains(protocolConfig.getProtocol())) {
                    logger.logError("Multiple configurations for protocol class " + protocolConfig.getProtocol().getName() + " found");
                    error = true;
                    continue;
                }
                protocolClasses.add(protocolConfig.getProtocol());
                this.collectConfigs(protocolConfig, this.protocolClassAttrMap);
            }
            for (ActorInstanceConfig instanceConfig : config.getActorInstanceConfigs()) {
                path = this.ConfigUtil.getPath(instanceConfig);
                if (actorInstances.contains(path)) {
                    logger.logError("Multiple configurations for actor instance " + path + " found");
                    continue;
                }
                actorInstances.add(path);
                this.collectConfigs(instanceConfig, path, this.actorInstanceAttrMap);
            }
            for (SubSystemConfig ssConfig : config.getSubSystemConfigs()) {
                path = this.ConfigUtil.getPath(ssConfig);
                if (this.subSystemConfigMap.containsKey(path)) {
                    logger.logError("Multiple configurations for subSystem" + path + " found");
                    error = true;
                    continue;
                }
                this.subSystemConfigMap.put(path, ssConfig);
            }
        }
        return !error;
    }

    private void collectConfigs(ActorInstanceConfig actorConfig, String path, Map<String, AttrInstanceConfig> map) {
        for (AttrInstanceConfig c : actorConfig.getAttributes()) {
            this.collectConfigs(c, String.valueOf(path) + "/" + c.getAttribute().getName(), map);
            if (!c.isDynConfig()) continue;
            List<AttrInstanceConfig> list = this.dynActorInstanceAttrMap.get(path);
            if (list == null) {
                list = new ArrayList<AttrInstanceConfig>();
            }
            list.add(c);
            this.dynActorInstanceAttrMap.put(path, list);
            ActorClass ac = this.ConfigUtil.getLastActorRef((ActorContainerClass)actorConfig.getSubSystem().getType(), actorConfig.getPath()).getType();
            list = this.dynActorClassAttrMap.get(ac);
            if (list == null) {
                list = new ArrayList<AttrInstanceConfig>();
            }
            list.add(c);
            this.dynActorClassAttrMap.put(ac, list);
        }
        for (AttrInstanceConfig c : actorConfig.getPorts()) {
            for (AttrInstanceConfig a : c.getAttributes()) {
                this.collectConfigs(a, String.valueOf(path) + "/" + c.getItem().getName() + "/" + a.getAttribute().getName(), map);
            }
        }
    }

    private void collectConfigs(ProtocolClassConfig protocolConfig, Map<String, AttrClassConfig> map) {
        String path = "/" + protocolConfig.getProtocol().getName();
        if (protocolConfig.getRegular() != null) {
            for (AttrClassConfig c : protocolConfig.getRegular().getAttributes()) {
                this.collectConfigs(c, String.valueOf(path) + "/regular/" + c.getAttribute().getName(), map);
            }
        }
        if (protocolConfig.getConjugated() != null) {
            for (AttrClassConfig c : protocolConfig.getConjugated().getAttributes()) {
                this.collectConfigs(c, String.valueOf(path) + "/conjugated/" + c.getAttribute().getName(), map);
            }
        }
    }

    private void collectConfigs(ActorClassConfig actorConfig, Map<String, AttrClassConfig> map) {
        String path = "/" + actorConfig.getActor().getName();
        for (AttrClassConfig c : actorConfig.getAttributes()) {
            this.collectConfigs(c, String.valueOf(path) + "/" + c.getAttribute().getName(), map);
        }
    }

    private void collectConfigs(AttrClassConfig config, String path, Map<String, AttrClassConfig> map) {
        Attribute a = config.getAttribute();
        if (a.getType().getType() instanceof DataClass) {
            for (AttrClassConfig c : config.getAttributes()) {
                this.collectConfigs(c, String.valueOf(path) + "/" + c.getAttribute().getName(), map);
            }
        }
        map.put(path, config);
    }

    private void collectConfigs(AttrInstanceConfig config, String path, Map<String, AttrInstanceConfig> map) {
        Attribute a = config.getAttribute();
        if (a.getType().getType() instanceof DataClass) {
            for (AttrInstanceConfig c : config.getAttributes()) {
                this.collectConfigs(c, String.valueOf(path) + "/" + c.getAttribute().getName(), map);
            }
        }
        map.put(path, config);
    }

    public String toStringPath(Iterable<String> path, String pathDelim) {
        StringBuilder b = new StringBuilder();
        for (String p : path) {
            b.append(String.valueOf(pathDelim) + p);
        }
        return b.toString();
    }
}

