/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.validation;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.common.base.Annotation;
import org.eclipse.etrice.core.common.base.BasePackage;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.core.room.util.StaticResourceHelpers;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.IsAffectedExtension;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class StaticResourceValidator
extends AbstractDeclarativeValidator {
    @Inject
    RoomHelpers roomHelpers;
    @Inject
    StaticResourceHelpers staticResourceHelpers;
    @Inject
    IQualifiedNameProvider nameProvider;
    static final String REGEX_VALID_RESOURCE_NAME = "^[a-zA-Z_]\\w*";

    @Check(value=CheckType.FAST)
    void checkImplicitResourceDeclarations(ActorContainerClass context) {
        HashSet seen = new HashSet();
        this.staticResourceHelpers.getResourcesOfType(context, "implicit").forEach(annotation -> {
            String res = this.roomHelpers.getAttribute((Annotation)annotation, "implicit");
            if (!res.matches(REGEX_VALID_RESOURCE_NAME)) {
                this.error("Implicit resource name contains invalid characters or starts with a digit", (EObject)annotation, (EStructuralFeature)BasePackage.eINSTANCE.getAnnotation_Attributes());
            }
            if (seen.contains(res)) {
                this.warning("Implicit resource \"" + res + "\" is already declared in this actor", (EObject)annotation, (EStructuralFeature)BasePackage.eINSTANCE.getAnnotation_Attributes());
            } else {
                seen.add(res);
            }
        });
    }

    @Check(value=CheckType.FAST)
    void checkUsesResourceReplicatedRefs(ActorContainerClass context) {
        for (ActorContainerRef ref : context.getActorRefs()) {
            ActorContainerClass refType = this.getActorContainerClass(ref.getStructureClass());
            Set<String> resourceNames = this.getAllResourceNames(refType);
            if (resourceNames.isEmpty() || !this.isReplicated(ref)) continue;
            this.error("ActorClass that uses an implicit static resource must have multiplicity of 1", ref, (EStructuralFeature)RoomPackage.eINSTANCE.getActorContainerRef_Name());
        }
    }

    @Check(value=CheckType.NORMAL)
    void checkUsesImplicitResource(LogicalSystem sys) {
        HashMap<QualifiedName, Set> usesResourcesByType = new HashMap<QualifiedName, Set>();
        HashMap<String, ActorRefWalker.ActorRefNode> firstUsedMapping = new HashMap<String, ActorRefWalker.ActorRefNode>();
        for (ActorRefWalker.ActorRefNode node : new ActorRefWalker(sys, this.roomHelpers)) {
            ActorContainerClass refType = this.getActorContainerClass(node.getRef().getStructureClass());
            if (refType == null || node.getRef().eContainer() == null) continue;
            QualifiedName refTypeName = this.nameProvider.getFullyQualifiedName((EObject)refType);
            Set resourceNames = usesResourcesByType.computeIfAbsent(refTypeName, name -> this.getAllResourceNames(refType));
            for (String resourceName : resourceNames) {
                ActorRefWalker.ActorRefNode firstUsedNode = firstUsedMapping.putIfAbsent(resourceName, node);
                if (firstUsedNode == null) continue;
                String msg = this.getMessageAlreadyUsed(resourceName, node, firstUsedNode, sys);
                this.error(msg, sys, (EStructuralFeature)RoomPackage.eINSTANCE.getRoomClass_Name());
            }
        }
    }

    private Set<String> getAllResourceNames(ActorContainerClass context) {
        return this.staticResourceHelpers.getTransitiveResourcesOfType(context, "implicit").map(annotation -> this.roomHelpers.getAttribute((Annotation)annotation, "implicit")).collect(Collectors.toSet());
    }

    private boolean isReplicated(ActorContainerRef ref) {
        return RoomPackage.eINSTANCE.getActorRef().isInstance((Object)ref) && ((ActorRef)ref).getMultiplicity() != 1;
    }

    private String getMessageAlreadyUsed(String resource, ActorRefWalker.ActorRefNode target, ActorRefWalker.ActorRefNode usedByRef, LogicalSystem context) {
        assert (usedByRef.getRef() != null);
        assert (target.getRef() != null);
        String targetType = this.getTypeName(target.getRef().getStructureClass());
        String usedByType = this.getTypeName(usedByRef.getRef().getStructureClass());
        String msg = "Resource \"" + resource + "\" in ref " + target.getPath().toString("/") + ":" + targetType + " is already used by another ref in system " + context.getName() + " (first encountered in " + usedByRef.getPath().toString("/") + ":" + usedByType + ")";
        return msg;
    }

    private String getTypeName(StructureClass sc) {
        if (sc == null) {
            return "(unknown type)";
        }
        RoomModel model = (RoomModel)EcoreUtil2.getContainerOfType((EObject)sc, RoomModel.class);
        String packagePrefix = model != null && !model.eIsProxy() ? String.valueOf(model.getName()) + "." : "(unknown package) ";
        String className = sc.getName() != null ? sc.getName() : "(unknown type)";
        return String.valueOf(packagePrefix) + className;
    }

    private ActorContainerClass getActorContainerClass(EObject object) {
        if (RoomPackage.eINSTANCE.getActorContainerClass().isInstance((Object)object)) {
            return (ActorContainerClass)object;
        }
        return null;
    }

    public void register(EValidatorRegistrar registrar) {
    }

    public static class ActorRefWalker
    implements Iterable<ActorRefNode> {
        private StructureClass root;
        private RoomHelpers roomHelpers;

        public ActorRefWalker(StructureClass root, RoomHelpers roomHelpers) {
            this.root = root;
            this.roomHelpers = roomHelpers;
        }

        @Override
        public Iterator<ActorRefNode> iterator() {
            return new ActorRefWalkerIterator(this.root, this.roomHelpers);
        }

        public static class ActorRefNode {
            private final QualifiedName path;
            private final ActorContainerRef ref;

            public ActorRefNode(QualifiedName path, ActorContainerRef ref) {
                this.path = path;
                this.ref = ref;
            }

            public QualifiedName getPath() {
                return this.path;
            }

            public ActorContainerRef getRef() {
                return this.ref;
            }
        }

        public static class ActorRefWalkerIterator
        implements Iterator<ActorRefNode> {
            public static final int MAX_DEPTH = 1000;
            RoomHelpers roomHelpers;
            Deque<ActorRefNode> stack = new LinkedList<ActorRefNode>();
            Deque<StructureClass> containment = new LinkedList<StructureClass>();

            public ActorRefWalkerIterator(StructureClass root, RoomHelpers roomHelpers) {
                this.roomHelpers = roomHelpers;
                for (ActorContainerRef ref : roomHelpers.getAllActorContainerRefs(root)) {
                    if (!this.isRefValid(ref)) continue;
                    this.stack.push(new ActorRefNode(QualifiedName.create((String)ref.getName()), ref));
                }
            }

            @Override
            public boolean hasNext() {
                return !this.stack.isEmpty();
            }

            @Override
            public ActorRefNode next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ActorRefNode node = this.stack.pop();
                StructureClass nodeClass = node.getRef().getStructureClass();
                while (this.containment.size() > node.getPath().getSegmentCount() - 1) {
                    this.containment.pop();
                }
                this.containment.push(nodeClass);
                if (this.containment.size() > 1000) {
                    throw new RuntimeException("Actor instance traversal exceeds maximum depth of 1000");
                }
                for (ActorContainerRef subRef : this.roomHelpers.getAllActorContainerRefs(nodeClass)) {
                    if (!this.isRefValid(subRef) || this.containment.contains(subRef.getStructureClass())) continue;
                    this.stack.push(new ActorRefNode(node.getPath().append(subRef.getName()), subRef));
                }
                return node;
            }

            private boolean isRefValid(ActorContainerRef ref) {
                return ref != null && !ref.eIsProxy() && ref.getName() != null && ref.getStructureClass() != null && !ref.getStructureClass().eIsProxy();
            }
        }
    }

    public static class StaticResourceValidatorIsAffected
    implements IsAffectedExtension {
        @Inject
        StaticResourceHelpers staticResourceHelper;

        public boolean isAffected(Collection<IResourceDescription.Delta> deltas, IResourceDescription candidate, IResourceDescriptions context) {
            if (!candidate.getExportedObjectsByType(RoomPackage.eINSTANCE.getLogicalSystem()).iterator().hasNext()) {
                return false;
            }
            for (IResourceDescription.Delta d : deltas) {
                if (!d.haveEObjectDescriptionsChanged()) continue;
                List<IEObjectDescription> newContainerClasses = d.getNew() == null ? Collections.emptyList() : d.getNew().getExportedObjectsByType(RoomPackage.eINSTANCE.getActorContainerClass());
                List<IEObjectDescription> oldContainerClasses = d.getOld() == null ? Collections.emptyList() : d.getOld().getExportedObjectsByType(RoomPackage.eINSTANCE.getActorContainerClass());
                Set<IEObjectDescription> newNames = this.getMatchingDescriptions(newContainerClasses, this.staticResourceHelper::hasUsesResourceAnnotation);
                Set<IEObjectDescription> oldNames = this.getMatchingDescriptions(oldContainerClasses, this.staticResourceHelper::hasUsesResourceAnnotation);
                if (oldNames.size() <= 0 && newNames.size() <= 0) continue;
                return true;
            }
            return false;
        }

        private Set<IEObjectDescription> getMatchingDescriptions(Iterable<IEObjectDescription> descriptions, Function<IEObjectDescription, Boolean> predicate) {
            HashSet<IEObjectDescription> result = new HashSet<IEObjectDescription>();
            for (IEObjectDescription d : descriptions) {
                if (!predicate.apply(d).booleanValue()) continue;
                result.add(d);
            }
            return result;
        }
    }
}

