/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.room.util;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.common.validation.ValidationHelpers;
import org.eclipse.etrice.core.fsm.fSM.FSMPackage;
import org.eclipse.etrice.core.fsm.util.FSMNewNamingUtil;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;

public class RoomNewNamingUtil
extends FSMNewNamingUtil {
    @Inject
    protected IQualifiedNameProvider fqnProvider;

    public String getUniqueName(String prefix, StructureClass sc) {
        Set<String> names = this.getAllNamesFromCompleteHierarchy(sc);
        int i = 0;
        while (i < 1000) {
            String name = String.valueOf(prefix) + i;
            if (!names.contains(name)) {
                return name;
            }
            ++i;
        }
        return "not_unique";
    }

    private Set<String> getAllNamesFromCompleteHierarchy(StructureClass sc) {
        HashSet visitedClass = Sets.newHashSet((Object[])new StructureClass[]{sc});
        HashSet leafClass = Sets.newHashSet((Object[])new StructureClass[]{sc});
        LinkedList stack = Lists.newLinkedList();
        stack.push(sc);
        while (!stack.isEmpty()) {
            StructureClass baseClass = (StructureClass)stack.pop();
            Collection usages = EcoreUtil.UsageCrossReferencer.find((EObject)baseClass, (ResourceSet)sc.eResource().getResourceSet());
            for (EStructuralFeature.Setting setting : usages) {
                StructureClass derivedClass = null;
                if (setting.getEStructuralFeature() == FSMPackage.Literals.MODEL_COMPONENT__BASE && setting.getEObject() instanceof StructureClass) {
                    derivedClass = (StructureClass)setting.getEObject();
                }
                if (derivedClass == null || !visitedClass.add(derivedClass)) continue;
                stack.push(derivedClass);
                leafClass.add(derivedClass);
                leafClass.remove(baseClass);
            }
        }
        final HashSet allNames = Sets.newHashSet();
        for (StructureClass toVisit : leafClass) {
            ValidationHelpers.saveRecursiveVisitor((EObject)toVisit, (Function)new Function<StructureClass, StructureClass>(){

                public StructureClass apply(StructureClass input) {
                    for (EObject containee : input.eContents()) {
                        String name;
                        QualifiedName qualifiedName = (QualifiedName)RoomNewNamingUtil.this.fqnProvider.apply((Object)containee);
                        String string = name = qualifiedName != null ? qualifiedName.getLastSegment() : null;
                        if (name == null) continue;
                        allNames.add(name);
                    }
                    return input instanceof ActorClass ? ((ActorClass)input).getActorBase() : null;
                }
            });
        }
        return allNames;
    }
}

