/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.fsm.generic;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.ComponentCommunicationType;
import org.eclipse.etrice.core.fsm.fSM.GuardedTransition;
import org.eclipse.etrice.core.fsm.fSM.InitialTransition;
import org.eclipse.etrice.core.fsm.fSM.MessageFromIf;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraphNode;
import org.eclipse.etrice.core.fsm.fSM.Transition;
import org.eclipse.etrice.core.fsm.fSM.TransitionPoint;
import org.eclipse.etrice.core.fsm.naming.FSMNameProvider;
import org.eclipse.etrice.core.fsm.util.FSMHelpers;
import org.eclipse.etrice.core.genmodel.fsm.FsmGenExtensions;
import org.eclipse.etrice.core.genmodel.fsm.TriggerExtensions;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.CommonTrigger;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Graph;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphContainer;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Link;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Node;
import org.eclipse.etrice.generator.fsm.base.CodegenHelpers;
import org.eclipse.etrice.generator.fsm.generic.FSMExtensions;
import org.eclipse.etrice.generator.fsm.generic.IDetailCodeTranslator;
import org.eclipse.etrice.generator.fsm.generic.IIfItemIdGenerator;
import org.eclipse.etrice.generator.fsm.generic.ILanguageExtensionBase;
import org.eclipse.etrice.generator.fsm.generic.IMessageIdGenerator;
import org.eclipse.etrice.generator.fsm.generic.TransitionChainGenerator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public abstract class AbstractStateMachineGenerator {
    protected static final int NUM_PREDEF_STATE_CONSTANTS = 2;
    @Inject
    @Extension
    public FSMHelpers _fSMHelpers;
    @Inject
    @Extension
    public CodegenHelpers _codegenHelpers;
    @Inject
    @Extension
    public FSMExtensions _fSMExtensions;
    @Inject
    public ILanguageExtensionBase langExt;
    @Inject
    public IMessageIdGenerator msgIdGen;
    @Inject
    public IIfItemIdGenerator itemIdGen;
    @Inject
    public TransitionChainGenerator transitionChainGenerator;
    @Inject
    public IDetailCodeTranslator translator;
    @Inject
    public FSMNameProvider fsmNameProvider;

    public String genTriggerConstants(GraphContainer gc) {
        return this.genTriggerConstants(gc, this.langExt.usesInheritance());
    }

    public String genTriggerConstants(GraphContainer gc, boolean omitBase) {
        List list = null;
        list = omitBase ? this._fSMHelpers.getOwnMessagesFromInterfaces(gc.getComponent()) : this._fSMHelpers.getAllMessagesFromInterfaces(gc.getComponent());
        List triggers = list;
        ArrayList list2 = CollectionLiterals.newArrayList();
        list2.add(Tuples.pair((Object)"POLLING", (Object)"0"));
        for (MessageFromIf mif : triggers) {
            boolean bl = mif.getFrom().isEventDriven();
            if (!bl) continue;
            String string = this.getTriggerCodeName(mif);
            String string2 = this.itemIdGen.getIfItemId(mif.getFrom());
            String string3 = String.valueOf(string2) + " + EVT_SHIFT*";
            String string4 = this.msgIdGen.getMessageID(mif);
            String string5 = String.valueOf(string3) + string4;
            list2.add(Tuples.pair((Object)string, (Object)string5));
        }
        return this.langExt.genEnumeration("triggers", list2);
    }

    public String getTriggerCodeName(MessageFromIf mif) {
        String string = mif.getFrom().getName();
        String string2 = "TRIG_" + string;
        String string3 = String.valueOf(string2) + "__";
        String string4 = this.fsmNameProvider.getMessageName(mif.getMessage());
        return String.valueOf(string3) + string4;
    }

    public String genStateIdConstants(GraphContainer gc) {
        return this.genStateIdConstants(gc, this.langExt.usesInheritance());
    }

    public String genStateIdConstants(GraphContainer gc, boolean omitBase) {
        Object object;
        List allStateNodes = IteratorExtensions.toList((Iterator)FsmGenExtensions.getAllStateNodes((Graph)gc.getGraph()));
        int n = 0;
        if (omitBase) {
            Functions.Function1<Node, Boolean> function1 = new Functions.Function1<Node, Boolean>(){

                public Boolean apply(Node it) {
                    return it.isInherited();
                }
            };
            n = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)allStateNodes, (Functions.Function1)function1));
        } else {
            n = 0;
        }
        int offset = 2 + n;
        Iterable iterable = null;
        if (omitBase) {
            object = new Functions.Function1<Node, Boolean>(){

                public Boolean apply(Node it) {
                    boolean bl = it.isInherited();
                    return !bl;
                }
            };
            iterable = IterableExtensions.filter((Iterable)allStateNodes, (Functions.Function1)object);
        } else {
            iterable = allStateNodes;
        }
        object = new Functions.Function1<Node, StateGraphNode>(){

            public StateGraphNode apply(Node it) {
                return it.getStateGraphNode();
            }
        };
        final Set consideredStates = IterableExtensions.toSet((Iterable)Iterables.filter((Iterable)IterableExtensions.map((Iterable)iterable, (Functions.Function1)object), State.class));
        Functions.Function1<State, Boolean> function1 = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                return consideredStates.contains(it);
            }
        };
        Iterable generatedStates = IterableExtensions.filter((Iterable)gc.getOrderedStates(), (Functions.Function1)function1);
        ArrayList list = CollectionLiterals.newArrayList();
        if (!omitBase) {
            list.add(Tuples.pair((Object)"NO_STATE", (Object)"0"));
            list.add(Tuples.pair((Object)"STATE_TOP", (Object)"1"));
        }
        for (State state : generatedStates) {
            list.add(Tuples.pair((Object)this._codegenHelpers.getGenStateId(state), (Object)Integer.valueOf(offset).toString()));
            ++offset;
        }
        list.add(Tuples.pair((Object)"STATE_MAX", (Object)Integer.valueOf(offset).toString()));
        return this.langExt.genEnumeration("state_ids", list);
    }

    public String genTransitionChainConstants(GraphContainer gc) {
        return this.genTransitionChainConstants(gc, false);
    }

    public String genTransitionChainConstants(GraphContainer gc, boolean omitBase) {
        Object object;
        Iterator iterator = null;
        if (omitBase) {
            object = new Functions.Function1<Link, Boolean>(){

                public Boolean apply(Link it) {
                    boolean bl = it.isInherited();
                    return !bl;
                }
            };
            iterator = IteratorExtensions.filter((Iterator)FsmGenExtensions.getAllLinks((Graph)gc.getGraph()), (Functions.Function1)object);
        } else {
            iterator = FsmGenExtensions.getAllLinks((Graph)gc.getGraph());
        }
        object = new Functions.Function1<Link, Transition>(){

            public Transition apply(Link it) {
                return it.getTransition();
            }
        };
        Functions.Function1<Transition, Boolean> function1 = new Functions.Function1<Transition, Boolean>(){

            public Boolean apply(Transition it) {
                return FsmGenExtensions.isChainHead((Transition)it);
            }
        };
        List chains = IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)IteratorExtensions.filter((Iterator)IteratorExtensions.map((Iterator)iterator, (Functions.Function1)object), (Functions.Function1)function1), Transition.class));
        int n = 0;
        if (omitBase) {
            Functions.Function1<Link, Boolean> function12 = new Functions.Function1<Link, Boolean>(){

                public Boolean apply(Link it) {
                    return it.isInherited();
                }
            };
            n = IteratorExtensions.size((Iterator)IteratorExtensions.filter((Iterator)FsmGenExtensions.getAllLinks((Graph)gc.getGraph()), (Functions.Function1)function12));
        } else {
            n = 0;
        }
        int offset = n;
        ArrayList list = CollectionLiterals.newArrayList();
        for (Transition chain : chains) {
            list.add(Tuples.pair((Object)this._codegenHelpers.getGenChainId(chain), (Object)Integer.valueOf(++offset).toString()));
        }
        return this.langExt.genEnumeration("ChainIDs", list);
    }

    public String genEntryAndExitCodes(GraphContainer gc, boolean generateImplementation) {
        return this.genEntryAndExitCodes(gc, generateImplementation, this.langExt.usesInheritance());
    }

    public String genEntryAndExitCodes(GraphContainer gc, boolean generateImplementation, final boolean omitBase) {
        String string = null;
        Functions.Function1<Node, Boolean> function1 = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                return !omitBase || !it.isInherited();
            }
        };
        List states = IteratorExtensions.toList((Iterator)IteratorExtensions.filter((Iterator)FsmGenExtensions.getAllStateNodes((Graph)gc.getGraph()), (Functions.Function1)function1));
        StringConcatenation stringConcatenation = new StringConcatenation();
        for (Node state : states) {
            String string2 = this.genActionCodeMethods(gc, state, generateImplementation);
            stringConcatenation.append(string2);
            stringConcatenation.newLineIfNotEmpty();
        }
        string = stringConcatenation.toString();
        return string;
    }

    public String genActionCodes(GraphContainer gc, boolean generateImplementation) {
        return this.genActionCodes(gc, generateImplementation, this.langExt.usesInheritance());
    }

    public String genActionCodes(GraphContainer gc, boolean generateImplementation, final boolean omitBase) {
        String string = null;
        Functions.Function1<Link, Boolean> function1 = new Functions.Function1<Link, Boolean>(){

            public Boolean apply(Link it) {
                return !omitBase || !it.isInherited();
            }
        };
        List transitions = IteratorExtensions.toList((Iterator)IteratorExtensions.filter((Iterator)FsmGenExtensions.getAllLinks((Graph)gc.getGraph()), (Functions.Function1)function1));
        StringConcatenation stringConcatenation = new StringConcatenation();
        for (Link tr : transitions) {
            String string2 = this.genActionCodeMethod(gc, tr, generateImplementation);
            stringConcatenation.append(string2);
            stringConcatenation.newLineIfNotEmpty();
        }
        string = stringConcatenation.toString();
        return string;
    }

    public String genStateSwitchMethods(GraphContainer gc, boolean generateImplementation) {
        CharSequence charSequence;
        String string;
        Object object;
        String string2;
        String string3;
        Object object2;
        String string4;
        String string5;
        String string6 = null;
        ModelComponent mc = gc.getComponent();
        ComponentCommunicationType componentCommunicationType = mc.getCommType();
        boolean async = Objects.equal((Object)componentCommunicationType, (Object)ComponentCommunicationType.ASYNCHRONOUS);
        ComponentCommunicationType componentCommunicationType2 = mc.getCommType();
        boolean eventDriven = Objects.equal((Object)componentCommunicationType2, (Object)ComponentCommunicationType.EVENT_DRIVEN);
        String string7 = this.interfaceItemType();
        String string8 = this.langExt.pointerLiteral();
        String ifItemPtr = String.valueOf(string7) + string8;
        boolean handleEvents = async || eventDriven;
        String string9 = null;
        boolean bl = this.langExt.usesInheritance();
        if (bl) {
            String string10 = this.getClassName(mc);
            String string11 = this.langExt.scopeSeparator();
            string9 = String.valueOf(string10) + string11;
        } else {
            string9 = "";
        }
        String chainIDScope = string9;
        String opScope = this.langExt.operationScope(this.getClassName(mc), !generateImplementation);
        String string12 = null;
        boolean bl2 = this.langExt.usesInheritance();
        string12 = bl2 ? opScope : "";
        String opScopePriv = string12;
        String string13 = null;
        boolean bl3 = this.langExt.usesInheritance();
        string13 = bl3 ? this.langExt.accessLevelPublic() : this.langExt.accessLevelPrivate();
        String publicIf = string13;
        String privAccess = this.langExt.accessLevelPrivate();
        String selfPtr = this.langExt.selfPointer(this.getClassName(mc), true);
        String selfOnly = this.langExt.selfPointer(this.getClassName(mc), false);
        String string14 = null;
        boolean bl4 = this.langExt.usesInheritance();
        if (bl4) {
            String string15 = null;
            boolean bl5 = this.langExt.usesPointers();
            string15 = bl5 ? "->getLocalId()" : ".getLocalId()";
            string14 = string15;
        } else {
            string14 = "->localId";
        }
        String getLocalId = string14;
        String string16 = null;
        boolean bl6 = this.langExt.usesPointers();
        string16 = bl6 ? "const " + ifItemPtr : ifItemPtr;
        String constIfItemPtr = string16;
        boolean usesHdlr = this.usesHandlerTrPoints(gc);
        Functions.Function1<Node, String> function1 = new Functions.Function1<Node, String>(){

            public String apply(Node it) {
                StateGraphNode stateGraphNode = it.getStateGraphNode();
                return AbstractStateMachineGenerator.this._codegenHelpers.getGenStateId((State)stateGraphNode);
            }
        };
        List nodes = IterableExtensions.sortBy((Iterable)IteratorExtensions.toList((Iterator)FsmGenExtensions.getAllStateNodes((Graph)gc.getGraph())), (Functions.Function1)function1);
        final HashMap state2node = CollectionLiterals.newHashMap();
        Consumer<Node> consumer = new Consumer<Node>(){

            @Override
            public void accept(Node it) {
                StateGraphNode stateGraphNode = it.getStateGraphNode();
                state2node.put((State)stateGraphNode, it);
            }
        };
        nodes.forEach(consumer);
        Functions.Function1<Node, StateGraphNode> function12 = new Functions.Function1<Node, StateGraphNode>(){

            public StateGraphNode apply(Node it) {
                return it.getStateGraphNode();
            }
        };
        List states = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)ListExtensions.map((List)nodes, (Functions.Function1)function12), State.class));
        Functions.Function1<State, Boolean> function13 = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                return AbstractStateMachineGenerator.this._fSMHelpers.isLeaf(it);
            }
        };
        boolean hasLeafStates = IterableExtensions.exists((Iterable)states, (Functions.Function1)function13);
        Functions.Function1<Link, Boolean> function14 = new Functions.Function1<Link, Boolean>(){

            public Boolean apply(Link it) {
                return FsmGenExtensions.isChainHead((Link)it);
            }
        };
        Functions.Function1<Link, String> function15 = new Functions.Function1<Link, String>(){

            public String apply(Link it) {
                return AbstractStateMachineGenerator.this._codegenHelpers.getGenChainId(it.getTransition());
            }
        };
        List transitionChains = IterableExtensions.sortBy((Iterable)IteratorExtensions.toList((Iterator)IteratorExtensions.filter((Iterator)FsmGenExtensions.getAllLinks((Graph)gc.getGraph()), (Functions.Function1)function14)), (Functions.Function1)function15);
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("/**");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* calls exit codes while exiting from the current state to one of its");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* parent states while remembering the history");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* @param current__et - the current state");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* @param to - the final parent state");
        stringConcatenation.newLine();
        if (usesHdlr) {
            stringConcatenation.append("* @param handler__et - entry and exit codes are called only if not handler (for handler TransitionPoints)");
            stringConcatenation.newLine();
        }
        stringConcatenation.append(" ");
        stringConcatenation.append("*/");
        stringConcatenation.newLine();
        if (generateImplementation) {
            stringConcatenation.append(privAccess);
            stringConcatenation.append("void ");
            stringConcatenation.append(opScopePriv);
            stringConcatenation.append("exitTo(");
            stringConcatenation.append(selfPtr);
            string5 = this.stateType();
            stringConcatenation.append(string5);
            stringConcatenation.append(" current__et, ");
            string4 = this.stateType();
            stringConcatenation.append(string4);
            stringConcatenation.append(" to");
            if (usesHdlr) {
                stringConcatenation.append(", ");
                object2 = this.boolType();
                stringConcatenation.append((String)object2);
                stringConcatenation.append(" handler__et");
            }
            stringConcatenation.append(") {");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("\t");
            stringConcatenation.append("while (current__et!=to) {");
            stringConcatenation.newLine();
            stringConcatenation.append("\t\t");
            stringConcatenation.append("switch (current__et) {");
            stringConcatenation.newLine();
            for (State state : states) {
                stringConcatenation.append("\t\t\t");
                stringConcatenation.append("case ");
                string3 = this._codegenHelpers.getGenStateId(state);
                stringConcatenation.append(string3, "\t\t\t");
                stringConcatenation.append(":");
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("\t\t\t");
                stringConcatenation.append("\t");
                boolean bl7 = this._fSMHelpers.hasExitCode(state, true);
                if (bl7) {
                    if (usesHdlr) {
                        stringConcatenation.append("if (!handler__et) ");
                    }
                    string2 = this._codegenHelpers.getExitCodeOperationName(state);
                    stringConcatenation.append(string2, "\t\t\t\t");
                    stringConcatenation.append("(");
                    object = this.langExt.selfPointer(false);
                    stringConcatenation.append((String)object, "\t\t\t\t");
                    stringConcatenation.append(");");
                }
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("\t\t\t");
                stringConcatenation.append("\t");
                string = this.setHistory(this._codegenHelpers.getParentStateId(state), this._codegenHelpers.getGenStateId(state));
                stringConcatenation.append(string, "\t\t\t\t");
                stringConcatenation.append(";");
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("\t\t\t");
                stringConcatenation.append("\t");
                stringConcatenation.append("current__et = ");
                string2 = this._codegenHelpers.getParentStateId(state);
                stringConcatenation.append(string2, "\t\t\t\t");
                stringConcatenation.append(";");
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("\t\t\t");
                stringConcatenation.append("\t");
                stringConcatenation.append("break;");
                stringConcatenation.newLine();
            }
            stringConcatenation.append("\t\t\t");
            stringConcatenation.append("default:");
            stringConcatenation.newLine();
            stringConcatenation.append("\t\t\t\t");
            stringConcatenation.append("/* should not occur */");
            stringConcatenation.newLine();
            stringConcatenation.append("\t\t\t\t");
            stringConcatenation.append("break;");
            stringConcatenation.newLine();
            stringConcatenation.append("\t\t");
            stringConcatenation.append("}");
            stringConcatenation.newLine();
            stringConcatenation.append("\t");
            stringConcatenation.append("}");
            stringConcatenation.newLine();
            stringConcatenation.append("}");
            stringConcatenation.newLine();
        } else {
            stringConcatenation.append("void exitTo(");
            stringConcatenation.append(selfPtr);
            string5 = this.stateType();
            stringConcatenation.append(string5);
            stringConcatenation.append(" current__et, ");
            string4 = this.stateType();
            stringConcatenation.append(string4);
            stringConcatenation.append(" to");
            if (usesHdlr) {
                stringConcatenation.append(", ");
                object2 = this.boolType();
                stringConcatenation.append((String)object2);
                stringConcatenation.append(" handler__et");
            }
            stringConcatenation.append(");");
            stringConcatenation.newLineIfNotEmpty();
        }
        stringConcatenation.newLine();
        stringConcatenation.append("/**");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* calls action, entry and exit codes along a transition chain. The generic data are cast to typed data");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* matching the trigger of this chain. The ID of the final state is returned");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* @param chain__et - the chain ID");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* @param generic_data__et - the generic data pointer");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* @return the +/- ID of the final state either with a positive sign, that indicates to execute the state's entry code, or a negative sign vice versa");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("*/");
        stringConcatenation.newLine();
        if (generateImplementation) {
            stringConcatenation.append(privAccess);
            string5 = this.stateType();
            stringConcatenation.append(string5);
            stringConcatenation.append(" ");
            stringConcatenation.append(opScopePriv);
            stringConcatenation.append("executeTransitionChain(");
            stringConcatenation.append(selfPtr);
            stringConcatenation.append("int chain__et");
            if (handleEvents) {
                stringConcatenation.append(", ");
                stringConcatenation.append(constIfItemPtr);
                stringConcatenation.append(" ifitem, ");
                string4 = this.langExt.voidPointer();
                stringConcatenation.append(string4);
                stringConcatenation.append(" generic_data__et");
            }
            stringConcatenation.append(") {");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("\t");
            stringConcatenation.append("switch (chain__et) {");
            stringConcatenation.newLine();
            for (Link tc : transitionChains) {
                stringConcatenation.append("\t\t");
                stringConcatenation.append("case ");
                stringConcatenation.append(chainIDScope, "\t\t");
                String string17 = this._codegenHelpers.getGenChainId(tc.getTransition());
                stringConcatenation.append(string17, "\t\t");
                stringConcatenation.append(":");
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("\t\t");
                stringConcatenation.append("{");
                stringConcatenation.newLine();
                stringConcatenation.append("\t\t");
                stringConcatenation.append("\t");
                string3 = this.transitionChainGenerator.generateExecuteChain(gc, tc);
                stringConcatenation.append(string3, "\t\t\t");
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("\t\t");
                stringConcatenation.append("}");
                stringConcatenation.newLine();
            }
            stringConcatenation.append("\t\t\t");
            stringConcatenation.append("default:");
            stringConcatenation.newLine();
            stringConcatenation.append("\t\t\t\t");
            stringConcatenation.append("/* should not occur */");
            stringConcatenation.newLine();
            stringConcatenation.append("\t\t\t\t");
            stringConcatenation.append("break;");
            stringConcatenation.newLine();
            stringConcatenation.append("\t");
            stringConcatenation.append("}");
            stringConcatenation.newLine();
            stringConcatenation.append("\t");
            stringConcatenation.append("return NO_STATE;");
            stringConcatenation.newLine();
            stringConcatenation.append("}");
            stringConcatenation.newLine();
        } else {
            string5 = this.stateType();
            stringConcatenation.append(string5);
            stringConcatenation.append(" executeTransitionChain(");
            stringConcatenation.append(selfPtr);
            stringConcatenation.append("int chain__et");
            if (handleEvents) {
                stringConcatenation.append(", ");
                stringConcatenation.append(constIfItemPtr);
                stringConcatenation.append(" ifitem, ");
                string4 = this.langExt.voidPointer();
                stringConcatenation.append(string4);
                stringConcatenation.append(" generic_data__et");
            }
            stringConcatenation.append(");");
            stringConcatenation.newLineIfNotEmpty();
        }
        stringConcatenation.newLine();
        stringConcatenation.append("/**");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* calls entry codes while entering a state's history. The ID of the final leaf state is returned");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* @param state__et - the state which is entered");
        stringConcatenation.newLine();
        if (usesHdlr) {
            stringConcatenation.append("* @param handler__et - entry code is executed if not handler");
            stringConcatenation.newLine();
        }
        stringConcatenation.append(" ");
        stringConcatenation.append("* @return - the ID of the final leaf state");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("*/");
        stringConcatenation.newLine();
        if (generateImplementation) {
            stringConcatenation.append(privAccess);
            string5 = this.stateType();
            stringConcatenation.append(string5);
            stringConcatenation.append(" ");
            stringConcatenation.append(opScopePriv);
            stringConcatenation.append("enterHistory(");
            stringConcatenation.append(selfPtr);
            string4 = this.stateType();
            stringConcatenation.append(string4);
            stringConcatenation.append(" state__et");
            if (usesHdlr) {
                stringConcatenation.append(", ");
                object2 = this.boolType();
                stringConcatenation.append((String)object2);
                stringConcatenation.append(" handler__et");
            }
            stringConcatenation.append(") {");
            stringConcatenation.newLineIfNotEmpty();
            if (hasLeafStates) {
                boolean bl8;
                stringConcatenation.append("\t");
                object2 = new Functions.Function1<State, Boolean>(){

                    public Boolean apply(State s) {
                        return AbstractStateMachineGenerator.this._fSMHelpers.hasEntryCode(s, true);
                    }
                };
                boolean bl9 = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)states, (Functions.Function1)object2));
                boolean needsSkipVar = !bl9;
                stringConcatenation.newLineIfNotEmpty();
                if (needsSkipVar) {
                    stringConcatenation.append("\t");
                    string = this.boolType();
                    stringConcatenation.append(string, "\t");
                    stringConcatenation.append(" skip_entry__et = ");
                    string2 = this.langExt.booleanConstant(false);
                    stringConcatenation.append(string2, "\t");
                    stringConcatenation.append(";");
                    stringConcatenation.newLineIfNotEmpty();
                }
                stringConcatenation.append("\t");
                stringConcatenation.append("if (state__et >= STATE_MAX) {");
                stringConcatenation.newLine();
                stringConcatenation.append("\t");
                stringConcatenation.append("\t");
                stringConcatenation.append("state__et = ");
                boolean bl10 = this.langExt.usesInheritance();
                boolean bl11 = bl8 = !bl10;
                if (bl8) {
                    stringConcatenation.append("(");
                    object = this.stateType();
                    stringConcatenation.append((String)object, "\t\t");
                    stringConcatenation.append(")");
                }
                stringConcatenation.append(" (state__et - STATE_MAX);");
                stringConcatenation.newLineIfNotEmpty();
                if (needsSkipVar) {
                    stringConcatenation.append("\t");
                    stringConcatenation.append("\t");
                    stringConcatenation.append("skip_entry__et = ");
                    String string18 = this.langExt.booleanConstant(true);
                    stringConcatenation.append(string18, "\t\t");
                    stringConcatenation.append(";");
                    stringConcatenation.newLineIfNotEmpty();
                }
                stringConcatenation.append("\t");
                stringConcatenation.append("}");
                stringConcatenation.newLine();
                stringConcatenation.append("\t");
                stringConcatenation.append("while (");
                string = this.langExt.booleanConstant(true);
                stringConcatenation.append(string, "\t");
                stringConcatenation.append(") {");
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("\t");
                stringConcatenation.append("\t");
                stringConcatenation.append("switch (state__et) {");
                stringConcatenation.newLine();
                for (State state_1 : states) {
                    String string19;
                    String string20;
                    stringConcatenation.append("\t");
                    stringConcatenation.append("\t\t");
                    stringConcatenation.append("case ");
                    charSequence = this._codegenHelpers.getGenStateId(state_1);
                    stringConcatenation.append(charSequence, "\t\t\t");
                    stringConcatenation.append(":");
                    stringConcatenation.newLineIfNotEmpty();
                    stringConcatenation.append("\t");
                    stringConcatenation.append("\t\t");
                    stringConcatenation.append("\t");
                    boolean bl12 = this._fSMHelpers.hasEntryCode(state_1, true);
                    if (bl12) {
                        stringConcatenation.append("if (!(skip_entry__et");
                        if (usesHdlr) {
                            stringConcatenation.append(" || handler__et");
                        }
                        stringConcatenation.append(")) ");
                        string20 = this._codegenHelpers.getEntryCodeOperationName(state_1);
                        stringConcatenation.append(string20, "\t\t\t\t");
                        stringConcatenation.append("(");
                        string19 = this.langExt.selfPointer(false);
                        stringConcatenation.append(string19, "\t\t\t\t");
                        stringConcatenation.append(");");
                    }
                    stringConcatenation.newLineIfNotEmpty();
                    bl12 = this._fSMHelpers.isLeaf(state_1);
                    if (bl12) {
                        stringConcatenation.append("\t");
                        stringConcatenation.append("\t\t");
                        stringConcatenation.append("\t");
                        stringConcatenation.append("/* in leaf state: return state id */");
                        stringConcatenation.newLine();
                        stringConcatenation.append("\t");
                        stringConcatenation.append("\t\t");
                        stringConcatenation.append("\t");
                        stringConcatenation.append("return ");
                        string20 = this._codegenHelpers.getGenStateId(state_1);
                        stringConcatenation.append(string20, "\t\t\t\t");
                        stringConcatenation.append(";");
                        stringConcatenation.newLineIfNotEmpty();
                        continue;
                    }
                    stringConcatenation.append("\t");
                    stringConcatenation.append("\t\t");
                    stringConcatenation.append("\t");
                    stringConcatenation.append("/* state has a sub graph */");
                    stringConcatenation.newLine();
                    stringConcatenation.append("\t");
                    stringConcatenation.append("\t\t");
                    stringConcatenation.append("\t");
                    InitialTransition sub_initt = FsmGenExtensions.getInitialTransition((Graph)((Node)state2node.get(state_1)).getSubgraph());
                    stringConcatenation.newLineIfNotEmpty();
                    if (sub_initt != null) {
                        String string21;
                        stringConcatenation.append("\t");
                        stringConcatenation.append("\t\t");
                        stringConcatenation.append("\t");
                        stringConcatenation.append("/* with init transition */");
                        stringConcatenation.newLine();
                        stringConcatenation.append("\t");
                        stringConcatenation.append("\t\t");
                        stringConcatenation.append("\t");
                        stringConcatenation.append("if (");
                        string19 = this.getHistory(this._codegenHelpers.getGenStateId(state_1));
                        stringConcatenation.append(string19, "\t\t\t\t");
                        stringConcatenation.append("==NO_STATE) {");
                        stringConcatenation.newLineIfNotEmpty();
                        stringConcatenation.append("\t");
                        stringConcatenation.append("\t\t");
                        stringConcatenation.append("\t");
                        stringConcatenation.append("\t");
                        stringConcatenation.append("state__et = executeTransitionChain(");
                        String string22 = this.langExt.selfPointer(true);
                        stringConcatenation.append(string22, "\t\t\t\t\t");
                        stringConcatenation.append(chainIDScope, "\t\t\t\t\t");
                        String string23 = this._codegenHelpers.getGenChainId((Transition)sub_initt);
                        stringConcatenation.append(string23, "\t\t\t\t\t");
                        if (handleEvents) {
                            stringConcatenation.append(", ");
                            string21 = this.langExt.nullPointer();
                            stringConcatenation.append(string21, "\t\t\t\t\t");
                            stringConcatenation.append(", ");
                            String string24 = this.langExt.nullPointer();
                            stringConcatenation.append(string24, "\t\t\t\t\t");
                        }
                        stringConcatenation.append(");");
                        stringConcatenation.newLineIfNotEmpty();
                        stringConcatenation.append("\t");
                        stringConcatenation.append("\t\t");
                        stringConcatenation.append("\t");
                        stringConcatenation.append("}");
                        stringConcatenation.newLine();
                        stringConcatenation.append("\t");
                        stringConcatenation.append("\t\t");
                        stringConcatenation.append("\t");
                        stringConcatenation.append("else {");
                        stringConcatenation.newLine();
                        stringConcatenation.append("\t");
                        stringConcatenation.append("\t\t");
                        stringConcatenation.append("\t");
                        stringConcatenation.append("\t");
                        stringConcatenation.append("state__et = ");
                        string21 = this.getHistory(this._codegenHelpers.getGenStateId(state_1));
                        stringConcatenation.append(string21, "\t\t\t\t\t");
                        stringConcatenation.append(";");
                        stringConcatenation.newLineIfNotEmpty();
                        stringConcatenation.append("\t");
                        stringConcatenation.append("\t\t");
                        stringConcatenation.append("\t");
                        stringConcatenation.append("}");
                        stringConcatenation.newLine();
                    } else {
                        stringConcatenation.append("\t");
                        stringConcatenation.append("\t\t");
                        stringConcatenation.append("\t");
                        stringConcatenation.append("/* without init transition */");
                        stringConcatenation.newLine();
                        stringConcatenation.append("\t");
                        stringConcatenation.append("\t\t");
                        stringConcatenation.append("\t");
                        stringConcatenation.append("state__et = ");
                        string19 = this.getHistory(this._codegenHelpers.getGenStateId(state_1));
                        stringConcatenation.append(string19, "\t\t\t\t");
                        stringConcatenation.append(";");
                        stringConcatenation.newLineIfNotEmpty();
                    }
                    stringConcatenation.append("\t");
                    stringConcatenation.append("\t\t");
                    stringConcatenation.append("\t");
                    stringConcatenation.append("break;");
                    stringConcatenation.newLine();
                }
                stringConcatenation.append("\t");
                stringConcatenation.append("\t\t");
                stringConcatenation.append("case STATE_TOP:");
                stringConcatenation.newLine();
                stringConcatenation.append("\t");
                stringConcatenation.append("\t\t\t");
                stringConcatenation.append("state__et = ");
                string2 = this.getHistory("STATE_TOP");
                stringConcatenation.append(string2, "\t\t\t\t");
                stringConcatenation.append(";");
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("\t");
                stringConcatenation.append("\t\t\t");
                stringConcatenation.append("break;");
                stringConcatenation.newLine();
                stringConcatenation.append("\t");
                stringConcatenation.append("\t\t");
                stringConcatenation.append("default:");
                stringConcatenation.newLine();
                stringConcatenation.append("\t");
                stringConcatenation.append("\t\t\t");
                stringConcatenation.append("/* should not occur */");
                stringConcatenation.newLine();
                stringConcatenation.append("\t");
                stringConcatenation.append("\t\t\t");
                stringConcatenation.append("break;");
                stringConcatenation.newLine();
                stringConcatenation.append("\t");
                stringConcatenation.append("\t");
                stringConcatenation.append("}");
                stringConcatenation.newLine();
                if (needsSkipVar) {
                    stringConcatenation.append("\t");
                    stringConcatenation.append("\t");
                    stringConcatenation.append("skip_entry__et = ");
                    object = this.langExt.booleanConstant(false);
                    stringConcatenation.append((String)object, "\t\t");
                    stringConcatenation.append(";");
                    stringConcatenation.newLineIfNotEmpty();
                }
                stringConcatenation.append("\t");
                stringConcatenation.append("}");
                stringConcatenation.newLine();
                stringConcatenation.append("\t");
                object = this.unreachableReturn();
                stringConcatenation.append((String)object, "\t");
                stringConcatenation.newLineIfNotEmpty();
            } else {
                stringConcatenation.append("\t");
                object2 = this.noStateReturn();
                stringConcatenation.append((String)object2, "\t");
                stringConcatenation.newLineIfNotEmpty();
            }
            stringConcatenation.append("}");
            stringConcatenation.newLine();
        } else {
            string5 = this.stateType();
            stringConcatenation.append(string5);
            stringConcatenation.append(" enterHistory(");
            stringConcatenation.append(selfPtr);
            string4 = this.stateType();
            stringConcatenation.append(string4);
            stringConcatenation.append(" state__et");
            if (usesHdlr) {
                stringConcatenation.append(", ");
                object2 = this.boolType();
                stringConcatenation.append((String)object2);
                stringConcatenation.append(" handler__et");
            }
            stringConcatenation.append(");");
            stringConcatenation.newLineIfNotEmpty();
        }
        stringConcatenation.newLine();
        if (generateImplementation) {
            stringConcatenation.append(publicIf);
            stringConcatenation.append("void ");
            stringConcatenation.append(opScope);
            stringConcatenation.append("executeInitTransition(");
            stringConcatenation.append(selfOnly);
            stringConcatenation.append(") {");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("\t");
            InitialTransition initt = FsmGenExtensions.getInitialTransition((Graph)gc.getGraph());
            stringConcatenation.newLineIfNotEmpty();
            if (initt == null) {
                stringConcatenation.append("\t");
                stringConcatenation.append("/* no initial transition allowed for abstract actor class */");
                stringConcatenation.newLine();
            } else {
                stringConcatenation.append("\t");
                stringConcatenation.append("int chain__et = ");
                stringConcatenation.append(chainIDScope, "\t");
                string4 = this._codegenHelpers.getGenChainId((Transition)initt);
                stringConcatenation.append(string4, "\t");
                stringConcatenation.append(";");
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("\t");
                object2 = this.stateType();
                stringConcatenation.append((String)object2, "\t");
                stringConcatenation.append(" next__et = ");
                stringConcatenation.append(opScopePriv, "\t");
                stringConcatenation.append("executeTransitionChain(");
                String string25 = this.langExt.selfPointer(true);
                stringConcatenation.append(string25, "\t");
                stringConcatenation.append("chain__et");
                if (handleEvents) {
                    stringConcatenation.append(", ");
                    String string26 = this.langExt.nullPointer();
                    stringConcatenation.append(string26, "\t");
                    stringConcatenation.append(", ");
                    string = this.langExt.nullPointer();
                    stringConcatenation.append(string, "\t");
                }
                stringConcatenation.append(");");
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("\t");
                stringConcatenation.append("next__et = ");
                stringConcatenation.append(opScopePriv, "\t");
                stringConcatenation.append("enterHistory(");
                String string27 = this.langExt.selfPointer(true);
                stringConcatenation.append(string27, "\t");
                stringConcatenation.append("next__et");
                if (usesHdlr) {
                    stringConcatenation.append(", ");
                    string = this.langExt.booleanConstant(false);
                    stringConcatenation.append(string, "\t");
                }
                stringConcatenation.append(");");
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("\t");
                stringConcatenation.append("setState(");
                string = this.langExt.selfPointer(true);
                stringConcatenation.append(string, "\t");
                stringConcatenation.append("next__et);");
                stringConcatenation.newLineIfNotEmpty();
            }
            stringConcatenation.append("}");
            stringConcatenation.newLine();
        } else {
            stringConcatenation.append("void ");
            stringConcatenation.append(opScope);
            stringConcatenation.append("executeInitTransition(");
            stringConcatenation.append(selfOnly);
            stringConcatenation.append(");");
            stringConcatenation.newLineIfNotEmpty();
        }
        stringConcatenation.newLine();
        stringConcatenation.append("/* receiveEvent contains the main implementation of the FSM */");
        stringConcatenation.newLine();
        if (generateImplementation) {
            stringConcatenation.append(publicIf);
            stringConcatenation.append("void ");
            stringConcatenation.append(opScope);
            stringConcatenation.append("receiveEventInternal(");
            string5 = this.langExt.selfPointer(this.getClassName(mc), handleEvents);
            stringConcatenation.append(string5);
            if (handleEvents) {
                stringConcatenation.append(ifItemPtr);
                stringConcatenation.append(" ifitem, int localId, int evt, ");
                string4 = this.langExt.voidPointer();
                stringConcatenation.append(string4);
                stringConcatenation.append(" generic_data__et");
            }
            stringConcatenation.append(") {");
            stringConcatenation.newLineIfNotEmpty();
            if (async) {
                stringConcatenation.append("\t");
                stringConcatenation.append("int trigger__et = (ifitem==");
                string4 = this.langExt.nullPointer();
                stringConcatenation.append(string4, "\t");
                stringConcatenation.append(")? POLLING : localId + EVT_SHIFT*evt;");
                stringConcatenation.newLineIfNotEmpty();
            } else if (eventDriven) {
                stringConcatenation.append("\t");
                stringConcatenation.append("int trigger__et = localId + EVT_SHIFT*evt;");
                stringConcatenation.newLine();
            }
            stringConcatenation.append("\t");
            stringConcatenation.append("int chain__et = NOT_CAUGHT;");
            stringConcatenation.newLine();
            stringConcatenation.append("\t");
            string4 = this.stateType();
            stringConcatenation.append(string4, "\t");
            stringConcatenation.append(" catching_state__et = NO_STATE;");
            stringConcatenation.newLineIfNotEmpty();
            if (usesHdlr) {
                stringConcatenation.append("\t");
                object2 = this.boolType();
                stringConcatenation.append((String)object2, "\t");
                stringConcatenation.append(" is_handler__et = ");
                String string28 = this.langExt.booleanConstant(false);
                stringConcatenation.append(string28, "\t");
                stringConcatenation.append(";");
                stringConcatenation.newLineIfNotEmpty();
            }
            if (async || eventDriven) {
                stringConcatenation.append("\t");
                object2 = this.markVariableUsed("trigger__et");
                stringConcatenation.append(object2, "\t");
                stringConcatenation.newLineIfNotEmpty();
            }
            stringConcatenation.newLine();
            if (handleEvents) {
                stringConcatenation.append("\t");
                stringConcatenation.append("if (!handleSystemEvent(ifitem, evt, generic_data__et)) {");
                stringConcatenation.newLine();
                stringConcatenation.append("\t");
                stringConcatenation.append("\t");
                object2 = this.genStateSwitch(gc, usesHdlr);
                stringConcatenation.append(object2, "\t\t");
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("\t");
                stringConcatenation.append("}");
                stringConcatenation.newLine();
            } else {
                stringConcatenation.append("\t");
                object2 = this.genStateSwitch(gc, usesHdlr);
                stringConcatenation.append(object2, "\t");
                stringConcatenation.newLineIfNotEmpty();
            }
            stringConcatenation.append("\t");
            stringConcatenation.append("if (chain__et != NOT_CAUGHT) {");
            stringConcatenation.newLine();
            stringConcatenation.append("\t\t");
            stringConcatenation.append(opScopePriv, "\t\t");
            stringConcatenation.append("exitTo(");
            object2 = this.langExt.selfPointer(true);
            stringConcatenation.append((String)object2, "\t\t");
            stringConcatenation.append("getState(");
            String string29 = this.langExt.selfPointer(false);
            stringConcatenation.append(string29, "\t\t");
            stringConcatenation.append("), catching_state__et");
            if (usesHdlr) {
                stringConcatenation.append(", is_handler__et");
            }
            stringConcatenation.append(");");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("\t\t");
            stringConcatenation.append("{");
            stringConcatenation.newLine();
            stringConcatenation.append("\t\t\t");
            String string30 = this.stateType();
            stringConcatenation.append(string30, "\t\t\t");
            stringConcatenation.append(" next__et = ");
            stringConcatenation.append(opScopePriv, "\t\t\t");
            stringConcatenation.append("executeTransitionChain(");
            string = this.langExt.selfPointer(true);
            stringConcatenation.append(string, "\t\t\t");
            stringConcatenation.append("chain__et");
            if (handleEvents) {
                stringConcatenation.append(", ifitem, generic_data__et");
            }
            stringConcatenation.append(");");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("\t\t\t");
            stringConcatenation.append("next__et = ");
            stringConcatenation.append(opScopePriv, "\t\t\t");
            stringConcatenation.append("enterHistory(");
            string2 = this.langExt.selfPointer(true);
            stringConcatenation.append(string2, "\t\t\t");
            stringConcatenation.append("next__et");
            if (usesHdlr) {
                stringConcatenation.append(", is_handler__et");
            }
            stringConcatenation.append(");");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("\t\t\t");
            stringConcatenation.append("setState(");
            object = this.langExt.selfPointer(true);
            stringConcatenation.append((String)object, "\t\t\t");
            stringConcatenation.append("next__et);");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("\t\t\t");
            charSequence = this.finalAction();
            stringConcatenation.append((Object)charSequence, "\t\t\t");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("\t\t");
            stringConcatenation.append("}");
            stringConcatenation.newLine();
            stringConcatenation.append("\t");
            stringConcatenation.append("}");
            stringConcatenation.newLine();
            stringConcatenation.append("}");
            stringConcatenation.newLine();
        } else {
            stringConcatenation.append("void ");
            stringConcatenation.append(opScope);
            stringConcatenation.append("receiveEventInternal(");
            string5 = this.langExt.selfPointer(this.getClassName(mc), handleEvents);
            stringConcatenation.append(string5);
            if (handleEvents) {
                stringConcatenation.append(ifItemPtr);
                stringConcatenation.append(" ifitem, int localId, int evt, ");
                string4 = this.langExt.voidPointer();
                stringConcatenation.append(string4);
                stringConcatenation.append(" generic_data__et");
            }
            stringConcatenation.append(");");
            stringConcatenation.newLineIfNotEmpty();
        }
        if (handleEvents) {
            if (generateImplementation) {
                stringConcatenation.append(publicIf);
                stringConcatenation.append("void ");
                stringConcatenation.append(opScope);
                stringConcatenation.append("receiveEvent(");
                string5 = this.langExt.selfPointer(this.getClassName(mc), true);
                stringConcatenation.append(string5);
                stringConcatenation.append(ifItemPtr);
                stringConcatenation.append(" ifitem, int evt, ");
                string4 = this.langExt.voidPointer();
                stringConcatenation.append(string4);
                stringConcatenation.append(" generic_data__et) {");
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("\t");
                stringConcatenation.append("int localId = (ifitem==");
                object2 = this.langExt.nullPointer();
                stringConcatenation.append((String)object2, "\t");
                stringConcatenation.append(")? 0 : ifitem");
                stringConcatenation.append(getLocalId, "\t");
                stringConcatenation.append(";");
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("\t");
                stringConcatenation.append(opScope, "\t");
                stringConcatenation.append("receiveEventInternal(");
                String string31 = this.langExt.selfPointer(true);
                stringConcatenation.append(string31, "\t");
                stringConcatenation.append("ifitem, localId, evt, generic_data__et);");
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("}");
                stringConcatenation.newLine();
            } else {
                stringConcatenation.append("void ");
                stringConcatenation.append(opScope);
                stringConcatenation.append("receiveEvent(");
                string5 = this.langExt.selfPointer(true);
                stringConcatenation.append(string5);
                stringConcatenation.append(ifItemPtr);
                stringConcatenation.append(" ifitem, int evt, ");
                string4 = this.langExt.voidPointer();
                stringConcatenation.append(string4);
                stringConcatenation.append(" generic_data__et);");
                stringConcatenation.newLineIfNotEmpty();
            }
        }
        string6 = stringConcatenation.toString();
        return string6;
    }

    public String genDoCodes(State state) {
        EObject eObject;
        String string;
        String string2;
        StringConcatenation stringConcatenation = new StringConcatenation();
        boolean bl = this._fSMHelpers.hasDoCode(state, true);
        if (bl) {
            string2 = this._codegenHelpers.getDoCodeOperationName(state);
            stringConcatenation.append(string2);
            stringConcatenation.append("(");
            string = this.langExt.selfPointer(false);
            stringConcatenation.append(string);
            stringConcatenation.append(");");
            stringConcatenation.newLineIfNotEmpty();
        }
        if ((eObject = state.eContainer().eContainer()) instanceof State) {
            string2 = state.eContainer().eContainer();
            string = this.genDoCodes((State)string2);
            stringConcatenation.append(string);
            stringConcatenation.newLineIfNotEmpty();
        }
        return stringConcatenation.toString();
    }

    public CharSequence genStateSwitch(GraphContainer gc, boolean usesHdlr) {
        StringConcatenation stringConcatenation = null;
        ComponentCommunicationType componentCommunicationType = gc.getComponent().getCommType();
        boolean async = Objects.equal((Object)componentCommunicationType, (Object)ComponentCommunicationType.ASYNCHRONOUS);
        ComponentCommunicationType componentCommunicationType2 = gc.getComponent().getCommType();
        boolean eventDriven = Objects.equal((Object)componentCommunicationType2, (Object)ComponentCommunicationType.EVENT_DRIVEN);
        ComponentCommunicationType componentCommunicationType3 = gc.getComponent().getCommType();
        boolean dataDriven = Objects.equal((Object)componentCommunicationType3, (Object)ComponentCommunicationType.DATA_DRIVEN);
        Functions.Function1<Node, Boolean> function1 = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                return FsmGenExtensions.isLeaf((Node)it);
            }
        };
        Functions.Function1<Node, String> function12 = new Functions.Function1<Node, String>(){

            public String apply(Node it) {
                StateGraphNode stateGraphNode = it.getStateGraphNode();
                return AbstractStateMachineGenerator.this._codegenHelpers.getGenStateId((State)stateGraphNode);
            }
        };
        List allLeafStateNodes = IterableExtensions.sortBy((Iterable)IteratorExtensions.toList((Iterator)IteratorExtensions.filter((Iterator)FsmGenExtensions.getAllStateNodes((Graph)gc.getGraph()), (Functions.Function1)function1)), (Functions.Function1)function12);
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("switch (getState(");
        String string = this.langExt.selfPointer(false);
        stringConcatenation2.append(string);
        stringConcatenation2.append(")) {");
        stringConcatenation2.newLineIfNotEmpty();
        for (Node stateNode : allLeafStateNodes) {
            CharSequence charSequence;
            boolean bl;
            boolean bl2;
            stringConcatenation2.append("\t");
            StateGraphNode stateGraphNode = stateNode.getStateGraphNode();
            State state = (State)stateGraphNode;
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("case ");
            String string2 = this._codegenHelpers.getGenStateId(state);
            stringConcatenation2.append(string2, "\t");
            stringConcatenation2.append(":");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            EList caughtTriggers = stateNode.getCaughtTriggers();
            stringConcatenation2.newLineIfNotEmpty();
            if (async) {
                bl2 = caughtTriggers.isEmpty();
                boolean bl3 = bl = !bl2;
                if (bl) {
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("switch(trigger__et) {");
                    stringConcatenation2.newLine();
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("case POLLING:");
                    stringConcatenation2.newLine();
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t\t");
                    charSequence = this.genDataDrivenTriggers(gc, stateNode, usesHdlr);
                    stringConcatenation2.append((Object)charSequence, "\t\t\t\t");
                    stringConcatenation2.newLineIfNotEmpty();
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t\t");
                    stringConcatenation2.append("break;");
                    stringConcatenation2.newLine();
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t");
                    CharSequence charSequence2 = this.genEventDrivenTriggers(gc, stateNode, usesHdlr);
                    stringConcatenation2.append((Object)charSequence2, "\t\t\t");
                    stringConcatenation2.newLineIfNotEmpty();
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("}");
                    stringConcatenation2.newLine();
                } else {
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t");
                    charSequence = this.genDataDrivenTriggers(gc, stateNode, usesHdlr);
                    stringConcatenation2.append((Object)charSequence, "\t\t");
                    stringConcatenation2.newLineIfNotEmpty();
                }
            } else if (dataDriven) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                CharSequence charSequence3 = this.genDataDrivenTriggers(gc, stateNode, usesHdlr);
                stringConcatenation2.append((Object)charSequence3, "\t\t");
                stringConcatenation2.newLineIfNotEmpty();
            } else if (eventDriven) {
                bl2 = caughtTriggers.isEmpty();
                boolean bl4 = bl = !bl2;
                if (bl) {
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("switch(trigger__et) {");
                    stringConcatenation2.newLine();
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t");
                    charSequence = this.genEventDrivenTriggers(gc, stateNode, usesHdlr);
                    stringConcatenation2.append((Object)charSequence, "\t\t\t");
                    stringConcatenation2.newLineIfNotEmpty();
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("}");
                    stringConcatenation2.newLine();
                }
            }
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("break;");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.append("default:");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("/* should not occur */");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("break;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    public CharSequence genDataDrivenTriggers(GraphContainer gc, Node stateNode, boolean usesHdlr) {
        Object object;
        StringConcatenation stringConcatenation = null;
        String string = null;
        boolean bl = this.langExt.usesInheritance();
        if (bl) {
            String string2 = this.getClassName(gc);
            object = this.langExt.scopeSeparator();
            string = String.valueOf(string2) + (String)object;
        } else {
            string = "";
        }
        String chainIDScope = string;
        object = stateNode.getStateGraphNode();
        State state = (State)object;
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        String string3 = this.genDoCodes(state);
        stringConcatenation2.append(string3);
        stringConcatenation2.newLineIfNotEmpty();
        Functions.Function1<Link, Boolean> function1 = new Functions.Function1<Link, Boolean>(){

            public Boolean apply(Link it) {
                Transition transition = it.getTransition();
                return transition instanceof GuardedTransition;
            }
        };
        Iterable links = IterableExtensions.filter((Iterable)FsmGenExtensions.getOutgoingLinksHierarchically((Node)stateNode), (Functions.Function1)function1);
        stringConcatenation2.newLineIfNotEmpty();
        for (Link l : links) {
            boolean bl2;
            stringConcatenation2.append("if (");
            String string4 = this.genGuardedTransitionGuard(l, "", gc);
            stringConcatenation2.append(string4);
            stringConcatenation2.append(")");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("{");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("chain__et = ");
            stringConcatenation2.append(chainIDScope, "\t");
            String string5 = this._codegenHelpers.getGenChainId(l.getTransition());
            stringConcatenation2.append(string5, "\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("catching_state__et = ");
            String string6 = this._codegenHelpers.getGenStateId(this._fSMHelpers.getSuperState(l.getTransition()));
            stringConcatenation2.append(string6, "\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
            if (FsmGenExtensions.isHandler((Link)l) && usesHdlr) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append("is_handler__et = TRUE;");
                stringConcatenation2.newLine();
            }
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
            Link link = (Link)IterableExtensions.last((Iterable)links);
            boolean bl3 = bl2 = !Objects.equal((Object)l, (Object)link);
            if (!bl2) continue;
            stringConcatenation2.append("else");
            stringConcatenation2.newLine();
        }
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    public CharSequence genEventDrivenTriggers(GraphContainer gc, Node stateNode, boolean usesHdlr) {
        String string;
        String string2 = null;
        EList eList = stateNode.getCaughtTriggers();
        Functions.Function1<CommonTrigger, String> function1 = new Functions.Function1<CommonTrigger, String>(){

            public String apply(CommonTrigger it) {
                return AbstractStateMachineGenerator.this.getTriggerCodeName(it);
            }
        };
        List caughtTriggers = IterableExtensions.sortBy(new ArrayList(eList), (Functions.Function1)function1);
        String string3 = null;
        boolean bl = this.langExt.usesInheritance();
        if (bl) {
            String string4 = this.getClassName(gc);
            string = this.langExt.scopeSeparator();
            string3 = String.valueOf(string4) + string;
        } else {
            string3 = "";
        }
        String chainIDScope = string3;
        string = new StringConcatenation();
        for (CommonTrigger ct : caughtTriggers) {
            Object object;
            string.append("case ");
            String string5 = this.getTriggerCodeName(ct);
            string.append(string5);
            string.append(":");
            string.newLineIfNotEmpty();
            string.append("\t");
            boolean needData = ct.isHasGuard();
            string.newLineIfNotEmpty();
            string.append("\t");
            if (needData) {
                string.append("{ ");
                object = this.langExt.getTypedDataDefinition(ct.getMsg());
                string.append((String)object, "\t");
            }
            string.newLineIfNotEmpty();
            object = ct.getLinks();
            boolean bl2 = false;
            for (Link link : object) {
                if (!bl2) {
                    bl2 = true;
                } else {
                    string.appendImmediate((Object)" else ", "\t");
                }
                string.append("\t");
                String string6 = this.genTriggeredTransitionGuard(link, ct.getTrigger(), gc);
                string.append(string6, "\t");
                string.newLineIfNotEmpty();
                string.append("\t");
                string.append("{");
                string.newLine();
                string.append("\t");
                string.append("\t");
                string.append("chain__et = ");
                string.append(chainIDScope, "\t\t");
                String string7 = this._codegenHelpers.getGenChainId(link.getTransition());
                string.append(string7, "\t\t");
                string.append(";");
                string.newLineIfNotEmpty();
                string.append("\t");
                string.append("\t");
                string.append("catching_state__et = ");
                String string8 = this._codegenHelpers.getGenStateId(this._fSMHelpers.getSuperState(link.getTransition()));
                string.append(string8, "\t\t");
                string.append(";");
                string.newLineIfNotEmpty();
                if (FsmGenExtensions.isHandler((Link)link) && usesHdlr) {
                    string.append("\t");
                    string.append("\t");
                    string.append("is_handler__et = ");
                    String string9 = this.langExt.booleanConstant(true);
                    string.append(string9, "\t\t");
                    string.append(";");
                    string.newLineIfNotEmpty();
                }
                string.append("\t");
                string.append("}");
                string.newLine();
            }
            string.append("\t");
            if (needData) {
                string.append("}");
            }
            string.newLineIfNotEmpty();
            string.append("break;");
            string.newLine();
        }
        string.append("default:");
        string.newLine();
        string.append("\t");
        string.append("/* should not occur */");
        string.newLine();
        string.append("\t");
        string.append("break;");
        string.newLine();
        string2 = string;
        return string2;
    }

    public String getClassName(GraphContainer gc) {
        return this.getClassName(gc.getComponent());
    }

    public String getClassName(ModelComponent mc) {
        return mc.getComponentName();
    }

    public String getTriggerCodeName(CommonTrigger tr) {
        String[] parts = tr.getTrigger().split(TriggerExtensions.TRIGGER_SEP);
        String string = parts[0];
        String string2 = "TRIG_" + string;
        String string3 = String.valueOf(string2) + "__";
        String string4 = parts[1];
        return String.valueOf(string3) + string4;
    }

    public String getHistory(String state) {
        String string = this.langExt.memberAccess();
        String string2 = String.valueOf(string) + "history[";
        String string3 = String.valueOf(string2) + state;
        return String.valueOf(string3) + "]";
    }

    public String setHistory(String state, String historyState) {
        String string = this.langExt.memberAccess();
        String string2 = String.valueOf(string) + "history[";
        String string3 = String.valueOf(string2) + state;
        String string4 = String.valueOf(string3) + "] = ";
        return String.valueOf(string4) + historyState;
    }

    public String stateType() {
        return "int";
    }

    public String unreachableReturn() {
        return "/* return NO_STATE; // required by CDT but detected as unreachable by JDT because of while (true) */";
    }

    public String noStateReturn() {
        return "return NO_STATE;";
    }

    public String boolType() {
        return "boolean";
    }

    public CharSequence finalAction() {
        StringConcatenation stringConcatenation = new StringConcatenation();
        return stringConcatenation;
    }

    public String interfaceItemType() {
        return "InterfaceItemBase";
    }

    public CharSequence markVariableUsed(String varname) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        return stringConcatenation;
    }

    public boolean usesHandlerTrPoints(GraphContainer gc) {
        Functions.Function1<Node, Boolean> function1 = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node t) {
                StateGraphNode stateGraphNode = t.getStateGraphNode();
                return ((TransitionPoint)stateGraphNode).isHandler();
            }
        };
        boolean bl = IteratorExtensions.isEmpty((Iterator)IteratorExtensions.filter((Iterator)FsmGenExtensions.getAllTransitionPointNodes((Graph)gc.getGraph()), (Functions.Function1)function1));
        return !bl;
    }

    public abstract String genTriggeredTransitionGuard(Link var1, String var2, GraphContainer var3);

    public abstract String genGuardedTransitionGuard(Link var1, String var2, GraphContainer var3);

    public abstract String genActionCodeMethod(GraphContainer var1, Link var2, boolean var3);

    public abstract String genActionCodeMethods(GraphContainer var1, Node var2, boolean var3);
}

