/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ui.outline;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.etrice.core.common.base.Import;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorInstanceMapping;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.ClassStructor;
import org.eclipse.etrice.core.room.LogicalThread;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortOperation;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.ui.internal.RoomActivator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.scoping.impl.ImportUriResolver;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.DefaultOutlineTreeProvider;

public class RoomOutlineTreeProvider
extends DefaultOutlineTreeProvider {
    private static final String STATE_MACHINE_LABEL = "StateMachine";
    private static final String BEHAVIOR_LABEL = "Behavior";
    private static final String STRUCTURE_LABEL = "Structure";
    private static final String INTERFACE_LABEL = "Interface";
    private static final Object INCOMING_LABEL = "incoming";
    private static final Object OUTGOING_LABEL = "outgoing";
    private static final Object REG_PORT_CLASS_LABEL = "regular port class";
    private static final Object CONJ_PORT_CLASS_LABEL = "conjugated port class";
    @Inject
    ImportUriResolver importUriResolver;
    @Inject
    ILabelProvider labelProvider;

    protected boolean _isLeaf(ActorClass ac) {
        if (ac.getInterfacePorts().size() > 0 || ac.getServiceProvisionPoints().size() > 0) {
            return false;
        }
        if (ac.getInternalPorts().size() > 0 || ac.getServiceImplementations().size() > 0 || ac.getServiceAccessPoints().size() > 0 || ac.getAttributes().size() > 0 || ac.getActorRefs().size() > 0) {
            return false;
        }
        return ac.getOperations().size() <= 0 && ac.getStateMachine() == null;
    }

    protected void _createChildren(IOutlineNode parentNode, ActorClass ac) {
        Object nodeName = parentNode.getText();
        if (parentNode.getText() instanceof StyledString) {
            nodeName = ((StyledString)parentNode.getText()).getString();
        }
        if (nodeName.equals(INTERFACE_LABEL) || nodeName.equals(STRUCTURE_LABEL) || nodeName.equals(BEHAVIOR_LABEL)) {
            this.createChildren2(parentNode, ac);
        } else if (((String)nodeName).startsWith(ac.getName())) {
            this.createChildren1(parentNode, ac);
        }
    }

    private void createChildren1(IOutlineNode parentNode, ActorClass ac) {
        if (ac.getInterfacePorts().size() > 0 || ac.getServiceProvisionPoints().size() > 0) {
            this.createExtraNode((EObject)ac, parentNode, INTERFACE_LABEL);
        }
        if (ac.getInternalPorts().size() > 0 || ac.getExternalPorts().size() > 0 || ac.getServiceImplementations().size() > 0 || ac.getServiceAccessPoints().size() > 0 || ac.getAttributes().size() > 0 || ac.getActorRefs().size() > 0) {
            this.createExtraNode((EObject)ac, parentNode, STRUCTURE_LABEL);
        }
        if (ac.getOperations().size() > 0 || ac.getStateMachine() != null) {
            this.createExtraNode((EObject)ac, parentNode, BEHAVIOR_LABEL);
        }
    }

    private void createChildren2(IOutlineNode parentNode, ActorClass ac) {
        if (parentNode.getText().equals(INTERFACE_LABEL)) {
            for (Port port : ac.getInterfacePorts()) {
                this.createNode(parentNode, (EObject)port);
            }
            for (SPP spp : ac.getServiceProvisionPoints()) {
                this.createNode(parentNode, (EObject)spp);
            }
        } else if (parentNode.getText().equals(STRUCTURE_LABEL)) {
            for (Port port : ac.getInternalPorts()) {
                this.createNode(parentNode, (EObject)port);
            }
            for (Port port : ac.getExternalPorts()) {
                this.createNode(parentNode, (EObject)port.getInterfacePort());
            }
            for (ServiceImplementation svc : ac.getServiceImplementations()) {
                this.createNode(parentNode, (EObject)svc);
            }
            for (SAP sap : ac.getServiceAccessPoints()) {
                this.createNode(parentNode, (EObject)sap);
            }
            for (Attribute attr : ac.getAttributes()) {
                this.createNode(parentNode, (EObject)attr);
            }
            for (ActorRef ar : ac.getActorRefs()) {
                this.createNode(parentNode, (EObject)ar);
            }
        } else if (parentNode.getText().equals(BEHAVIOR_LABEL)) {
            for (ClassStructor structor : ac.getStructors()) {
                this.createNode(parentNode, (EObject)structor);
            }
            for (Operation op : ac.getOperations()) {
                this.createNode(parentNode, (EObject)op);
            }
            if (ac.getStateMachine() != null) {
                this.createNode(parentNode, (EObject)ac.getStateMachine());
            }
        }
    }

    protected void _createChildren(IOutlineNode parentNode, StateGraph st) {
        for (State s : st.getStates()) {
            this.createNode(parentNode, (EObject)s);
        }
    }

    protected Object _text(StateGraph modelElement) {
        return STATE_MACHINE_LABEL;
    }

    protected Image _image(StateGraph modelElement) {
        return RoomActivator.getInstance().getImageRegistry().get("defaultoutlinenode.gif");
    }

    protected boolean _isLeaf(SubSystemClass ssc) {
        return ssc.getActorRefs().isEmpty();
    }

    protected void _createChildren(IOutlineNode parentNode, SubSystemClass ssc) {
        for (ActorRef aref : ssc.getActorRefs()) {
            this.createNode(parentNode, (EObject)aref);
        }
        for (LogicalThread thread : ssc.getThreads()) {
            this.createNode(parentNode, (EObject)thread);
        }
        for (ActorInstanceMapping aim : ssc.getActorInstanceMappings()) {
            this.createNode(parentNode, (EObject)aim);
        }
    }

    protected void _createChildren(IOutlineNode parentNode, State s) {
        if (s.getSubgraph() != null) {
            for (State state : s.getSubgraph().getStates()) {
                this.createNode(parentNode, (EObject)state);
            }
        }
    }

    protected boolean _isLeaf(State s) {
        return s.getSubgraph() == null || s.getSubgraph().getStates().isEmpty();
    }

    protected void _createChildren(IOutlineNode parentNode, ProtocolClass pc) {
        Object nodeName = parentNode.getText();
        if (parentNode.getText() instanceof StyledString) {
            nodeName = ((StyledString)parentNode.getText()).getString();
        }
        if (nodeName.equals(this.labelProvider.getText((Object)pc))) {
            this.createChildren1(parentNode, pc);
        } else {
            this.createChildren2(parentNode, pc);
        }
    }

    private void createChildren1(IOutlineNode parentNode, ProtocolClass pc) {
        if (pc.getIncomingMessages().size() > 0) {
            this.createExtraNode((EObject)pc, parentNode, INCOMING_LABEL);
        }
        if (pc.getOutgoingMessages().size() > 0) {
            this.createExtraNode((EObject)pc, parentNode, OUTGOING_LABEL);
        }
        if (pc.getRegular() != null) {
            this.createExtraNode((EObject)pc, parentNode, REG_PORT_CLASS_LABEL);
        }
        if (pc.getConjugated() != null) {
            this.createExtraNode((EObject)pc, parentNode, CONJ_PORT_CLASS_LABEL);
        }
    }

    private void createChildren2(IOutlineNode parentNode, ProtocolClass pc) {
        block7: {
            block9: {
                block8: {
                    block6: {
                        if (!parentNode.getText().equals(INCOMING_LABEL)) break block6;
                        for (Message m : pc.getIncomingMessages()) {
                            this.createNode(parentNode, (EObject)m);
                        }
                        break block7;
                    }
                    if (!parentNode.getText().equals(OUTGOING_LABEL)) break block8;
                    for (Message m : pc.getOutgoingMessages()) {
                        this.createNode(parentNode, (EObject)m);
                    }
                    break block7;
                }
                if (!parentNode.getText().equals(REG_PORT_CLASS_LABEL)) break block9;
                for (Attribute att : pc.getRegular().getAttributes()) {
                    this.createNode(parentNode, (EObject)att);
                }
                for (PortOperation op : pc.getRegular().getOperations()) {
                    this.createNode(parentNode, (EObject)op);
                }
                break block7;
            }
            if (!parentNode.getText().equals(CONJ_PORT_CLASS_LABEL)) break block7;
            for (Attribute att : pc.getConjugated().getAttributes()) {
                this.createNode(parentNode, (EObject)att);
            }
            for (PortOperation op : pc.getConjugated().getOperations()) {
                this.createNode(parentNode, (EObject)op);
            }
        }
    }

    protected boolean _isLeaf(Message m) {
        return true;
    }

    protected boolean _isLeaf(Operation o) {
        return true;
    }

    protected boolean _isLeaf(ClassStructor structor) {
        return true;
    }

    protected boolean _isLeaf(Attribute ac) {
        return true;
    }

    protected void _createChildren(IOutlineNode parentNode, Import im) {
        String resolvedURI = this.importUriResolver.resolve((EObject)im);
        if (resolvedURI == null) {
            return;
        }
        Resource res = im.eResource().getResourceSet().getResource(URI.createURI((String)resolvedURI), false);
        if (res == null) {
            return;
        }
        for (EObject content : res.getContents()) {
            if (!(content instanceof RoomModel)) continue;
            for (EObject topLevel : content.eContents()) {
                if (topLevel instanceof Import) continue;
                this._createNode(parentNode, topLevel);
            }
        }
    }

    protected boolean _isLeaf(Import im) {
        return false;
    }

    private void createExtraNode(EObject obj, IOutlineNode parent, Object text) {
        this.createEObjectNode(parent, obj, RoomActivator.getInstance().getImageRegistry().get("defaultoutlinenode.gif"), text, false);
    }

    protected boolean _isLeaf(ActorInstanceMapping aim) {
        return true;
    }
}

