/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.postprocessing;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.etrice.core.common.postprocessing.PostprocessingHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.GeneratedMetamodel;

public class DocuPostprocessor {
    public void process(GeneratedMetamodel metamodel) {
        EPackage pckg = metamodel.getEPackage();
        EClass cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"ConfigModel");
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("The root object for the ROOM Config model. It gives access to");
        stringConcatenation.newLine();
        stringConcatenation.append("the {@link SubSystemConfig sub system class},");
        stringConcatenation.newLine();
        stringConcatenation.append("{@link ActorClassConfig actor class}, {@link ProtocolClassConfig protocol class} and");
        stringConcatenation.newLine();
        stringConcatenation.append("{@link ActorInstanceConfig actor instance} configurations and the room model {@link Import imports}.");
        stringConcatenation.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation.toString());
        EAttribute eAttribute = PostprocessingHelpers.getAttribute((EClass)cls, (String)"name");
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("The model name is a dot separated fully qualified name and is");
        stringConcatenation2.newLine();
        stringConcatenation2.append("used to provide a name space.");
        stringConcatenation2.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute, (String)stringConcatenation2.toString());
        EReference eReference = PostprocessingHelpers.getReference((EClass)cls, (String)"imports");
        StringConcatenation stringConcatenation3 = new StringConcatenation();
        stringConcatenation3.append("This is a list of all imported room models. The config elements reference these imports.");
        stringConcatenation3.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference, (String)stringConcatenation3.toString());
        EReference eReference2 = PostprocessingHelpers.getReference((EClass)cls, (String)"configElements");
        StringConcatenation stringConcatenation4 = new StringConcatenation();
        stringConcatenation4.append("This is a list of all top level config elements");
        stringConcatenation4.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference2, (String)stringConcatenation4.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"ConfigElement");
        StringConcatenation stringConcatenation5 = new StringConcatenation();
        stringConcatenation5.append("This is the super class of the top level config elements");
        stringConcatenation5.newLine();
        stringConcatenation5.append("<ul>");
        stringConcatenation5.newLine();
        stringConcatenation5.append("\t");
        stringConcatenation5.append("<li>{@link SubSystemConfig}</li>");
        stringConcatenation5.newLine();
        stringConcatenation5.append("\t");
        stringConcatenation5.append("<li>{@link ActorClassConfig}</li>");
        stringConcatenation5.newLine();
        stringConcatenation5.append("\t");
        stringConcatenation5.append("<li>{@link ActorInstanceConfig}</li>");
        stringConcatenation5.newLine();
        stringConcatenation5.append("\t");
        stringConcatenation5.append("<li>{@link ProtocolClassConfig}</li>");
        stringConcatenation5.newLine();
        stringConcatenation5.append("</ul>");
        stringConcatenation5.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation5.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"SubSystemConfig");
        StringConcatenation stringConcatenation6 = new StringConcatenation();
        stringConcatenation6.append("This class defines settings with a sub system scope.");
        stringConcatenation6.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation6.toString());
        EReference eReference3 = PostprocessingHelpers.getReference((EClass)cls, (String)"root");
        StringConcatenation stringConcatenation7 = new StringConcatenation();
        stringConcatenation7.append("This is the logical system that contains the {@link org.eclipse.etrice.core.room.SubSystemRef sub system reference}.");
        stringConcatenation7.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference3, (String)stringConcatenation7.toString());
        EReference eReference4 = PostprocessingHelpers.getReference((EClass)cls, (String)"subSystem");
        StringConcatenation stringConcatenation8 = new StringConcatenation();
        stringConcatenation8.append("This is the sub system reference.");
        stringConcatenation8.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference4, (String)stringConcatenation8.toString());
        EReference eReference5 = PostprocessingHelpers.getReference((EClass)cls, (String)"dynConfig");
        StringConcatenation stringConcatenation9 = new StringConcatenation();
        stringConcatenation9.append("This is the dynamic configuration. It is available within the {@link #getSubSystem sub system}.");
        stringConcatenation9.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference5, (String)stringConcatenation9.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"DynamicConfig");
        StringConcatenation stringConcatenation10 = new StringConcatenation();
        stringConcatenation10.append("The dynamic configuration provides a configuration at runtime.");
        stringConcatenation10.newLine();
        stringConcatenation10.append("The source of the configuration is abstracted by an interface.");
        stringConcatenation10.newLine();
        stringConcatenation10.append("<br>");
        stringConcatenation10.newLine();
        stringConcatenation10.append("This feature is experimental and implemented for target language java only.");
        stringConcatenation10.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation10.toString());
        EAttribute eAttribute2 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"filePath");
        StringConcatenation stringConcatenation11 = new StringConcatenation();
        stringConcatenation11.append("This is the file path of the configuration. In this case the source of the configuration is a simple file.");
        stringConcatenation11.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute2, (String)stringConcatenation11.toString());
        EAttribute eAttribute3 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"userCode1");
        StringConcatenation stringConcatenation12 = new StringConcatenation();
        stringConcatenation12.append("Defines the import statement for the implemenation of the configuration source.");
        stringConcatenation12.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute3, (String)stringConcatenation12.toString());
        EAttribute eAttribute4 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"userCode2");
        StringConcatenation stringConcatenation13 = new StringConcatenation();
        stringConcatenation13.append("This is the constructor statement for the implemenation of the configuration source.");
        stringConcatenation13.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute4, (String)stringConcatenation13.toString());
        EAttribute eAttribute5 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"polling");
        StringConcatenation stringConcatenation14 = new StringConcatenation();
        stringConcatenation14.append("Defines the time interval in milliseconds to query changes from the configuration source.");
        stringConcatenation14.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute5, (String)stringConcatenation14.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"ActorClassConfig");
        StringConcatenation stringConcatenation15 = new StringConcatenation();
        stringConcatenation15.append("This class models a configuration for an {@link org.eclipse.etrice.core.room.ActorClass actor class}.");
        stringConcatenation15.newLine();
        stringConcatenation15.append("The configuration defines the default values for all instances of the {@link #getActor actor}.");
        stringConcatenation15.newLine();
        stringConcatenation15.append("The values are applied at generation time.");
        stringConcatenation15.newLine();
        stringConcatenation15.append("The config sub elements are:");
        stringConcatenation15.newLine();
        stringConcatenation15.append("<ul>");
        stringConcatenation15.newLine();
        stringConcatenation15.append("\t");
        stringConcatenation15.append("<li>{@link AttrClassConfig attribute class config}</li>");
        stringConcatenation15.newLine();
        stringConcatenation15.append("</ul>\t\t\t\t");
        stringConcatenation15.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation15.toString());
        EReference eReference6 = PostprocessingHelpers.getReference((EClass)cls, (String)"actor");
        StringConcatenation stringConcatenation16 = new StringConcatenation();
        stringConcatenation16.append("This is the actor class.");
        stringConcatenation16.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference6, (String)stringConcatenation16.toString());
        EReference eReference7 = PostprocessingHelpers.getReference((EClass)cls, (String)"attributes");
        StringConcatenation stringConcatenation17 = new StringConcatenation();
        stringConcatenation17.append("This is a list of all attribute configurations.");
        stringConcatenation17.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference7, (String)stringConcatenation17.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"ProtocolClassConfig");
        StringConcatenation stringConcatenation18 = new StringConcatenation();
        stringConcatenation18.append("This class models a configuration for an {@link org.eclipse.etrice.core.room.ProtocolClass protocol class}.");
        stringConcatenation18.newLine();
        stringConcatenation18.append("The config sub elements are:");
        stringConcatenation18.newLine();
        stringConcatenation18.append("<ul>");
        stringConcatenation18.newLine();
        stringConcatenation18.append("\t");
        stringConcatenation18.append("<li>a {@link PortClassConfig port class config} for the regular port class</li>");
        stringConcatenation18.newLine();
        stringConcatenation18.append("\t");
        stringConcatenation18.append("<li>a {@link PortClassConfig port class config} for the conjugate port class</li>");
        stringConcatenation18.newLine();
        stringConcatenation18.append("</ul>");
        stringConcatenation18.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation18.toString());
        EReference eReference8 = PostprocessingHelpers.getReference((EClass)cls, (String)"protocol");
        StringConcatenation stringConcatenation19 = new StringConcatenation();
        stringConcatenation19.append("This is the protocol class.");
        stringConcatenation19.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference8, (String)stringConcatenation19.toString());
        EReference eReference9 = PostprocessingHelpers.getReference((EClass)cls, (String)"regular");
        StringConcatenation stringConcatenation20 = new StringConcatenation();
        stringConcatenation20.append("This is the configuration for the regular part of the protocol.");
        stringConcatenation20.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference9, (String)stringConcatenation20.toString());
        EReference eReference10 = PostprocessingHelpers.getReference((EClass)cls, (String)"conjugated");
        StringConcatenation stringConcatenation21 = new StringConcatenation();
        stringConcatenation21.append("This is the configuration for the conjugated part of the protocol.");
        stringConcatenation21.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference10, (String)stringConcatenation21.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"PortClassConfig");
        StringConcatenation stringConcatenation22 = new StringConcatenation();
        stringConcatenation22.append("This class models a configuration for an {@link org.eclipse.etrice.core.room.PortClass port class}.");
        stringConcatenation22.newLine();
        stringConcatenation22.append("The configuration defines the default values for all instances of the port.");
        stringConcatenation22.newLine();
        stringConcatenation22.append("The values are applied at generation time.");
        stringConcatenation22.newLine();
        stringConcatenation22.append("The config sub elements are:");
        stringConcatenation22.newLine();
        stringConcatenation22.append("<ul>");
        stringConcatenation22.newLine();
        stringConcatenation22.append("\t");
        stringConcatenation22.append("<li>{@link AttrClassConfig attribute class config}</li>");
        stringConcatenation22.newLine();
        stringConcatenation22.append("</ul>");
        stringConcatenation22.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation22.toString());
        EReference eReference11 = PostprocessingHelpers.getReference((EClass)cls, (String)"attributes");
        StringConcatenation stringConcatenation23 = new StringConcatenation();
        stringConcatenation23.append("This is a list of all attribute configurations.");
        stringConcatenation23.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference11, (String)stringConcatenation23.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"ActorInstanceConfig");
        StringConcatenation stringConcatenation24 = new StringConcatenation();
        stringConcatenation24.append("This class models a configuration for an {@link org.eclipse.etrice.core.room.ActorRef actor instance}.");
        stringConcatenation24.newLine();
        stringConcatenation24.append("The configuration defines values for this actor instance and overrides the default values from the corresponding class config.");
        stringConcatenation24.newLine();
        stringConcatenation24.append("The values are applied at generation time.");
        stringConcatenation24.newLine();
        stringConcatenation24.append("The config sub elements are:");
        stringConcatenation24.newLine();
        stringConcatenation24.append("<ul>");
        stringConcatenation24.newLine();
        stringConcatenation24.append("\t");
        stringConcatenation24.append("<li>{@link AttrInstanceConfig attribute instance config}</li>");
        stringConcatenation24.newLine();
        stringConcatenation24.append("</ul>\t\t\t\t");
        stringConcatenation24.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation24.toString());
        EReference eReference12 = PostprocessingHelpers.getReference((EClass)cls, (String)"root");
        StringConcatenation stringConcatenation25 = new StringConcatenation();
        stringConcatenation25.append("This is the logical system that contains the {@link #getSubSystem sub system}.");
        stringConcatenation25.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference12, (String)stringConcatenation25.toString());
        EReference eReference13 = PostprocessingHelpers.getReference((EClass)cls, (String)"subSystem");
        StringConcatenation stringConcatenation26 = new StringConcatenation();
        stringConcatenation26.append("This is the sub system that contains the {@link #getPath actor instance}.");
        stringConcatenation26.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference13, (String)stringConcatenation26.toString());
        EReference eReference14 = PostprocessingHelpers.getReference((EClass)cls, (String)"path");
        StringConcatenation stringConcatenation27 = new StringConcatenation();
        stringConcatenation27.append("This is the path of the actor instance relative to the {@link #getSubSystem sub system}.");
        stringConcatenation27.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference14, (String)stringConcatenation27.toString());
        EReference eReference15 = PostprocessingHelpers.getReference((EClass)cls, (String)"attributes");
        StringConcatenation stringConcatenation28 = new StringConcatenation();
        stringConcatenation28.append("This is a list of all attribute configurations.");
        stringConcatenation28.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference15, (String)stringConcatenation28.toString());
        EReference eReference16 = PostprocessingHelpers.getReference((EClass)cls, (String)"ports");
        StringConcatenation stringConcatenation29 = new StringConcatenation();
        stringConcatenation29.append("This is a list of all port configurations.");
        stringConcatenation29.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference16, (String)stringConcatenation29.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"PortInstanceConfig");
        StringConcatenation stringConcatenation30 = new StringConcatenation();
        stringConcatenation30.append("This class models a configuration for an {@link org.eclipse.etrice.core.room.InterfaceItem interface item} (e.g. port instance).");
        stringConcatenation30.newLine();
        stringConcatenation30.append("The configuration defines values for this interface item and overrides the default values from the corresponding class config.");
        stringConcatenation30.newLine();
        stringConcatenation30.append("The values are applied at generation time.");
        stringConcatenation30.newLine();
        stringConcatenation30.append("The config sub elements are:");
        stringConcatenation30.newLine();
        stringConcatenation30.append("<ul>");
        stringConcatenation30.newLine();
        stringConcatenation30.append("\t");
        stringConcatenation30.append("<li>{@link AttrInstanceConfig attribute instance config}</li>");
        stringConcatenation30.newLine();
        stringConcatenation30.append("</ul>\t\t\t\t");
        stringConcatenation30.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation30.toString());
        EReference eReference17 = PostprocessingHelpers.getReference((EClass)cls, (String)"item");
        StringConcatenation stringConcatenation31 = new StringConcatenation();
        stringConcatenation31.append("This is the interface item.");
        stringConcatenation31.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference17, (String)stringConcatenation31.toString());
        EReference eReference18 = PostprocessingHelpers.getReference((EClass)cls, (String)"attributes");
        StringConcatenation stringConcatenation32 = new StringConcatenation();
        stringConcatenation32.append("This is a list of all attribute configurations.");
        stringConcatenation32.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference18, (String)stringConcatenation32.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"AttrConfig");
        StringConcatenation stringConcatenation33 = new StringConcatenation();
        stringConcatenation33.append("It is the super class of");
        stringConcatenation33.newLine();
        stringConcatenation33.append("<ul>");
        stringConcatenation33.newLine();
        stringConcatenation33.append("\t");
        stringConcatenation33.append("<li>{@link AttrClassConfig}</li>");
        stringConcatenation33.newLine();
        stringConcatenation33.append("\t");
        stringConcatenation33.append("<li>{@link AttrInstanceConfig}</li>");
        stringConcatenation33.newLine();
        stringConcatenation33.append("</ul>\t\t\t\t");
        stringConcatenation33.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation33.toString());
        EReference eReference19 = PostprocessingHelpers.getReference((EClass)cls, (String)"attribute");
        StringConcatenation stringConcatenation34 = new StringConcatenation();
        stringConcatenation34.append("This is the attribute.");
        stringConcatenation34.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference19, (String)stringConcatenation34.toString());
        EReference eReference20 = PostprocessingHelpers.getReference((EClass)cls, (String)"value");
        StringConcatenation stringConcatenation35 = new StringConcatenation();
        stringConcatenation35.append("This is the value of {@link #getAttribute attribute}.");
        stringConcatenation35.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference20, (String)stringConcatenation35.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"AttrClassConfig");
        StringConcatenation stringConcatenation36 = new StringConcatenation();
        stringConcatenation36.append("This class models a configuration for an {@link org.eclipse.etrice.core.room.Attribute attribute}.");
        stringConcatenation36.newLine();
        stringConcatenation36.append("The configuration defines a default value for all instances of the attribute.");
        stringConcatenation36.newLine();
        stringConcatenation36.append("The values are applied at generation time.");
        stringConcatenation36.newLine();
        stringConcatenation36.append("<br>If the type of the given {@link org.eclipse.etrice.core.config.AttrConfig#getAttribute attribute} is");
        stringConcatenation36.newLine();
        stringConcatenation36.append("<ul>");
        stringConcatenation36.newLine();
        stringConcatenation36.append("\t");
        stringConcatenation36.append("<li>primitive, then a {@link org.eclipse.etrice.core.config.AttrConfig#getValue value} might exist and {@link #getAttributes attributes} is empty</li>");
        stringConcatenation36.newLine();
        stringConcatenation36.append("\t");
        stringConcatenation36.append("<li>compound attribute (e.g. {@link org.eclipse.etrice.core.room.DataClass data class}), then {@link org.eclipse.etrice.core.config.AttrConfig#getValue value} is null and configurations for children {@link #getAttributes attributes} might exist</li>");
        stringConcatenation36.newLine();
        stringConcatenation36.append("</ul>\t\t\t\t");
        stringConcatenation36.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation36.toString());
        EReference eReference21 = PostprocessingHelpers.getReference((EClass)cls, (String)"attributes");
        StringConcatenation stringConcatenation37 = new StringConcatenation();
        stringConcatenation37.append("This is a list of attribute configurations of children attributes, in case the {@link org.eclipse.etrice.core.config.AttrConfig#getAttribute attribute} is compound.");
        stringConcatenation37.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference21, (String)stringConcatenation37.toString());
        EReference eReference22 = PostprocessingHelpers.getReference((EClass)cls, (String)"min");
        StringConcatenation stringConcatenation38 = new StringConcatenation();
        stringConcatenation38.append("This is the lower bound of {@link org.eclipse.etrice.core.config.AttrConfig#getValue value} , in case the {@link org.eclipse.etrice.core.config.AttrConfig#getAttribute attribute} has a numerical value.");
        stringConcatenation38.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference22, (String)stringConcatenation38.toString());
        EReference eReference23 = PostprocessingHelpers.getReference((EClass)cls, (String)"max");
        StringConcatenation stringConcatenation39 = new StringConcatenation();
        stringConcatenation39.append("This is the upper bound of {@link org.eclipse.etrice.core.config.AttrConfig#getValue value} , in case the {@link org.eclipse.etrice.core.config.AttrConfig#getAttribute attribute} has a numerical value.");
        stringConcatenation39.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference23, (String)stringConcatenation39.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"AttrInstanceConfig");
        StringConcatenation stringConcatenation40 = new StringConcatenation();
        stringConcatenation40.append("This class models a configuration for an {@link org.eclipse.etrice.core.room.Attribute attribute}.");
        stringConcatenation40.newLine();
        stringConcatenation40.append("The configuration defines values for this attribute instance and overrides the default values from the corresponding class config.");
        stringConcatenation40.newLine();
        stringConcatenation40.append("The values are applied at generation time.");
        stringConcatenation40.newLine();
        stringConcatenation40.append("<br>If the type of the given {@link org.eclipse.etrice.core.config.AttrConfig#getAttribute attribute} is");
        stringConcatenation40.newLine();
        stringConcatenation40.append("<ul>");
        stringConcatenation40.newLine();
        stringConcatenation40.append("\t");
        stringConcatenation40.append("<li>primitive, then a {@link org.eclipse.etrice.core.config.AttrConfig#getValue value} might exist and {@link #getAttributes attributes} is empty</li>");
        stringConcatenation40.newLine();
        stringConcatenation40.append("\t");
        stringConcatenation40.append("<li>compound attribute (e.g. {@link org.eclipse.etrice.core.room.DataClass data class}), then {@link org.eclipse.etrice.core.config.AttrConfig#getValue value} is null and configurations for children {@link #getAttributes attributes} might exist</li>");
        stringConcatenation40.newLine();
        stringConcatenation40.append("</ul>\t\t\t\t");
        stringConcatenation40.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation40.toString());
        EReference eReference24 = PostprocessingHelpers.getReference((EClass)cls, (String)"attributes");
        StringConcatenation stringConcatenation41 = new StringConcatenation();
        stringConcatenation41.append("This is a list of attribute configurations of children attributes, in case the {@link org.eclipse.etrice.core.config.AttrConfig#getAttribute attribute} is compound.");
        stringConcatenation41.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference24, (String)stringConcatenation41.toString());
        EAttribute eAttribute6 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"dynConfig");
        StringConcatenation stringConcatenation42 = new StringConcatenation();
        stringConcatenation42.append("If the dynamic configuration options is activated for this attribute, then the values are set at runtime by the means of the {@link DynamicConfig dynamic config}.");
        stringConcatenation42.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute6, (String)stringConcatenation42.toString());
        EAttribute eAttribute7 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"readOnly");
        StringConcatenation stringConcatenation43 = new StringConcatenation();
        stringConcatenation43.append("Controls the behavior of the dynamic configuration. If set to false, then {@link org.eclipse.etrice.core.config.AttrConfig#getValue value} is updated (overwritten) if changes occur in the external configuration, ");
        stringConcatenation43.newLine();
        stringConcatenation43.append("otherwise set to true, then changes in {@link org.eclipse.etrice.core.config.AttrConfig#getValue value} (that occur from within the system) are recorded to the external configuration.");
        stringConcatenation43.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute7, (String)stringConcatenation43.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"RefPath");
        StringConcatenation stringConcatenation44 = new StringConcatenation();
        stringConcatenation44.append("A path of strings that are interpreted as {@link org.eclipse.etrice.core.room.ActorRef}s starting at a {@link org.eclipse.etrice.core.room.SubSystemClass}.");
        stringConcatenation44.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation44.toString());
        EReference eReference25 = PostprocessingHelpers.getReference((EClass)cls, (String)"refs");
        StringConcatenation stringConcatenation45 = new StringConcatenation();
        stringConcatenation45.append("This is a path in the instance tree where each segment corresponds to the name of the");
        stringConcatenation45.newLine();
        stringConcatenation45.append("corresponding {@link {@link org.eclipse.etrice.core.room.ActorContainerRef}}.");
        stringConcatenation45.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference25, (String)stringConcatenation45.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"RefSegment");
        StringConcatenation stringConcatenation46 = new StringConcatenation();
        stringConcatenation46.append("A segment of a {@link RefPath}. It consists of a name and an optional index.");
        stringConcatenation46.newLine();
        stringConcatenation46.append("If the index is not set it will be {@code -1}.");
        stringConcatenation46.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation46.toString());
        EAttribute eAttribute8 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"ref");
        StringConcatenation stringConcatenation47 = new StringConcatenation();
        stringConcatenation47.append("The segment name corresponding to an actor reference.");
        stringConcatenation47.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute8, (String)stringConcatenation47.toString());
        EAttribute eAttribute9 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"idx");
        StringConcatenation stringConcatenation48 = new StringConcatenation();
        stringConcatenation48.append("The optional index of the reference (for replicated actors).");
        stringConcatenation48.newLine();
        stringConcatenation48.append("If not set the index is {@code -1}.");
        stringConcatenation48.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute9, (String)stringConcatenation48.toString());
    }
}

