/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.fsm.actioneditor.preferences;

import java.util.ArrayList;
import org.eclipse.etrice.ui.behavior.fsm.Activator;
import org.eclipse.etrice.ui.behavior.fsm.actioneditor.ActionCodeEditorRegistry;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ActionEditorPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String CHOOSE_EDITOR_LANGUAGE = "Choose editor language:";
    public static final String CHOOSE_JAVA_EDITOR = "Choose editor for Java:";
    public static final String CHOOSE_CPP_EDITOR = "Choose editor for C/C++:";

    public ActionEditorPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("A preference page for choosing action code editors for target languages.");
    }

    public void createFieldEditors() {
        this.addField((FieldEditor)new RadioGroupFieldEditor("org.eclipse.etrice.ui.behavior.actioneditor.preferences.language", CHOOSE_EDITOR_LANGUAGE, 1, (String[][])new String[][]{{"Java", "org.eclipse.etrice.ui.behavior.actioneditor.preferences.javalanguage"}, {"C/C++", "org.eclipse.etrice.ui.behavior.actioneditor.preferences.cpplanguage"}}, this.getFieldEditorParent()));
        this.addField((FieldEditor)new RadioGroupFieldEditor("org.eclipse.etrice.ui.behavior.actioneditor.preferences.javaeditor", CHOOSE_JAVA_EDITOR, 1, this.getChoicesForTargetLanguage("JAVA"), this.getFieldEditorParent()));
        this.addField((FieldEditor)new RadioGroupFieldEditor("org.eclipse.etrice.ui.behavior.actioneditor.preferences.cppeditor", CHOOSE_CPP_EDITOR, 1, this.getChoicesForTargetLanguage("C++"), this.getFieldEditorParent()));
    }

    private String[][] getChoicesForTargetLanguage(String targetLanguage) {
        ActionCodeEditorRegistry.ActionCodeEditorRegistryEntry[] editors = ActionCodeEditorRegistry.INSTANCE.getEditorsForTargetLanguage(targetLanguage);
        ArrayList<String[]> editorChoices = new ArrayList<String[]>();
        ActionCodeEditorRegistry.ActionCodeEditorRegistryEntry[] actionCodeEditorRegistryEntryArray = editors;
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            ActionCodeEditorRegistry.ActionCodeEditorRegistryEntry javaEditor = actionCodeEditorRegistryEntryArray[n2];
            String[] choice = new String[]{javaEditor.getName(), javaEditor.getId()};
            editorChoices.add(choice);
            ++n2;
        }
        return (String[][])editorChoices.toArray((T[])new String[editorChoices.size()][]);
    }

    public void init(IWorkbench workbench) {
    }
}

