/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ui.contentassist;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.etrice.core.common.base.AnnotationType;
import org.eclipse.etrice.core.common.base.BasePackage;
import org.eclipse.etrice.core.common.ui.contentassist.ImportModelAssist;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.naming.RoomNameProvider;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorInstanceMapping;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.RefPath;
import org.eclipse.etrice.core.room.RefSegment;
import org.eclipse.etrice.core.room.RoomAnnotationTargetEnum;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.StandardOperation;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.core.services.RoomGrammarAccess;
import org.eclipse.etrice.core.ui.contentassist.AbstractRoomProposalProvider;
import org.eclipse.etrice.core.ui.util.UIExpressionUtil;
import org.eclipse.etrice.expressions.detailcode.IDetailExpressionProvider;
import org.eclipse.etrice.expressions.ui.contentassist.RoomExpressionProposalProvider;
import org.eclipse.etrice.generator.base.io.IModelPath;
import org.eclipse.etrice.generator.base.io.IModelPathProvider;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.formatting.IWhitespaceInformationProvider;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.contentassist.AbstractContentProposalProvider;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class RoomProposalProvider
extends AbstractRoomProposalProvider {
    @Inject
    protected RoomHelpers roomHelpers;
    @Inject
    protected RoomNameProvider roomNameProvider;
    @Inject
    protected RoomGrammarAccess grammar;
    @Inject
    protected IModelPathProvider modelPathProvider;
    @Inject
    protected IWhitespaceInformationProvider whiteSpaceInfo;
    @Inject
    RoomExpressionProposalProvider expressionProposalAdapter;

    @Override
    public void complete_RoomModel(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        XtextResource resource = context.getResource();
        if (model == null || model.eContents().isEmpty()) {
            IModelPath modelPath = this.modelPathProvider.get((Resource)resource);
            Optional modelPathFQN = modelPath.getQualifiedName(resource.getURI());
            String modelName = modelPathFQN.map(fqn -> fqn.toString()).orElse(resource.getURI().trimFileExtension().lastSegment());
            String lineSep = this.whiteSpaceInfo.getLineSeparatorInformation(resource.getURI()).getLineSeparator();
            String indent = this.whiteSpaceInfo.getIndentationInformation(resource.getURI()).getIndentString();
            String proposalStr = "RoomModel " + modelName + " {" + lineSep + lineSep + indent + "import etrice.api.types.*" + lineSep + lineSep + indent + lineSep + "}";
            ICompletionProposal proposal = this.createCompletionProposal(proposalStr, "RoomModel - empty template", null, context);
            if (proposal instanceof ConfigurableCompletionProposal) {
                ConfigurableCompletionProposal configProposal = (ConfigurableCompletionProposal)proposal;
                configProposal.setSelectionStart(proposalStr.length() - (String.valueOf(lineSep) + "}").length());
                configProposal.setSelectionLength(1);
            }
            acceptor.accept(proposal);
        } else {
            super.complete_RoomModel(model, ruleCall, context, acceptor);
        }
    }

    public void completeKeyword(Keyword keyword, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (keyword == this.grammar.getVarDeclAccess().getVarargsVarargsKeyword_3_0()) {
            return;
        }
        super.completeKeyword(keyword, context, acceptor);
    }

    @Override
    public void completeActorRef_Type(final EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.lookupCrossReference((CrossReference)assignment.getTerminal(), context, acceptor, (Predicate)new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription candidate) {
                ActorRef ar = (ActorRef)model;
                if (!(ar.eContainer() instanceof ActorClass)) {
                    return true;
                }
                ActorClass ac = (ActorClass)ar.eContainer();
                EObject objectOrProxy = candidate.getEObjectOrProxy();
                if (objectOrProxy instanceof ActorClass) {
                    ActorClass referenced = (ActorClass)objectOrProxy;
                    return !RoomProposalProvider.this.roomHelpers.isReferencing(referenced, ac);
                }
                return false;
            }
        });
    }

    public void completeImport_ImportedNamespace(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.lookupImportedNamespace(model, context, acceptor, new EClass[]{RoomPackage.eINSTANCE.getRoomClass(), BasePackage.eINSTANCE.getAnnotationType()});
    }

    public void completeImport_ImportURI(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ImportModelAssist.addPaths((AbstractContentProposalProvider)this, (ContentAssistContext)context, (ICompletionProposalAcceptor)acceptor, (String)".room");
    }

    @Override
    public void completeActorInstanceMapping_Path(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeActorInstanceMapping_Path(model, assignment, context, acceptor);
        List<ActorRef> instances = this.collectInstances((ActorInstanceMapping)model);
        for (ActorRef instance : instances) {
            acceptor.accept(this.createCompletionProposal(instance.getName(), context));
        }
    }

    @Override
    public void completeRefPath_Refs(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeRefPath_Refs(model, assignment, context, acceptor);
        if (model instanceof ActorInstanceMapping) {
            this.completeActorInstanceMapping_Path(model, assignment, context, acceptor);
            return;
        }
        RefPath path = (RefPath)model;
        if (path.eContainer() instanceof ActorInstanceMapping) {
            List<ActorRef> instances = this.collectInstances((ActorInstanceMapping)path.eContainer());
            for (ActorRef instance : instances) {
                acceptor.accept(this.createCompletionProposal(instance.getName(), context));
            }
        }
    }

    public void complete_AnnotationTargetType(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        BasicEList existingTargets = new BasicEList();
        if (model instanceof AnnotationType) {
            existingTargets.addAll((Collection)((AnnotationType)model).getTargets());
        }
        RoomAnnotationTargetEnum[] roomAnnotationTargetEnumArray = RoomAnnotationTargetEnum.values();
        int n = roomAnnotationTargetEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            RoomAnnotationTargetEnum t = roomAnnotationTargetEnumArray[n2];
            String targetName = t.getLiteral();
            if (!existingTargets.isEmpty() && !existingTargets.contains((Object)targetName)) {
                acceptor.accept(this.createCompletionProposal(targetName, context));
            }
            ++n2;
        }
    }

    public void complete_ID(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model instanceof StandardOperation) {
            StandardOperation op = (StandardOperation)model;
            List superOps = Lists.newArrayList();
            RoomClass roomClass = this.roomHelpers.getRoomClass((EObject)op);
            if (roomClass instanceof ActorClass && ((ActorClass)roomClass).getActorBase() != null) {
                superOps = this.roomHelpers.getLatestOperations(((ActorClass)roomClass).getActorBase());
            } else if (roomClass instanceof DataClass && ((DataClass)roomClass).getBase() != null) {
                superOps = this.roomHelpers.getLatestOperations(((DataClass)roomClass).getBase());
            }
            for (Operation superOp : superOps) {
                String signature = this.roomNameProvider.getSignature(superOp);
                String superClassName = this.roomHelpers.getRoomClass((EObject)superOp).getName();
                acceptor.accept(this.createCompletionProposal(signature, String.valueOf(signature) + " - " + superClassName, this.getImage((EObject)superOp), context));
            }
        }
        super.complete_ID(model, ruleCall, context, acceptor);
    }

    private List<ActorRef> collectInstances(ActorInstanceMapping aim) {
        ArrayList<ActorRef> refs = new ArrayList<ActorRef>();
        ActorContainerClass root = this.roomHelpers.getParentContainer(aim);
        if (root != null) {
            RefPath path = aim.getPath();
            if (path != null && !path.getRefs().isEmpty() && path.getRefs().get(0) != null && ((RefSegment)path.getRefs().get(0)).getRef() != null) {
                root = this.roomHelpers.getActorContainerClass(aim);
            }
            if (root != null) {
                for (ActorContainerRef ref : this.roomHelpers.getRefs((StructureClass)root, true)) {
                    ActorRef aRef;
                    if (!(ref instanceof ActorRef) || (aRef = (ActorRef)ref).getMultiplicity() != 1) continue;
                    refs.add((ActorRef)ref);
                }
            }
        }
        return refs;
    }

    public void complete_CC_STRING(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (context.getCurrentNode().getSemanticElement() instanceof DetailCode) {
            String text = context.getCurrentNode().getText();
            int localOffset = context.getOffset() - context.getCurrentNode().getOffset();
            int globalOffset = context.getOffset();
            DetailCode detailCode = (DetailCode)context.getCurrentNode().getSemanticElement();
            IDetailExpressionProvider exprPovider = UIExpressionUtil.getExpressionProvider(detailCode);
            for (ICompletionProposal proposal : this.expressionProposalAdapter.createProposals(exprPovider, text, localOffset, globalOffset)) {
                acceptor.accept(proposal);
            }
        }
        super.complete_CC_STRING(model, ruleCall, context, acceptor);
    }
}

