/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.stickyscroll;

import java.time.Duration;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.Throttler;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.texteditor.stickyscroll.StickyLine;
import org.eclipse.ui.internal.texteditor.stickyscroll.StickyLinesProvider;
import org.eclipse.ui.internal.texteditor.stickyscroll.StickyScrollingControl;
import org.eclipse.ui.internal.texteditor.stickyscroll.StickyScrollingControlSettings;

public class StickyScrollingHandler
implements IViewportListener {
    private static final int THROTTLER_DELAY = 100;
    private ISourceViewer sourceViewer;
    private StickyScrollingControl stickyScrollingControl;
    private int tabWidth;
    private IPropertyChangeListener propertyChangeListener;
    private IPreferenceStore preferenceStore;
    private StickyLinesProvider stickyLinesProvider;
    private Throttler throttler;
    private int verticalOffset;

    public StickyScrollingHandler(ISourceViewer sourceViewer, IVerticalRuler verticalRuler, IPreferenceStore preferenceStore) {
        this(sourceViewer, verticalRuler, preferenceStore, new StickyLinesProvider());
    }

    public StickyScrollingHandler(ISourceViewer sourceViewer, IVerticalRuler verticalRuler, IPreferenceStore preferenceStore, StickyLinesProvider stickyLinesProvider) {
        this.sourceViewer = sourceViewer;
        this.throttler = new Throttler(sourceViewer.getTextWidget().getDisplay(), Duration.ofMillis(100L), this::calculateAndShowStickyLines);
        this.stickyLinesProvider = stickyLinesProvider;
        StickyScrollingControlSettings settings = this.loadAndListenForProperties(preferenceStore);
        this.stickyScrollingControl = new StickyScrollingControl(sourceViewer, verticalRuler, settings, this);
        sourceViewer.addViewportListener((IViewportListener)this);
    }

    private StickyScrollingControlSettings loadAndListenForProperties(IPreferenceStore store) {
        this.preferenceStore = store;
        this.propertyChangeListener = e -> {
            if ((e.getProperty().equals("tabWidth") || e.getProperty().equals("stickyScrollingMaximumCount") || e.getProperty().equals("currentLineColor") || e.getProperty().equals("lineNumberRuler") || e.getProperty().equals("org.eclipse.ui.editors.stickyLinesSeparatorColor")) && this.stickyScrollingControl != null && !this.sourceViewer.getTextWidget().isDisposed()) {
                StickyScrollingControlSettings settings = this.loadSettings(this.preferenceStore);
                this.stickyScrollingControl.applySettings(settings);
                this.stickyLinesProvider.setTabWidth(this.tabWidth);
            }
        };
        store.addPropertyChangeListener(this.propertyChangeListener);
        return this.loadSettings(store);
    }

    private StickyScrollingControlSettings loadSettings(IPreferenceStore store) {
        this.tabWidth = store.getInt("tabWidth");
        int stickyScrollingMaxCount = store.getInt("stickyScrollingMaximumCount");
        Color lineNumberColor = new Color(PreferenceConverter.getColor((IPreferenceStore)store, (String)"lineNumberColor"));
        this.sourceViewer.getTextWidget().addDisposeListener(e -> lineNumberColor.dispose());
        Color stickyLineHoverColor = new Color(PreferenceConverter.getColor((IPreferenceStore)store, (String)"currentLineColor"));
        this.sourceViewer.getTextWidget().addDisposeListener(e -> stickyLineHoverColor.dispose());
        Color stickyLineBackgroundColor = this.sourceViewer.getTextWidget().getBackground();
        boolean showLineNumbers = store.getBoolean("lineNumberRuler");
        Color stickyLineSeparatorColor = null;
        if (EditorsPlugin.getDefault() != null) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"org.eclipse.ui.editors.stickyLinesSeparatorColor");
            ISharedTextColors sharedTextColors = EditorsPlugin.getDefault().getSharedTextColors();
            stickyLineSeparatorColor = sharedTextColors.getColor(rgb);
        }
        return new StickyScrollingControlSettings(stickyScrollingMaxCount, lineNumberColor, stickyLineHoverColor, stickyLineBackgroundColor, stickyLineSeparatorColor, showLineNumbers);
    }

    public void viewportChanged(int newVerticalOffset) {
        if (this.verticalOffset == newVerticalOffset) {
            return;
        }
        this.verticalOffset = newVerticalOffset;
        this.throttler.throttledExec();
    }

    private void calculateAndShowStickyLines() {
        List<StickyLine> stickyLines = this.stickyLinesProvider.get(this.verticalOffset, this.sourceViewer);
        this.stickyScrollingControl.setStickyLines(stickyLines);
    }

    public void uninstall() {
        this.sourceViewer.removeViewportListener((IViewportListener)this);
        this.preferenceStore.removePropertyChangeListener(this.propertyChangeListener);
        this.preferenceStore = null;
        this.throttler = null;
        this.stickyScrollingControl.dispose();
    }
}

