/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.generator.parser;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.setext.generator.parser.GrammarItemsMap;
import org.eclipse.escet.setext.generator.parser.LookaheadItem;
import org.eclipse.escet.setext.parser.ast.Symbol;
import org.eclipse.escet.setext.parser.ast.parser.NonTerminal;
import org.eclipse.escet.setext.parser.ast.parser.ParserRule;
import org.eclipse.escet.setext.parser.ast.parser.ParserRulePart;

public class GrammarItem {
    public final NonTerminal nonterminal;
    public final ParserRule rule;
    public final int progress;

    public GrammarItem(NonTerminal nonterminal, ParserRule rule, int progress) {
        this.nonterminal = nonterminal;
        this.rule = rule;
        this.progress = progress;
    }

    public boolean isKernelItem() {
        return !this.isBefore() || this.isInitialItem();
    }

    public boolean isInitialItem() {
        return this.progress == 0 && this.nonterminal.isAugmentedStartSymbol();
    }

    public boolean isBefore() {
        return this.progress == 0;
    }

    public boolean isAfter() {
        return this.progress == this.rule.symbols.size();
    }

    public Symbol getNextSymbol() {
        if (this.isAfter()) {
            throw new IllegalStateException();
        }
        return ((ParserRulePart)this.rule.symbols.get((int)this.progress)).symbol;
    }

    public GrammarItem getNextItem(GrammarItemsMap itemsMap) {
        if (this.isAfter()) {
            throw new IllegalStateException();
        }
        return (GrammarItem)((List)((Map)itemsMap.get(this.nonterminal)).get(this.rule)).get(this.progress + 1);
    }

    public List<Symbol> remainder() {
        List rslt = Lists.listc((int)(this.rule.symbols.size() - this.progress));
        int i = this.progress;
        while (i < this.rule.symbols.size()) {
            rslt.add(((ParserRulePart)this.rule.symbols.get((int)i)).symbol);
            ++i;
        }
        return rslt;
    }

    public List<Symbol> remainderAfterNext() {
        if (this.isAfter()) {
            throw new IllegalStateException();
        }
        List rslt = Lists.listc((int)(this.rule.symbols.size() - this.progress - 1));
        int i = this.progress + 1;
        while (i < this.rule.symbols.size()) {
            rslt.add(((ParserRulePart)this.rule.symbols.get((int)i)).symbol);
            ++i;
        }
        return rslt;
    }

    public LookaheadItem toLookaheadItem() {
        Set lookaheads = Sets.set();
        return new LookaheadItem(this, lookaheads);
    }

    public String toString() {
        StringBuilder rslt = new StringBuilder();
        rslt.append("[");
        rslt.append(this.nonterminal.name.toString());
        rslt.append(" :");
        int i = 0;
        while (i < this.rule.symbols.size()) {
            if (i == this.progress) {
                rslt.append(" .");
            }
            rslt.append(" " + ((ParserRulePart)this.rule.symbols.get((int)i)).name);
            ++i;
        }
        if (this.isAfter()) {
            rslt.append(" .");
        }
        rslt.append("]");
        return rslt.toString();
    }
}

