/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.jdt.internal.corext.fix.ConvertLoopOperation;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroupCore;
import org.eclipse.jdt.internal.corext.fix.Messages;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.text.edits.TextEditGroup;

public final class ConvertIterableLoopOperation
extends ConvertLoopOperation {
    private static final StatusInfo SEMANTIC_CHANGE_WARNING_STATUS = new StatusInfo(2, FixMessages.ConvertIterableLoopOperation_semanticChangeWarning);
    private boolean fAssigned;
    private IBinding fElementVariable;
    private Expression fExpression;
    private IBinding fIterable;
    private boolean fThis;
    private IVariableBinding fIteratorVariable;
    private final List<Expression> fOccurrences = new ArrayList<Expression>(2);
    private EnhancedForStatement fEnhancedForLoop;
    private boolean fMakeFinal;
    private boolean fCheckIfVarUsed;
    private boolean fElementVariableReferenced;

    private static ITypeBinding getSuperType(ITypeBinding binding, String name) {
        ITypeBinding result;
        if (binding.isArray() || binding.isPrimitive()) {
            return null;
        }
        if (binding.getErasure().getQualifiedName().equals(name)) {
            return binding;
        }
        ITypeBinding type = binding.getSuperclass();
        if (type != null && (result = ConvertIterableLoopOperation.getSuperType(type, name)) != null) {
            return result;
        }
        ITypeBinding[] iTypeBindingArray = binding.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding type2 = iTypeBindingArray[n2];
            ITypeBinding result2 = ConvertIterableLoopOperation.getSuperType(type2, name);
            if (result2 != null) {
                return result2;
            }
            ++n2;
        }
        return null;
    }

    public ConvertIterableLoopOperation(ForStatement statement) {
        this(statement, new String[0], false, false);
    }

    public ConvertIterableLoopOperation(ForStatement statement, String[] usedNames, boolean makeFinal, boolean checkIfVarUsed) {
        super(statement, usedNames);
        this.fMakeFinal = makeFinal;
        this.fCheckIfVarUsed = checkIfVarUsed;
    }

    @Override
    public String getIntroducedVariableName() {
        if (this.fElementVariable != null) {
            return this.fElementVariable.getName();
        }
        return this.getVariableNameProposals()[0];
    }

    private String[] getVariableNameProposals() {
        String[] variableNames = this.getUsedVariableNames();
        String baseName = "element";
        if (this.fExpression != null) {
            if (this.fExpression instanceof SimpleName) {
                baseName = ConvertLoopOperation.modifyBaseName(((SimpleName)this.fExpression).getFullyQualifiedName());
            } else if (this.fExpression instanceof QualifiedName) {
                baseName = ConvertLoopOperation.modifyBaseName(((QualifiedName)this.fExpression).getName().getFullyQualifiedName());
            }
        }
        String[] elementSuggestions = StubUtility.getLocalNameSuggestions(this.getJavaProject(), baseName, 0, variableNames);
        ITypeBinding binding = this.fIteratorVariable.getType();
        if (binding != null && binding.isParameterizedType()) {
            String type = binding.getTypeArguments()[0].getName();
            String[] typeSuggestions = StubUtility.getLocalNameSuggestions(this.getJavaProject(), type, 0, variableNames);
            String[] result = new String[elementSuggestions.length + typeSuggestions.length];
            String[] first = typeSuggestions;
            String[] second = elementSuggestions;
            if (!"element".equals(baseName)) {
                first = elementSuggestions;
                second = typeSuggestions;
            }
            System.arraycopy(first, 0, result, 0, first.length);
            System.arraycopy(second, 0, result, first.length, second.length);
            return result;
        }
        return elementSuggestions;
    }

    private IJavaProject getJavaProject() {
        return this.getRoot().getJavaElement().getJavaProject();
    }

    private CompilationUnit getRoot() {
        return (CompilationUnit)this.getForStatement().getRoot();
    }

    private Expression getExpression(ASTRewrite rewrite) {
        if (this.fThis) {
            return rewrite.getAST().newThisExpression();
        }
        if (this.fExpression instanceof MethodInvocation) {
            return (MethodInvocation)rewrite.createMoveTarget((ASTNode)this.fExpression);
        }
        return (Expression)ASTNode.copySubtree((AST)rewrite.getAST(), (ASTNode)this.fExpression);
    }

    private ITypeBinding getElementType(ITypeBinding iterator) {
        ITypeBinding[] bindings;
        if (iterator != null && (bindings = iterator.getTypeArguments()).length > 0) {
            ITypeBinding arg = bindings[0];
            if (arg.isWildcardType()) {
                arg = ASTResolving.normalizeWildcardType(arg, true, this.getRoot().getAST());
            }
            return arg;
        }
        return this.getRoot().getAST().resolveWellKnownType(Object.class.getCanonicalName());
    }

    @Override
    protected Statement convert(final CompilationUnitRewrite cuRewrite, final TextEditGroup group, LinkedProposalModelCore positionGroups) throws CoreException {
        final AST ast = cuRewrite.getAST();
        final ASTRewrite astRewrite = cuRewrite.getASTRewrite();
        ImportRewrite importRewrite = cuRewrite.getImportRewrite();
        final ImportRemover remover = cuRewrite.getImportRemover();
        this.fEnhancedForLoop = ast.newEnhancedForStatement();
        String[] names = this.getVariableNameProposals();
        String name = this.fElementVariable != null ? this.fElementVariable.getName() : names[0];
        final LinkedProposalPositionGroupCore pg = positionGroups.getPositionGroup(name, true);
        if (this.fElementVariable != null) {
            pg.addProposal(name, 10);
        }
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name2 = stringArray[n2];
            pg.addProposal(name2, 10);
            ++n2;
        }
        Statement body = this.getForStatement().getBody();
        final List commentList = this.getRoot().getCommentList();
        if (body != null) {
            ListRewrite list;
            if (body instanceof Block) {
                list = astRewrite.getListRewrite((ASTNode)body, Block.STATEMENTS_PROPERTY);
                for (Expression expression : this.fOccurrences) {
                    Statement parent = ASTNodes.getParent((ASTNode)expression, Statement.class);
                    this.removeorReplaceStatementByTrailingComments(cuRewrite, group, astRewrite, remover, commentList, parent);
                }
            } else {
                list = null;
            }
            final String text = name;
            body.accept(new ASTVisitor(){

                private boolean replace(Expression expression) {
                    SimpleName node = ast.newSimpleName(text);
                    ASTNodes.replaceButKeepComment(astRewrite, (ASTNode)expression, (ASTNode)node, group);
                    remover.registerRemovedNode((ASTNode)expression);
                    this.checkChildOperations(expression, node);
                    pg.addPosition(astRewrite.track((ASTNode)node), false);
                    return false;
                }

                private void checkChildOperations(Expression newExpression, SimpleName node) {
                    ConvertLoopOperation child = ConvertIterableLoopOperation.this.getChildLoopOperation();
                    while (child != null) {
                        Expression exp;
                        if (child instanceof ConvertIterableLoopOperation && newExpression.subtreeMatch(new ASTMatcher(), (Object)(exp = ((ConvertIterableLoopOperation)child).getExpression()))) {
                            ((ConvertIterableLoopOperation)child).setExpression((Expression)node);
                        }
                        child = child.getChildLoopOperation();
                    }
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean visit(MethodInvocation node) {
                    IMethodBinding binding = node.resolveMethodBinding();
                    if (binding == null || !"next".equals(binding.getName()) && !"nextElement".equals(binding.getName())) return super.visit(node);
                    Expression expression = node.getExpression();
                    if (expression instanceof Name) {
                        IBinding result = ((Name)expression).resolveBinding();
                        if (result == null || !result.equals((Object)ConvertIterableLoopOperation.this.fIteratorVariable)) return super.visit(node);
                        List siblingNodes = Optional.ofNullable(ASTNodes.getParent((ASTNode)node, Statement.class)).map(it -> ASTNodes.getChildren((ASTNode)it)).orElse(new ArrayList());
                        if (!siblingNodes.stream().allMatch(arg_0 -> ((MethodInvocation)node).equals(arg_0))) return this.replace((Expression)node);
                        Statement parentStatement = ASTNodes.getParent((ASTNode)node, Statement.class);
                        ConvertIterableLoopOperation.this.removeorReplaceStatementByTrailingComments(cuRewrite, group, astRewrite, remover, commentList, parentStatement);
                        return super.visit(node);
                    } else {
                        IVariableBinding result;
                        if (!(expression instanceof FieldAccess) || (result = ((FieldAccess)expression).resolveFieldBinding()) == null || !result.equals((Object)ConvertIterableLoopOperation.this.fIteratorVariable)) return super.visit(node);
                        return this.replace((Expression)node);
                    }
                }

                public final boolean visit(SimpleName node) {
                    Statement parent;
                    IBinding binding;
                    if (ConvertIterableLoopOperation.this.fElementVariable != null && (binding = node.resolveBinding()) != null && binding.equals((Object)ConvertIterableLoopOperation.this.fElementVariable) && (parent = ASTNodes.getParent((ASTNode)node, Statement.class)) != null && (list == null || list.getRewrittenList().contains(parent))) {
                        pg.addPosition(astRewrite.track((ASTNode)node), false);
                    }
                    return false;
                }
            });
            this.fEnhancedForLoop.setBody(this.getBody(cuRewrite, group, positionGroups));
        }
        SingleVariableDeclaration declaration = ast.newSingleVariableDeclaration();
        SimpleName simple = ast.newSimpleName(name);
        pg.addPosition(astRewrite.track((ASTNode)simple), true);
        declaration.setName(simple);
        ITypeBinding elementType = this.getElementType(this.fIteratorVariable.getType());
        Type importType = this.importType(elementType, (ASTNode)this.getForStatement(), importRewrite, this.getRoot(), ImportRewrite.TypeLocation.LOCAL_VARIABLE);
        remover.registerAddedImports(importType);
        declaration.setType(importType);
        if (this.fMakeFinal) {
            ModifierRewrite.create(astRewrite, (ASTNode)declaration).setModifiers(16, 0, group);
        }
        remover.registerAddedImport(elementType.getQualifiedName());
        this.fEnhancedForLoop.setParameter(declaration);
        this.fEnhancedForLoop.setExpression(this.getExpression(astRewrite));
        for (Object node : this.getForStatement().initializers()) {
            if (node instanceof VariableDeclarationExpression) {
                VariableDeclarationExpression variableDeclarationExpression = (VariableDeclarationExpression)node;
                remover.registerRemovedNode((ASTNode)variableDeclarationExpression.getType());
                continue;
            }
            remover.registerRemovedNode((ASTNode)node);
        }
        for (Object object : this.getForStatement().updaters()) {
            remover.registerRemovedNode((ASTNode)object);
        }
        return this.fEnhancedForLoop;
    }

    private void removeorReplaceStatementByTrailingComments(CompilationUnitRewrite cuRewrite, TextEditGroup group, ASTRewrite astRewrite, ImportRemover remover, List<Comment> commentList, Statement parent) {
        if (parent != null && parent.getParent() instanceof Block) {
            ListRewrite innerList = astRewrite.getListRewrite(parent.getParent(), Block.STATEMENTS_PROPERTY);
            ArrayList<ASTNode> newComments = new ArrayList<ASTNode>();
            for (Comment comment : commentList) {
                String commentString;
                CompilationUnit cu = (CompilationUnit)parent.getRoot();
                if (comment.getStartPosition() < cu.getExtendedStartPosition((ASTNode)parent) || comment.getStartPosition() + comment.getLength() >= parent.getStartPosition()) continue;
                try {
                    commentString = cuRewrite.getCu().getBuffer().getText(comment.getStartPosition(), comment.getLength());
                }
                catch (IndexOutOfBoundsException | JavaModelException e) {
                    commentString = "";
                }
                ASTNode newComment = astRewrite.createStringPlaceholder(commentString, comment.isBlockComment() ? 64 : 63);
                newComments.add(newComment);
            }
            if (!newComments.isEmpty()) {
                ASTNode lastComment = (ASTNode)newComments.get(0);
                innerList.replace((ASTNode)parent, lastComment, group);
                int i = 1;
                while (i < newComments.size()) {
                    ASTNode nextComment = (ASTNode)newComments.get(i);
                    innerList.insertAfter(nextComment, lastComment, group);
                    lastComment = nextComment;
                    ++i;
                }
            } else {
                innerList.remove((ASTNode)parent, group);
            }
            remover.registerRemovedNode((ASTNode)parent);
        }
    }

    public Expression getExpression() {
        return this.fExpression;
    }

    public void setExpression(Expression exp) {
        this.fExpression = exp;
    }

    @Override
    public IStatus satisfiesPreconditions() {
        IStatus resultStatus = StatusInfo.OK_STATUS;
        if (JavaModelUtil.is50OrHigher(this.getJavaProject())) {
            ASTNode root;
            resultStatus = this.checkExpressionCondition();
            if (resultStatus.getSeverity() == 4) {
                return resultStatus;
            }
            List updateExpressions = this.getForStatement().updaters();
            if (updateExpressions.size() == 1) {
                resultStatus = new StatusInfo(2, Messages.format(FixMessages.ConvertIterableLoopOperation_RemoveUpdateExpression_Warning, BasicElementLabels.getJavaCodeString(((Expression)updateExpressions.get(0)).toString())));
            } else if (updateExpressions.size() > 1) {
                resultStatus = new StatusInfo(2, FixMessages.ConvertIterableLoopOperation_RemoveUpdateExpressions_Warning);
            }
            for (Object outer : this.getForStatement().initializers()) {
                ITypeBinding superBinding;
                IMethodBinding methodBinding;
                ITypeBinding returnType;
                ITypeBinding type;
                if (!(outer instanceof VariableDeclarationExpression)) continue;
                VariableDeclarationExpression declaration = (VariableDeclarationExpression)outer;
                List fragments = declaration.fragments();
                if (fragments.size() != 1) {
                    return new StatusInfo(4, "");
                }
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
                IVariableBinding binding = fragment.resolveBinding();
                if (binding == null || (type = binding.getType()) == null) continue;
                ITypeBinding iterator = ConvertIterableLoopOperation.getSuperType(type, Iterator.class.getCanonicalName());
                if (iterator == null) {
                    iterator = ConvertIterableLoopOperation.getSuperType(type, Enumeration.class.getCanonicalName());
                }
                if (iterator == null) continue;
                this.fIteratorVariable = binding;
                MethodInvocation method = ASTNodes.as(fragment.getInitializer(), MethodInvocation.class);
                if (method == null || method.resolveMethodBinding() == null || (returnType = (methodBinding = method.resolveMethodBinding()).getReturnType()) == null) continue;
                String qualified = returnType.getErasure().getQualifiedName();
                ITypeBinding returnElementType = this.getElementType(returnType);
                ITypeBinding variableElementType = this.getElementType(this.fIteratorVariable.getType());
                if (returnElementType == null || variableElementType == null || !returnElementType.isAssignmentCompatible(variableElementType) || !"java.util.Iterator".equals(qualified) && !"java.util.Enumeration".equals(qualified)) continue;
                Expression qualifier = method.getExpression();
                if (qualifier != null) {
                    ITypeBinding iterable;
                    ITypeBinding resolved = qualifier.resolveTypeBinding();
                    if (resolved == null || (iterable = ConvertIterableLoopOperation.getSuperType(resolved, Iterable.class.getCanonicalName())) == null) continue;
                    this.fExpression = qualifier;
                    this.fIterable = resolved;
                    continue;
                }
                ITypeBinding declaring = methodBinding.getDeclaringClass();
                if (declaring == null || (superBinding = ConvertIterableLoopOperation.getSuperType(declaring, Iterable.class.getCanonicalName())) == null) continue;
                this.fIterable = superBinding;
                this.fThis = true;
            }
            Statement statement = this.getForStatement().getBody();
            if (statement != null && this.fIteratorVariable != null) {
                final boolean[] otherInvocationThenNext = new boolean[1];
                final int[] nextInvocationCount = new int[1];
                final ITypeBinding elementType = this.getElementType(this.fIteratorVariable.getType());
                statement.accept(new ASTVisitor(){

                    public boolean visit(SimpleName node) {
                        IBinding nodeBinding = node.resolveBinding();
                        if (ConvertIterableLoopOperation.this.fElementVariable != null && ConvertIterableLoopOperation.this.fElementVariable.equals((Object)nodeBinding)) {
                            ConvertIterableLoopOperation.this.fMakeFinal = false;
                        }
                        if (nodeBinding == ConvertIterableLoopOperation.this.fIteratorVariable) {
                            MethodInvocation invocation;
                            String name;
                            if (node.getLocationInParent() == MethodInvocation.EXPRESSION_PROPERTY && ("next".equals(name = (invocation = (MethodInvocation)node.getParent()).getName().getIdentifier()) || "nextElement".equals(name))) {
                                nextInvocationCount[0] = nextInvocationCount[0] + 1;
                                Expression left = null;
                                if (invocation.getLocationInParent() == Assignment.RIGHT_HAND_SIDE_PROPERTY) {
                                    left = ((Assignment)invocation.getParent()).getLeftHandSide();
                                } else if (invocation.getLocationInParent() == VariableDeclarationFragment.INITIALIZER_PROPERTY) {
                                    VariableDeclarationExpression varexp;
                                    VariableDeclarationFragment fragment = (VariableDeclarationFragment)invocation.getParent();
                                    if (fragment.getParent() instanceof VariableDeclarationExpression && (varexp = (VariableDeclarationExpression)fragment.getParent()).getLocationInParent() == TryStatement.RESOURCES2_PROPERTY) {
                                        ConvertIterableLoopOperation.this.fElementVariableReferenced = true;
                                        return true;
                                    }
                                    left = fragment.getName();
                                }
                                return this.visitElementVariable(left);
                            }
                            otherInvocationThenNext[0] = true;
                        }
                        return true;
                    }

                    private boolean visitElementVariable(Expression node) {
                        ITypeBinding binding;
                        if (node != null && (binding = node.resolveTypeBinding()) != null && elementType.equals((Object)binding)) {
                            FieldAccess access;
                            IVariableBinding result;
                            if (node instanceof Name) {
                                Name name = (Name)node;
                                IBinding result2 = name.resolveBinding();
                                if (result2 != null) {
                                    ConvertIterableLoopOperation.this.fOccurrences.add(node);
                                    ConvertIterableLoopOperation.this.fElementVariable = result2;
                                    return false;
                                }
                            } else if (node instanceof FieldAccess && (result = (access = (FieldAccess)node).resolveFieldBinding()) != null) {
                                ConvertIterableLoopOperation.this.fOccurrences.add(node);
                                ConvertIterableLoopOperation.this.fElementVariable = result;
                                return false;
                            }
                        }
                        return true;
                    }
                });
                if (otherInvocationThenNext[0] || nextInvocationCount[0] > 1) {
                    return ERROR_STATUS;
                }
                if (this.fElementVariable != null) {
                    final String elementVarName = this.fElementVariable.getName();
                    statement.accept(new ASTVisitor(){

                        public final boolean visit(VariableDeclarationFragment node) {
                            SimpleName name;
                            if (node.getInitializer() instanceof NullLiteral && elementType.equals((Object)(name = node.getName()).resolveTypeBinding()) && ConvertIterableLoopOperation.this.fElementVariable.equals((Object)name.resolveBinding())) {
                                ConvertIterableLoopOperation.this.fOccurrences.add((Expression)name);
                            }
                            return true;
                        }

                        public final boolean visit(SimpleName node) {
                            StructuralPropertyDescriptor location;
                            IBinding binding;
                            if (ConvertIterableLoopOperation.this.fCheckIfVarUsed && !ConvertIterableLoopOperation.this.fElementVariableReferenced && node.getFullyQualifiedName().equals(elementVarName) && (binding = node.resolveBinding()) != null && binding.equals((Object)ConvertIterableLoopOperation.this.fElementVariable) && (location = node.getLocationInParent()) != VariableDeclarationFragment.NAME_PROPERTY) {
                                ConvertIterableLoopOperation.this.fElementVariableReferenced = true;
                            }
                            return true;
                        }
                    });
                }
            }
            if ((root = this.getForStatement().getRoot()) != null) {
                root.accept(new ASTVisitor(){

                    public final boolean visit(ForStatement node) {
                        return !node.equals((Object)ConvertIterableLoopOperation.this.getForStatement());
                    }

                    public final boolean visit(SimpleName node) {
                        IBinding binding = node.resolveBinding();
                        if (binding != null && binding.equals((Object)ConvertIterableLoopOperation.this.fElementVariable)) {
                            ConvertIterableLoopOperation.this.fAssigned = true;
                        }
                        return false;
                    }
                });
            }
        }
        if (!(this.fExpression == null && !this.fThis || this.fIterable == null || this.fIteratorVariable == null || this.fAssigned || !this.fElementVariableReferenced && this.fCheckIfVarUsed)) {
            return resultStatus;
        }
        return ERROR_STATUS;
    }

    private IStatus checkExpressionCondition() {
        Expression expression = this.getForStatement().getExpression();
        if (!(expression instanceof MethodInvocation)) {
            return SEMANTIC_CHANGE_WARNING_STATUS;
        }
        MethodInvocation invoc = (MethodInvocation)expression;
        IMethodBinding methodBinding = invoc.resolveMethodBinding();
        if (methodBinding == null) {
            return ERROR_STATUS;
        }
        ITypeBinding declaringClass = methodBinding.getDeclaringClass();
        if (declaringClass == null) {
            return ERROR_STATUS;
        }
        String qualifiedName = declaringClass.getErasure().getQualifiedName();
        String methodName = invoc.getName().getIdentifier();
        if (Enumeration.class.getCanonicalName().equals(qualifiedName)) {
            if (!"hasMoreElements".equals(methodName)) {
                return SEMANTIC_CHANGE_WARNING_STATUS;
            }
        } else {
            if (Iterator.class.getCanonicalName().equals(qualifiedName)) {
                if (!"hasNext".equals(methodName)) {
                    return SEMANTIC_CHANGE_WARNING_STATUS;
                }
                return this.checkIteratorCondition();
            }
            return SEMANTIC_CHANGE_WARNING_STATUS;
        }
        return StatusInfo.OK_STATUS;
    }

    private IStatus checkIteratorCondition() {
        List initializers = this.getForStatement().initializers();
        if (initializers.size() != 1) {
            return SEMANTIC_CHANGE_WARNING_STATUS;
        }
        Expression expression = (Expression)initializers.get(0);
        if (!(expression instanceof VariableDeclarationExpression)) {
            return SEMANTIC_CHANGE_WARNING_STATUS;
        }
        VariableDeclarationExpression declaration = (VariableDeclarationExpression)expression;
        List variableDeclarationFragments = declaration.fragments();
        if (variableDeclarationFragments.size() != 1) {
            return SEMANTIC_CHANGE_WARNING_STATUS;
        }
        VariableDeclarationFragment declarationFragment = (VariableDeclarationFragment)variableDeclarationFragments.get(0);
        Expression initializer = declarationFragment.getInitializer();
        if (!(initializer instanceof MethodInvocation)) {
            return SEMANTIC_CHANGE_WARNING_STATUS;
        }
        MethodInvocation methodInvocation = (MethodInvocation)initializer;
        String methodName = methodInvocation.getName().getIdentifier();
        if (!"iterator".equals(methodName) || !methodInvocation.arguments().isEmpty()) {
            return SEMANTIC_CHANGE_WARNING_STATUS;
        }
        return StatusInfo.OK_STATUS;
    }
}

