/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.varorder.hyperedges;

import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.escet.cif.bdd.spec.CifBddDiscVariable;
import org.eclipse.escet.cif.bdd.spec.CifBddInputVariable;
import org.eclipse.escet.cif.bdd.spec.CifBddLocPtrVariable;
import org.eclipse.escet.cif.bdd.spec.CifBddVariable;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public abstract class HyperEdgeCreator {
    private final Specification spec;
    private final List<CifBddVariable> variables;
    private final Map<PositionObject, Integer> cifBddVarBitIndices;

    public HyperEdgeCreator(Specification spec, List<CifBddVariable> variables) {
        this.spec = spec;
        this.variables = variables;
        this.cifBddVarBitIndices = Maps.mapc((int)variables.size());
        int i = 0;
        while (i < variables.size()) {
            CifBddVariable cifBddVar = variables.get(i);
            if (cifBddVar instanceof CifBddDiscVariable) {
                CifBddDiscVariable discCifBddVar = (CifBddDiscVariable)cifBddVar;
                this.cifBddVarBitIndices.put((PositionObject)discCifBddVar.var, i);
            } else if (cifBddVar instanceof CifBddInputVariable) {
                CifBddInputVariable inputCifBddVar = (CifBddInputVariable)cifBddVar;
                this.cifBddVarBitIndices.put((PositionObject)inputCifBddVar.var, i);
            } else if (cifBddVar instanceof CifBddLocPtrVariable) {
                CifBddLocPtrVariable locPtrCifBddVar = (CifBddLocPtrVariable)cifBddVar;
                this.cifBddVarBitIndices.put((PositionObject)locPtrCifBddVar.aut, i);
            } else {
                throw new RuntimeException("Unknown CIF/BDD variable: " + String.valueOf(cifBddVar));
            }
            ++i;
        }
    }

    protected Specification getSpecification() {
        return this.spec;
    }

    protected List<CifBddVariable> getVariables() {
        return this.variables;
    }

    public abstract List<BitSet> getHyperEdges();

    protected void addHyperEdge(Collection<PositionObject> edgeVars, List<BitSet> hyperEdges) {
        if (edgeVars.isEmpty()) {
            return;
        }
        BitSet hyperEdge = new BitSet(this.cifBddVarBitIndices.size());
        for (PositionObject var : edgeVars) {
            int bitIdx = this.cifBddVarBitIndices.get(var);
            hyperEdge.set(bitIdx);
        }
        hyperEdges.add(hyperEdge);
    }
}

