/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.model.types;

import java.util.function.Predicate;
import org.eclipse.escet.cif.plcgen.model.types.PlcAbstractType;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.model.types.PlcType;
import org.eclipse.escet.common.java.Strings;

public class PlcGenericType
extends PlcAbstractType {
    public static final PlcGenericType ANY_INT_TYPE = new PlcGenericType(PlcGenericKind.ANY_INT);
    public static final PlcGenericType ANY_REAL_TYPE = new PlcGenericType(PlcGenericKind.ANY_REAL);
    public static final PlcGenericType ANY_NUM_TYPE = new PlcGenericType(PlcGenericKind.ANY_NUM);
    public static final PlcGenericType ANY_ELEMENTARY_TYPE = new PlcGenericType(PlcGenericKind.ANY_ELEMENTARY);
    public static final PlcGenericType ANY_TYPE = new PlcGenericType(PlcGenericKind.ANY);
    private final PlcGenericKind kind;

    private PlcGenericType(PlcGenericKind kind) {
        this.kind = kind;
    }

    public boolean checkMatch(PlcType type) {
        return this.kind.isOfGenericKind.test(type);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof PlcGenericType) {
            PlcGenericType genType = (PlcGenericType)other;
            if (genType.kind == this.kind) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.kind.hashCode();
    }

    @Override
    public String toString() {
        return Strings.fmt((String)"PlcGenericType(%s)", (Object[])new Object[]{this.kind});
    }

    private static enum PlcGenericKind {
        ANY_INT(type -> PlcElementaryType.isIntType(type)),
        ANY_REAL(type -> PlcElementaryType.isRealType(type)),
        ANY_NUM(type -> PlcElementaryType.isIntType(type) || PlcElementaryType.isRealType(type)),
        ANY_ELEMENTARY(type -> PlcElementaryType.isIntType(type) || PlcElementaryType.isRealType(type) || type.equals(PlcElementaryType.BOOL_TYPE) || type.equals(PlcElementaryType.TIME_TYPE)),
        ANY(type -> true);

        private final Predicate<PlcType> isOfGenericKind;

        private PlcGenericKind(Predicate<PlcType> isOfGenericKind) {
            this.isOfGenericKind = isOfGenericKind;
        }
    }
}

