/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.model.expressions;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcExpression;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcNamedValue;
import org.eclipse.escet.cif.plcgen.model.types.PlcStructType;
import org.eclipse.escet.common.java.Assert;

public class PlcStructLiteral
extends PlcExpression {
    public final List<PlcNamedValue> values;

    public PlcStructLiteral(List<PlcNamedValue> values, PlcStructType type) {
        super(type);
        this.values = Collections.unmodifiableList(values);
        Assert.areEqual((Object)values.size(), (Object)type.fields.size());
        Assert.check((boolean)IntStream.range(0, values.size()).allMatch(i -> ((PlcNamedValue)list.get((int)i)).name.equals(plcStructType.fields.get((int)i).fieldName)));
    }

    @Override
    public String toString() {
        String s = this.values.stream().map(v -> v.toString()).collect(Collectors.joining(" "));
        return "PlcStructLiteral(" + s + ")";
    }
}

