/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.Collection;
import java.util.List;
import org.eclipse.escet.cif.cif2cif.CifToCifPreconditionException;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifUpdateUtils;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgIn;
import org.eclipse.escet.cif.metamodel.java.CifWalker;

public class ElimIfUpdates
extends CifWalker
implements CifToCifTransformation {
    private static final String UNSUPPORTED_MESSAGE = "Eliminating 'if' updates, from a CIF specification with multi-assignments and/or partial variable assignments (projected addressables), is currently not supported.";

    @Override
    public void transform(Specification spec) {
        if (CifScopeUtils.hasCompDefInst((Group)spec)) {
            String msg = "Eliminating 'if' updates, from a CIF specification with component definitions is currently not supported.";
            throw new CifToCifPreconditionException(msg);
        }
        this.walkSpecification(spec);
    }

    protected void preprocessEdge(Edge edge) {
        List assignments;
        if (edge.getUpdates().isEmpty()) {
            return;
        }
        try {
            assignments = CifUpdateUtils.updatesToAssignmentsPerVar((List)edge.getUpdates());
        }
        catch (CifUpdateUtils.UnsupportedUpdateException e) {
            throw new CifToCifPreconditionException(UNSUPPORTED_MESSAGE);
        }
        edge.getUpdates().clear();
        edge.getUpdates().addAll((Collection)assignments);
    }

    protected void preprocessSvgIn(SvgIn svgIn) {
        List assignments;
        if (svgIn.getUpdates().isEmpty()) {
            return;
        }
        try {
            assignments = CifUpdateUtils.updatesToAssignmentsPerVar((List)svgIn.getUpdates());
        }
        catch (CifUpdateUtils.UnsupportedUpdateException e) {
            throw new CifToCifPreconditionException(UNSUPPORTED_MESSAGE);
        }
        svgIn.getUpdates().clear();
        svgIn.getUpdates().addAll((Collection)assignments);
    }
}

