/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks;

import java.util.Collection;
import java.util.Set;
import org.eclipse.escet.cif.checkers.CifCheckNoCompDefInst;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class EventNoPureMonitorsCheck
extends CifCheckNoCompDefInst {
    private final Set<Event> specAlphabet = Sets.set();
    private final Set<Event> specNonMonitorEvents = Sets.set();

    protected void preprocessAutomaton(Automaton aut, CifCheckViolations violations) {
        Set autAlphabet = CifEventUtils.getAlphabet((Automaton)aut);
        Set autMonitorsEvents = CifEventUtils.getMonitors((Automaton)aut, (Set)autAlphabet);
        Set autNonMonitorEvents = Sets.difference((Collection)autAlphabet, (Collection)autMonitorsEvents);
        this.specAlphabet.addAll(autAlphabet);
        this.specNonMonitorEvents.addAll(autNonMonitorEvents);
    }

    protected void postprocessSpecification(Specification spec, CifCheckViolations violations) {
        for (Event evt : this.specAlphabet) {
            if (this.specNonMonitorEvents.contains(evt)) continue;
            violations.add((PositionObject)evt, "Event is only used as a monitor event", new Object[0]);
        }
    }
}

