/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.engine.DownloadManager;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitPhase;
import org.eclipse.equinox.internal.p2.engine.Phase;
import org.eclipse.equinox.internal.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.p2.engine.phases.Collect;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IPhaseSet;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.internal.repository.tools.AbstractApplication;
import org.eclipse.equinox.p2.internal.repository.tools.Activator;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.internal.repository.tools.RepositoryDescriptor;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Repo2Runnable
extends AbstractApplication
implements IApplication {
    private static final String NATIVE_ARTIFACTS = "nativeArtifacts";
    private static final String NATIVE_TYPE = "org.eclipse.equinox.p2.native";
    private static final String PARM_OPERAND = "operand";
    private Collection<IInstallableUnit> processedIUs = new ArrayList<IInstallableUnit>();

    @Override
    public IStatus run(IProgressMonitor monitor) throws ProvisionException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
        this.initializeRepos((IProgressMonitor)progress);
        this.validate();
        this.collectIUs((IProgressMonitor)progress.newChild(1));
        IProfile profile = this.createProfile();
        try {
            IEngine engine = (IEngine)this.agent.getService(IEngine.SERVICE_NAME);
            if (engine == null) {
                throw new ProvisionException(Messages.exception_noEngineService);
            }
            ProvisioningContext context = new ProvisioningContext(this.agent);
            context.setMetadataRepositories(this.getRepositories(true));
            context.setArtifactRepositories(this.getRepositories(false));
            IProvisioningPlan plan = engine.createPlan(profile, context);
            Iterator<IInstallableUnit> iterator = this.processedIUs.iterator();
            while (iterator.hasNext()) {
                plan.addInstallableUnit(iterator.next());
            }
            IStatus result = engine.perform(plan, (IPhaseSet)this.getPhaseSet(), (IProgressMonitor)progress.newChild(1));
            PhaseSet nativeSet = this.getNativePhase();
            if (nativeSet != null) {
                engine.perform(plan, (IPhaseSet)nativeSet, (IProgressMonitor)progress.newChild(1));
            }
            this.publishMetadata((IProgressMonitor)progress.newChild(1));
            IStatus iStatus = result;
            return iStatus;
        }
        finally {
            this.removeProfile(profile);
            this.finalizeRepositories();
        }
    }

    protected URI[] getRepositories(boolean metadata) {
        ArrayList<URI> repos = new ArrayList<URI>();
        for (RepositoryDescriptor repo : this.sourceRepositories) {
            if (!(metadata ? repo.isMetadata() : repo.isArtifact())) continue;
            repos.add(repo.getRepoLocation());
        }
        return repos.toArray(new URI[repos.size()]);
    }

    protected PhaseSet getPhaseSet() {
        return new PhaseSet(new Phase[]{new Collect(100)}){};
    }

    protected PhaseSet getNativePhase() {
        return new PhaseSet(new Phase[]{new CollectNativesPhase(100)}){};
    }

    private void collectIUs(IProgressMonitor monitor) throws ProvisionException {
        if (this.sourceIUs != null && !this.sourceIUs.isEmpty()) {
            this.processedIUs = this.sourceIUs;
            return;
        }
        if (!this.hasMetadataSources()) {
            throw new ProvisionException(Messages.exception_needIUsOrNonEmptyRepo);
        }
        Iterator itor = this.getAllIUs(this.getCompositeMetadataRepository(), monitor).iterator();
        while (itor.hasNext()) {
            this.processedIUs.add((IInstallableUnit)itor.next());
        }
        if (this.processedIUs.isEmpty()) {
            throw new ProvisionException(Messages.exception_needIUsOrNonEmptyRepo);
        }
    }

    private void publishMetadata(IProgressMonitor monitor) {
        if (this.destinationMetadataRepository == null) {
            return;
        }
        this.destinationMetadataRepository.addInstallableUnits(this.processedIUs);
    }

    private IQueryResult<IInstallableUnit> getAllIUs(IMetadataRepository repository, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        try {
            IQueryResult iQueryResult = repository.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)progress.newChild(1));
            return iQueryResult;
        }
        finally {
            progress.done();
        }
    }

    private void removeProfile(IProfile profile) throws ProvisionException {
        IProfileRegistry registry = Activator.getProfileRegistry();
        registry.removeProfile(profile.getProfileId());
    }

    private IProfile createProfile() throws ProvisionException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.eclipse.equinox.p2.cache", URIUtil.toFile((URI)this.destinationArtifactRepository.getLocation()).getAbsolutePath());
        properties.put("org.eclipse.equinox.p2.installFolder", URIUtil.toFile((URI)this.destinationArtifactRepository.getLocation()).getAbsolutePath());
        IProfileRegistry registry = Activator.getProfileRegistry();
        return registry.addProfile(new StringBuffer(String.valueOf(System.currentTimeMillis())).append("-").append(Math.random()).toString(), properties);
    }

    public Object start(IApplicationContext context) throws Exception {
        String[] args = (String[])context.getArguments().get("application.args");
        this.processCommandLineArgs(args);
        this.run(null);
        return IApplication.EXIT_OK;
    }

    private void processCommandLineArgs(String[] args) throws URISyntaxException {
        if (args == null) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            String option = args[i];
            if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (option.equalsIgnoreCase("-source")) {
                    RepositoryDescriptor source = new RepositoryDescriptor();
                    source.setLocation(URIUtil.fromString((String)arg));
                    this.addSource(source);
                }
                if (option.equalsIgnoreCase("-destination")) {
                    RepositoryDescriptor destination = new RepositoryDescriptor();
                    destination.setLocation(URIUtil.fromString((String)arg));
                    this.addDestination(destination);
                }
            }
            ++i;
        }
    }

    private void validate() throws ProvisionException {
        if (!this.hasMetadataSources() && this.sourceIUs == null) {
            throw new ProvisionException(Messages.exception_needIUsOrNonEmptyRepo);
        }
        if (this.destinationArtifactRepository == null) {
            throw new ProvisionException(Messages.exception_needDestinationRepo);
        }
    }

    public void stop() {
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CollectNativesAction
    extends ProvisioningAction {
        protected CollectNativesAction() {
        }

        public IStatus execute(Map<String, Object> parameters) {
            InstallableUnitOperand operand = (InstallableUnitOperand)parameters.get(Repo2Runnable.PARM_OPERAND);
            IInstallableUnit installableUnit = operand.second();
            IArtifactRepositoryManager manager = Repo2Runnable.this.getArtifactRepositoryManager();
            Collection toDownload = installableUnit.getArtifacts();
            if (toDownload == null) {
                return Status.OK_STATUS;
            }
            List artifactRequests = (List)parameters.get(Repo2Runnable.NATIVE_ARTIFACTS);
            for (IArtifactKey keyToDownload : toDownload) {
                IArtifactRequest request = manager.createMirrorRequest(keyToDownload, Repo2Runnable.this.destinationArtifactRepository, null, null);
                artifactRequests.add(request);
            }
            return Status.OK_STATUS;
        }

        public IStatus undo(Map<String, Object> parameters) {
            return Status.OK_STATUS;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CollectNativesPhase
    extends InstallableUnitPhase {
        public CollectNativesPhase(int weight) {
            super(Repo2Runnable.NATIVE_ARTIFACTS, weight);
        }

        protected List<ProvisioningAction> getActions(InstallableUnitOperand operand) {
            IInstallableUnit unit = operand.second();
            if (unit.getTouchpointType().getId().equals(Repo2Runnable.NATIVE_TYPE)) {
                return Collections.singletonList(new CollectNativesAction());
            }
            return null;
        }

        protected IStatus initializePhase(IProgressMonitor monitor, IProfile profile, Map<String, Object> parameters) {
            parameters.put(Repo2Runnable.NATIVE_ARTIFACTS, new ArrayList());
            return null;
        }

        protected IStatus completePhase(IProgressMonitor monitor, IProfile profile, Map<String, Object> parameters) {
            List artifactRequests = (List)parameters.get(Repo2Runnable.NATIVE_ARTIFACTS);
            ProvisioningContext context = (ProvisioningContext)parameters.get("context");
            IProvisioningAgent agent = (IProvisioningAgent)parameters.get("agent");
            DownloadManager dm = new DownloadManager(context, agent);
            for (IArtifactRequest request : artifactRequests) {
                dm.add(request);
            }
            return dm.start(monitor);
        }
    }
}

