/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.model.InstalledIUElement;
import org.eclipse.equinox.internal.p2.ui.model.ProvElement;
import org.eclipse.equinox.internal.p2.ui.model.RollbackProfileElement;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.equinox.p2.ui.RevertProfilePage;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class RevertProfilePageWithCompare
extends RevertProfilePage {
    private static final int COMPARE_ID = 1026;
    Button compareButton;
    static /* synthetic */ Class class$0;

    public void createPageButtons(Composite parent) {
        if (ProvisioningUI.getDefaultUI().getProfileId() == null) {
            return;
        }
        this.compareButton = this.createButton(parent, 1026, ProvUIMessages.RevertProfilePage_CompareLabel);
        this.compareButton.setToolTipText(ProvUIMessages.RevertProfilePage_CompareTooltip);
        this.compareButton.setEnabled(this.computeCompareEnablement(this.getSelection()));
        super.createPageButtons(parent);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1026: {
                this.compare();
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }

    boolean computeCompareEnablement(IStructuredSelection structuredSelection) {
        Object[] selection = structuredSelection.toArray();
        if (selection.length == 2) {
            int i = 0;
            while (i < selection.length) {
                if (!(selection[i] instanceof RollbackProfileElement)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected void handleSelectionChanged(IStructuredSelection selection) {
        super.handleSelectionChanged(selection);
        if (!selection.isEmpty()) {
            if (selection.size() == 1) {
                if (this.compareButton != null) {
                    this.compareButton.setEnabled(false);
                }
            } else if (this.compareButton != null) {
                this.compareButton.setEnabled(this.computeCompareEnablement(selection));
            }
        } else if (this.compareButton != null) {
            this.compareButton.setEnabled(false);
        }
    }

    private RollbackProfileElement[] getRollbackProfileElementsToCompare() {
        RollbackProfileElement[] result = new RollbackProfileElement[2];
        IStructuredSelection selection = this.getSelection();
        int i = 0;
        Iterator iterator = selection.toList().iterator();
        while (iterator.hasNext()) {
            Object selected = iterator.next();
            if (selected != null && selected instanceof RollbackProfileElement) {
                result[i++] = (RollbackProfileElement)selected;
            }
            if (i == 2) break;
        }
        return result;
    }

    void compare() {
        RollbackProfileElement[] rpe = this.getRollbackProfileElementsToCompare();
        CompareUI.openCompareDialog((CompareEditorInput)new ProfileCompareEditorInput(rpe));
    }

    private class ProfileCompareEditorInput
    extends CompareEditorInput {
        private Object root;
        private ProvElementNode l;
        private ProvElementNode r;

        public ProfileCompareEditorInput(RollbackProfileElement[] rpe) {
            super(new CompareConfiguration());
            Assert.isTrue((rpe.length == 2 ? 1 : 0) != 0);
            this.l = new ProvElementNode(rpe[0]);
            this.r = new ProvElementNode(rpe[1]);
        }

        protected Object prepareInput(IProgressMonitor monitor) {
            this.initLabels();
            Differencer d = new Differencer();
            this.root = d.findDifferences(false, monitor, null, null, (Object)this.l, (Object)this.r);
            return this.root;
        }

        private void initLabels() {
            CompareConfiguration cc = this.getCompareConfiguration();
            cc.setLeftEditable(false);
            cc.setRightEditable(false);
            cc.setLeftLabel(this.l.getName());
            cc.setLeftImage(this.l.getImage());
            cc.setRightLabel(this.r.getName());
            cc.setRightImage(this.r.getImage());
        }

        public String getOKButtonLabel() {
            return IDialogConstants.OK_LABEL;
        }
    }

    private class ProvElementNode
    implements IStructureComparator,
    ITypedElement,
    IStreamContentAccessor {
        private ProvElement pe;
        private IInstallableUnit iu;
        static final String BLANK = "";
        private String id = "";

        public ProvElementNode(Object input) {
            this.pe = (ProvElement)input;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.equinox.p2.metadata.IInstallableUnit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.iu = (IInstallableUnit)ProvUI.getAdapter((Object)this.pe, (Class)clazz);
            if (this.iu != null) {
                this.id = this.iu.getId();
            }
        }

        public Object[] getChildren() {
            HashSet<ProvElementNode> children;
            block3: {
                block2: {
                    children = new HashSet<ProvElementNode>();
                    if (!(this.pe instanceof RollbackProfileElement)) break block2;
                    Object[] c = ((RollbackProfileElement)this.pe).getChildren(null);
                    int i = 0;
                    while (i < c.length) {
                        children.add(new ProvElementNode(c[i]));
                        ++i;
                    }
                    break block3;
                }
                if (!(this.pe instanceof InstalledIUElement)) break block3;
                Object[] c = ((InstalledIUElement)this.pe).getChildren(null);
                int i = 0;
                while (i < c.length) {
                    children.add(new ProvElementNode(c[i]));
                    ++i;
                }
            }
            return children.toArray();
        }

        public boolean equals(Object other) {
            if (other instanceof ProvElementNode) {
                return this.id.equals(((ProvElementNode)other).id);
            }
            return super.equals(other);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public Image getImage() {
            return this.pe.getImage(null);
        }

        public String getName() {
            if (this.iu != null) {
                return this.iu.getProperty("org.eclipse.equinox.p2.name", null);
            }
            return this.pe.getLabel(null);
        }

        public String getType() {
            return "???";
        }

        public InputStream getContents() {
            String contents = BLANK;
            if (this.iu != null) {
                contents = this.iu.getVersion().toString();
            }
            return new ByteArrayInputStream(contents.getBytes());
        }
    }
}

