/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.services;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class LabelCellEditorLocator
implements CellEditorLocator {
    private final EditPartViewer myViewer;
    private final Label myLabel;

    public LabelCellEditorLocator(EditPartViewer viewer, Label label) {
        this.myViewer = viewer;
        this.myLabel = label;
    }

    public void relocate(CellEditor celleditor) {
        Rectangle rect = this.getLabel().getTextBounds();
        this.getLabel().translateToAbsolute((Translatable)rect);
        if (this.getLabel().getFont() != null) {
            double zoomLevel;
            ZoomManager zoomManager = this.getZoomManager();
            double d = zoomLevel = zoomManager == null ? 1.0 : zoomManager.getZoom();
            if (zoomLevel > 1.0) {
                FontData[] datas = this.getLabel().getFont().getFontData();
                int i = 0;
                while (i < datas.length) {
                    datas[i].height = (float)((double)datas[i].height * zoomLevel);
                    ++i;
                }
                final Font font = new Font(this.getLabel().getFont().getDevice(), datas);
                celleditor.getControl().setFont(font);
                celleditor.getControl().addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        font.dispose();
                    }
                });
            } else {
                celleditor.getControl().setFont(this.getLabel().getFont());
            }
        }
        int avr = FigureUtilities.getFontMetrics((Font)celleditor.getControl().getFont()).getAverageCharWidth();
        rect.setSize(new Dimension(celleditor.getControl().computeSize(-1, -1)).expand(avr * 2, 0));
        celleditor.getControl().setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    protected ZoomManager getZoomManager() {
        return (ZoomManager)this.myViewer.getProperty(ZoomManager.class.toString());
    }

    protected Label getLabel() {
        return this.myLabel;
    }
}

