/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.transform;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.internal.bridge.transform.GMFGenModelDiagnosticPage;
import org.eclipse.gmf.internal.bridge.transform.GMFGenNewFileCreationPage;
import org.eclipse.gmf.internal.bridge.transform.GenModelConfigurationPage;
import org.eclipse.gmf.internal.bridge.transform.ITransformToGenModelOperation;
import org.eclipse.gmf.internal.bridge.transform.MapModelConfigurationPage;
import org.eclipse.gmf.internal.bridge.transform.MapModelDiagnosticPage;
import org.eclipse.gmf.internal.bridge.transform.Messages;
import org.eclipse.gmf.internal.bridge.transform.ModelDiagnosticPage;
import org.eclipse.gmf.internal.bridge.transform.TransformToGenModelOperation;
import org.eclipse.gmf.internal.bridge.transform.ViewmapProducerWizardPage;
import org.eclipse.gmf.internal.bridge.ui.Plugin;
import org.eclipse.gmf.internal.bridge.wizards.WizardUtil;
import org.eclipse.gmf.internal.common.URIUtil;
import org.eclipse.gmf.internal.common.ui.ResourceLocationProvider;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

public class TransformToGenModelWizard
extends Wizard
implements IWorkbenchWizard {
    private IStructuredSelection mySelection;
    private GMFGenNewFileCreationPage newFileCreationPage;
    private MapModelConfigurationPage mapModelPage;
    private ModelDiagnosticPage mapDiagnosticPage;
    private GenModelConfigurationPage genModelPage;
    private ViewmapProducerWizardPage transformOptionPage;
    private ModelDiagnosticPage genDiagnosticPage;
    private WizardPage myErrorContainer;
    private ITransformToGenModelOperation myOperation;

    public void addPages() {
        this.newFileCreationPage = new GMFGenNewFileCreationPage(this.mySelection);
        IFile file = WizardUtil.findExistingFile(this.mySelection, "gmfgen");
        if (file != null) {
            this.newFileCreationPage.setFileName(file.getName());
        } else {
            this.newFileCreationPage.setFileName(WizardUtil.getDefaultFileName(this.mySelection, "My", "gmfgen"));
        }
        this.addPage((IWizardPage)this.newFileCreationPage);
        ResourceSet resourceSet = this.getTransformOperation().getResourceSet();
        ResourceLocationProvider rlp = new ResourceLocationProvider((ISelection)this.mySelection);
        this.mapModelPage = this.createMapModelConfigurationPage(MapModelConfigurationPage.class.getSimpleName(), rlp, resourceSet);
        this.mapModelPage.setPageComplete(false);
        this.mapModelPage.setModelRequired(true);
        this.addPage((IWizardPage)this.mapModelPage);
        this.mapDiagnosticPage = new MapModelDiagnosticPage(MapModelDiagnosticPage.class.getSimpleName());
        this.addPage((IWizardPage)this.mapDiagnosticPage);
        this.genModelPage = new GenModelConfigurationPage(GenModelConfigurationPage.class.getSimpleName(), rlp, resourceSet);
        this.genModelPage.setPageComplete(false);
        this.genModelPage.setModelRequired(false);
        this.addPage((IWizardPage)this.genModelPage);
        this.transformOptionPage = new ViewmapProducerWizardPage(ViewmapProducerWizardPage.class.getSimpleName());
        this.transformOptionPage.setPageComplete(false);
        this.addPage((IWizardPage)this.transformOptionPage);
        this.genDiagnosticPage = new GMFGenModelDiagnosticPage(GMFGenModelDiagnosticPage.class.getSimpleName());
        this.addPage((IWizardPage)this.genDiagnosticPage);
    }

    protected MapModelConfigurationPage createMapModelConfigurationPage(String pageId, ResourceLocationProvider rlp, ResourceSet resourceSet) {
        return new MapModelConfigurationPage(pageId, rlp, resourceSet);
    }

    private boolean checkGMFGenValidationResult() {
        Diagnostic diagnostic = this.getTransformOperation().getGMFGenValidationResult();
        return 4 != diagnostic.getSeverity();
    }

    protected ResourceSet createResourceSet() {
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
        return rs;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (this.myErrorContainer != null) {
            this.myErrorContainer.setErrorMessage(null);
            this.myErrorContainer = null;
        }
        if (page == this.mapModelPage) {
            Diagnostic diagnostic = this.getTransformOperation().getMapmodelValidationResult();
            if (4 == diagnostic.getSeverity()) {
                this.findNextPageAfterMapping();
                return this.mapDiagnosticPage;
            }
            return this.findNextPageAfterMapping();
        }
        if (page == this.mapDiagnosticPage) {
            return this.findNextPageAfterMapping();
        }
        if (page == this.transformOptionPage) {
            if (this.checkGMFGenValidationResult()) {
                return null;
            }
            return this.genDiagnosticPage;
        }
        return super.getNextPage(page);
    }

    private IWizardPage findNextPageAfterMapping() {
        try {
            GenModel genmmodel = this.getTransformOperation().findGenmodel();
            if (genmmodel == null) {
                this.genModelPage.setPageComplete(true);
                return this.transformOptionPage;
            }
        }
        catch (CoreException e) {
            this.genModelPage.setStatusMessage(e.getStatus());
        }
        return this.genModelPage;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.mySelection = selection;
        this.setWindowTitle(Messages.TransformToGenModelWizard_title_wizard);
        this.setNeedsProgressMonitor(true);
        this.myOperation = this.createTransformOperation(this.createResourceSet());
    }

    protected ITransformToGenModelOperation createTransformOperation(ResourceSet resourceSet) {
        return new TransformToGenModelOperation(resourceSet);
    }

    public boolean performFinish() {
        if (this.getTransformOperation().getOptions().getIgnoreGMFGenValidation() && this.getContainer().getCurrentPage() == this.genDiagnosticPage) {
            this.saveTransformOptions();
            return true;
        }
        try {
            final IStatus[] s = new IStatus[1];
            IRunnableWithProgress iwr = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    ITransformToGenModelOperation op = TransformToGenModelWizard.this.getTransformOperation();
                    IFile target = TransformToGenModelWizard.this.getTargetFile();
                    op.setGenURI(URI.createPlatformResourceURI((String)target.getFullPath().toString(), (boolean)true));
                    s[0] = op.executeTransformation(monitor);
                }
            };
            this.getContainer().run(false, false, iwr);
            if (s[0].isOK()) {
                return this.processGMFGenValidationResult();
            }
            this.setErrorMessage(s[0].getMessage());
            if (s[0].getException() != null) {
                Plugin.log(s[0]);
            }
            return false;
        }
        catch (InvocationTargetException ex) {
            String message = Messages.TransformToGenModelOperation_e_generator_creation;
            Throwable targetException = ex.getTargetException();
            if (targetException != null) {
                message = targetException.getMessage() != null ? targetException.getMessage() : String.valueOf(message) + ": " + targetException.getClass().getName();
            }
            this.setErrorMessage(message);
            Plugin.log(Plugin.createError(message, targetException));
            return false;
        }
        catch (InterruptedException interruptedException) {
            this.setErrorMessage(Messages.TransformToGenModelWizard_e_operation_cancelled);
            return false;
        }
    }

    private boolean processGMFGenValidationResult() {
        if (this.checkGMFGenValidationResult()) {
            this.setErrorMessage(null);
            this.saveTransformOptions();
            return true;
        }
        this.getContainer().showPage((IWizardPage)this.genDiagnosticPage);
        return false;
    }

    private void saveTransformOptions() {
        if (this.getTransformOperation() != null) {
            this.getTransformOperation().getOptions().flush();
        }
    }

    public boolean performCancel() {
        if (this.getTransformOperation() != null) {
            this.getTransformOperation().getOptions().reset();
        }
        return super.performCancel();
    }

    ITransformToGenModelOperation getTransformOperation() {
        return this.myOperation;
    }

    IFile getTargetFile() {
        return this.newFileCreationPage.getModelFile();
    }

    IFile getMapFile() {
        URI mapURI = this.mapModelPage.getURI();
        if (mapURI != null) {
            return URIUtil.getFile((URI)mapURI);
        }
        return (IFile)this.mySelection.getFirstElement();
    }

    private void setErrorMessage(String message) {
        WizardDialog wd = (WizardDialog)this.getContainer();
        WizardPage wp = (WizardPage)wd.getCurrentPage();
        if (wp != null) {
            this.myErrorContainer = wp;
            this.myErrorContainer.setErrorMessage(message);
        }
    }
}

