/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.ISourceFileReader;
import net.sourceforge.plantuml.SourceFileReaderAbstract;
import net.sourceforge.plantuml.file.SuggestedFile;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.utils.Log;

public class SourceFileReader
extends SourceFileReaderAbstract
implements ISourceFileReader {
    private File outputDirectory;

    public SourceFileReader(File file) throws IOException {
        this(file, file.getAbsoluteFile().getParentFile());
    }

    public SourceFileReader(File file, File outputDirectory, String charset) throws IOException {
        this(Defines.createWithFileName(file), file, outputDirectory, Collections.emptyList(), charset, new FileFormatOption(FileFormat.PNG));
    }

    public SourceFileReader(File file, File outputDirectory) throws IOException {
        this(Defines.createWithFileName(file), file, outputDirectory, Collections.emptyList(), null, new FileFormatOption(FileFormat.PNG));
    }

    public SourceFileReader(File file, File outputDirectory, FileFormatOption fileFormatOption) throws IOException {
        this(Defines.createWithFileName(file), file, outputDirectory, Collections.emptyList(), null, fileFormatOption);
    }

    public SourceFileReader(Defines defines, File file, File outputDirectory, List<String> config, String charset, FileFormatOption fileFormatOption) throws IOException {
        super(file, fileFormatOption, defines, config, charset);
        FileSystem.getInstance().setCurrentDir(SFile.fromFile(file.getAbsoluteFile().getParentFile()));
        if (outputDirectory == null) {
            outputDirectory = file.getAbsoluteFile().getParentFile();
        } else if (!outputDirectory.isAbsolute()) {
            outputDirectory = FileSystem.getInstance().getFile(outputDirectory.getPath()).conv();
        }
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        this.outputDirectory = outputDirectory;
    }

    private File getDirIfDirectory(String newName) throws FileNotFoundException {
        Log.info("Checking=" + newName);
        if (this.endsWithSlashOrAntislash(newName)) {
            Log.info("It ends with / so it looks like a directory");
            newName = newName.substring(0, newName.length() - 1);
            File f = new File(newName);
            Log.info("f=" + f);
            if (!f.isAbsolute()) {
                Log.info("It's relative, so let's change it");
                f = new File(this.outputDirectory, newName);
                Log.info("f=" + f);
            }
            if (!f.exists()) {
                Log.info("It does not exist: let's create it");
                try {
                    f.mkdirs();
                }
                catch (Exception e) {
                    Log.info("Error " + e);
                }
                if (f.exists() && f.isDirectory()) {
                    Log.info("Creation ok");
                    return f;
                }
                Log.info("We cannot create it");
            } else if (!f.isDirectory()) {
                Log.info("It exists, but is not a directory: we ignore it");
                return null;
            }
            return f;
        }
        File f = new File(newName);
        Log.info("f=" + f);
        if (!f.isAbsolute()) {
            Log.info("Relative, so let's change it");
            f = new File(this.outputDirectory, newName);
            Log.info("f=" + f);
        }
        if (f.exists() && f.isDirectory()) {
            Log.info("It's an existing directory");
            return f;
        }
        Log.info("It's not a directory");
        return null;
    }

    @Override
    protected SuggestedFile getSuggestedFile(BlockUml blockUml) throws FileNotFoundException {
        String newName = blockUml.getFileOrDirname();
        SuggestedFile suggested = null;
        if (newName != null) {
            Log.info("name from block=" + newName);
            File dir = this.getDirIfDirectory(newName);
            if (dir == null) {
                Log.info(newName + " is not taken as a directory");
                suggested = SuggestedFile.fromOutputFile(new File(this.outputDirectory, newName), this.getFileFormatOption().getFileFormat(), 0);
            } else {
                Log.info("We are going to create files in directory " + dir);
                suggested = SuggestedFile.fromOutputFile(new File(dir, this.getFileName()), this.getFileFormatOption().getFileFormat(), 0);
            }
            Log.info("We are going to put data in " + suggested);
        }
        if (suggested == null) {
            suggested = this.getSuggestedFile(this.outputDirectory, this.getFileName());
        }
        suggested.getParentFile().mkdirs();
        return suggested;
    }
}

