/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dap.variables.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.epsilon.eol.dap.variables.IVariableReference;
import org.eclipse.epsilon.eol.dap.variables.SuspendedState;
import org.eclipse.epsilon.eol.dap.variables.collections.CollectionReference;
import org.eclipse.epsilon.eol.execute.context.IEolContext;

public class PerElementCollectionReference
extends CollectionReference {
    private final String name;

    public PerElementCollectionReference(IEolContext context, String name, Collection<Object> collection) {
        super(context, collection);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<IVariableReference> getVariables(SuspendedState state) {
        ArrayList<IVariableReference> refs = new ArrayList<IVariableReference>(((Collection)this.target).size());
        int i = 0;
        for (Object e : (Collection)this.target) {
            refs.add(state.getValueReference(this.context, String.format("%s[%d]", this.name, i++), e));
        }
        return refs;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.name);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PerElementCollectionReference other = (PerElementCollectionReference)obj;
        return Objects.equals(this.name, other.name);
    }
}

